/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import pGraph.AvgSumXYPanel;
import pGraph.DataSet;
import pGraph.GenericPanel;
import pGraph.GlobalConfig;
import pGraph.SumXYPanel;
import pGraph.XYPanel;

public class GenericFrame
extends JFrame {
    private static final long serialVersionUID = -115448456728273692L;
    private GlobalConfig configuration;
    protected JPanel graphicContainer;
    protected JPanel boxPanel;
    protected JButton allButton;
    protected JButton noneButton;
    protected JButton saveButton;
    protected JButton zoomButton;
    protected JToggleButton absMinMaxTButton;
    protected JCheckBox sameMaxBox;
    protected boolean forceSameMax = false;
    protected GenericPanel[] dataPanel = null;
    protected String[] dataPanelName = null;
    protected JPanel[] graphPanel = null;
    protected JLabel[][] dataLimits = null;
    protected JLabel pointedValues;
    protected JCheckBox[] checkBox = null;
    protected int graphPanelIndex = 0;
    protected String[] oldCheckBoxName = null;
    protected boolean[] oldCheckBoxSelected = null;
    protected MyEventHandler myEventHandler = new MyEventHandler();
    protected int minZoom = -1;
    protected int maxZoom = DataSet.SLOTS;
    private int XSIZE = DataSet.SLOTS + 250;
    private int YSIZE = 200;
    protected Vector separators = new Vector();
    protected Vector separatorIndex = new Vector();
    protected Vector separatorButton = new Vector();
    protected boolean separatorPressed = false;
    private SumXYPanel[] sumPanelList = null;
    private AvgSumXYPanel[] avgSumPanelList = null;

    public GenericFrame(String title, GlobalConfig config) {
        super(title);
        this.configuration = config;
        this.setup();
    }

    public void reset() {
        this.oldCheckBoxName = new String[this.checkBox.length];
        this.oldCheckBoxSelected = new boolean[this.checkBox.length];
        int i = 0;
        while (i < this.checkBox.length) {
            this.oldCheckBoxName[i] = this.checkBox[i].getText();
            this.oldCheckBoxSelected[i] = this.checkBox[i].isSelected();
            ++i;
        }
        this.dataPanel = null;
        this.dataPanelName = null;
        this.graphPanel = null;
        this.dataLimits = null;
        this.checkBox = null;
        this.graphPanelIndex = 0;
        this.minZoom = -1;
        this.maxZoom = DataSet.SLOTS;
        this.setup();
    }

    private int oldCheckBoxIndex(String s) {
        if (this.oldCheckBoxName == null) {
            return -1;
        }
        int i = 0;
        while (i < this.oldCheckBoxName.length) {
            if (s.equals(this.oldCheckBoxName[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setup() {
        this.YSIZE = this.configuration.getPanelHeight();
        this.XSIZE = DataSet.SLOTS + this.configuration.getTextareaWidth();
        this.graphicContainer = new JPanel();
        this.graphicContainer.setLayout(new GridBagLayout());
        this.graphicContainer.setAlignmentY(0.5f);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setAutoscrolls(true);
        scrollPane.setViewportView(this.graphicContainer);
        this.pointedValues = new JLabel();
        this.pointedValues.setFont(this.configuration.getPointedDataFont());
        this.pointedValues.setText("Current: ");
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new BorderLayout());
        dataPanel.add((Component)this.pointedValues, "North");
        dataPanel.add((Component)scrollPane, "Center");
        this.boxPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.boxPanel, 1);
        this.boxPanel.setLayout(boxLayout);
        scrollPane = new JScrollPane();
        scrollPane.setAutoscrolls(true);
        scrollPane.setViewportView(this.boxPanel);
        scrollPane.setPreferredSize(new Dimension(220, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(null);
        buttonPanel.setPreferredSize(new Dimension(220, 107));
        this.allButton = new JButton();
        this.allButton.setName("Check All");
        this.allButton.setText("Check All");
        this.allButton.setFont(this.configuration.getButtonFont());
        this.allButton.addActionListener(this.myEventHandler);
        this.allButton.setBounds(2, 2, 107, 25);
        buttonPanel.add((Component)this.allButton, "All");
        this.noneButton = new JButton();
        this.noneButton.setName("Uncheck All");
        this.noneButton.setText("Uncheck All");
        this.noneButton.setFont(this.configuration.getButtonFont());
        this.noneButton.addActionListener(this.myEventHandler);
        this.noneButton.setBounds(111, 2, 107, 25);
        buttonPanel.add((Component)this.noneButton, "None");
        this.saveButton = new JButton();
        this.saveButton.setName("Export");
        this.saveButton.setText("Export");
        this.saveButton.setFont(this.configuration.getButtonFont());
        this.saveButton.addActionListener(this.myEventHandler);
        this.saveButton.setBounds(2, 29, 107, 25);
        buttonPanel.add((Component)this.saveButton, "Save");
        this.zoomButton = new JButton();
        this.zoomButton.setName("Zoom");
        this.zoomButton.setText("Zoom");
        this.zoomButton.setFont(this.configuration.getButtonFont());
        this.zoomButton.addActionListener(this.myEventHandler);
        this.zoomButton.setBounds(111, 29, 107, 25);
        buttonPanel.add((Component)this.zoomButton, "Zoom");
        this.absMinMaxTButton = new JToggleButton();
        this.absMinMaxTButton.setName("Absolute Min&Max");
        this.absMinMaxTButton.setText("Absolute Min&Max: ON");
        this.absMinMaxTButton.setSelected(true);
        this.absMinMaxTButton.setFont(this.configuration.getButtonFont());
        this.absMinMaxTButton.addItemListener(this.myEventHandler);
        this.absMinMaxTButton.setBounds(12, 56, 196, 25);
        buttonPanel.add((Component)this.absMinMaxTButton, "Absolute Min&Max");
        this.sameMaxBox = new JCheckBox();
        this.sameMaxBox.setSelected(false);
        this.sameMaxBox.addChangeListener(this.myEventHandler);
        this.sameMaxBox.setText("Same max value");
        this.sameMaxBox.setFont(this.configuration.getButtonFont());
        this.sameMaxBox.setBounds(12, 85, 196, 14);
        buttonPanel.add((Component)this.sameMaxBox, "sameMaxBox");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        controlPanel.add((Component)buttonPanel, "North");
        controlPanel.add((Component)scrollPane, "Center");
        JPanel framePanel = new JPanel();
        framePanel.setLayout(new BorderLayout());
        framePanel.add((Component)controlPanel, "West");
        framePanel.add((Component)dataPanel, "Center");
        this.setContentPane(framePanel);
        this.validate();
    }

    protected void printFrame() {
        if (this.graphicContainer == null) {
            return;
        }
        JFileChooser openFileDialog = new JFileChooser();
        openFileDialog.setName("SaveFile");
        String[] cvs = new String[]{"csv"};
        String[] png = new String[]{"png"};
        MyFileFilter cvsFilter = new MyFileFilter(cvs, "Semicolumn separated files (*.csv)");
        MyFileFilter pngFilter = new MyFileFilter(png, "PNG pictures (*.png)");
        openFileDialog.addChoosableFileFilter(cvsFilter);
        openFileDialog.addChoosableFileFilter(pngFilter);
        int rc = openFileDialog.showSaveDialog(this);
        FileFilter chosenFilter = openFileDialog.getFileFilter();
        if (rc != 0) {
            return;
        }
        File file = openFileDialog.getSelectedFile();
        String name = file.getName();
        int i = 0;
        while (i < this.dataPanel.length) {
            this.dataPanel[i].setHideZoomBars(true);
            ++i;
        }
        if (chosenFilter == pngFilter) {
            if (!name.toLowerCase().endsWith(".png")) {
                file = new File(String.valueOf(file.getPath()) + ".png");
            }
            this.createPNG(file);
        } else if (chosenFilter == cvsFilter) {
            if (!name.toLowerCase().endsWith(".csv")) {
                file = new File(String.valueOf(file.getPath()) + ".csv");
            }
            this.createCVS(file);
        } else {
            if (!name.toLowerCase().endsWith(".png")) {
                file = new File(String.valueOf(file.getPath()) + ".png");
            }
            this.createPNG(file);
        }
        i = 0;
        while (i < this.dataPanel.length) {
            this.dataPanel[i].setHideZoomBars(false);
            ++i;
        }
    }

    private void createCVS(File file) {
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(outStream);
            pw.print("Date;");
            int i = 0;
            while (i < this.graphPanel.length) {
                if (this.graphPanel[i].isVisible()) {
                    pw.print(this.dataPanel[i].getCSVNames(this.dataPanelName[i]));
                }
                ++i;
            }
            pw.println();
            i = 0;
            while (i < DataSet.SLOTS) {
                pw.print(this.dataPanel[0].getCSVTime(i));
                int j = 0;
                while (j < this.graphPanel.length) {
                    if (this.graphPanel[j].isVisible()) {
                        pw.print(this.dataPanel[j].getCSVData(i));
                    }
                    ++j;
                }
                pw.println();
                ++i;
            }
            pw.flush();
            pw.close();
            outStream.close();
        }
        catch (IOException ioe) {
            return;
        }
    }

    private void createPNG(File file) {
        try {
            BufferedImage bi = new BufferedImage(this.graphicContainer.getWidth(), this.graphicContainer.getHeight(), 1);
            Graphics2D g2d = bi.createGraphics();
            this.graphicContainer.paint(g2d);
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException iOException) {}
        }
        catch (OutOfMemoryError oome) {
            System.out.println(" Insufficient memory to create PNG output!");
            System.out.println(" Provide more memory to Java using the -Xmx flag.");
            System.out.println(" Example with 500 MB: java -Xmx500m -cp pGraph.jar pGraph.Viewer ");
        }
    }

    public void zoom() {
        int i = 0;
        while (i < this.dataPanel.length) {
            if (this.dataPanel[i] != null) {
                this.dataPanel[i].zoom();
            }
            ++i;
        }
        this.forceSameMax = false;
        this.sameMaxBox.setSelected(false);
    }

    public void addGraph(GenericPanel p, String name, Color[] color) {
        this.addGraph(p, name);
    }

    public void addGraph(GenericPanel p, String name) {
        int i;
        if (this.dataPanel == null) {
            this.dataPanel = new GenericPanel[1];
            this.dataPanel[0] = p;
            this.dataPanelName = new String[1];
            this.dataPanelName[0] = name;
        } else {
            GenericPanel[] newArray = new GenericPanel[this.dataPanel.length + 1];
            String[] newArrayName = new String[this.dataPanel.length + 1];
            i = 0;
            while (i < this.dataPanel.length) {
                newArray[i] = this.dataPanel[i];
                newArrayName[i] = this.dataPanelName[i];
                ++i;
            }
            newArray[newArray.length - 1] = p;
            newArrayName[newArray.length - 1] = name;
            this.dataPanel = newArray;
            this.dataPanelName = newArrayName;
        }
        if (this.graphPanel == null) {
            this.graphPanel = new JPanel[1];
            this.graphPanel[0] = new JPanel();
        } else {
            JPanel[] newJPanel = new JPanel[this.graphPanel.length + 1];
            i = 0;
            while (i < this.graphPanel.length) {
                newJPanel[i] = this.graphPanel[i];
                ++i;
            }
            newJPanel[newJPanel.length - 1] = new JPanel();
            this.graphPanel = newJPanel;
        }
        if (this.checkBox == null) {
            this.checkBox = new JCheckBox[1];
            this.checkBox[0] = new JCheckBox();
        } else {
            JCheckBox[] newBox = new JCheckBox[this.checkBox.length + 1];
            i = 0;
            while (i < this.checkBox.length) {
                newBox[i] = this.checkBox[i];
                ++i;
            }
            newBox[newBox.length - 1] = new JCheckBox();
            this.checkBox = newBox;
        }
        if (p instanceof SumXYPanel) {
            if (this.sumPanelList == null) {
                this.sumPanelList = new SumXYPanel[1];
                this.sumPanelList[0] = (SumXYPanel)p;
            } else {
                SumXYPanel[] newSumPanelList = new SumXYPanel[this.sumPanelList.length + 1];
                i = 0;
                while (i < this.sumPanelList.length) {
                    newSumPanelList[i] = this.sumPanelList[i];
                    ++i;
                }
                newSumPanelList[newSumPanelList.length - 1] = (SumXYPanel)p;
                this.sumPanelList = newSumPanelList;
            }
        }
        if (p instanceof AvgSumXYPanel) {
            if (this.avgSumPanelList == null) {
                this.avgSumPanelList = new AvgSumXYPanel[1];
                this.avgSumPanelList[0] = (AvgSumXYPanel)p;
            } else {
                AvgSumXYPanel[] newAvgSumPanelList = new AvgSumXYPanel[this.avgSumPanelList.length + 1];
                i = 0;
                while (i < this.avgSumPanelList.length) {
                    newAvgSumPanelList[i] = this.avgSumPanelList[i];
                    ++i;
                }
                newAvgSumPanelList[newAvgSumPanelList.length - 1] = (AvgSumXYPanel)p;
                this.avgSumPanelList = newAvgSumPanelList;
            }
        }
        this.graphPanel[this.graphPanel.length - 1].setPreferredSize(new Dimension(this.XSIZE, this.YSIZE));
        this.graphPanel[this.graphPanel.length - 1].setMaximumSize(new Dimension(this.XSIZE, this.YSIZE));
        this.graphPanel[this.graphPanel.length - 1].setLayout(new BorderLayout());
        i = this.oldCheckBoxIndex(name);
        if (i >= 0) {
            this.graphPanel[this.graphPanel.length - 1].setVisible(this.oldCheckBoxSelected[i]);
        }
        JLabel label = new JLabel();
        label.setName(name);
        label.setText(name);
        label.setFont(this.configuration.getPanelTitleFont());
        label.setBorder(new EtchedBorder());
        label.setHorizontalAlignment(0);
        label.setOpaque(true);
        this.graphPanel[this.graphPanel.length - 1].add((Component)label, "North");
        p.setOpaque(true);
        p.addPropertyChangeListener(this.myEventHandler);
        this.graphPanel[this.graphPanel.length - 1].add((Component)p, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = this.graphPanelIndex++;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.graphicContainer.add((Component)this.graphPanel[this.graphPanel.length - 1], constraints);
        this.checkBox[this.checkBox.length - 1].setSelected(true);
        i = this.oldCheckBoxIndex(name);
        if (i >= 0) {
            this.checkBox[this.checkBox.length - 1].setSelected(this.oldCheckBoxSelected[i]);
        }
        this.checkBox[this.checkBox.length - 1].addChangeListener(this.myEventHandler);
        this.checkBox[this.checkBox.length - 1].setText(name);
        this.boxPanel.add(this.checkBox[this.checkBox.length - 1]);
    }

    public void addSeparator(String name) {
        JLabel label;
        if (this.separators.size() != 0) {
            label = new JLabel();
            label.setFont(new Font("", 1, 12));
            label.setPreferredSize(new Dimension(200, 12));
            label.setMaximumSize(new Dimension(200, 12));
            label.setText("");
            label.setHorizontalAlignment(2);
            label.setOpaque(true);
            this.boxPanel.add(label);
        }
        label = new JLabel();
        label.setFont(new Font("", 1, 15));
        label.setName(name);
        label.setText(name);
        label.setHorizontalAlignment(0);
        label.setOpaque(true);
        label.setPreferredSize(new Dimension(this.XSIZE, 30));
        label.setMaximumSize(new Dimension(this.XSIZE, 30));
        label.setMinimumSize(new Dimension(this.XSIZE, 30));
        label.setSize(new Dimension(this.XSIZE, 30));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = this.graphPanelIndex++;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.graphicContainer.add((Component)label, constraints);
        this.separators.add(label);
        if (this.checkBox == null) {
            this.separatorIndex.add(new Integer(0));
        } else {
            this.separatorIndex.add(new Integer(this.checkBox.length));
        }
        JToggleButton jtb = new JToggleButton();
        jtb.setFont(this.configuration.getButtonFont());
        jtb.setPreferredSize(new Dimension(200, 22));
        jtb.setMaximumSize(new Dimension(200, 22));
        jtb.setName(name);
        jtb.setText(name);
        jtb.setHorizontalAlignment(0);
        jtb.setOpaque(true);
        jtb.setSelected(true);
        jtb.addActionListener(this.myEventHandler);
        this.separatorButton.add(jtb);
        this.boxPanel.add(jtb);
    }

    private void hideShowSeparators(int cb) {
        int numSep = -1;
        int i = 0;
        while (i < this.separatorIndex.size()) {
            int n = (Integer)this.separatorIndex.elementAt(i);
            if (n > cb) break;
            numSep = i++;
        }
        if (numSep == -1) {
            return;
        }
        int from = (Integer)this.separatorIndex.elementAt(numSep);
        int to = numSep == this.separatorIndex.size() - 1 ? this.checkBox.length - 1 : (Integer)this.separatorIndex.elementAt(numSep + 1) - 1;
        boolean visible = false;
        i = from;
        while (i <= to && !visible) {
            if (this.checkBox[i].isSelected()) {
                visible = true;
            }
            ++i;
        }
        ((JLabel)this.separators.elementAt(numSep)).setVisible(visible);
        ((JToggleButton)this.separatorButton.elementAt(numSep)).setSelected(visible);
    }

    private void separatorPressed(int n) {
        int from = (Integer)this.separatorIndex.elementAt(n);
        int to = n == this.separatorIndex.size() - 1 ? this.checkBox.length - 1 : (Integer)this.separatorIndex.elementAt(n + 1) - 1;
        boolean selected = ((JToggleButton)this.separatorButton.elementAt(n)).isSelected();
        this.separatorPressed = true;
        int i = from;
        while (i <= to) {
            this.checkBox[i].setSelected(selected);
            ++i;
        }
        this.separatorPressed = false;
        this.hideShowSeparators(from);
    }

    public void showErrorBars(boolean show) {
        int i = 0;
        while (i < this.dataPanel.length) {
            if (this.dataPanel[i] != null && this.dataPanel[i] instanceof XYPanel) {
                ((XYPanel)this.dataPanel[i]).setShowErrorbars(show);
            }
            ++i;
        }
        this.absMinMaxTButton.setSelected(show);
    }

    private void alignMaxValue() {
        float newMax = 0.0f;
        int i = 0;
        while (i < this.dataPanel.length) {
            float f;
            if (this.dataPanel[i] instanceof XYPanel && !(this.dataPanel[i] instanceof SumXYPanel) && this.checkBox[i].isSelected() && (f = ((XYPanel)this.dataPanel[i]).getMaxValue()) > newMax) {
                newMax = f;
            }
            ++i;
        }
        i = 0;
        while (i < this.dataPanel.length) {
            if (this.dataPanel[i] instanceof XYPanel && !(this.dataPanel[i] instanceof SumXYPanel)) {
                ((XYPanel)this.dataPanel[i]).setMaxValue(newMax);
            }
            ++i;
        }
    }

    private void restoreMaxValue() {
        int i = 0;
        while (i < this.dataPanel.length) {
            if (this.dataPanel[i] instanceof XYPanel && !(this.dataPanel[i] instanceof SumXYPanel)) {
                ((XYPanel)this.dataPanel[i]).restoreMaxValue();
            }
            ++i;
        }
    }

    class MyEventHandler
    implements PropertyChangeListener,
    ChangeListener,
    ActionListener,
    ItemListener {
        MyEventHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            int i;
            if (evt.getPropertyName().equals("focus")) {
                GenericFrame.this.pointedValues.setText((String)evt.getNewValue());
            }
            if (evt.getPropertyName().equals("minZoom")) {
                GenericFrame.this.minZoom = (Integer)evt.getNewValue();
                i = 0;
                while (i < GenericFrame.this.dataPanel.length) {
                    if (GenericFrame.this.dataPanel[i] != null) {
                        GenericFrame.this.dataPanel[i].setMinZoomBar(GenericFrame.this.minZoom);
                    }
                    ++i;
                }
            }
            if (evt.getPropertyName().equals("maxZoom")) {
                GenericFrame.this.maxZoom = (Integer)evt.getNewValue();
                i = 0;
                while (i < GenericFrame.this.dataPanel.length) {
                    if (GenericFrame.this.dataPanel[i] != null) {
                        GenericFrame.this.dataPanel[i].setMaxZoomBar(GenericFrame.this.maxZoom);
                    }
                    ++i;
                }
            }
            if (evt.getPropertyName().equals("focusBar")) {
                int fb = (Integer)evt.getNewValue();
                int i2 = 0;
                while (i2 < GenericFrame.this.dataPanel.length) {
                    if (GenericFrame.this.dataPanel[i2] != null) {
                        GenericFrame.this.dataPanel[i2].setFocusBar(fb);
                    }
                    ++i2;
                }
            }
        }

        public void stateChanged(ChangeEvent e) {
            int i = 0;
            while (i < GenericFrame.this.checkBox.length) {
                if (e.getSource() == GenericFrame.this.checkBox[i]) {
                    int j;
                    GenericFrame.this.graphPanel[i].setVisible(GenericFrame.this.checkBox[i].isSelected());
                    if (!GenericFrame.this.separatorPressed) {
                        GenericFrame.this.hideShowSeparators(i);
                    }
                    if (GenericFrame.this.sumPanelList != null) {
                        j = 0;
                        while (j < GenericFrame.this.sumPanelList.length) {
                            GenericFrame.this.sumPanelList[j].panelIsSelected(GenericFrame.this.dataPanel[i], GenericFrame.this.checkBox[i].isSelected());
                            ++j;
                        }
                    }
                    if (GenericFrame.this.avgSumPanelList != null) {
                        j = 0;
                        while (j < GenericFrame.this.avgSumPanelList.length) {
                            GenericFrame.this.avgSumPanelList[j].panelIsSelected(GenericFrame.this.dataPanel[i], GenericFrame.this.checkBox[i].isSelected());
                            ++j;
                        }
                    }
                    if (GenericFrame.this.forceSameMax) {
                        GenericFrame.this.alignMaxValue();
                    }
                    return;
                }
                ++i;
            }
            if (e.getSource() == GenericFrame.this.sameMaxBox) {
                if (GenericFrame.this.sameMaxBox.isSelected()) {
                    if (!GenericFrame.this.forceSameMax) {
                        GenericFrame.this.alignMaxValue();
                        GenericFrame.this.forceSameMax = true;
                    }
                } else if (GenericFrame.this.forceSameMax) {
                    GenericFrame.this.restoreMaxValue();
                    GenericFrame.this.forceSameMax = false;
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GenericFrame.this.allButton) {
                int i = 0;
                while (i < GenericFrame.this.checkBox.length) {
                    if (GenericFrame.this.checkBox[i] != null) {
                        GenericFrame.this.checkBox[i].setSelected(true);
                    }
                    ++i;
                }
                if (GenericFrame.this.sumPanelList != null) {
                    i = 0;
                    while (i < GenericFrame.this.sumPanelList.length) {
                        GenericFrame.this.sumPanelList[i].selectAll();
                        ++i;
                    }
                }
                if (GenericFrame.this.avgSumPanelList != null) {
                    i = 0;
                    while (i < GenericFrame.this.avgSumPanelList.length) {
                        GenericFrame.this.avgSumPanelList[i].selectAll();
                        ++i;
                    }
                }
                return;
            }
            if (e.getSource() == GenericFrame.this.noneButton) {
                int i = 0;
                while (i < GenericFrame.this.checkBox.length) {
                    if (GenericFrame.this.checkBox[i] != null) {
                        GenericFrame.this.checkBox[i].setSelected(false);
                    }
                    ++i;
                }
                if (GenericFrame.this.sumPanelList != null) {
                    i = 0;
                    while (i < GenericFrame.this.sumPanelList.length) {
                        GenericFrame.this.sumPanelList[i].deselectAll();
                        ++i;
                    }
                }
                if (GenericFrame.this.avgSumPanelList != null) {
                    i = 0;
                    while (i < GenericFrame.this.avgSumPanelList.length) {
                        GenericFrame.this.avgSumPanelList[i].deselectAll();
                        ++i;
                    }
                }
                return;
            }
            if (e.getSource() == GenericFrame.this.saveButton) {
                GenericFrame.this.printFrame();
                return;
            }
            if (e.getSource() == GenericFrame.this.zoomButton) {
                if (GenericFrame.this.minZoom >= 0 && GenericFrame.this.maxZoom < DataSet.SLOTS) {
                    Vector<Integer> v = new Vector<Integer>();
                    v.add(new Integer(GenericFrame.this.minZoom));
                    v.add(new Integer(GenericFrame.this.maxZoom + 1));
                    GenericFrame.this.firePropertyChange("zoomEvent", null, v);
                }
                return;
            }
            int i = 0;
            while (i < GenericFrame.this.separatorButton.size()) {
                if (e.getSource() == (JToggleButton)GenericFrame.this.separatorButton.elementAt(i)) {
                    GenericFrame.this.separatorPressed(i);
                }
                ++i;
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == GenericFrame.this.absMinMaxTButton) {
                int state = e.getStateChange();
                Vector<Boolean> v = new Vector<Boolean>();
                if (state == 1) {
                    GenericFrame.this.absMinMaxTButton.setText("Absolute Min&Max: ON");
                    v.add(new Boolean(true));
                } else {
                    GenericFrame.this.absMinMaxTButton.setText("Absolute Min&Max: OFF");
                    v.add(new Boolean(false));
                }
                GenericFrame.this.firePropertyChange("errorBar", null, v);
            }
        }
    }

    class MyFileFilter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public MyFileFilter(String ext) {
            this(new String[]{ext}, null);
        }

        public MyFileFilter(String[] exts, String descr) {
            this.extensions = new String[exts.length];
            int i = exts.length - 1;
            while (i >= 0) {
                this.extensions[i] = exts[i].toLowerCase();
                --i;
            }
            this.description = descr == null ? String.valueOf(exts[0]) + " files" : descr;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName().toLowerCase();
            int i = this.extensions.length - 1;
            while (i >= 0) {
                if (name.endsWith(this.extensions[i])) {
                    return true;
                }
                --i;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

