/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import pGraph.DataSet;
import pGraph.GenericPanel;
import pGraph.GlobalConfig;

public class XYPanel
extends GenericPanel {
    protected static final byte VALUE = 0;
    protected static final byte MIN = 1;
    protected static final byte MAX = 2;
    private boolean showErrorBars = true;
    private boolean forbidErrorBars = false;
    private static final long serialVersionUID = -1515932918244424846L;
    private static final byte MIN_PIXEL_DIST = 8;
    private static final float DOT_SIZE = 6.0f;
    private static final float[] dash = new float[]{2.0f, 2.0f};
    private static BasicStroke lineStroke = new BasicStroke(2.0f, 1, 1);
    private static BasicStroke minMaxStroke = new BasicStroke(1.0f, 1, 1);
    private static BasicStroke dotStroke = new BasicStroke(6.0f, 1, 1);
    private static BasicStroke connStroke = new BasicStroke(1.0f, 1, 1, 1.0f, dash, 2.0f);

    public void setShowErrorbars(boolean showErrorBars) {
        this.showErrorBars = showErrorBars;
        this.repaint();
    }

    public void setForbidErrorbars(boolean v) {
        this.forbidErrorBars = v;
        this.repaint();
    }

    public XYPanel(GlobalConfig config) {
        super(config);
    }

    public void paint(Graphics g) {
        super.paintComponent(g);
        int ysize = this.getHeight() - this.TEXT_SPACE;
        g.setColor(this.configuration.getGraphBackColor());
        g.fillRect(0, 0, DataSet.SLOTS, ysize);
        if (this.dataSet == null) {
            return;
        }
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                this.drawLine(i, g);
            }
            ++i;
        }
        this.drawZoomBars(g);
        this.drawGrid(g);
        this.drawLimits(g);
    }

    private void drawLine(int n, Graphics g) {
        if (!this.forbidErrorBars && this.showErrorBars) {
            this.drawLine(n, g, (byte)1);
            this.drawLine(n, g, (byte)2);
        }
        this.drawLine(n, g, (byte)0);
    }

    private void drawLine(int n, Graphics g, byte type) {
        int ysize = this.getHeight() - this.TEXT_SPACE - 1;
        int goodx = -1;
        int goody = -1;
        Graphics2D g2 = (Graphics2D)g;
        Color color = this.configuration.getLineColor(n);
        if (type == 1 || type == 2) {
            color = color.darker().darker();
        }
        g2.setColor(color);
        if (type == 1 || type == 2) {
            g2.setStroke(minMaxStroke);
        } else {
            g2.setStroke(lineStroke);
        }
        int i = 0;
        while (i < DataSet.SLOTS) {
            float value;
            switch (type) {
                case 0: {
                    value = this.dataSet[n].getValue(i);
                    break;
                }
                case 1: {
                    value = this.dataSet[n].getAbsMin(i);
                    break;
                }
                case 2: {
                    value = this.dataSet[n].getAbsMax(i);
                    break;
                }
                default: {
                    return;
                }
            }
            if (!(value < 0.0f)) {
                int y = ysize - 1 - (int)(1.0f * value * (float)(ysize - 1) / this.maxValue) + 1;
                if (goodx >= 0 && i - goodx < 8) {
                    g2.drawLine(goodx, goody, i, y);
                } else {
                    if (goodx >= 0) {
                        g2.setStroke(dotStroke);
                        g2.drawLine(goodx, goody, goodx, goody);
                        g2.setStroke(connStroke);
                        g2.drawLine(goodx, goody, i, y);
                    }
                    g2.setStroke(dotStroke);
                    g2.drawLine(i, y, i, y);
                    if (type == 1 || type == 2) {
                        g2.setStroke(minMaxStroke);
                    } else {
                        g2.setStroke(lineStroke);
                    }
                }
                goodx = i;
                goody = y;
            }
            ++i;
        }
        if (goodx >= 0) {
            g2.setStroke(dotStroke);
            g2.drawLine(goodx, goody, goodx, goody);
            if (type == 1 || type == 2) {
                g2.setStroke(minMaxStroke);
            } else {
                g2.setStroke(lineStroke);
            }
        }
    }
}

