/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class TimePanel
extends JPanel
implements MouseInputListener,
MouseMotionListener {
    private static final long serialVersionUID = 8544039225571683710L;
    private GregorianCalendar minTime;
    private GregorianCalendar maxTime;
    private GregorianCalendar minActive;
    private GregorianCalendar maxActive;
    private GregorianCalendar minZoom;
    private GregorianCalendar maxZoom;
    private int activeFrom;
    private int activeTo;
    private int zoomFrom;
    private int zoomTo;
    private static final byte ACTIVE_HEIGHT = 20;
    private static final byte KNOB_HALF = 5;
    private static final Font font = new Font("SansSerif", 1, 10);
    private float[] pattern = new float[2];
    private byte activeLimit = 0;
    private boolean pressed = false;
    private int pressedPoint;
    private int pressedZoomFrom;
    private int pressedZoomTo;
    private static final byte NONE = 0;
    private static final byte START = 1;
    private static final byte END = 2;
    private static final byte BOTH = 3;

    public TimePanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.maxTime = null;
        this.minTime = null;
        this.maxActive = null;
        this.minActive = null;
        this.maxZoom = null;
        this.minZoom = null;
        this.pattern[0] = 10.0f;
        this.pattern[1] = 5.0f;
        this.setTime(new GregorianCalendar(1970, 0, 1), new GregorianCalendar());
    }

    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return null;
        }
        FontMetrics metrics = g.getFontMetrics(font);
        return new Dimension(3 * metrics.stringWidth("2008-12-12 00:00:00"), 20 + 4 * metrics.getAscent());
    }

    public void setTime(GregorianCalendar minTime, GregorianCalendar maxTime) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.minActive = (GregorianCalendar)minTime.clone();
        this.maxActive = (GregorianCalendar)maxTime.clone();
        this.minZoom = (GregorianCalendar)minTime.clone();
        this.maxZoom = (GregorianCalendar)maxTime.clone();
    }

    public void setActive(GregorianCalendar minActive, GregorianCalendar maxActive) {
        this.minActive = minActive;
        this.maxActive = maxActive;
        this.minZoom = (GregorianCalendar)minActive.clone();
        this.maxZoom = (GregorianCalendar)maxActive.clone();
    }

    public void paint(Graphics g) {
        super.paintComponent(g);
        int xsize = this.getWidth();
        int ysize = this.getHeight();
        if (xsize == 0) {
            return;
        }
        long min = this.minTime.getTimeInMillis();
        long max = this.maxTime.getTimeInMillis();
        this.activeFrom = 5 + (int)(1.0f * (float)(xsize - 10) * (float)(this.minActive.getTimeInMillis() - min) / (float)(max - min));
        this.activeTo = 5 + (int)(1.0f * (float)(xsize - 10) * (float)(this.maxActive.getTimeInMillis() - min) / (float)(max - min));
        this.zoomFrom = 5 + (int)(1.0f * (float)(xsize - 10) * (float)(this.minZoom.getTimeInMillis() - min) / (float)(max - min));
        this.zoomTo = 5 + (int)(1.0f * (float)(xsize - 10) * (float)(this.maxZoom.getTimeInMillis() - min) / (float)(max - min));
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(font);
        g.setColor(new Color(157, 156, 153));
        g.drawLine(5, ysize / 2 - 2, xsize - 5, ysize / 2 - 2);
        g.setColor(new Color(242, 241, 233));
        g.drawLine(5, ysize / 2 - 1, xsize - 5, ysize / 2 - 1);
        g.drawLine(5, ysize / 2, xsize - 5, ysize / 2);
        g.setColor(new Color(240, 237, 224));
        g.drawLine(5, ysize / 2 + 1, xsize - 5, ysize / 2 + 1);
        g.setColor(new Color(255, 255, 255));
        g.drawLine(5, ysize / 2 + 2, xsize - 5, ysize / 2 + 2);
        g.setColor(Color.BLACK);
        g.drawLine(this.activeFrom, ysize / 2 - 1, this.activeTo, ysize / 2 - 1);
        g.drawLine(this.activeFrom, ysize / 2, this.activeTo, ysize / 2);
        g.drawLine(this.activeFrom, ysize / 2 + 1, this.activeTo, ysize / 2 + 1);
        g.drawLine(this.activeFrom, ysize / 2 - 5, this.activeFrom, ysize / 2 + 5);
        g.drawLine(this.activeFrom - 1, ysize / 2 - 5, this.activeFrom - 1, ysize / 2 + 5);
        g.drawLine(this.activeFrom + 1, ysize / 2 - 5, this.activeFrom + 1, ysize / 2 + 5);
        g.drawLine(this.activeTo, ysize / 2 - 5, this.activeTo, ysize / 2 + 5);
        g.drawLine(this.activeTo - 1, ysize / 2 - 5, this.activeTo - 1, ysize / 2 + 5);
        g.drawLine(this.activeTo + 1, ysize / 2 - 5, this.activeTo + 1, ysize / 2 + 5);
        g.setColor(new Color(0, 0, 0, 30));
        g.fillRect(this.activeFrom, 0, this.activeTo - this.activeFrom + 1, ysize);
        if (this.minTime == null) {
            return;
        }
        String from = this.gcToString(this.minActive);
        String to = this.gcToString(this.maxActive);
        FontMetrics metrics = g2.getFontMetrics(font);
        int fromSize = metrics.stringWidth(from);
        int toSize = metrics.stringWidth(to);
        int asc = metrics.getAscent() + 2;
        g.setColor(Color.BLACK);
        if (fromSize > this.activeFrom) {
            g2.drawString(from, 0, ysize / 2 + 10 + asc);
        } else if (this.activeTo + toSize > xsize && this.activeFrom > xsize - toSize - 20) {
            g2.drawString(from, xsize - toSize - 20 - fromSize, ysize / 2 + 10 + asc);
            g2.drawLine(xsize - toSize - 20, ysize / 2 + 10, this.activeFrom, ysize / 2);
        } else {
            g2.drawString(from, this.activeFrom - fromSize, ysize / 2 + 10 + asc);
        }
        if (this.activeTo + toSize > xsize) {
            g2.drawString(to, xsize - toSize, ysize / 2 + 10 + asc);
        } else if (fromSize > this.activeFrom && fromSize + 20 > this.activeTo) {
            g2.drawString(to, fromSize + 20, ysize / 2 + 10 + asc);
            g2.drawLine(fromSize + 20, ysize / 2 + 10, this.activeTo, ysize / 2);
        } else {
            g2.drawString(to, this.activeTo, ysize / 2 + 10 + asc);
        }
        if (this.zoomFrom >= 0) {
            g.setColor(Color.RED);
            g.drawLine(this.zoomFrom, ysize / 2 - 1, this.zoomTo, ysize / 2 - 1);
            g.drawLine(this.zoomFrom, ysize / 2, this.zoomTo, ysize / 2);
            g.drawLine(this.zoomFrom, ysize / 2 + 1, this.zoomTo, ysize / 2 + 1);
            from = this.gcToString(this.minZoom);
            to = this.gcToString(this.maxZoom);
            metrics = g2.getFontMetrics(font);
            fromSize = metrics.stringWidth(from);
            toSize = metrics.stringWidth(to);
            if (fromSize > this.zoomFrom) {
                g2.drawString(from, 0, ysize / 2 - 10 - 2);
            } else if (this.zoomTo + toSize > xsize && this.zoomFrom > xsize - toSize - 20) {
                g2.drawString(from, xsize - toSize - 20 - fromSize, ysize / 2 - 10 - 2);
                g2.drawLine(xsize - toSize - 20, ysize / 2 - 10 - 2, this.zoomFrom, ysize / 2);
            } else {
                g2.drawString(from, this.zoomFrom - fromSize, ysize / 2 - 10 - 2);
            }
            if (this.zoomTo + toSize > xsize) {
                g2.drawString(to, xsize - toSize, ysize / 2 - 10 - 2);
            } else if (fromSize > this.zoomFrom && fromSize + 20 > this.zoomTo) {
                g2.drawString(to, fromSize + 20, ysize / 2 - 10 - 2);
                g2.drawLine(fromSize + 20, ysize / 2 - 10 - 2, this.zoomTo, ysize / 2);
            } else {
                g2.drawString(to, this.zoomTo, ysize / 2 - 10 - 2);
            }
        }
        this.paintKnob(g, this.zoomFrom, ysize / 2, this.activeLimit == 1);
        this.paintKnob(g, this.zoomTo, ysize / 2, this.activeLimit == 2);
    }

    protected String gcToString(GregorianCalendar gc) {
        int Y = gc.get(1);
        int M = gc.get(2) + 1;
        int D = gc.get(5);
        int h = gc.get(11);
        int m = gc.get(12);
        int s = gc.get(13);
        String str = String.valueOf(Y) + "-";
        if (M < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + M + "-";
        if (D < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + D + " ";
        if (h < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + h + ":";
        if (m < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + m + ":";
        if (s < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + s;
        return str;
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int xsize = this.getWidth();
        if (x < 0 || x > xsize) {
            return;
        }
        if (this.zoomFrom >= 0 && !this.pressed) {
            this.activeLimit = this.zoomFrom - 5 <= x && x <= this.zoomFrom + 5 ? (byte)1 : (this.zoomTo - 5 <= x && x <= this.zoomTo + 5 ? (byte)2 : (this.zoomFrom < x && x < this.zoomTo ? (byte)3 : (byte)0));
        }
        if (this.pressed) {
            if (this.activeLimit == 1) {
                if (x < this.zoomTo) {
                    this.zoomFrom = x;
                }
                if (this.zoomFrom < 5) {
                    this.zoomFrom = 5;
                }
            } else if (this.activeLimit == 2) {
                if (x > this.zoomFrom) {
                    this.zoomTo = x;
                }
                if (this.zoomTo > xsize - 5) {
                    this.zoomTo = xsize - 5;
                }
            } else if (this.activeLimit == 3) {
                this.zoomFrom = this.pressedZoomFrom + (x - this.pressedPoint);
                this.zoomTo = this.pressedZoomTo + (x - this.pressedPoint);
                if (this.zoomFrom < 5) {
                    this.zoomFrom = 5;
                }
                if (this.zoomTo > xsize - 5) {
                    this.zoomTo = xsize - 5;
                }
            }
            long delta = this.maxTime.getTimeInMillis() - this.minTime.getTimeInMillis();
            this.minZoom.setTimeInMillis(this.minTime.getTimeInMillis() + (long)(1.0f * (float)delta * (float)(this.zoomFrom - 5) / (float)(this.getWidth() - 10)));
            this.maxZoom.setTimeInMillis(this.minTime.getTimeInMillis() + (long)(1.0f * (float)delta * (float)(this.zoomTo - 5) / (float)(this.getWidth() - 10)));
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e) {
        int m = e.getModifiers();
        if ((m & 0x10) == 0) {
            return;
        }
        this.pressed = true;
        this.pressedPoint = e.getX();
        this.pressedZoomFrom = this.zoomFrom;
        this.pressedZoomTo = this.zoomTo;
    }

    public void mouseReleased(MouseEvent arg0) {
        this.pressed = false;
    }

    private void paintKnob(Graphics g, int x, int y, boolean selected) {
        g.setColor(new Color(181, 196, 205));
        g.drawLine(x - 5, y - 10 + 2, x - 5, y + 10 - 2);
        g.setColor(new Color(212, 211, 225));
        g.drawLine(x - 4, y - 10 + 2, x - 4, y + 10 - 2);
        g.setColor(new Color(255, 255, 255));
        g.drawLine(x - 3, y - 10 + 2, x - 3, y + 10 - 2);
        g.setColor(new Color(241, 241, 241));
        g.drawLine(x - 2, y - 10 + 2, x - 2, y + 10 - 2);
        g.setColor(new Color(225, 225, 235));
        g.drawLine(x - 1, y - 10 + 2, x - 1, y + 10 - 2);
        g.setColor(new Color(212, 211, 225));
        g.drawLine(x, y - 10 + 2, x, y + 10 - 2);
        g.drawLine(x + 1, y - 10 + 2, x + 1, y + 10 - 2);
        g.setColor(new Color(198, 198, 210));
        g.drawLine(x + 2, y - 10 + 2, x + 2, y + 10 - 2);
        g.drawLine(x + 3, y - 10 + 2, x + 3, y + 10 - 2);
        g.setColor(new Color(183, 182, 196));
        g.drawLine(x + 4, y - 10 + 2, x + 4, y + 10 - 2);
        g.setColor(new Color(119, 136, 146));
        g.drawLine(x + 5, y - 10 + 2, x + 5, y + 10 - 2);
        if (selected) {
            g.setColor(Color.GREEN);
        } else {
            g.setColor(Color.ORANGE);
        }
        g.drawLine(x - 5, y - 10 + 1, x + 5, y - 10 + 1);
        g.drawLine(x - 4, y - 10, x + 4, y - 10);
        g.drawLine(x - 5, y + 10 - 1, x + 5, y + 10 - 1);
        g.drawLine(x - 4, y + 10, x + 4, y + 10);
    }

    public GregorianCalendar getMinZoom() {
        return this.minZoom;
    }

    public GregorianCalendar getMaxZoom() {
        return this.maxZoom;
    }

    public GregorianCalendar getMinActive() {
        return this.minActive;
    }

    public GregorianCalendar getMaxActive() {
        return this.maxActive;
    }
}

