/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.util.GregorianCalendar;
import java.util.Vector;
import pGraph.DataSet;
import pGraph.Parser;

public class PerfData {
    private static final int ITEM_BLOCK = 10;
    private DataSet[][][] data = new DataSet[15][10][];
    private String[][] names = new String[15][10];
    private int[] valid_names = new int[15];
    private int[][] sorted_names = new int[15][];
    private float cpuWeight = 1.0f;
    private Vector<String> lssrad_ref1 = null;
    private Vector<String> lssrad_srad = null;
    private Vector<String> lssrad_mem = null;
    private Vector<String> lssrad_cpu = null;
    public static final byte LPARSTATI = 0;
    public static final byte VMSTATV = 1;
    public static final byte VMSTATVEND = 2;
    private static final byte NUM_TEXT = 3;
    private Vector<String>[] textLabel = new Vector[3];
    private Vector<String>[] textValue = new Vector[3];
    public static final byte SMT_UNKNOWN = 0;
    public static final byte SMT_SUPPOSED_ON = 1;
    public static final byte SMT_SUPPOSED_OFF = 2;
    public static final byte SMT_PARSED = 3;
    private byte smtStatus = 0;
    private byte smt_threads = 0;
    private GregorianCalendar start = null;
    private GregorianCalendar end = null;
    private static final String SYSTEM_ITEM = "S";
    public static final byte SYSTEM = 0;
    public static final byte CPU = 1;
    public static final byte DISK = 2;
    public static final byte ESS = 3;
    public static final byte SCSI = 4;
    public static final byte NETWORK = 5;
    public static final byte WPAR = 6;
    public static final byte TOPPROC = 7;
    public static final byte TOPPROC_BY_NAME = 8;
    public static final byte FS = 9;
    public static final byte FCSTAT = 10;
    public static final byte DAC = 11;
    public static final byte PROCPOOL = 12;
    public static final byte SEA = 13;
    public static final byte PCPU = 14;
    private static final byte NUM_GROUPS = 15;
    public static final byte PC = 0;
    public static final byte VP = 1;
    public static final byte LP = 2;
    public static final byte POOL = 3;
    public static final byte FREEPOOL = 4;
    public static final byte ENT = 5;
    public static final byte EC = 6;
    public static final byte AVM = 7;
    public static final byte FRE = 8;
    public static final byte PI = 9;
    public static final byte PO = 10;
    public static final byte FI = 11;
    public static final byte FO = 12;
    public static final byte FR = 13;
    public static final byte CY = 14;
    public static final byte SR = 15;
    public static final byte RAM = 16;
    public static final byte NUMPERM = 17;
    public static final byte MINPERM = 18;
    public static final byte MAXPERM = 19;
    public static final byte MINFREE = 20;
    public static final byte MAXFREE = 21;
    public static final byte NUMFREE = 22;
    public static final byte USEDMEM = 23;
    public static final byte NUMCLIENT = 24;
    public static final byte MAXCLIENT = 25;
    public static final byte RUNQ = 26;
    public static final byte SWQ = 27;
    public static final byte WQPS = 28;
    public static final byte PSW = 29;
    public static final byte SYSC = 30;
    public static final byte FORK = 31;
    public static final byte EXEC = 32;
    public static final byte READ = 33;
    public static final byte WRITE = 34;
    public static final byte TOT_CPU = 35;
    public static final byte SRFR_RATIO = 36;
    public static final byte DED = 37;
    public static final byte SHARED = 38;
    public static final byte SHARED_DED = 39;
    public static final byte DED_PC = 40;
    public static final byte GLOB_PC = 41;
    public static final byte NUM_AIO = 42;
    public static final byte ACTIVE_AIO = 43;
    public static final byte CPU_AIO = 44;
    public static final byte LOGICAL_MEM = 45;
    public static final byte PHYS_MEM = 46;
    public static final byte LOAN_MEM = 47;
    public static final byte HYPPAG_IN = 48;
    public static final byte HYPPAG_TIME = 49;
    public static final byte USED_LP = 50;
    public static final byte FREE_LP = 51;
    public static final byte TRUE_MEM = 52;
    public static final byte COMP_POOL = 53;
    public static final byte UNC_POOL = 54;
    public static final byte EXP_MEM = 55;
    public static final byte CP_PI = 56;
    public static final byte CP_PO = 57;
    public static final byte ENT_USED = 58;
    public static final byte PC_USED = 59;
    public static final byte FOLDED = 60;
    public static final byte VP_US = 61;
    public static final byte VP_SY = 62;
    public static final byte VP_WA = 63;
    public static final byte VP_ID = 64;
    public static final byte CPI = 65;
    public static final byte FAULTS = 66;
    private static final byte NUM_SYSTEM = 67;
    public static final byte US = 0;
    public static final byte SY = 1;
    public static final byte WA = 2;
    public static final byte ID = 3;
    private static final byte NUM_CPU = 4;
    public static final byte DSK_BUSY = 0;
    public static final byte DSK_READKB = 1;
    public static final byte DSK_WRITEKB = 2;
    public static final byte DSK_XFER = 3;
    public static final byte DSK_BSIZE = 4;
    public static final byte DSK_RPS = 5;
    public static final byte DSK_AVG_R = 6;
    public static final byte DSK_MIN_R = 7;
    public static final byte DSK_MAX_R = 8;
    public static final byte DSK_TO_R = 9;
    public static final byte DSK_FAIL_R = 10;
    public static final byte DSK_WPS = 11;
    public static final byte DSK_AVG_W = 12;
    public static final byte DSK_MIN_W = 13;
    public static final byte DSK_MAX_W = 14;
    public static final byte DSK_TO_W = 15;
    public static final byte DSK_FAIL_W = 16;
    public static final byte DSK_AVG_T = 17;
    public static final byte DSK_MIN_T = 18;
    public static final byte DSK_MAX_T = 19;
    public static final byte DSK_AVG_WQ = 20;
    public static final byte DSK_AVG_SQ = 21;
    public static final byte DSK_FULLQ = 22;
    public static final byte DSK_AVGSERV = 23;
    public static final byte DSK_AVGWAIT = 24;
    public static final byte DSK_AVG_RW = 25;
    public static final byte DSK_RWPS = 26;
    private static final byte NUM_DISK = 27;
    public static final byte ESS_READKB = 0;
    public static final byte ESS_WRITEKB = 1;
    public static final byte ESS_XFER = 2;
    public static final byte ESS_BUSY = 3;
    public static final byte ESS_AVGSERV = 4;
    public static final byte ESS_AVGWAIT = 5;
    private static final byte NUM_ESS = 6;
    public static final byte SCSI_READKB = 0;
    public static final byte SCSI_WRITEKB = 1;
    public static final byte SCSI_XFER = 2;
    public static final byte SCSI_RPS = 3;
    public static final byte SCSI_AVG_R = 4;
    public static final byte SCSI_MIN_R = 5;
    public static final byte SCSI_MAX_R = 6;
    public static final byte SCSI_WPS = 7;
    public static final byte SCSI_AVG_W = 8;
    public static final byte SCSI_MIN_W = 9;
    public static final byte SCSI_MAX_W = 10;
    public static final byte SCSI_AVG_T = 11;
    public static final byte SCSI_MIN_T = 12;
    public static final byte SCSI_MAX_T = 13;
    public static final byte SCSI_AVG_WQ = 14;
    public static final byte SCSI_AVG_SQ = 15;
    public static final byte SCSI_FULLQ = 16;
    private static final byte NUM_SCSI = 17;
    public static final byte NET_READKB = 0;
    public static final byte NET_WRITEKB = 1;
    public static final byte NET_READS = 2;
    public static final byte NET_WRITES = 3;
    public static final byte NET_IERRORS = 4;
    public static final byte NET_OERRORS = 5;
    public static final byte NET_COLLISIONS = 6;
    private static final byte NUM_NETWORK = 7;
    public static final byte WPAR_CPU = 0;
    public static final byte WPAR_MEM = 1;
    public static final byte WPAR_DISK = 2;
    public static final byte WPAR_PROC = 3;
    private static final byte NUM_WPAR = 4;
    public static final byte TOP_CPU = 0;
    public static final byte TOP_RESTEXT = 1;
    public static final byte TOP_RESDATA = 2;
    private static final byte NUM_TOPPROC = 3;
    public static final byte TOP_CPU_BYNAME = 0;
    public static final byte TOP_RAM_BYNAME = 1;
    private static final byte NUM_TOPPROC_BYNAME = 2;
    public static final byte SPACEUSED = 0;
    public static final byte INODEUSED = 1;
    private static final byte NUM_FS = 2;
    public static final byte FCREAD = 0;
    public static final byte FCWRITE = 1;
    public static final byte FCXFERIN = 2;
    public static final byte FCXFEROUT = 3;
    private static final byte NUM_FCSTAT = 4;
    public static final byte POOLSIZE = 0;
    public static final byte POOLUSED = 1;
    public static final byte ACTIVEPOOL = 2;
    private static final byte NUM_PROCPOOL = 3;
    public static final byte P_TOT = 0;
    private static final byte NUM_PCPU = 1;

    public PerfData() {
        int i = 0;
        while (i < 15) {
            this.valid_names[i] = 0;
            ++i;
        }
    }

    public byte getSmt_threads() {
        return this.smt_threads;
    }

    public void setSmt_threads(byte smt_threads) {
        this.smt_threads = smt_threads;
    }

    public int getNumTopProc() {
        int num = 0;
        int i = 0;
        while (i < this.data[7].length) {
            if (this.data[7][i] != null) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public void invalidateTop() {
        this.data[7] = new DataSet[10][];
        this.names[7] = new String[10];
        this.valid_names[7] = 0;
    }

    private byte getGroupTypes(byte group) {
        switch (group) {
            case 0: {
                return 67;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 27;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 17;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 4;
            }
            case 11: {
                return 27;
            }
            case 12: {
                return 3;
            }
            case 13: {
                return 7;
            }
            case 14: {
                return 1;
            }
        }
        System.out.println("FATAL ERROR: getGroupTypes(" + group + ")");
        System.exit(1);
        return 0;
    }

    private String getSetName(byte group, byte type) {
        switch (group) {
            case 0: {
                switch (type) {
                    case 0: {
                        return "Proc consumed";
                    }
                    case 1: {
                        return "Virt Proc";
                    }
                    case 2: {
                        return "Logical Proc";
                    }
                    case 3: {
                        return "Proc Pool";
                    }
                    case 4: {
                        return "Free Pool";
                    }
                    case 5: {
                        return "Entitlement";
                    }
                    case 6: {
                        return "Ent% Consumed";
                    }
                    case 7: {
                        return "Avg Virt Mem";
                    }
                    case 8: {
                        return "Free RAM MB";
                    }
                    case 9: {
                        return "Paging IN 4KB";
                    }
                    case 10: {
                        return "Paging OUT 4KB";
                    }
                    case 11: {
                        return "File page-in / sec";
                    }
                    case 12: {
                        return "File page-out / sec";
                    }
                    case 13: {
                        return "Pages Freed";
                    }
                    case 14: {
                        return "Clock Cycles";
                    }
                    case 15: {
                        return "Pages Scanned";
                    }
                    case 16: {
                        return "Total RAM MB";
                    }
                    case 17: {
                        return "Num% Perm Pages";
                    }
                    case 18: {
                        return "Min% Perm Pages";
                    }
                    case 19: {
                        return "Max% Perm Pages";
                    }
                    case 22: {
                        return "Num Free Pages";
                    }
                    case 23: {
                        return "Used RAM MB";
                    }
                    case 20: {
                        return "Min Free Pages";
                    }
                    case 21: {
                        return "Max Free Pages";
                    }
                    case 24: {
                        return "Num% Client Pages";
                    }
                    case 25: {
                        return "Max% Client Pages";
                    }
                    case 26: {
                        return "RunQ";
                    }
                    case 27: {
                        return "WaitQ";
                    }
                    case 28: {
                        return "#threads waiting I/O per sec";
                    }
                    case 29: {
                        return "Proc Switches";
                    }
                    case 30: {
                        return "Sys Calls";
                    }
                    case 31: {
                        return "Forks";
                    }
                    case 32: {
                        return "Execs";
                    }
                    case 33: {
                        return "Reads";
                    }
                    case 34: {
                        return "Write";
                    }
                    case 35: {
                        return "Total sys CPU";
                    }
                    case 36: {
                        return "sr/fr ratio";
                    }
                    case 37: {
                        return "#Dedicated";
                    }
                    case 38: {
                        return "#Shared";
                    }
                    case 39: {
                        return "#Shared dedicated";
                    }
                    case 40: {
                        return "Hint on Proc Consumed";
                    }
                    case 41: {
                        return "uLPAR + hint-dedicated";
                    }
                    case 42: {
                        return "Total AIO Procs";
                    }
                    case 43: {
                        return "Active AIO Procs";
                    }
                    case 44: {
                        return "CPU used by AIO";
                    }
                    case 45: {
                        return "Logical Memory";
                    }
                    case 46: {
                        return "Physical Memory";
                    }
                    case 47: {
                        return "Loaned Memory";
                    }
                    case 48: {
                        return "Hypervisor page-in";
                    }
                    case 49: {
                        return "Hypervisor page-in time";
                    }
                    case 50: {
                        return "#large pages used";
                    }
                    case 51: {
                        return "#large pages free";
                    }
                    case 52: {
                        return "True Mem MB";
                    }
                    case 53: {
                        return "Comp pool MB";
                    }
                    case 54: {
                        return "Uncomp pool MB";
                    }
                    case 55: {
                        return "Exp Mem MB";
                    }
                    case 56: {
                        return "Comp Pool pgin";
                    }
                    case 57: {
                        return "Comp Pool pgout";
                    }
                    case 58: {
                        return "Proc consumed within ent";
                    }
                    case 59: {
                        return "Proc consumed & used";
                    }
                    case 60: {
                        return "Folded VPs";
                    }
                    case 61: {
                        return "VP Us%";
                    }
                    case 62: {
                        return "VP Sy%";
                    }
                    case 63: {
                        return "VP Wa%";
                    }
                    case 64: {
                        return "VP Id%";
                    }
                    case 65: {
                        return "Cycles per Instruction";
                    }
                    case 66: {
                        return "faults/s";
                    }
                }
                return "SYS-ERROR";
            }
            case 1: {
                switch (type) {
                    case 0: {
                        return "Us%";
                    }
                    case 1: {
                        return "Sy%";
                    }
                    case 2: {
                        return "Wa%";
                    }
                    case 3: {
                        return "Id%";
                    }
                }
                return "CPU-ERROR";
            }
            case 14: {
                switch (type) {
                    case 0: {
                        return "Total";
                    }
                }
                return "PCPU-ERROR";
            }
            case 2: {
                switch (type) {
                    case 0: {
                        return "Busy%";
                    }
                    case 1: {
                        return "Read KB";
                    }
                    case 2: {
                        return "Write KB";
                    }
                    case 3: {
                        return "Transf/sec";
                    }
                    case 4: {
                        return "Block size";
                    }
                    case 5: {
                        return "Reads/s";
                    }
                    case 6: {
                        return "AvgRead ms";
                    }
                    case 7: {
                        return "MinRead ms";
                    }
                    case 8: {
                        return "MaxRead ms";
                    }
                    case 9: {
                        return "read Timeouts/s";
                    }
                    case 10: {
                        return "Failed Read Requests/s";
                    }
                    case 11: {
                        return "Write/s";
                    }
                    case 12: {
                        return "AvgWrite ms";
                    }
                    case 13: {
                        return "MinWrite ms";
                    }
                    case 14: {
                        return "MaxWrite ms";
                    }
                    case 15: {
                        return "Write Timeouts/s";
                    }
                    case 16: {
                        return "Failed Write Requests/s";
                    }
                    case 17: {
                        return "AvgTime ms";
                    }
                    case 18: {
                        return "MinTime ms";
                    }
                    case 19: {
                        return "MaxTime ms";
                    }
                    case 20: {
                        return "Avg WaitQ Size";
                    }
                    case 21: {
                        return "Avg ServiceQ Size";
                    }
                    case 22: {
                        return "Service Queue full per sec";
                    }
                    case 23: {
                        return "Avg service time";
                    }
                    case 24: {
                        return "Service wait time";
                    }
                    case 25: {
                        return "AvgRW ms";
                    }
                    case 26: {
                        return "Read/s+Write/s";
                    }
                }
                return "DISK-ERROR";
            }
            case 3: {
                switch (type) {
                    case 0: {
                        return "Read KB";
                    }
                    case 1: {
                        return "Write KB";
                    }
                    case 2: {
                        return "Transf/sec";
                    }
                    case 4: {
                        return "Avg service time";
                    }
                    case 5: {
                        return "Service wait time";
                    }
                }
                return "ESS-ERROR";
            }
            case 4: {
                switch (type) {
                    case 0: {
                        return "Dsk Read KB";
                    }
                    case 1: {
                        return "Dsk Write KB";
                    }
                    case 2: {
                        return "Dsk Transf/sec";
                    }
                    case 3: {
                        return "Dsk Reads/s";
                    }
                    case 4: {
                        return "Dsk AvgRead ms";
                    }
                    case 5: {
                        return "Dsk MinRead ms";
                    }
                    case 6: {
                        return "Dsk MaxRead ms";
                    }
                    case 7: {
                        return "Dsk Write/s";
                    }
                    case 8: {
                        return "Dsk AvgWrite ms";
                    }
                    case 9: {
                        return "Dsk MinWrite ms";
                    }
                    case 10: {
                        return "Dsk MaxWrite ms";
                    }
                    case 11: {
                        return "Dsk AvgTime ms";
                    }
                    case 12: {
                        return "Dsk MinTime ms";
                    }
                    case 13: {
                        return "Dsk MaxTime ms";
                    }
                    case 14: {
                        return "Dsk Avg WaitQ Size";
                    }
                    case 15: {
                        return "Dsk Avg ServiceQ Size";
                    }
                    case 16: {
                        return "Dsk Service Queue full per sec";
                    }
                }
                return "SCSI-ERROR";
            }
            case 5: {
                switch (type) {
                    case 0: {
                        return "Read KB";
                    }
                    case 1: {
                        return "Write KB";
                    }
                    case 2: {
                        return "Reads/s";
                    }
                    case 3: {
                        return "Write/s";
                    }
                    case 4: {
                        return "In errors";
                    }
                    case 5: {
                        return "Out errors";
                    }
                    case 6: {
                        return "Collisions";
                    }
                }
                return "NETWORK-ERROR";
            }
            case 13: {
                switch (type) {
                    case 0: {
                        return "Read KB";
                    }
                    case 1: {
                        return "Write KB";
                    }
                    case 2: {
                        return "Reads/s";
                    }
                    case 3: {
                        return "Write/s";
                    }
                    case 4: {
                        return "In errors";
                    }
                    case 5: {
                        return "Out errors";
                    }
                    case 6: {
                        return "Collisions";
                    }
                }
                return "SEA-ERROR";
            }
            case 6: {
                switch (type) {
                    case 0: {
                        return "CPU%";
                    }
                    case 1: {
                        return "RAM%";
                    }
                    case 2: {
                        return "IO Bandwidth%";
                    }
                    case 3: {
                        return "Proc consumed";
                    }
                }
                return "WPAR-ERROR";
            }
            case 7: {
                switch (type) {
                    case 0: {
                        return "ONE-CPU%";
                    }
                    case 1: {
                        return "ResText";
                    }
                    case 2: {
                        return "ResData";
                    }
                }
                return "TOPPROC-ERROR";
            }
            case 8: {
                switch (type) {
                    case 0: {
                        return "ONE-CPU%";
                    }
                    case 1: {
                        return "MEM%";
                    }
                }
                return "TOPPROC-ERROR";
            }
            case 9: {
                switch (type) {
                    case 0: {
                        return "Space Used%";
                    }
                    case 1: {
                        return "Inode Used%";
                    }
                }
                return "FS-ERROR";
            }
            case 10: {
                switch (type) {
                    case 0: {
                        return "FC Read KB/s";
                    }
                    case 1: {
                        return "FC Write KB/s";
                    }
                    case 2: {
                        return "FC Transfer IN";
                    }
                    case 3: {
                        return "FC Transfer OUT";
                    }
                }
                return "FC-ERROR";
            }
            case 11: {
                switch (type) {
                    case 0: {
                        return "Dsk Read KB";
                    }
                    case 1: {
                        return "Dsk Write KB";
                    }
                    case 2: {
                        return "Dsk Transf/sec";
                    }
                    case 3: {
                        return "Dsk Reads/s";
                    }
                    case 4: {
                        return "Dsk AvgRead ms";
                    }
                    case 5: {
                        return "Dsk MinRead ms";
                    }
                    case 6: {
                        return "Dsk MaxRead ms";
                    }
                    case 7: {
                        return "Dsk Write/s";
                    }
                    case 8: {
                        return "Dsk AvgWrite ms";
                    }
                    case 9: {
                        return "Dsk MinWrite ms";
                    }
                    case 10: {
                        return "Dsk MaxWrite ms";
                    }
                    case 11: {
                        return "Dsk AvgTime ms";
                    }
                    case 12: {
                        return "Dsk MinTime ms";
                    }
                    case 13: {
                        return "Dsk MaxTime ms";
                    }
                    case 14: {
                        return "Dsk Avg WaitQ Size";
                    }
                    case 15: {
                        return "Dsk Avg ServiceQ Size";
                    }
                    case 16: {
                        return "Dsk Service Queue full per sec";
                    }
                }
                return "DAC-ERROR";
            }
            case 12: {
                switch (type) {
                    case 0: {
                        return "ProcPool size";
                    }
                    case 1: {
                        return "ProcPool used";
                    }
                    case 2: {
                        return "This pool is active";
                    }
                }
                return "PROCPOOL-ERROR";
            }
        }
        return "GEN-ERROR";
    }

    private DataSet getDataSet(byte group, byte type, String item) {
        int i = 0;
        while (i < this.valid_names[group]) {
            if (item.equals(this.names[group][i])) {
                if (this.data[group][i][type] == null) {
                    this.data[group][i][type] = new DataSet(this.getSetName(group, type));
                    if (group == 7 || group == 8) {
                        this.data[group][i][type].setAbsLimitActive(false);
                    }
                }
                return this.data[group][i][type];
            }
            ++i;
        }
        int pos = this.valid_names[group];
        if (pos == this.names[group].length) {
            DataSet[][] ds = this.data[group];
            this.data[group] = new DataSet[ds.length + 10][];
            String[] s = this.names[group];
            this.names[group] = new String[s.length + 10];
            i = 0;
            while (i < ds.length) {
                this.data[group][i] = ds[i];
                this.names[group][i] = s[i];
                ++i;
            }
        }
        this.data[group][pos] = new DataSet[this.getGroupTypes(group)];
        this.data[group][pos][type] = new DataSet(this.getSetName(group, type));
        if (group == 7 || group == 8) {
            this.data[group][pos][type].setAbsLimitActive(false);
        }
        this.names[group][pos] = item;
        byte by = group;
        this.valid_names[by] = this.valid_names[by] + 1;
        return this.data[group][pos][type];
    }

    public void add(int slot, byte type, float value) {
        this.add(slot, (byte)0, type, SYSTEM_ITEM, value);
    }

    public void add(int slot, byte group, byte type, String item, float value) {
        if (slot >= DataSet.SLOTS || group < 0 || group >= 15 || type < 0) {
            return;
        }
        if (value < 0.0f) {
            return;
        }
        if (group == 0) {
            item = SYSTEM_ITEM;
        }
        DataSet ds = this.getDataSet(group, type, item);
        if (slot >= 0) {
            ds.add(slot, value);
        }
    }

    public void addBySlot(int slot, byte type, float value, float min, float max) {
        this.addBySlot(slot, (byte)0, type, SYSTEM_ITEM, value, min, max);
    }

    public void addBySlot(int slot, byte group, byte type, String item, float value, float min, float max) {
        if (slot >= DataSet.SLOTS || group < 0 || group >= 15 || type < 0) {
            return;
        }
        if (value < 0.0f) {
            return;
        }
        DataSet ds = this.getDataSet(group, type, item);
        if (slot >= 0) {
            ds.addBySlot(slot, value, min, max);
        }
    }

    public void setLimits(GregorianCalendar start, GregorianCalendar end) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != null) {
                int j = 0;
                while (j < this.data[i].length) {
                    if (this.data[i][j] != null) {
                        int k = 0;
                        while (k < this.data[i][j].length) {
                            if (this.data[i][j][k] != null) {
                                this.data[i][j][k].reset();
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.lssrad_ref1 = null;
        this.lssrad_srad = null;
        this.lssrad_mem = null;
        this.lssrad_cpu = null;
        i = 0;
        while (i < this.textLabel.length) {
            this.textLabel[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.textValue.length) {
            this.textValue[i] = null;
            ++i;
        }
        this.start = start;
        this.end = end;
    }

    public void endOfData() {
        DataSet ds4;
        float x;
        float w;
        float maxR;
        float maxW;
        float maxX;
        float minR;
        float minW;
        float minX;
        float tr;
        float tw;
        float tx;
        DataSet ds3;
        DataSet ds2;
        float pc;
        DataSet ds1;
        int j;
        if (this.data[0] != null && this.data[0][0] != null) {
            if (this.data[0][0][0] != null) {
                this.data[0][0][0].setWeight(this.cpuWeight);
            }
            if (this.data[0][0][5] != null) {
                this.data[0][0][5].setWeight(this.cpuWeight);
            }
        }
        int i = 0;
        while (i < this.data.length) {
            j = 0;
            while (this.data[i] != null && j < this.data[i].length) {
                int k = 0;
                while (this.data[i][j] != null && k < this.data[i][j].length) {
                    if (this.data[i][j][k] != null) {
                        this.data[i][j][k].endOfData();
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (this.data[0][0] != null && this.data[0][0][0] != null && this.data[0][0][5] != null && this.data[1] != null && this.data[1][0] != null) {
            int avgID = -1;
            i = 0;
            while (i < this.names[1].length) {
                if (this.names[1][i].equals(Parser.AVG_CPU)) {
                    avgID = i;
                    break;
                }
                ++i;
            }
            if (avgID >= 0) {
                ds1 = this.getDataSet((byte)0, (byte)59, SYSTEM_ITEM);
                i = 0;
                while (i < DataSet.SLOTS) {
                    pc = this.data[0][0][0].getValue(i);
                    float ent = this.data[0][0][5].getValue(i);
                    float us = this.data[1][avgID][0].getValue(i);
                    float sy = this.data[1][avgID][1].getValue(i);
                    float min_pc = this.data[0][0][0].getAbsMin(i);
                    float min_ent = this.data[0][0][5].getAbsMin(i);
                    float min_us = this.data[1][avgID][0].getAbsMin(i);
                    float min_sy = this.data[1][avgID][1].getAbsMin(i);
                    float max_pc = this.data[0][0][0].getAbsMax(i);
                    float max_ent = this.data[0][0][5].getAbsMax(i);
                    float max_us = this.data[1][avgID][0].getAbsMax(i);
                    float max_sy = this.data[1][avgID][1].getAbsMax(i);
                    if (!(pc < 0.0f || ent < 0.0f || us < 0.0f || sy < 0.0f)) {
                        float max_used;
                        float min_used;
                        float used;
                        if (pc <= ent) {
                            used = ent * (us + sy) / 100.0f;
                            min_used = min_ent * (min_us + min_sy) / 100.0f;
                            max_used = max_ent * (max_us + max_sy) / 100.0f;
                        } else {
                            used = pc * (us + sy) / 100.0f;
                            min_used = min_pc * (min_us + min_sy) / 100.0f;
                            max_used = max_pc * (max_us + max_sy) / 100.0f;
                        }
                        ds1.addBySlot(i, used, min_used, max_used);
                    }
                    ++i;
                }
                ds1.endOfData();
            }
        }
        if (this.data[0] != null && this.data[0][0] != null && this.data[0][0][0] != null && this.data[0][0][40] != null) {
            ds1 = this.getDataSet((byte)0, (byte)41, SYSTEM_ITEM);
            i = 0;
            while (i < DataSet.SLOTS) {
                float pc2 = this.data[0][0][0].getValue(i);
                float ded_pc = this.data[0][0][40].getValue(i);
                float min_pc = this.data[0][0][0].getAbsMin(i);
                float min_ded_pc = this.data[0][0][40].getAbsMin(i);
                float max_pc = this.data[0][0][0].getAbsMax(i);
                float max_ded_pc = this.data[0][0][40].getAbsMax(i);
                if (!(pc2 < 0.0f) && !(ded_pc < 0.0f)) {
                    ds1.addBySlot(i, pc2 + ded_pc, min_pc + min_ded_pc, max_pc + max_ded_pc);
                }
                ++i;
            }
            ds1.endOfData();
        }
        if (this.data[0] != null && this.data[0][0] != null && this.data[0][0][15] != null && this.data[0][0][13] != null) {
            ds1 = this.getDataSet((byte)0, (byte)36, SYSTEM_ITEM);
            i = 0;
            while (i < DataSet.SLOTS) {
                float sr = this.data[0][0][15].getValue(i);
                float fr = this.data[0][0][13].getValue(i);
                if (!(fr < 0.0f) && !(sr < 0.0f)) {
                    if (fr == 0.0f) {
                        ds1.addBySlot(i, 0.0f);
                    } else {
                        ds1.addBySlot(i, sr / fr);
                    }
                }
                ++i;
            }
            ds1.endOfData();
        }
        if (this.data[0] != null && this.data[0][0] != null && this.data[0][0][16] != null && this.data[0][0][8] != null) {
            ds1 = this.getDataSet((byte)0, (byte)23, SYSTEM_ITEM);
            i = 0;
            while (i < DataSet.SLOTS) {
                float fre = this.data[0][0][8].getValue(i);
                float ram = this.data[0][0][16].getValue(i);
                float min_fre = this.data[0][0][8].getAbsMin(i);
                float min_ram = this.data[0][0][16].getAbsMin(i);
                float max_fre = this.data[0][0][8].getAbsMax(i);
                float max_ram = this.data[0][0][16].getAbsMax(i);
                if (!(fre < 0.0f) && !(ram < 0.0f)) {
                    ds1.addBySlot(i, ram - fre, min_ram - max_fre, max_ram - min_fre);
                }
                ++i;
            }
            ds1.endOfData();
        }
        if (this.data[12] != null) {
            i = 0;
            while (i < this.data[12].length) {
                if (this.data[12][i] != null && this.data[12][i][2] != null) {
                    ds1 = this.getDataSet((byte)12, (byte)1, this.names[12][i]);
                    j = 0;
                    while (j < DataSet.SLOTS) {
                        if (this.data[12][i][2].getValue(j) >= 0.0f) {
                            ds1.addBySlot(j, this.data[0][0][0].getValue(j), this.data[0][0][0].getAbsMin(j), this.data[0][0][0].getAbsMax(j));
                        }
                        ++j;
                    }
                    ds1.endOfData();
                }
                ++i;
            }
        }
        if (this.data[6] != null && this.data[0][0] != null && this.data[0][0][0] != null) {
            i = 0;
            while (i < this.data[6].length) {
                if (this.data[6][i] != null && this.data[6][i][0] != null) {
                    ds1 = this.getDataSet((byte)6, (byte)3, this.names[6][i]);
                    j = 0;
                    while (j < DataSet.SLOTS) {
                        float cpu = this.data[6][i][0].getValue(j);
                        pc = this.data[0][0][0].getValue(j);
                        float min_cpu = this.data[6][i][0].getAbsMin(j);
                        float min_pc = this.data[0][0][0].getAbsMin(j);
                        float max_cpu = this.data[6][i][0].getAbsMax(j);
                        float max_pc = this.data[0][0][0].getAbsMax(j);
                        if (!(cpu < 0.0f) && !(pc < 0.0f)) {
                            ds1.addBySlot(j, pc / 100.0f * cpu, min_pc / 100.0f * min_cpu, max_pc / 100.0f * max_cpu);
                        }
                        ++j;
                    }
                    ds1.endOfData();
                }
                ++i;
            }
        }
        if (this.data[2] != null && this.data[2][0] != null && this.data[2][1] != null) {
            ds1 = this.getDataSet((byte)2, (byte)1, "_Global_Disk");
            ds2 = this.getDataSet((byte)2, (byte)2, "_Global_Disk");
            ds3 = this.getDataSet((byte)2, (byte)3, "_Global_Disk");
            i = 0;
            while (i < DataSet.SLOTS) {
                tx = -1.0f;
                tw = -1.0f;
                tr = -1.0f;
                minX = -1.0f;
                minW = -1.0f;
                minR = -1.0f;
                maxX = -1.0f;
                maxW = -1.0f;
                maxR = -1.0f;
                j = 0;
                while (j < this.data[2].length) {
                    if (this.data[2][j] != null && this.data[2][j][1] != ds1 && this.data[2][j][2] != ds2 && this.data[2][j][3] != ds3) {
                        if (this.data[2][j][1] != null) {
                            float r = this.data[2][j][1].getValue(i);
                            if (r >= 0.0f) {
                                tr = tr < 0.0f ? r : (tr += r);
                            }
                            if ((r = this.data[2][j][1].getAbsMin(i)) >= 0.0f) {
                                minR = minR < 0.0f ? r : (minR += r);
                            }
                            if ((r = this.data[2][j][1].getAbsMax(i)) >= 0.0f) {
                                maxR = maxR < 0.0f ? r : (maxR += r);
                            }
                        }
                        if (this.data[2][j][2] != null) {
                            w = this.data[2][j][2].getValue(i);
                            if (w >= 0.0f) {
                                tw = tw < 0.0f ? w : (tw += w);
                            }
                            if ((w = this.data[2][j][2].getAbsMin(i)) >= 0.0f) {
                                minW = minW < 0.0f ? w : (minW += w);
                            }
                            if ((w = this.data[2][j][2].getAbsMax(i)) >= 0.0f) {
                                maxW = maxW < 0.0f ? w : (maxW += w);
                            }
                        }
                        if (this.data[2][j][3] != null) {
                            x = this.data[2][j][3].getValue(i);
                            if (x >= 0.0f) {
                                tx = tx < 0.0f ? x : (tx += x);
                            }
                            if ((x = this.data[2][j][3].getAbsMin(i)) >= 0.0f) {
                                minX = minX < 0.0f ? x : (minX += x);
                            }
                            if ((x = this.data[2][j][3].getAbsMax(i)) >= 0.0f) {
                                maxX = maxX < 0.0f ? x : (maxX += x);
                            }
                        }
                    }
                    ++j;
                }
                ds1.addBySlot(i, tr, minR, maxR);
                ds2.addBySlot(i, tw, minW, maxW);
                ds3.addBySlot(i, tx, minX, maxX);
                ++i;
            }
            ds1.endOfData();
            ds2.endOfData();
            ds3.endOfData();
        }
        if (this.data[2] != null) {
            i = 0;
            while (i < this.data[2].length) {
                if (this.data[2][i] != null) {
                    ds1 = this.data[2][i][5];
                    ds2 = this.data[2][i][6];
                    ds3 = this.data[2][i][11];
                    ds4 = this.data[2][i][12];
                    if (ds1 != null && ds2 != null && ds3 != null && ds4 != null) {
                        DataSet ds5 = this.getDataSet((byte)2, (byte)25, this.names[2][i]);
                        DataSet ds6 = this.getDataSet((byte)2, (byte)26, this.names[2][i]);
                        j = 0;
                        while (j < DataSet.SLOTS) {
                            float rps = ds1.getValue(j);
                            float r = ds2.getValue(j);
                            float wps = ds3.getValue(j);
                            float w2 = ds4.getValue(j);
                            if (!(rps < 0.0f || r < 0.0f || wps < 0.0f || w2 < 0.0f)) {
                                float rw = rps + wps == 0.0f ? 0.0f : (rps * r + wps * w2) / (rps + wps);
                                ds5.addBySlot(j, rw);
                                ds6.addBySlot(j, rps + wps);
                            }
                            ++j;
                        }
                        ds5.endOfData();
                        ds6.endOfData();
                    }
                }
                ++i;
            }
        }
        if (this.data[3] != null && this.data[3][0] != null && this.data[3][1] != null) {
            ds1 = this.getDataSet((byte)3, (byte)0, "_Global_MPIO");
            ds2 = this.getDataSet((byte)3, (byte)1, "_Global_MPIO");
            ds3 = this.getDataSet((byte)3, (byte)2, "_Global_MPIO");
            i = 0;
            while (i < DataSet.SLOTS) {
                tx = -1.0f;
                tw = -1.0f;
                tr = -1.0f;
                minX = -1.0f;
                minW = -1.0f;
                minR = -1.0f;
                maxX = -1.0f;
                maxW = -1.0f;
                maxR = -1.0f;
                j = 0;
                while (j < this.data[3].length) {
                    if (this.data[3][j] != null && this.data[3][j][0] != ds1 && this.data[3][j][1] != ds2 && this.data[3][j][2] != ds3) {
                        float r = this.data[3][j][0].getValue(i);
                        w = this.data[3][j][1].getValue(i);
                        x = this.data[3][j][2].getValue(i);
                        if (r >= 0.0f) {
                            tr = tr < 0.0f ? r : (tr += r);
                        }
                        if (w >= 0.0f) {
                            tw = tw < 0.0f ? w : (tw += w);
                        }
                        if (x >= 0.0f) {
                            tx = tx < 0.0f ? x : (tx += x);
                        }
                        r = this.data[3][j][0].getAbsMin(i);
                        w = this.data[3][j][1].getAbsMin(i);
                        x = this.data[3][j][2].getAbsMin(i);
                        if (r >= 0.0f) {
                            minR = minR < 0.0f ? r : (minR += r);
                        }
                        if (w >= 0.0f) {
                            minW = minW < 0.0f ? w : (minW += w);
                        }
                        if (x >= 0.0f) {
                            minX = minX < 0.0f ? x : (minX += x);
                        }
                        r = this.data[3][j][0].getAbsMax(i);
                        w = this.data[3][j][1].getAbsMax(i);
                        x = this.data[3][j][2].getAbsMax(i);
                        if (r >= 0.0f) {
                            maxR = maxR < 0.0f ? r : (maxR += r);
                        }
                        if (w >= 0.0f) {
                            maxW = maxW < 0.0f ? w : (maxW += w);
                        }
                        if (x >= 0.0f) {
                            maxX = maxX < 0.0f ? x : (maxX += x);
                        }
                    }
                    ++j;
                }
                ds1.addBySlot(i, tr, minR, maxR);
                ds2.addBySlot(i, tw, minW, maxW);
                ds3.addBySlot(i, tx, minX, maxX);
                ++i;
            }
            ds1.endOfData();
            ds2.endOfData();
            ds3.endOfData();
        }
        if (this.data[4] != null) {
            ds1 = this.getDataSet((byte)4, (byte)0, "_Global_Disk_Adapter");
            ds2 = this.getDataSet((byte)4, (byte)1, "_Global_Disk_Adapter");
            ds3 = this.getDataSet((byte)4, (byte)2, "_Global_Disk_Adapter");
            i = 0;
            while (i < DataSet.SLOTS) {
                tx = -1.0f;
                tw = -1.0f;
                tr = -1.0f;
                minX = -1.0f;
                minW = -1.0f;
                minR = -1.0f;
                maxX = -1.0f;
                maxW = -1.0f;
                maxR = -1.0f;
                j = 0;
                while (j < this.data[4].length) {
                    if (this.data[4][j] != null && this.data[4][j][0] != ds1 && this.data[4][j][1] != ds2 && this.data[4][j][2] != ds3) {
                        float r = this.data[4][j][0].getValue(i);
                        w = this.data[4][j][1].getValue(i);
                        x = this.data[4][j][2].getValue(i);
                        if (r >= 0.0f) {
                            tr = tr < 0.0f ? r : (tr += r);
                        }
                        if (w >= 0.0f) {
                            tw = tw < 0.0f ? w : (tw += w);
                        }
                        if (x >= 0.0f) {
                            tx = tx < 0.0f ? x : (tx += x);
                        }
                        r = this.data[4][j][0].getAbsMin(i);
                        w = this.data[4][j][1].getAbsMin(i);
                        x = this.data[4][j][2].getAbsMin(i);
                        if (r >= 0.0f) {
                            minR = minR < 0.0f ? r : (minR += r);
                        }
                        if (w >= 0.0f) {
                            minW = minW < 0.0f ? w : (minW += w);
                        }
                        if (x >= 0.0f) {
                            minX = minX < 0.0f ? x : (minX += x);
                        }
                        r = this.data[4][j][0].getAbsMax(i);
                        w = this.data[4][j][1].getAbsMax(i);
                        x = this.data[4][j][2].getAbsMax(i);
                        if (r >= 0.0f) {
                            maxR = maxR < 0.0f ? r : (maxR += r);
                        }
                        if (w >= 0.0f) {
                            maxW = maxW < 0.0f ? w : (maxW += w);
                        }
                        if (x >= 0.0f) {
                            maxX = maxX < 0.0f ? x : (maxX += x);
                        }
                    }
                    ++j;
                }
                ds1.addBySlot(i, tr, minR, maxR);
                ds2.addBySlot(i, tw, minW, maxW);
                ds3.addBySlot(i, tx, minX, maxX);
                ++i;
            }
            ds1.endOfData();
            ds2.endOfData();
            ds3.endOfData();
        }
        if (this.data[10] != null && this.data[10][0] != null && this.data[10][1] != null) {
            ds1 = this.getDataSet((byte)10, (byte)0, "_Global_FC_Adapter");
            ds2 = this.getDataSet((byte)10, (byte)1, "_Global_FC_Adapter");
            ds3 = this.getDataSet((byte)10, (byte)2, "_Global_FC_Adapter");
            ds4 = this.getDataSet((byte)10, (byte)3, "_Global_FC_Adapter");
            i = 0;
            while (i < DataSet.SLOTS) {
                float txout = -1.0f;
                float txin = -1.0f;
                float tw2 = -1.0f;
                float tr2 = -1.0f;
                float minXout = -1.0f;
                float minXin = -1.0f;
                float minW2 = -1.0f;
                float minR2 = -1.0f;
                float maxXout = -1.0f;
                float maxXin = -1.0f;
                float maxW2 = -1.0f;
                float maxR2 = -1.0f;
                j = 0;
                while (j < this.data[10].length) {
                    if (this.data[10][j] != null && this.data[10][j][0] != ds1 && this.data[10][j][1] != ds2 && this.data[10][j][2] != ds3 && this.data[10][j][3] != ds4) {
                        float r = this.data[10][j][0].getValue(i);
                        w = this.data[10][j][1].getValue(i);
                        float xin = this.data[10][j][2].getValue(i);
                        float xout = this.data[10][j][3].getValue(i);
                        if (r >= 0.0f) {
                            tr2 = tr2 < 0.0f ? r : (tr2 += r);
                        }
                        if (w >= 0.0f) {
                            tw2 = tw2 < 0.0f ? w : (tw2 += w);
                        }
                        if (xin >= 0.0f) {
                            txin = txin < 0.0f ? xin : (txin += xin);
                        }
                        if (xout >= 0.0f) {
                            txout = txout < 0.0f ? xout : (txout += xout);
                        }
                        r = this.data[10][j][0].getAbsMin(i);
                        w = this.data[10][j][1].getAbsMin(i);
                        xin = this.data[10][j][2].getAbsMin(i);
                        xout = this.data[10][j][3].getAbsMin(i);
                        if (r >= 0.0f) {
                            minR2 = minR2 < 0.0f ? r : (minR2 += r);
                        }
                        if (w >= 0.0f) {
                            minW2 = minW2 < 0.0f ? w : (minW2 += w);
                        }
                        if (xin >= 0.0f) {
                            minXin = minXin < 0.0f ? xin : (minXin += xin);
                        }
                        if (xout >= 0.0f) {
                            minXout = minXout < 0.0f ? xout : (minXout += xout);
                        }
                        r = this.data[10][j][0].getAbsMax(i);
                        w = this.data[10][j][1].getAbsMax(i);
                        xin = this.data[10][j][2].getAbsMax(i);
                        xout = this.data[10][j][3].getAbsMax(i);
                        if (r >= 0.0f) {
                            maxR2 = maxR2 < 0.0f ? r : (maxR2 += r);
                        }
                        if (w >= 0.0f) {
                            maxW2 = maxW2 < 0.0f ? w : (maxW2 += w);
                        }
                        if (xin >= 0.0f) {
                            maxXin = maxXin < 0.0f ? xin : (maxXin += xin);
                        }
                        if (xout >= 0.0f) {
                            maxXout = maxXout < 0.0f ? xout : (maxXout += xout);
                        }
                    }
                    ++j;
                }
                ds1.addBySlot(i, tr2, minR2, maxR2);
                ds2.addBySlot(i, tw2, minW2, maxW2);
                ds3.addBySlot(i, txin, minXin, maxXin);
                ds4.addBySlot(i, txout, minXout, maxXout);
                ++i;
            }
            ds1.endOfData();
            ds2.endOfData();
            ds3.endOfData();
            ds4.endOfData();
        }
        if (this.data[5] != null && this.data[5][0] != null && this.data[5][1] != null && this.data[5][2] != null) {
            ds1 = this.getDataSet((byte)5, (byte)0, "_Global_Network");
            ds2 = this.getDataSet((byte)5, (byte)1, "_Global_Network");
            i = 0;
            while (i < DataSet.SLOTS) {
                float tw3 = -1.0f;
                float tr3 = -1.0f;
                float minW3 = -1.0f;
                float minR3 = -1.0f;
                float maxW3 = -1.0f;
                float maxR3 = -1.0f;
                j = 0;
                while (j < this.data[5].length) {
                    if (this.data[5][j] != null && !this.names[5][j].startsWith("lo") && this.data[5][j][0] != ds1 && this.data[5][j][1] != ds2) {
                        float r = this.data[5][j][0].getValue(i);
                        w = this.data[5][j][1].getValue(i);
                        if (r >= 0.0f) {
                            tr3 = tr3 < 0.0f ? r : (tr3 += r);
                        }
                        if (w >= 0.0f) {
                            tw3 = tw3 < 0.0f ? w : (tw3 += w);
                        }
                        r = this.data[5][j][0].getAbsMin(i);
                        w = this.data[5][j][1].getAbsMin(i);
                        if (r >= 0.0f) {
                            minR3 = minR3 < 0.0f ? r : (minR3 += r);
                        }
                        if (w >= 0.0f) {
                            minW3 = minW3 < 0.0f ? w : (minW3 += w);
                        }
                        r = this.data[5][j][0].getAbsMax(i);
                        w = this.data[5][j][1].getAbsMax(i);
                        if (r >= 0.0f) {
                            maxR3 = maxR3 < 0.0f ? r : (maxR3 += r);
                        }
                        if (w >= 0.0f) {
                            maxW3 = maxW3 < 0.0f ? w : (maxW3 += w);
                        }
                    }
                    ++j;
                }
                ds1.addBySlot(i, tr3, minR3, maxR3);
                ds2.addBySlot(i, tw3, minW3, maxW3);
                ++i;
            }
            ds1.endOfData();
            ds2.endOfData();
        }
        i = 0;
        while (i < this.data[7].length) {
            if (this.data[7][i] != null) {
                String[] procName = this.names[7][i].split(":");
                j = 0;
                while (j < DataSet.SLOTS) {
                    this.add(j, (byte)8, (byte)0, procName[0], this.data[7][i][0].getValue(j));
                    ++j;
                }
                DataSet ds = this.getDataSet((byte)8, (byte)1, procName[0]);
                j = 0;
                while (j < DataSet.SLOTS) {
                    float resdata = this.data[7][i][2].getValue(j) / 1024.0f;
                    float restext = this.data[7][i][1].getValue(j) / 1024.0f;
                    float ram = this.data[0][0][16].getValue(j);
                    if (!(resdata < 0.0f || restext < 0.0f || ram < 0.0f)) {
                        if (ds.getValue(j) < 0.0f) {
                            this.add(j, (byte)8, (byte)1, procName[0], restext / ram * 100.0f);
                        }
                        this.add(j, (byte)8, (byte)1, procName[0], resdata / ram * 100.0f);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.data[8].length) {
            if (this.data[8][i] != null) {
                j = 0;
                while (j < 2) {
                    this.data[8][i][j].endOfDataSpecial();
                    ++j;
                }
            }
            ++i;
        }
        if (this.data[0] != null && (this.data[0][0] == null || this.data[0][0][0] == null) && this.data[1][0] != null) {
            int avgID = -1;
            i = 0;
            while (i < this.names[1].length) {
                if (this.names[1][i].equals(Parser.AVG_CPU)) {
                    avgID = i;
                    break;
                }
                ++i;
            }
            if (avgID >= 0) {
                ds1 = this.getDataSet((byte)0, (byte)40, SYSTEM_ITEM);
                ds1.setWeight(this.cpuWeight);
                i = 0;
                while (i < DataSet.SLOTS) {
                    float ncpu;
                    float us = this.data[1][avgID][0].getValue(i);
                    float sy = this.data[1][avgID][1].getValue(i);
                    if (this.data[0][0][35] != null) {
                        this.smtStatus = (byte)3;
                        ncpu = this.data[0][0][35].getValue(i);
                    } else {
                        j = 0;
                        ncpu = 0.0f;
                        while (j < this.names[1].length && this.names[1][j] != null) {
                            if (this.data[1][j][0].getValue(i) >= 0.0f) {
                                ncpu += 1.0f;
                            }
                            ++j;
                        }
                        if (ncpu > 1.0f) {
                            ncpu -= 1.0f;
                        }
                    }
                    if (!(us < 0.0f || sy < 0.0f || ncpu <= 0.0f)) {
                        if (this.smtStatus == 1) {
                            ncpu /= 2.0f;
                        }
                        ds1.addBySlot(i, 1.0f * ncpu * (us + sy) / 100.0f);
                    }
                    ++i;
                }
                ds1.endOfData();
            }
        }
        this.sortNames();
    }

    private void sortNames() {
        int i = 0;
        while (i < 15) {
            this.sorted_names[i] = new int[this.valid_names[i]];
            int j = 0;
            while (j < this.sorted_names[i].length) {
                this.sorted_names[i][j] = -1;
                ++j;
            }
            j = 0;
            while (j < this.valid_names[i]) {
                int k = 0;
                while (this.sorted_names[i][k] >= 0 && this.compareNames(this.names[i][this.sorted_names[i][k]], this.names[i][j]) < 0) {
                    ++k;
                }
                if (this.sorted_names[i][k] >= 0) {
                    int x = this.valid_names[i] - 1;
                    while (x > k) {
                        this.sorted_names[i][x] = this.sorted_names[i][x - 1];
                        --x;
                    }
                }
                this.sorted_names[i][k] = j++;
            }
            ++i;
        }
    }

    private int compareNames(String a, String b) {
        if (a.length() == 0) {
            return -1;
        }
        if (b.length() == 0) {
            return 1;
        }
        if (a.charAt(0) == '_') {
            return -1;
        }
        if (b.charAt(0) == '_') {
            return 1;
        }
        if (a.startsWith("Avg")) {
            return -1;
        }
        if (b.startsWith("Avg")) {
            return 1;
        }
        int diff = a.length() - b.length();
        if (diff != 0) {
            return diff;
        }
        return a.compareTo(b);
    }

    public String[] getNames(byte group) {
        if (group < 0 || group >= this.names.length) {
            return null;
        }
        if (this.valid_names[group] == 0) {
            return null;
        }
        String[] result = new String[this.valid_names[group]];
        int i = 0;
        while (i < this.valid_names[group]) {
            result[i] = this.names[group][this.sorted_names[group][i]];
            ++i;
        }
        return result;
    }

    public DataSet getData(byte group, int item, byte type) {
        if (this.data == null || this.data[group] == null || item >= this.sorted_names[group].length || this.data[group][this.sorted_names[group][item]] == null) {
            return null;
        }
        return this.data[group][this.sorted_names[group][item]][type];
    }

    public DataSet getData(byte group, String item, byte type) {
        if (this.data == null || this.data[group] == null) {
            return null;
        }
        int i = 0;
        while (i < this.names[group].length) {
            if (item.equals(this.names[group][i])) {
                return this.data[group][i][type];
            }
            ++i;
        }
        return null;
    }

    public void removeData(byte group, int item, byte type) {
        if (this.data == null || this.data[group] == null || this.sorted_names[group].length == 0 || this.data[group][this.sorted_names[group][item]] == null) {
            return;
        }
        this.data[group][this.sorted_names[group][item]][type] = null;
    }

    public GregorianCalendar getEnd() {
        return this.end;
    }

    public GregorianCalendar getStart() {
        return this.start;
    }

    public byte getSmtStatus() {
        return this.smtStatus;
    }

    public void setSmtStatus(byte smtStatus) {
        this.smtStatus = smtStatus;
    }

    public void setCpuWeight(float cpuWeight) {
        this.cpuWeight = cpuWeight;
    }

    public int getNumLssrad() {
        if (this.lssrad_ref1 == null) {
            return 0;
        }
        return this.lssrad_ref1.size();
    }

    public void addLssrad(String ref1, String srad, String mem, String cpu) {
        if (this.lssrad_ref1 == null) {
            this.lssrad_ref1 = new Vector();
            this.lssrad_srad = new Vector();
            this.lssrad_mem = new Vector();
            this.lssrad_cpu = new Vector();
        }
        this.lssrad_ref1.add(ref1);
        this.lssrad_srad.add(srad);
        this.lssrad_mem.add(mem);
        this.lssrad_cpu.add(cpu);
    }

    public String getLssradRef1(int num) {
        if (this.lssrad_ref1 == null || num > this.lssrad_ref1.size()) {
            return null;
        }
        return this.lssrad_ref1.elementAt(num);
    }

    public String getLssradSrad(int num) {
        if (this.lssrad_srad == null || num > this.lssrad_srad.size()) {
            return null;
        }
        return this.lssrad_srad.elementAt(num);
    }

    public String getLssradMem(int num) {
        if (this.lssrad_mem == null || num > this.lssrad_mem.size()) {
            return null;
        }
        return this.lssrad_mem.elementAt(num);
    }

    public String getLssradCpu(int num) {
        if (this.lssrad_cpu == null || num > this.lssrad_cpu.size()) {
            return null;
        }
        return this.lssrad_cpu.elementAt(num);
    }

    public void addTextLabel(byte type, String label, String value) {
        if (type < 0 || type >= 3) {
            return;
        }
        if (this.textLabel[type] == null) {
            this.textLabel[type] = new Vector();
            this.textValue[type] = new Vector();
        }
        this.textLabel[type].add(label);
        this.textValue[type].add(value);
    }

    public String getTextlabel(byte type, String label) {
        if (type < 0 || type >= 3) {
            return null;
        }
        int n = 0;
        while (n < this.textLabel[type].size() && !this.textLabel[type].elementAt(n).equals(label)) {
            ++n;
        }
        if (n < this.textLabel[type].size()) {
            return this.textValue[type].elementAt(n);
        }
        return null;
    }

    public String[] getTextlabelNum(byte type, int num) {
        if (type < 0 || type >= 3) {
            return null;
        }
        if (num < 0 || num >= this.textLabel[type].size()) {
            return null;
        }
        String[] result = new String[]{this.textLabel[type].elementAt(num), this.textValue[type].elementAt(num)};
        return result;
    }
}

