/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.util.GregorianCalendar;
import pGraph.Parser;
import pGraph.ParserManager;

public class Parser_Sar
extends Parser {
    private static final byte UNKNOWN = 0;
    private static final byte AIX = 1;
    private static final byte HPUX = 2;
    private static final byte SUNOS = 3;
    private byte operatingSystem = 0;
    private byte[][] groupMatrix = null;
    private byte[][] typeMatrix = null;
    private int numCpu = -1;
    private byte DEVICE = (byte)127;
    GregorianCalendar headerGc = null;

    public Parser_Sar(ParserManager v) {
        this.manager = v;
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block3: {
            if (this.start == null || this.end == null) {
                return;
            }
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of sar data (line " + this.current_file_line_read + ")");
                if (!lastParse) break block3;
                this.endOfData();
            }
        }
    }

    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        if (firstParse) {
            this.perfData.setLimits(this.start, this.end);
            this.lines_read = 0;
        }
        this.current_file_line_read = 0;
        GregorianCalendar gc = this.start;
        BufferedReader br = this.getReader();
        String line = this.readLineAndShowProgress(br);
        while (line != null) {
            line = this.parseHeaderLines(line, br);
            if (this.headerGc == null) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, invalid date in sar data (line " + this.current_file_line_read + "). Skipping remaining lines.");
                return;
            }
            gc = this.headerGc;
            while (line != null && !line.startsWith("Average")) {
                if (line.length() < 8 || line.charAt(2) != ':' | line.charAt(5) != ':') {
                    line = this.readLineAndShowProgress(br);
                    continue;
                }
                gc = this.parseDate(line, gc);
                int slot = this.getSlot(gc);
                line = this.parseDataLines(line, br, slot);
            }
            while (line != null && line.startsWith("Average")) {
                line = this.readLineAndShowProgress(br);
            }
        }
        if (lastParse) {
            this.perfData.endOfData();
        }
    }

    /*
     * Unable to fully structure code
     */
    private String parseHeaderLines(String line, BufferedReader br) throws Exception {
        this.typeMatrix = null;
        this.groupMatrix = null;
        while (line != null) {
            block33: {
                if (line.toLowerCase().startsWith("cores")) {
                    tokens = line.split("(\\s*=\\s*)");
                    if (tokens.length != 2) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        line = this.readLineAndShowProgress(br);
                        continue;
                    }
                    try {
                        this.numCpu = Integer.parseInt(tokens[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                    }
                    line = this.readLineAndShowProgress(br);
                    continue;
                }
                if (line.startsWith("AIX") || line.startsWith("HP-UX") || line.startsWith("SunOS")) {
                    this.headerGc = this.scanDate(line);
                    line = this.readLineAndShowProgress(br);
                    continue;
                }
                if (line.startsWith("Average")) {
                    System.out.println("\"Average\" right after header. broken stanza? " + this.current_file_line_read + ": " + line);
                    return line;
                }
                if (line.length() < 8) {
                    line = this.readLineAndShowProgress(br);
                    continue;
                }
                if (this.groupMatrix == null && (line.length() < 8 || line.charAt(2) != ':' || line.charAt(5) != ':')) {
                    line = this.readLineAndShowProgress(br);
                    continue;
                }
                if (this.groupMatrix != null && line.length() > 8 && line.charAt(2) == ':' && line.charAt(5) == ':') {
                    return line;
                }
                tokens = line.substring(8).trim().split("(\\s+)");
                if (tokens.length == 0) {
                    System.out.println("Unexpected line. Skipping. " + this.current_file_line_read + ": " + line);
                    line = this.readLineAndShowProgress(br);
                    continue;
                }
                try {
                    Float.parseFloat(tokens[tokens.length - 1]);
                    return line;
                }
                catch (NumberFormatException var8_10) {
                    if (this.groupMatrix == null) {
                        this.groupMatrix = new byte[1][tokens.length];
                        this.typeMatrix = new byte[1][tokens.length];
                        row = 0;
                        break block33;
                    }
                    prevGroupMatrix = this.groupMatrix;
                    prevTypeMatrix = this.typeMatrix;
                    this.groupMatrix = new byte[this.groupMatrix.length + 1][];
                    this.typeMatrix = new byte[this.typeMatrix.length + 1][];
                    i = 0;
                    ** while (i < prevGroupMatrix.length)
                }
lbl-1000:
                // 1 sources

                {
                    this.groupMatrix[i] = prevGroupMatrix[i];
                    this.typeMatrix[i] = prevTypeMatrix[i];
                    ++i;
                    continue;
                }
lbl57:
                // 1 sources

                this.groupMatrix[prevGroupMatrix.length] = new byte[tokens.length];
                this.typeMatrix[prevTypeMatrix.length] = new byte[tokens.length];
                row = prevTypeMatrix.length;
            }
            i = 0;
            while (i < tokens.length) {
                this.groupMatrix[row][i] = -1;
                this.typeMatrix[row][i] = -1;
                ++i;
            }
            i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals("device")) {
                    this.groupMatrix[row][i] = this.DEVICE;
                    this.typeMatrix[row][i] = this.DEVICE;
                }
                if (tokens[i].equals("%usr")) {
                    this.groupMatrix[row][i] = 1;
                    this.typeMatrix[row][i] = 0;
                }
                if (tokens[i].equals("%sys")) {
                    this.groupMatrix[row][i] = 1;
                    this.typeMatrix[row][i] = 1;
                }
                if (tokens[i].equals("%wio")) {
                    this.groupMatrix[row][i] = 1;
                    this.typeMatrix[row][i] = 2;
                }
                if (tokens[i].equals("%idle")) {
                    this.groupMatrix[row][i] = 1;
                    this.typeMatrix[row][i] = 3;
                }
                if (tokens[i].equals("physc")) {
                    this.groupMatrix[row][i] = 0;
                    this.typeMatrix[row][i] = tokens.length > i + 1 && tokens[i + 1].equals("%entc") != false ? 0 : 35;
                }
                if (tokens[i].equals("%entc")) {
                    this.groupMatrix[row][i] = 0;
                    this.typeMatrix[row][i] = 6;
                }
                if (!this.multipleLPAR) {
                    if (tokens[i].equals("scall/s")) {
                        this.groupMatrix[row][i] = 0;
                        this.typeMatrix[row][i] = 30;
                    }
                    if (tokens[i].equals("sread/s")) {
                        this.groupMatrix[row][i] = 0;
                        this.typeMatrix[row][i] = 33;
                    }
                    if (tokens[i].equals("swrit/s")) {
                        this.groupMatrix[row][i] = 0;
                        this.typeMatrix[row][i] = 34;
                    }
                    if (tokens[i].equals("fork/s")) {
                        this.groupMatrix[row][i] = 0;
                        this.typeMatrix[row][i] = 31;
                    }
                    if (tokens[i].equals("exec/s")) {
                        this.groupMatrix[row][i] = 0;
                        this.typeMatrix[row][i] = 32;
                    }
                    if (tokens[i].equals("%busy")) {
                        this.groupMatrix[row][i] = 2;
                        this.typeMatrix[row][i] = 0;
                    }
                    if (tokens[i].equals("runq-sz")) {
                        this.groupMatrix[row][i] = 0;
                        this.typeMatrix[row][i] = 26;
                    }
                    if (tokens[i].equals("swpq-sz")) {
                        this.groupMatrix[row][i] = 0;
                        this.typeMatrix[row][i] = 27;
                    }
                }
                ++i;
            }
            line = this.readLineAndShowProgress(br);
        }
        return null;
    }

    private String parseDataLines(String line, BufferedReader br, int slot) throws Exception {
        line = "        " + line.substring(8);
        int row = 0;
        while (row < this.groupMatrix.length) {
            if (line == null || line.length() >= 5 && (line.charAt(2) == ':' || line.charAt(5) == ':') || line.startsWith("Average")) {
                return line;
            }
            if ((line = line.trim()).length() == 0 && this.operatingSystem == 1) {
                ++row;
                line = this.readLineAndShowProgress(br);
                continue;
            }
            if (line.length() == 0) {
                return line;
            }
            String[] tokens = line.split("(\\s+)");
            if (this.groupMatrix[row][0] == this.DEVICE) {
                if (tokens.length != this.groupMatrix[row].length) {
                    ++row;
                } else {
                    try {
                        Float.parseFloat(tokens[0]);
                        ++row;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (tokens.length > this.groupMatrix[row].length) {
                System.out.println("Unexpected line. Skipping. " + this.current_file_line_read + ": " + line);
                return line;
            }
            int i = 0;
            while (i < tokens.length) {
                if (this.groupMatrix[row][i] != -1 && (this.groupMatrix[row][0] != this.DEVICE || i != 0)) {
                    float f;
                    try {
                        f = Float.parseFloat(tokens[i]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        return line;
                    }
                    switch (this.groupMatrix[row][i]) {
                        case 2: {
                            this.perfData.add(slot, this.groupMatrix[row][i], this.typeMatrix[row][i], tokens[0], f);
                            break;
                        }
                        case 0: {
                            this.perfData.add(slot, this.typeMatrix[row][i], f);
                            break;
                        }
                        case 1: {
                            this.perfData.add(slot, (byte)1, this.typeMatrix[row][i], AVG_CPU, f);
                            break;
                        }
                        default: {
                            System.out.println("Unexpected line " + this.current_file_line_read + ": " + line);
                            return line;
                        }
                    }
                }
                ++i;
            }
            if (this.numCpu > 0 && this.groupMatrix[row][0] == 1) {
                this.perfData.add(slot, (byte)35, this.numCpu);
            }
            if (this.groupMatrix[row][0] != this.DEVICE) {
                ++row;
            }
            line = this.readLineAndShowProgress(br);
        }
        return line;
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception e) {
            System.out.println("Error in scanning limits");
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
        if (this.operatingSystem == 0) {
            this.valid = false;
        }
    }

    private GregorianCalendar scanDate(String line) {
        int year;
        int day;
        int month;
        String[] s = line.split("(\\s+)|(/)");
        try {
            month = Integer.parseInt(s[s.length - 3]);
            day = Integer.parseInt(s[s.length - 2]);
            year = Integer.parseInt(s[s.length - 1]);
            if (year < 1970) {
                year = year >= 90 ? (year += 1900) : (year += 2000);
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new GregorianCalendar(year, month - 1, day);
    }

    private GregorianCalendar parseDate(String line, GregorianCalendar gc) {
        int s;
        int m;
        int h;
        try {
            h = Integer.parseInt(line.substring(0, 2));
            m = Integer.parseInt(line.substring(3, 5));
            s = Integer.parseInt(line.substring(6, 8));
        }
        catch (NumberFormatException e) {
            return null;
        }
        GregorianCalendar result = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), h, m, s);
        if (result.before(gc)) {
            result.add(5, 1);
        }
        return result;
    }

    private void parseTimeLimits() throws Exception {
        GregorianCalendar gc = null;
        BufferedReader br = this.getReader();
        String line = br.readLine();
        while (line != null && (line.length() == 0 || line.toLowerCase().startsWith("cores"))) {
            ++this.total_lines;
            line = br.readLine();
        }
        if (line == null) {
            this.valid = false;
            return;
        }
        ++this.total_lines;
        if (line.startsWith("AIX")) {
            this.operatingSystem = 1;
        } else if (line.startsWith("HP-UX")) {
            this.operatingSystem = (byte)2;
        } else if (line.startsWith("SunOS")) {
            this.operatingSystem = (byte)3;
        } else {
            this.valid = false;
            return;
        }
        gc = this.scanDate(line);
        if (gc == null) {
            this.valid = false;
            return;
        }
        line = br.readLine();
        while (line != null && !line.startsWith("Average")) {
            ++this.total_lines;
            if (line.length() > 8 && line.charAt(2) == ':' && line.charAt(5) == ':') {
                if ((gc = this.parseDate(line, gc)) == null) {
                    System.out.println("Error in line " + this.total_lines + " " + line);
                } else {
                    if (this.start == null || gc.before(this.start)) {
                        this.start = gc;
                    }
                    if (this.end == null || gc.after(this.end)) {
                        this.end = gc;
                    }
                }
            }
            line = br.readLine();
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
        while (line != null) {
            ++this.total_lines;
            line = br.readLine();
        }
    }
}

