/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.util.GregorianCalendar;
import java.util.Vector;
import pGraph.NmonTokenizer;
import pGraph.Parser;
import pGraph.ParserManager;

public class Parser_Nmon_Tokenized
extends Parser {
    private static final byte AIX = 0;
    private static final byte LINUX = 1;
    private byte operatingSystem = 0;
    private byte smt = 0;

    public Parser_Nmon_Tokenized(ParserManager v) {
        this.manager = v;
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
    }

    private void parseTimeLimits() throws Exception {
        GregorianCalendar gc = null;
        int MAXWAIT = 10;
        boolean aaaFound = false;
        BufferedReader br = this.getReader();
        while (true) {
            String line;
            if ((line = br.readLine()) == null) {
                if (this.start == null || this.end == null) break;
                this.valid = true;
                break;
            }
            ++this.total_lines;
            if (!aaaFound && line.startsWith("AAA")) {
                aaaFound = true;
            }
            if (!aaaFound && this.total_lines > 10) {
                return;
            }
            if (!line.startsWith("ZZZZ") || line.length() < 19) continue;
            if ((gc = this.parseDate(line, gc)) == null) {
                System.out.println("Error in line " + this.total_lines + " " + line);
                continue;
            }
            if (this.start == null || gc.before(this.start)) {
                this.start = gc;
            }
            if (this.end != null && !gc.after(this.end)) continue;
            this.end = gc;
        }
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block4: {
            if (this.start == null || this.end == null) {
                return;
            }
            if (firstParse) {
                this.avoidTop = false;
            }
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of nmon data (line " + this.current_file_line_read + ")");
                if (!lastParse) break block4;
                this.endOfData();
            }
        }
        this.firstRun = false;
    }

    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        String line;
        GregorianCalendar gc = null;
        String timeLabel = "";
        int slot = -1;
        NmonTokenizer nt = new NmonTokenizer();
        int numDisks = 0;
        boolean suppressFCwarning = false;
        boolean suppressJFSwarning = false;
        boolean suppressWLMwarning = false;
        boolean suppressNetWarnings = false;
        String diskName = null;
        String cpu = null;
        String mem = null;
        String srad = null;
        String ref1 = null;
        if (firstParse) {
            this.perfData.setLimits(this.start, this.end);
            this.lines_read = 0;
        }
        this.current_file_line_read = 0;
        BufferedReader br = this.getReader();
        block7: while ((line = this.readLineAndShowProgress(br)) != null) {
            int i;
            String[] currentKeys;
            float f8;
            float f7;
            float f6;
            float f5;
            float f4;
            float f3;
            float f2;
            float f1;
            String key;
            block141: {
                int type;
                String cpuName;
                if (line.length() == 0) continue;
                if (line.startsWith("ZZZZ")) {
                    String date;
                    int from = line.indexOf(44) + 1;
                    int to = line.indexOf(44, from);
                    String label = line.substring(from, to);
                    from = to + 1;
                    String time = line.substring(from, to = line.indexOf(44, from));
                    gc = this.parseDate(time, date = line.substring(to + 1), gc);
                    if (gc == null) {
                        System.out.println("Error in line " + this.current_file_line_read + " " + line);
                        continue;
                    }
                    timeLabel = gc.before(this.start) || gc.after(this.end) ? null : label;
                    slot = this.getSlot(gc);
                    continue;
                }
                if (line.startsWith("ERROR:")) continue;
                nt.parseString(line, this.current_file_line_read);
                key = nt.getString(0);
                if (key == null) continue;
                if (key.equals("AAA") && line.toLowerCase().contains("linux")) {
                    this.operatingSystem = 1;
                }
                if (key.equals("BBBP") && line.contains("systemid")) {
                    this.cecName = nt.getString(4).substring(0, 9);
                    continue;
                }
                if (key.equals("BBBP") && nt.getString(2).equals("lssrad")) {
                    if (nt.getNumTokens() == 3) {
                        cpu = null;
                        mem = null;
                        srad = null;
                        ref1 = null;
                        continue;
                    }
                    if (nt.getString(3).startsWith("\"REF1")) continue;
                    if (!nt.getString(3).startsWith("\" ")) {
                        if (ref1 != null) {
                            cpu = null;
                            mem = null;
                            srad = null;
                            ref1 = null;
                        }
                        ref1 = nt.getString(3);
                        ref1 = ref1.substring(1, ref1.length() - 1);
                        continue;
                    }
                    String[] ss = nt.getString(3).replaceAll("\"", "").trim().split(" {2,}");
                    srad = ss[0];
                    mem = ss[1];
                    cpu = ss.length >= 3 ? ss[2] : null;
                    this.perfData.addLssrad(ref1, srad, mem, cpu);
                    continue;
                }
                if (key.equals("BBBP") && nt.getString(2).equals("lparstat -i")) {
                    if (nt.getNumTokens() == 3) continue;
                    String[] ss = nt.getString(3).replaceAll("\"", "").split(":");
                    this.perfData.addTextLabel((byte)0, ss[0].trim(), ss[1].trim());
                    continue;
                }
                if (key.equals("BBBP") && nt.getString(2).equals("vmstat -v")) {
                    if (nt.getNumTokens() == 3) continue;
                    String[] ss = new String[2];
                    String s = nt.getString(3).replaceAll("\"", "").trim();
                    int pos = s.indexOf(32);
                    ss[0] = s.substring(pos + 1);
                    ss[1] = s.substring(0, pos);
                    this.perfData.addTextLabel((byte)1, ss[0], ss[1]);
                    continue;
                }
                if (key.equals("BBBP") && nt.getString(2).equals("ending vmstat -v")) {
                    if (nt.getNumTokens() == 3) continue;
                    String[] ss = new String[2];
                    String s = nt.getString(3).replaceAll("\"", "").trim();
                    int pos = s.indexOf(32);
                    ss[0] = s.substring(pos + 1);
                    ss[1] = s.substring(0, pos);
                    this.perfData.addTextLabel((byte)2, ss[0], ss[1]);
                    continue;
                }
                if (key.equals("BBBL") && nt.getString(2).equals("smt threads")) {
                    this.smt = Byte.parseByte(nt.getString(3));
                    this.perfData.setSmt_threads(this.smt);
                    continue;
                }
                if (key.equals("BBBP") && nt.getString(2).equals("lparstat -i")) {
                    if (nt.getString(3).endsWith("Dedicated-SMT\"")) {
                        this.perfData.setSmtStatus((byte)1);
                    }
                    if (nt.getString(3).endsWith("Dedicated\"")) {
                        this.perfData.setSmtStatus((byte)2);
                    }
                }
                if (!this.isTimeStamp(nt.getString(1))) {
                    if (!(key.equals("AAA") || key.startsWith("BBB") || key.startsWith("CPU") || key.startsWith("SCPU") || key.startsWith("PCPU") || key.equals("ZZZZ") || key.equals("TOP"))) {
                        nt.updateKeys();
                    }
                    if (key.equals("TOP") && nt.getNumTokens() > 2 && !this.isTimeStamp(nt.getString(2))) {
                        nt.updateKeys();
                    }
                }
                if (!this.multipleLPAR && !this.isTimeStamp(nt.getString(1)) && key.startsWith("DISKBUSY")) {
                    if (this.avoidDisk) continue;
                    numDisks = numDisks + nt.getNumTokens() - 2;
                    if (!this.firstRun || numDisks <= this.MAX_DISKS) continue;
                    this.avoidDisk = true;
                    System.out.println("More than " + this.MAX_DISKS + " disks. Skipping disk data.");
                    System.out.println("    - Deselect \"No disk data\" to include disk data and then press Zoom button.");
                    System.out.println("    - Use pGraph.properties file and change MaxDisks variable.");
                    continue;
                }
                if (!nt.getString(1).equals(timeLabel) && (nt.getNumTokens() <= 2 || !key.equals("TOP") || !nt.getString(2).equals(timeLabel))) continue;
                if (key.startsWith("CPU") && key.indexOf("_USE") < 0) {
                    cpuName = key.equals("CPU_ALL") ? AVG_CPU : key;
                    if (nt.getNumTokens() < 6) continue;
                    f1 = nt.getValue(2);
                    f2 = nt.getValue(3);
                    f3 = nt.getValue(4);
                    this.perfData.add(slot, (byte)1, (byte)0, cpuName, f1);
                    this.perfData.add(slot, (byte)1, (byte)1, cpuName, f2);
                    this.perfData.add(slot, (byte)1, (byte)2, cpuName, f3);
                    this.perfData.add(slot, (byte)1, (byte)3, cpuName, 100.0f - f1 - f2 - f3);
                    continue;
                }
                if (key.startsWith("PCPU")) {
                    cpuName = key.equals("PCPU_ALL") ? AVG_CPU : key;
                    if (nt.getNumTokens() < 6) continue;
                    f1 = nt.getValue(2);
                    f2 = nt.getValue(3);
                    f3 = nt.getValue(4);
                    f4 = nt.getValue(5);
                    this.perfData.add(slot, (byte)14, (byte)0, cpuName, f1 + f2 + f3 + f4);
                    continue;
                }
                if (key.equals("MEM")) {
                    if (this.operatingSystem == 0) {
                        f1 = nt.getValueFromKey("Virtual total(MB)");
                        f2 = nt.getValueFromKey("Real free(MB)");
                        f3 = f2 * 1024.0f / 4.0f;
                        f4 = nt.getValueFromKey("Real total(MB)");
                        this.perfData.add(slot, (byte)7, f1);
                        this.perfData.add(slot, (byte)8, f2);
                        this.perfData.add(slot, (byte)22, f3);
                        this.perfData.add(slot, (byte)16, f4);
                        f1 = nt.getValueFromKey("Size of the Compressed pool(MB)");
                        f2 = nt.getValueFromKey("Size of true memory(MB)");
                        f3 = nt.getValueFromKey("Expanded memory size(MB)");
                        f4 = nt.getValueFromKey("Size of the Uncompressed pool(MB)");
                        this.perfData.add(slot, (byte)53, f1);
                        this.perfData.add(slot, (byte)52, f2);
                        this.perfData.add(slot, (byte)55, f3);
                        this.perfData.add(slot, (byte)54, f4);
                        continue;
                    }
                    if (this.operatingSystem != 1) continue;
                    f1 = nt.getValueFromKey("memtotal");
                    f2 = nt.getValueFromKey("memfree");
                    this.perfData.add(slot, (byte)16, f1);
                    this.perfData.add(slot, (byte)8, f2);
                    continue;
                }
                if (!this.multipleLPAR && key.equals("MEMUSE")) {
                    f1 = nt.getValueFromKey("%numperm");
                    f2 = nt.getValueFromKey("%minperm");
                    f3 = nt.getValueFromKey("%maxperm");
                    f4 = nt.getValueFromKey("minfree");
                    f5 = nt.getValueFromKey("maxfree");
                    f6 = nt.getValueFromKey("%numclient");
                    f7 = nt.getValueFromKey("%maxclient");
                    this.perfData.add(slot, (byte)17, f1);
                    this.perfData.add(slot, (byte)18, f2);
                    this.perfData.add(slot, (byte)19, f3);
                    this.perfData.add(slot, (byte)20, f4);
                    this.perfData.add(slot, (byte)21, f5);
                    this.perfData.add(slot, (byte)24, f6);
                    this.perfData.add(slot, (byte)25, f7);
                    continue;
                }
                if (!this.multipleLPAR && key.equals("VM")) {
                    f1 = nt.getValueFromKey("pswpin");
                    f2 = nt.getValueFromKey("pswpout");
                    this.perfData.add(slot, (byte)9, f1);
                    this.perfData.add(slot, (byte)10, f2);
                    continue;
                }
                if (!this.multipleLPAR && key.equals("PAGE")) {
                    f1 = nt.getValueFromKey("pgsin");
                    f2 = nt.getValueFromKey("pgsout");
                    f3 = nt.getValueFromKey("reclaims");
                    f4 = nt.getValueFromKey("scans");
                    f5 = nt.getValueFromKey("cycles");
                    f6 = nt.getValueFromKey("faults");
                    this.perfData.add(slot, (byte)9, f1);
                    this.perfData.add(slot, (byte)10, f2);
                    this.perfData.add(slot, (byte)13, f3);
                    this.perfData.add(slot, (byte)15, f4);
                    this.perfData.add(slot, (byte)14, f5);
                    this.perfData.add(slot, (byte)66, f6);
                    f1 = nt.getValueFromKey("Compressed pool pgins");
                    f2 = nt.getValueFromKey("Compressed pool pgouts");
                    this.perfData.add(slot, (byte)56, f1);
                    this.perfData.add(slot, (byte)57, f2);
                    continue;
                }
                if (key.equals("LPAR")) {
                    float f11;
                    float f10;
                    float f9;
                    if (this.operatingSystem == 0) {
                        f1 = nt.getValueFromKey("PhysicalCPU");
                        f2 = nt.getValueFromKey("virtualCPUs");
                        f3 = nt.getValueFromKey("logicalCPUs");
                        f4 = nt.getValueFromKey("poolCPUs");
                        f5 = nt.getValueFromKey("entitled");
                        f6 = nt.getValueFromKey("PoolIdle");
                        f7 = nt.getValueFromKey("Folded");
                        f8 = nt.getValueFromKey("VP_User%");
                        f9 = nt.getValueFromKey("VP_Sys%");
                        f10 = nt.getValueFromKey("VP_Wait%");
                        f11 = nt.getValueFromKey("VP_Idle%");
                    } else if (this.operatingSystem == 1) {
                        f1 = nt.getValueFromKey("PhysicalCPU");
                        f2 = nt.getValueFromKey("partition_active_processors");
                        f3 = nt.getValueFromKey("Logical CPU");
                        f4 = nt.getValueFromKey("pool_capacity") / 100.0f;
                        f5 = nt.getValueFromKey("partition_entitled_capacity");
                        f6 = -1.0f;
                        f7 = -1.0f;
                        f11 = -1.0f;
                        f10 = -1.0f;
                        f9 = -1.0f;
                        f8 = -1.0f;
                    } else {
                        f11 = -1.0f;
                        f10 = -1.0f;
                        f9 = -1.0f;
                        f8 = -1.0f;
                        f7 = -1.0f;
                        f6 = -1.0f;
                        f5 = -1.0f;
                        f4 = -1.0f;
                        f3 = -1.0f;
                        f2 = -1.0f;
                        f1 = -1.0f;
                    }
                    if (f1 <= 512.0f) {
                        this.perfData.add(slot, (byte)0, f1);
                    }
                    if (f2 <= 512.0f) {
                        this.perfData.add(slot, (byte)1, f2);
                    }
                    if (f3 <= 4096.0f) {
                        this.perfData.add(slot, (byte)2, f3);
                    }
                    if (f4 <= 512.0f) {
                        this.perfData.add(slot, (byte)3, f4);
                    }
                    if (f5 <= 512.0f) {
                        this.perfData.add(slot, (byte)5, f5);
                    }
                    if (f6 <= 512.0f) {
                        this.perfData.add(slot, (byte)4, f6);
                    }
                    if (f1 >= 0.0f && f1 <= 512.0f && f5 > 0.0f && f5 <= 512.0f) {
                        this.perfData.add(slot, (byte)6, 100.0f * f1 / f5);
                    }
                    if (f7 <= 512.0f) {
                        this.perfData.add(slot, (byte)60, f7);
                    }
                    if (f8 <= 100.0f) {
                        this.perfData.add(slot, (byte)61, f8);
                    }
                    if (f9 <= 100.0f) {
                        this.perfData.add(slot, (byte)62, f9);
                    }
                    if (f10 <= 100.0f) {
                        this.perfData.add(slot, (byte)63, f10);
                    }
                    if (!(f11 <= 100.0f)) continue;
                    this.perfData.add(slot, (byte)64, f11);
                    continue;
                }
                if (this.multipleLPAR || this.avoidDisk || !key.startsWith("DISK")) break block141;
                if (nt.getNumTokens() != nt.getKeys().length) {
                    System.out.println("Warning: number of disks changed since nmon started. Skippping disk data.");
                    this.avoidDisk = true;
                    continue;
                }
                if (key.startsWith("DISKREADSERV")) {
                    type = 6;
                } else if (key.startsWith("DISKWRITESERV")) {
                    type = 12;
                } else if (key.startsWith("DISKBUSY")) {
                    type = 0;
                } else if (key.startsWith("DISKREAD")) {
                    type = 1;
                } else if (key.startsWith("DISKWRITE")) {
                    type = 2;
                } else if (key.startsWith("DISKXFER")) {
                    type = 3;
                } else if (key.startsWith("DISKBSIZE")) {
                    type = 4;
                } else if (key.startsWith("DISKSERV")) {
                    type = 23;
                } else if (key.startsWith("DISKWAIT")) {
                    type = 24;
                } else if (key.startsWith("DISKRIO")) {
                    type = 5;
                } else {
                    if (!key.startsWith("DISKWIO")) continue;
                    type = 11;
                }
                currentKeys = nt.getKeys();
                i = 2;
                while (i < currentKeys.length) {
                    block143: {
                        block142: {
                            byte newType;
                            f1 = nt.getValue(i);
                            diskName = currentKeys[i];
                            if (!diskName.startsWith("hdiskpower")) break block142;
                            switch (type) {
                                case 1: {
                                    newType = 0;
                                    break;
                                }
                                case 2: {
                                    newType = 1;
                                    break;
                                }
                                case 3: {
                                    newType = 2;
                                    break;
                                }
                                case 23: {
                                    newType = 4;
                                    break;
                                }
                                case 24: {
                                    newType = 5;
                                    break;
                                }
                                default: {
                                    break block143;
                                }
                            }
                            this.perfData.add(slot, (byte)3, newType, diskName, f1);
                            break block143;
                        }
                        if (diskName.startsWith("dac")) {
                            this.perfData.add(slot, (byte)11, (byte)type, diskName, f1);
                        } else {
                            this.perfData.add(slot, (byte)2, (byte)type, diskName, f1);
                        }
                    }
                    ++i;
                }
                continue;
            }
            if (!this.multipleLPAR && key.startsWith("ESS")) {
                byte type;
                if (key.equals("ESSREAD")) {
                    type = 0;
                } else if (key.equals("ESSWRITE")) {
                    type = 1;
                } else {
                    if (!key.equals("ESSXFER")) continue;
                    type = 2;
                }
                currentKeys = nt.getKeys();
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)3, type, diskName, f1);
                    ++i;
                }
                continue;
            }
            if (key.equals("IOADAPT")) {
                i = 2;
                while (i < nt.getNumTokens()) {
                    f1 = nt.getValue(i);
                    f2 = nt.getValue(i + 1);
                    f3 = nt.getValue(i + 2);
                    diskName = nt.getKeys()[i].split("_")[0];
                    this.perfData.add(slot, (byte)4, (byte)0, diskName, f1);
                    this.perfData.add(slot, (byte)4, (byte)1, diskName, f2);
                    this.perfData.add(slot, (byte)4, (byte)2, diskName, f3);
                    i += 3;
                }
                continue;
            }
            if (key.startsWith("NET")) {
                int j;
                String[] keys;
                if (key.equals("NET")) {
                    i = 2;
                    while (i < nt.getNumTokens()) {
                        keys = nt.getKeys();
                        if (nt.getNumTokens() != keys.length) {
                            if (suppressNetWarnings) continue block7;
                            System.out.println("Network line " + this.current_file_line_read + ": networks have chaged! Skipping network data!");
                            suppressNetWarnings = true;
                            continue block7;
                        }
                        String[] split = keys[i].split("-");
                        diskName = split[0];
                        j = 1;
                        while (j < split.length - 2) {
                            diskName = String.valueOf(diskName) + "-" + split[j];
                            ++j;
                        }
                        String type = split[split.length - 2];
                        if (type.equals("read")) {
                            this.perfData.add(slot, (byte)5, (byte)0, diskName, nt.getValue(i));
                        }
                        if (type.equals("write")) {
                            this.perfData.add(slot, (byte)5, (byte)1, diskName, nt.getValue(i));
                        }
                        ++i;
                    }
                    continue;
                }
                if (!this.multipleLPAR && key.equals("NETPACKET")) {
                    i = 2;
                    while (i < nt.getNumTokens()) {
                        keys = nt.getKeys();
                        if (nt.getNumTokens() != keys.length) {
                            if (suppressNetWarnings) continue block7;
                            System.out.println("Network line " + this.current_file_line_read + ": networks have chaged! Skipping network data!");
                            suppressNetWarnings = true;
                            continue block7;
                        }
                        String[] split = keys[i].split("-");
                        diskName = split[0];
                        j = 1;
                        while (j < split.length - 2) {
                            diskName = String.valueOf(diskName) + "-" + split[j];
                            ++j;
                        }
                        String type = split[split.length - 1];
                        if (type.equals("reads/s")) {
                            this.perfData.add(slot, (byte)5, (byte)2, diskName, nt.getValue(i));
                        }
                        if (type.equals("writes/s")) {
                            this.perfData.add(slot, (byte)5, (byte)3, diskName, nt.getValue(i));
                        }
                        ++i;
                    }
                    continue;
                }
                if (this.multipleLPAR || !key.equals("NETERROR")) continue;
                i = 2;
                while (i < nt.getNumTokens()) {
                    keys = nt.getKeys();
                    if (nt.getNumTokens() != keys.length) {
                        if (suppressNetWarnings) continue block7;
                        System.out.println("Network line " + this.current_file_line_read + ": networks have chaged! Skipping network data!");
                        suppressNetWarnings = true;
                        continue block7;
                    }
                    String[] split = keys[i].split("-");
                    diskName = split[0];
                    j = 1;
                    while (j < split.length - 2) {
                        diskName = String.valueOf(diskName) + "-" + split[j];
                        ++j;
                    }
                    String type = split[split.length - 1];
                    if (type.equals("ierrs")) {
                        this.perfData.add(slot, (byte)5, (byte)4, diskName, nt.getValue(i));
                    }
                    if (type.equals("oerrs")) {
                        this.perfData.add(slot, (byte)5, (byte)5, diskName, nt.getValue(i));
                    }
                    if (type.equals("collisions")) {
                        this.perfData.add(slot, (byte)5, (byte)6, diskName, nt.getValue(i));
                    }
                    ++i;
                }
                continue;
            }
            if (!this.multipleLPAR && key.equals("PROC")) {
                f1 = nt.getValueFromKey("Runnable");
                f2 = nt.getValueFromKey("Swap-in");
                f3 = nt.getValueFromKey("pswitch");
                f4 = nt.getValueFromKey("syscall");
                f5 = nt.getValueFromKey("read");
                f6 = nt.getValueFromKey("write");
                f7 = nt.getValueFromKey("fork");
                f8 = nt.getValueFromKey("exec");
                this.perfData.add(slot, (byte)26, f1);
                this.perfData.add(slot, (byte)27, f2);
                this.perfData.add(slot, (byte)29, f3);
                this.perfData.add(slot, (byte)30, f4);
                this.perfData.add(slot, (byte)33, f5);
                this.perfData.add(slot, (byte)34, f6);
                this.perfData.add(slot, (byte)31, f7);
                this.perfData.add(slot, (byte)32, f8);
                continue;
            }
            if (!this.multipleLPAR && !this.avoidTop && key.equals("TOP")) {
                f1 = nt.getValueFromKey("%CPU");
                f2 = nt.getValueFromKey("ResText");
                f3 = nt.getValueFromKey("ResData");
                if (f1 <= 51200.0f) {
                    this.perfData.add(slot, (byte)7, (byte)0, String.valueOf(nt.getStringFromKey("Command")) + ":" + nt.getStringFromKey("+PID"), f1);
                }
                this.perfData.add(slot, (byte)7, (byte)1, String.valueOf(nt.getStringFromKey("Command")) + ":" + nt.getStringFromKey("+PID"), f2);
                this.perfData.add(slot, (byte)7, (byte)2, String.valueOf(nt.getStringFromKey("Command")) + ":" + nt.getStringFromKey("+PID"), f3);
                if (this.perfData.getNumTopProc() < this.MAX_TOPPROC) continue;
                this.avoidTop = true;
                this.perfData.invalidateTop();
                System.out.println("Too many TOP processes. Limit of " + this.MAX_TOPPROC + " has been reached: skipping TOP data.");
                System.out.println("    - Select a smaller time period to show TOP information.");
                System.out.println("    - Use pGraph.properties file and change MaxTopProcs variable to higher value.");
                continue;
            }
            if (!this.multipleLPAR && key.equals("JFSFILE")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressJFSwarning) continue;
                    System.out.println("JFSFILE line " + this.current_file_line_read + " skipped: filesystem number has changed.");
                    suppressJFSwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)9, (byte)0, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("JFSINODE")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressJFSwarning) continue;
                    System.out.println("JFSINODE line " + this.current_file_line_read + " skipped: filesystem number has changed.");
                    suppressJFSwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)9, (byte)1, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("WLMCPU")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressWLMwarning) continue;
                    System.out.println("WLM line " + this.current_file_line_read + " skipped: WLM class number has changed.");
                    suppressWLMwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)6, (byte)0, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("WLMMEM")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressWLMwarning) continue;
                    System.out.println("WLM line " + this.current_file_line_read + " skipped: WLM class number has changed.");
                    suppressWLMwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)6, (byte)1, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("WLMBIO")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressWLMwarning) continue;
                    System.out.println("WLM line " + this.current_file_line_read + " skipped: WLM class number has changed.");
                    suppressWLMwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)6, (byte)2, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("PROCAIO")) {
                f1 = nt.getValueFromKey("aioprocs");
                f2 = nt.getValueFromKey("aiorunning");
                f3 = nt.getValueFromKey("aiocp");
                this.perfData.add(slot, (byte)42, f1);
                this.perfData.add(slot, (byte)43, f2);
                this.perfData.add(slot, (byte)44, f3);
                continue;
            }
            if (!this.multipleLPAR && key.equals("FCREAD")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)10, (byte)0, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("FCWRITE")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)10, (byte)1, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("FCXFERIN")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)10, (byte)2, diskName, f1);
                    ++i;
                }
            }
            if (!this.multipleLPAR && key.equals("FCXFEROUT")) {
                currentKeys = nt.getKeys();
                if (nt.getNumTokens() != currentKeys.length) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < currentKeys.length) {
                    f1 = nt.getValue(i);
                    diskName = currentKeys[i];
                    this.perfData.add(slot, (byte)10, (byte)3, diskName, f1);
                    ++i;
                }
            }
            if (this.multipleLPAR || !key.startsWith("SEA")) continue;
            if (key.equals("SEA")) {
                i = 2;
                while (i < nt.getNumTokens()) {
                    String[] split = nt.getKeys()[i].split("-");
                    diskName = split[0];
                    String type = split[1];
                    if (type.equals("read")) {
                        this.perfData.add(slot, (byte)13, (byte)0, diskName, nt.getValue(i));
                    }
                    if (type.equals("write")) {
                        this.perfData.add(slot, (byte)13, (byte)0, diskName, nt.getValue(i));
                    }
                    ++i;
                }
                continue;
            }
            if (!key.equals("SEAPACKET")) continue;
            i = 2;
            while (i < nt.getNumTokens()) {
                String[] split = nt.getKeys()[i].split("-");
                diskName = split[0];
                String type = split[1];
                if (type.equals("reads/s")) {
                    this.perfData.add(slot, (byte)13, (byte)2, diskName, nt.getValue(i));
                }
                if (type.equals("writes/s")) {
                    this.perfData.add(slot, (byte)13, (byte)3, diskName, nt.getValue(i));
                }
                ++i;
            }
        }
        br.close();
        if (lastParse) {
            this.perfData.endOfData();
        }
    }

    private Vector splitLine(String s) {
        int end;
        Vector<String> result = new Vector<String>();
        int begin = 0;
        while ((end = s.indexOf(44, begin)) >= 0) {
            result.add(s.substring(begin, end));
            begin = end + 1;
        }
        result.add(s.substring(begin));
        return result;
    }

    private GregorianCalendar parseDate(String line, GregorianCalendar last) {
        return this.parseDate(this.splitLine(line), last);
    }

    private GregorianCalendar parseDate(Vector v, GregorianCalendar last) {
        int s;
        int m;
        int h;
        String time = (String)v.elementAt(2);
        try {
            h = Integer.parseInt(time.substring(0, 2));
            m = Integer.parseInt(time.substring(3, 5));
            s = Integer.parseInt(time.substring(6));
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (v.size() == 4) {
            String date = (String)v.elementAt(3);
            int day = Integer.parseInt(date.substring(0, 2));
            int year = Integer.parseInt(date.substring(7));
            String str = date.substring(3, 6);
            int month = 0;
            if (str.equals("JAN")) {
                month = 0;
            } else if (str.equals("FEB")) {
                month = 1;
            } else if (str.equals("MAR")) {
                month = 2;
            } else if (str.equals("APR")) {
                month = 3;
            } else if (str.equals("MAY")) {
                month = 4;
            } else if (str.equals("JUN")) {
                month = 5;
            } else if (str.equals("JUL")) {
                month = 6;
            } else if (str.equals("AUG")) {
                month = 7;
            } else if (str.equals("SEP")) {
                month = 8;
            } else if (str.equals("OCT")) {
                month = 9;
            } else if (str.equals("NOV")) {
                month = 10;
            } else if (str.equals("DEC")) {
                month = 11;
            }
            return new GregorianCalendar(year, month, day, h, m, s);
        }
        if (last == null) {
            return new GregorianCalendar(1970, 0, 1, h, m, s);
        }
        if (h < last.get(11)) {
            return new GregorianCalendar(1970, 0, last.get(5) + 1, h, m, s);
        }
        return new GregorianCalendar(1970, 0, last.get(5), h, m, s);
    }

    private GregorianCalendar parseDate(String time, String date, GregorianCalendar last) {
        int s;
        int m;
        int h;
        try {
            h = Integer.parseInt(time.substring(0, 2));
            m = Integer.parseInt(time.substring(3, 5));
            s = Integer.parseInt(time.substring(6));
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (date != null) {
            int day = Integer.parseInt(date.substring(0, 2));
            int year = Integer.parseInt(date.substring(7));
            String str = date.substring(3, 6);
            int month = 0;
            if (str.equals("JAN")) {
                month = 0;
            } else if (str.equals("FEB")) {
                month = 1;
            } else if (str.equals("MAR")) {
                month = 2;
            } else if (str.equals("APR")) {
                month = 3;
            } else if (str.equals("MAY")) {
                month = 4;
            } else if (str.equals("JUN")) {
                month = 5;
            } else if (str.equals("JUL")) {
                month = 6;
            } else if (str.equals("AUG")) {
                month = 7;
            } else if (str.equals("SEP")) {
                month = 8;
            } else if (str.equals("OCT")) {
                month = 9;
            } else if (str.equals("NOV")) {
                month = 10;
            } else if (str.equals("DEC")) {
                month = 11;
            }
            return new GregorianCalendar(year, month, day, h, m, s);
        }
        if (last == null) {
            return new GregorianCalendar(1970, 0, 1, h, m, s);
        }
        if (h < last.get(11)) {
            return new GregorianCalendar(1970, 0, last.get(5) + 1, h, m, s);
        }
        return new GregorianCalendar(1970, 0, last.get(5), h, m, s);
    }

    private boolean isTimeStamp(String s) {
        if (s == null || s.length() < 2 || !s.startsWith("T")) {
            return false;
        }
        s = s.substring(1);
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

