/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import pGraph.DataSet;

public class GlobalConfig {
    private String configFileName = null;
    private FontData buttonFont = new FontData("SansSerif", 1, 12);
    private FontData panelDataFont = new FontData("SansSerif", 1, 12);
    private FontData panelGridFont = new FontData("SansSerif", 0, 10);
    private FontData panelTitleFont = new FontData("SansSerif", 1, 12);
    private FontData pointedDataFont = new FontData("SansSerif", 0, 12);
    private int panelHeight = 200;
    private int textareaWidth = 250;
    private ColorData usColor = new ColorData(Color.RED);
    private ColorData syColor = new ColorData(Color.GREEN);
    private ColorData waColor = new ColorData(Color.BLUE);
    private ColorData idColor = new ColorData(Color.YELLOW);
    private ColorData graphBackColor = new ColorData(Color.LIGHT_GRAY);
    private ColorData[] seriesColor = new ColorData[]{new ColorData(Color.RED), new ColorData(Color.GREEN), new ColorData(Color.BLUE), new ColorData(Color.YELLOW), new ColorData(Color.CYAN)};
    private ColorData dataBackColor = new ColorData(170, 170, 170);
    private File workingDirectory = null;
    private int maxTopProcs = 6000;
    private int maxDisks = 100;

    public int getMaxTopProcs() {
        return this.maxTopProcs;
    }

    public int getMaxDisks() {
        return this.maxDisks;
    }

    public Font getButtonFont() {
        return this.buttonFont.getFont();
    }

    public Font getPanelDataFont() {
        return this.panelDataFont.getFont();
    }

    public Font getPanelGridFont() {
        return this.panelGridFont.getFont();
    }

    public Font getPanelTitleFont() {
        return this.panelTitleFont.getFont();
    }

    public Font getPointedDataFont() {
        return this.pointedDataFont.getFont();
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public int getTextareaWidth() {
        return this.textareaWidth;
    }

    public Color getUsColor() {
        return this.usColor.getColor();
    }

    public Color getSyColor() {
        return this.syColor.getColor();
    }

    public Color getWaColor() {
        return this.waColor.getColor();
    }

    public Color getIdColor() {
        return this.idColor.getColor();
    }

    public Color getGraphBackColor() {
        return this.graphBackColor.getColor();
    }

    public Color getDataBackColor() {
        return this.dataBackColor.getColor();
    }

    public Color getLineColor(int lineno) {
        if (lineno < this.seriesColor.length) {
            return this.seriesColor[lineno].getColor();
        }
        return null;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public GlobalConfig(String name) {
        this.configFileName = name;
        this.readProperties();
    }

    public void readProperties() {
        Properties configFile = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.configFileName);
            configFile.load(in);
            in.close();
        }
        catch (IOException ioe) {
            return;
        }
        this.buttonFont.parseFont(configFile.getProperty("ButtonFont"));
        this.panelDataFont.parseFont(configFile.getProperty("PanelDataFont"));
        this.panelGridFont.parseFont(configFile.getProperty("PanelGridFont"));
        this.panelTitleFont.parseFont(configFile.getProperty("PanelTitleFont"));
        this.pointedDataFont.parseFont(configFile.getProperty("PointedDataFont"));
        try {
            this.panelHeight = Integer.parseInt(configFile.getProperty("GraphHeight"));
        }
        catch (NumberFormatException ioe) {
            // empty catch block
        }
        try {
            int panelWidth = Integer.parseInt(configFile.getProperty("GraphWidth"));
            if (panelWidth > 0) {
                DataSet.SLOTS = panelWidth;
            }
        }
        catch (NumberFormatException panelWidth) {
            // empty catch block
        }
        try {
            this.textareaWidth = Integer.parseInt(configFile.getProperty("TextAreaWidth"));
            if (this.textareaWidth < 250) {
                this.textareaWidth = 250;
            }
        }
        catch (NumberFormatException panelWidth) {
            // empty catch block
        }
        try {
            this.maxTopProcs = Integer.parseInt(configFile.getProperty("MaxTopProcs"));
        }
        catch (NumberFormatException panelWidth) {
            // empty catch block
        }
        try {
            this.maxDisks = Integer.parseInt(configFile.getProperty("MaxDisks"));
        }
        catch (NumberFormatException panelWidth) {
            // empty catch block
        }
        this.usColor.parseColor(configFile.getProperty("UserColor"));
        this.syColor.parseColor(configFile.getProperty("SystemColor"));
        this.waColor.parseColor(configFile.getProperty("WaitColor"));
        this.idColor.parseColor(configFile.getProperty("IdleColor"));
        this.graphBackColor.parseColor(configFile.getProperty("GraphBackColor"));
        this.dataBackColor.parseColor(configFile.getProperty("DataBackColor"));
        this.seriesColor[0].parseColor(configFile.getProperty("Series1Color"));
        this.seriesColor[1].parseColor(configFile.getProperty("Series2Color"));
        this.seriesColor[2].parseColor(configFile.getProperty("Series3Color"));
        this.seriesColor[3].parseColor(configFile.getProperty("Series4Color"));
        this.seriesColor[4].parseColor(configFile.getProperty("Series5Color"));
        String workDir = configFile.getProperty("WorkingDirectory");
        if (workDir != null) {
            this.workingDirectory = new File(workDir);
            if (!this.workingDirectory.canRead() || !this.workingDirectory.isDirectory()) {
                this.workingDirectory = null;
            }
        } else {
            this.workingDirectory = null;
        }
    }

    class ColorData {
        Color color;

        public ColorData(Color c) {
            this.color = c;
        }

        public ColorData(int r, int g, int b) {
            this.color = new Color(r, g, b);
        }

        public Color getColor() {
            return this.color;
        }

        public void parseColor(String label) {
            if (label == null) {
                return;
            }
            String[] items = label.split(",");
            int i = 0;
            while (i < items.length) {
                items[i] = items[i].trim().toLowerCase();
                ++i;
            }
            if (items.length == 1) {
                if (items[0].equals("black")) {
                    this.color = Color.BLACK;
                }
                if (items[0].equals("blue")) {
                    this.color = Color.BLUE;
                }
                if (items[0].equals("cyan")) {
                    this.color = Color.CYAN;
                }
                if (items[0].equals("darkgray")) {
                    this.color = Color.DARK_GRAY;
                }
                if (items[0].equals("gray")) {
                    this.color = Color.GRAY;
                }
                if (items[0].equals("green")) {
                    this.color = Color.GREEN;
                }
                if (items[0].equals("lightgray")) {
                    this.color = Color.LIGHT_GRAY;
                }
                if (items[0].equals("magenta")) {
                    this.color = Color.MAGENTA;
                }
                if (items[0].equals("orange")) {
                    this.color = Color.ORANGE;
                }
                if (items[0].equals("pink")) {
                    this.color = Color.PINK;
                }
                if (items[0].equals("red")) {
                    this.color = Color.RED;
                }
                if (items[0].equals("white")) {
                    this.color = Color.WHITE;
                }
                return;
            }
            if (items.length == 3) {
                try {
                    int r = Integer.parseInt(items[0]);
                    int g = Integer.parseInt(items[1]);
                    int b = Integer.parseInt(items[2]);
                    this.color = new Color(r, g, b);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    class FontData {
        String name;
        int style;
        int size;

        public FontData(String name, int style, int size) {
            this.name = name;
            this.style = style;
            this.size = size;
        }

        public Font getFont() {
            return new Font(this.name, this.style, this.size);
        }

        public void parseFont(String label) {
            if (label == null) {
                return;
            }
            String[] items = label.split(",");
            if (items.length != 3) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                items[i] = items[i].trim().toLowerCase();
                ++i;
            }
            if (items[0].equals("dialog")) {
                this.name = items[0];
            }
            if (items[0].equals("dialoginput")) {
                this.name = items[0];
            }
            if (items[0].equals("monospaced")) {
                this.name = items[0];
            }
            if (items[0].equals("serif")) {
                this.name = items[0];
            }
            if (items[0].equals("sanserif")) {
                this.name = items[0];
            }
            if (items[1].equals("plain")) {
                this.style = 0;
            }
            if (items[1].equals("bold")) {
                this.style = 1;
            }
            if (items[1].equals("italic")) {
                this.style = 2;
            }
            if (items[1].equals("bolditalic")) {
                this.style = 3;
            }
            try {
                this.size = Integer.parseInt(items[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

