/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import pGraph.CPUPerfPanel;
import pGraph.DataSet;
import pGraph.GlobalConfig;
import pGraph.PerfData;

public abstract class GenericPanel
extends JPanel
implements MouseMotionListener {
    protected int minZoom;
    protected int maxZoom;
    protected float maxValue = 0.0f;
    protected float computedMaxValue = 0.0f;
    protected GlobalConfig configuration;
    protected DataSet[] dataSet = null;
    protected PerfData perfData = null;
    protected int TEXT_SPACE = 12;
    private int STEP = DataSet.SLOTS / 6;
    protected int pointedX = -1;
    protected int pointedY = -1;
    protected boolean hideZoomBars = false;
    protected int required_top = 0;
    protected String[] completeNames = null;
    protected DataSet[] completeDataSet = null;
    protected String[] overrideNames = null;
    protected int validPointedSlot = -1;

    public GenericPanel(GlobalConfig config) {
        int width;
        this.configuration = config;
        FontMetrics metrics = this.getFontMetrics(this.configuration.getPanelGridFont());
        this.STEP = width = metrics.stringWidth("XD00-00:00:00X");
        this.TEXT_SPACE = this.configuration.getPanelGridFont().getSize() + 2;
        this.minZoom = -1;
        this.maxZoom = DataSet.SLOTS;
        this.addMouseMotionListener(this);
    }

    public void setData(PerfData perfData, DataSet[] dataSet, String[] names, int num_top) {
        this.perfData = perfData;
        this.completeDataSet = dataSet;
        this.completeNames = names;
        this.required_top = num_top;
        this.dataSet = new DataSet[this.required_top];
        this.overrideNames = new String[this.required_top];
        this.extractTopByAvg();
        this.computeMaxValue();
    }

    public void setData(PerfData perfData, DataSet[] dataSet) {
        this.perfData = perfData;
        this.dataSet = dataSet;
        this.computeMaxValue();
    }

    protected void extractTopByAvg() {
        if (this.completeDataSet == null) {
            return;
        }
        int i = 0;
        while (i < this.dataSet.length) {
            this.dataSet[i] = null;
            this.overrideNames[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.completeDataSet.length) {
            if (this.completeDataSet[i] != null) {
                float avg = this.completeDataSet[i].getAvg();
                int j = 0;
                while (j < this.dataSet.length && this.dataSet[j] != null && avg < this.dataSet[j].getAvg()) {
                    ++j;
                }
                if (j < this.dataSet.length) {
                    int k = this.dataSet.length - 1;
                    while (k > j) {
                        this.dataSet[k] = this.dataSet[k - 1];
                        this.overrideNames[k] = this.overrideNames[k - 1];
                        --k;
                    }
                    this.dataSet[j] = this.completeDataSet[i];
                    this.overrideNames[j] = this.completeNames[i];
                }
            }
            ++i;
        }
    }

    public void mouseDragged(MouseEvent e) {
        int m = e.getModifiers();
        int x = e.getX();
        int xsize = this.getWidth();
        if (x < 0 || x > xsize - 1) {
            return;
        }
        if ((m & 0x10) != 0 && x < this.maxZoom) {
            this.firePropertyChange("minZoom", null, new Integer(this.nearestValidPoint(x)));
        }
        if ((m & 4) != 0 && x > this.minZoom) {
            this.firePropertyChange("maxZoom", null, new Integer(this.nearestValidPoint(x)));
        }
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int xsize = this.getWidth();
        this.pointedX = e.getX();
        this.pointedY = e.getY();
        if (x < 0 || x > xsize - 1) {
            return;
        }
        this.validPointedSlot = this.nearestValidPoint(x);
        this.firePropertyChange("focusBar", null, new Integer(this.validPointedSlot));
        this.firePropertyChange("focus", null, this.getPointedData(this.validPointedSlot));
    }

    private int nearestValidPoint(int p) {
        int result = -1;
        int i = 0;
        while (i < this.dataSet.length) {
            int v;
            if (this.dataSet[i] != null && (v = this.dataSet[i].getNearestValidSlot(p)) >= 0) {
                if (result < 0) {
                    result = v;
                } else if (Math.abs(p - v) < Math.abs(p - result)) {
                    result = v;
                }
            }
            ++i;
        }
        return result;
    }

    public void setMinZoomBar(int min) {
        this.minZoom = min;
        this.repaint();
    }

    public void setMaxZoomBar(int max) {
        this.maxZoom = max;
        this.repaint();
    }

    public void setFocusBar(int v) {
        this.validPointedSlot = v;
        this.repaint();
    }

    public void zoom() {
        this.minZoom = -1;
        this.maxZoom = DataSet.SLOTS;
        this.validPointedSlot = -1;
        this.extractTopByAvg();
        this.computeMaxValue();
        this.repaint();
    }

    protected void drawLimits(Graphics g) {
        g.setColor(this.configuration.getDataBackColor());
        g.fillRect(DataSet.SLOTS, 0, this.getWidth(), this.getHeight() - this.TEXT_SPACE);
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.configuration.getPanelDataFont());
        int limitsFontSize = this.configuration.getPanelDataFont().getSize();
        g2.setColor(Color.BLACK);
        g2.drawString("From:", DataSet.SLOTS + 3, limitsFontSize + 5);
        g2.drawString(this.gcToString(this.perfData.getStart(), true), DataSet.SLOTS + 50, limitsFontSize + 5);
        g2.drawString("To:", DataSet.SLOTS + 3, (limitsFontSize + 5) * 2);
        g2.drawString(this.gcToString(this.perfData.getEnd(), true), DataSet.SLOTS + 50, (limitsFontSize + 5) * 2);
        g2.setColor(Color.WHITE);
        g2.drawString("Limits: [ Min - Avg - Max ] Std Deviation", DataSet.SLOTS + 3, (limitsFontSize + 5) * 3);
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                if (this instanceof CPUPerfPanel) {
                    switch (i) {
                        case 0: {
                            g2.setColor(this.configuration.getUsColor());
                            break;
                        }
                        case 1: {
                            g2.setColor(this.configuration.getSyColor());
                            break;
                        }
                        case 2: {
                            g2.setColor(this.configuration.getWaColor());
                            break;
                        }
                        case 3: {
                            g2.setColor(this.configuration.getIdColor());
                            break;
                        }
                        default: {
                            g2.setColor(Color.BLACK);
                            break;
                        }
                    }
                } else {
                    g2.setColor(this.configuration.getLineColor(i));
                }
                g2.drawString(this.limitString(i), DataSet.SLOTS + 3, (limitsFontSize + 5) * (4 + i));
            }
            ++i;
        }
    }

    private String limitString(int index) {
        DataSet ds = this.dataSet[index];
        String result = this.overrideNames != null && this.overrideNames[index] != null ? String.valueOf(this.overrideNames[index]) + ": [ " : String.valueOf(ds.getName()) + ": [ ";
        float min = ds.getMin();
        float avg = ds.getAvg();
        float max = ds.getMax();
        if (min > max && avg == 0.0f && max == 0.0f) {
            return String.valueOf(result) + "N/A ]";
        }
        float v = ds.getMin();
        result = v < 0.0f ? String.valueOf(result) + "N/A" : String.valueOf(result) + Float.toString(v);
        result = String.valueOf(result) + " - ";
        v = ds.getAvg();
        result = v < 0.0f ? String.valueOf(result) + "N/A" : String.valueOf(result) + Float.toString(v);
        result = String.valueOf(result) + " - ";
        v = ds.getMax();
        result = v < 0.0f ? String.valueOf(result) + "N/A" : String.valueOf(result) + Float.toString(v);
        result = String.valueOf(result) + " ]";
        result = String.valueOf(result) + " " + ds.getDevStd();
        return result;
    }

    protected void drawGrid(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        float[] pattern = new float[]{10.0f, 5.0f};
        g2.setPaint(Color.BLACK);
        g2.setFont(this.configuration.getPanelGridFont());
        g2.setStroke(new BasicStroke(1.0f, 1, 1, 5.0f, pattern, 0.0f));
        int ysize = this.getHeight() - this.TEXT_SPACE;
        g2.drawLine(0, ysize / 4, DataSet.SLOTS - 1, ysize / 4);
        g2.drawLine(0, ysize / 2, DataSet.SLOTS - 1, ysize / 2);
        g2.drawLine(0, 3 * ysize / 4, DataSet.SLOTS - 1, 3 * ysize / 4);
        float f = (float)((int)(3.0f * this.maxValue / 4.0f * 100.0f)) / 100.0f;
        g2.drawString(Float.toString(f), 1, ysize / 4 - 2);
        f = (float)((int)(this.maxValue / 2.0f * 100.0f)) / 100.0f;
        g2.drawString(Float.toString(f), 1, ysize / 2 - 2);
        f = (float)((int)(this.maxValue / 4.0f * 100.0f)) / 100.0f;
        g2.drawString(Float.toString(f), 1, 3 * ysize / 4 - 2);
        FontMetrics metrics = this.getFontMetrics(this.configuration.getPanelGridFont());
        int i = this.STEP;
        while (i < DataSet.SLOTS) {
            g2.drawLine(i, 0, i, ysize);
            String s = this.gcToString(this.slotToGc(i), false);
            int size = metrics.stringWidth(s);
            g2.drawString(s, i - size / 2, ysize + this.configuration.getPanelGridFont().getSize());
            i += this.STEP;
        }
    }

    protected void drawZoomBars(Graphics g) {
        if (this.hideZoomBars) {
            return;
        }
        int ysize = this.getHeight() - this.TEXT_SPACE;
        g.setColor(Color.WHITE);
        g.drawLine(this.validPointedSlot, 0, this.validPointedSlot, ysize - 1);
        g.setColor(Color.black);
        if (this.minZoom >= 0) {
            g.drawLine(this.minZoom, 0, this.minZoom, ysize - 1);
        }
        if (this.maxZoom < DataSet.SLOTS) {
            g.drawLine(this.maxZoom, 0, this.maxZoom, ysize - 1);
        }
    }

    protected void computeMaxValue() {
        this.maxValue = Float.MIN_VALUE;
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                float f;
                float v = this.dataSet[i].getMax();
                if (f > this.maxValue) {
                    this.maxValue = v;
                }
            }
            ++i;
        }
        this.computedMaxValue = this.maxValue;
    }

    protected String getPointedData(int time) {
        if (time < 0 || time >= DataSet.SLOTS) {
            return " ";
        }
        String s = "[" + this.gcToString(this.slotToGc(time), true) + "]";
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                s = this.overrideNames != null && this.overrideNames[i] != null ? String.valueOf(s) + " " + this.overrideNames[i] + "=" : String.valueOf(s) + " " + this.dataSet[i].getName() + "=";
                float v = this.dataSet[i].getValue(time);
                float min = this.dataSet[i].getAbsMin(time);
                float max = this.dataSet[i].getAbsMax(time);
                s = v < 0.0f ? String.valueOf(s) + "N/A" : (min < 0.0f || max < 0.0f || min == v && v == max ? String.valueOf(s) + v : String.valueOf(s) + "[" + min + " - " + v + " - " + max + "]");
            }
            ++i;
        }
        return s;
    }

    protected GregorianCalendar slotToGc(int time) {
        GregorianCalendar t = new GregorianCalendar();
        long delta = (long)time * (this.perfData.getEnd().getTime().getTime() - this.perfData.getStart().getTime().getTime()) / (long)(DataSet.SLOTS - 1);
        t.setTime(new Date(this.perfData.getStart().getTime().getTime() + delta));
        return t;
    }

    protected String gcToString(GregorianCalendar gc, boolean year) {
        int Y = gc.get(1);
        int M = gc.get(2) + 1;
        int D = gc.get(5);
        int h = gc.get(11);
        int m = gc.get(12);
        int s = gc.get(13);
        String str = "";
        if (year) {
            if (Y < 1980) {
                str = "Day " + D + ": ";
            } else {
                str = String.valueOf(Y) + "-";
                if (M < 10) {
                    str = String.valueOf(str) + "0";
                }
                str = String.valueOf(str) + M + "-";
                if (D < 10) {
                    str = String.valueOf(str) + "0";
                }
                str = String.valueOf(str) + D + " ";
            }
        } else {
            str = D < 10 ? "D0" + D + "-" : "D" + D + "-";
        }
        if (h < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + h + ":";
        if (m < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + m + ":";
        if (s < 10) {
            str = String.valueOf(str) + "0";
        }
        str = String.valueOf(str) + s;
        return str;
    }

    public void setHideZoomBars(boolean hideZoomBars) {
        this.hideZoomBars = hideZoomBars;
    }

    public String getCSVNames(String prefix) {
        String s = "";
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                s = this.overrideNames != null && this.overrideNames[i] != null ? String.valueOf(s) + prefix + " " + this.overrideNames[i] + ";" : String.valueOf(s) + prefix + " " + this.dataSet[i].getName() + ";";
            }
            ++i;
        }
        return s;
    }

    public String getCSVTime(int i) {
        if (i < 0 || i >= DataSet.SLOTS) {
            return null;
        }
        GregorianCalendar t = new GregorianCalendar();
        long start = this.perfData.getStart().getTime().getTime();
        long end = this.perfData.getEnd().getTime().getTime();
        long delta = (long)i * (end - start) / (long)(DataSet.SLOTS - 1);
        t.setTime(new Date(start + delta));
        return t.get(1) + "-" + (t.get(2) + 1) + "-" + t.get(5) + " " + t.get(11) + ":" + t.get(12) + ":" + t.get(13) + ";";
    }

    public String getCSVData(int slot) {
        String s = "";
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                float v = this.dataSet[i].getValue(slot);
                s = v < 0.0f ? String.valueOf(s) + ";" : String.valueOf(s) + v + ";";
            }
            ++i;
        }
        return s;
    }

    public float getMaxValue() {
        return this.computedMaxValue;
    }

    public void setMaxValue(float f) {
        this.maxValue = f;
        this.repaint();
    }

    public void restoreMaxValue() {
        this.maxValue = this.computedMaxValue;
        this.repaint();
    }
}

