/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.io.IOException;

public class FileTokenizer {
    private String name;
    private BufferedReader br = null;
    private int lines_read;
    private char separator;
    private String line;
    private int[] start = null;
    private int[] end = null;
    private int tokens = 0;
    private static byte TOKENBLOCK = (byte)10;

    public FileTokenizer(BufferedReader br, String name) {
        this.br = br;
        this.name = name;
        this.lines_read = 0;
        this.separator = (char)32;
        this.start = new int[TOKENBLOCK];
        this.end = new int[TOKENBLOCK];
        this.resetTokens();
    }

    private void resetTokens() {
        int i = 0;
        while (i < this.start.length) {
            this.start[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.end.length) {
            this.end[i] = -1;
            ++i;
        }
        this.tokens = 0;
    }

    public int readLine() {
        boolean newToken = true;
        try {
            this.line = this.br.readLine();
        }
        catch (IOException ioe) {
            System.out.println("Warning: IO Exception while reading from " + this.name + " after line number " + this.lines_read + ". Closing stream and continuing.");
            this.line = null;
        }
        if (this.line == null) {
            this.tokens = 0;
            return -1;
        }
        ++this.lines_read;
        if (this.line.length() == 0) {
            return 0;
        }
        this.resetTokens();
        int i = 0;
        while (i < this.line.length()) {
            if (newToken) {
                if (this.line.charAt(i) != this.separator) {
                    if (this.tokens >= this.start.length) {
                        this.expandTokenArrays();
                    }
                    this.start[this.tokens] = i;
                    newToken = false;
                }
            } else if (this.line.charAt(i) == this.separator) {
                this.end[this.tokens] = i;
                ++this.tokens;
                newToken = true;
            }
            ++i;
        }
        if (!newToken) {
            this.end[this.tokens] = -1;
            ++this.tokens;
        }
        return this.tokens;
    }

    private void expandTokenArrays() {
        int[] oldStart = this.start;
        int[] oldEnd = this.end;
        this.start = new int[oldStart.length + TOKENBLOCK];
        this.end = new int[oldEnd.length + TOKENBLOCK];
        int i = 0;
        while (i < oldStart.length) {
            this.start[i] = oldStart[i];
            this.end[i] = oldEnd[i];
            ++i;
        }
        i = oldStart.length;
        while (i < this.start.length) {
            this.start[i] = -1;
            this.end[i] = -1;
            ++i;
        }
    }

    public String getStringToken(int n) {
        if (this.end[n] == -1) {
            return this.line.substring(this.start[n]);
        }
        return this.line.substring(this.start[n], this.end[n]);
    }

    public float getFloatToken(int n) {
        try {
            return Float.parseFloat(this.getStringToken(n));
        }
        catch (NumberFormatException nfe) {
            System.out.println("Warning: cannot parse value on line " + this.lines_read + ". Continuing skipping value. The following line shows error.");
            String errLine = "";
            if (n > 0) {
                errLine = String.valueOf(errLine) + this.line.substring(0, this.start[n]);
            }
            errLine = String.valueOf(errLine) + ">>";
            if (this.end[n] == -1) {
                errLine = String.valueOf(errLine) + this.line.substring(this.start[n]);
                errLine = String.valueOf(errLine) + "<<";
            } else {
                errLine = String.valueOf(errLine) + this.line.substring(this.start[n], this.end[n]);
                errLine = String.valueOf(errLine) + "<<";
                errLine = String.valueOf(errLine) + this.line.substring(this.end[n]);
            }
            System.out.println(errLine);
            return -1.0f;
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

