/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import pGraph.DataSet;
import pGraph.GenericPanel;
import pGraph.GlobalConfig;
import pGraph.PerfData;
import pGraph.XYPanel;

public class SumXYPanel
extends XYPanel {
    private static final long serialVersionUID = 3819142265041879154L;
    private final byte BLOCK = (byte)5;
    private DataSet[][] sourceData = null;
    private GenericPanel[] sourcePanel = null;
    private boolean[] selected = null;
    private int numData = 0;
    private boolean smartComputing = false;

    public SumXYPanel(PerfData perfData, GlobalConfig config) {
        super(config);
        this.perfData = perfData;
    }

    public void selectAll() {
        int i = 0;
        while (i < this.numData) {
            this.selected[i] = true;
            ++i;
        }
        this.computeData();
    }

    public void deselectAll() {
        int i = 0;
        while (i < this.numData) {
            this.selected[i] = false;
            ++i;
        }
        this.computeData();
    }

    public void panelIsSelected(GenericPanel jp, boolean isSelected) {
        int i = 0;
        while (i < this.numData) {
            if (jp == this.sourcePanel[i]) {
                if (isSelected != this.selected[i]) {
                    this.selected[i] = isSelected;
                    this.computeData();
                }
                return;
            }
            ++i;
        }
    }

    public void zoom() {
        this.computeData();
        super.zoom();
    }

    private void computeDataSmart() {
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                int slot = 0;
                while (slot < DataSet.SLOTS) {
                    float maxSum = -1.0f;
                    float minSum = -1.0f;
                    float sum = -1.0f;
                    int j = 0;
                    while (j < this.numData) {
                        if (this.selected[j] && this.sourceData[j][i] != null) {
                            float v = this.getValidData(this.sourceData[j][i], slot, (byte)0);
                            if (v >= 0.0f) {
                                sum = sum >= 0.0f ? (sum += v) : v;
                            }
                            if ((v = this.getValidData(this.sourceData[j][i], slot, (byte)1)) >= 0.0f) {
                                minSum = minSum >= 0.0f ? (minSum += v) : v;
                            }
                            if ((v = this.getValidData(this.sourceData[j][i], slot, (byte)2)) >= 0.0f) {
                                maxSum = maxSum >= 0.0f ? (maxSum += v) : v;
                            }
                        }
                        ++j;
                    }
                    if (sum >= 0.0f) {
                        this.dataSet[i].addBySlot(slot, sum, minSum, maxSum);
                    }
                    ++slot;
                }
                this.dataSet[i].endOfData();
            }
            ++i;
        }
    }

    private void computeDataExact() {
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                int slot = 0;
                while (slot < DataSet.SLOTS) {
                    float maxSum = -1.0f;
                    float minSum = -1.0f;
                    float sum = -1.0f;
                    int j = 0;
                    while (j < this.numData) {
                        if (this.selected[j] && this.sourceData[j][i] != null) {
                            float v = this.sourceData[j][i].getValue(slot);
                            if (v >= 0.0f) {
                                sum = sum >= 0.0f ? (sum += v) : v;
                            }
                            if ((v = this.sourceData[j][i].getAbsMin(slot)) >= 0.0f) {
                                minSum = minSum >= 0.0f ? (minSum += v) : v;
                            }
                            if ((v = this.sourceData[j][i].getAbsMax(slot)) >= 0.0f) {
                                maxSum = maxSum >= 0.0f ? (maxSum += v) : v;
                            }
                        }
                        ++j;
                    }
                    if (sum >= 0.0f) {
                        this.dataSet[i].addBySlot(slot, sum, minSum, maxSum);
                    }
                    ++slot;
                }
                this.dataSet[i].endOfData();
            }
            ++i;
        }
    }

    public void computeData() {
        if (this.dataSet == null) {
            this.dataSet = new DataSet[this.sourceData[0].length];
            int i = 0;
            while (i < this.dataSet.length) {
                int j = 0;
                while (j < this.sourceData.length) {
                    if (this.sourceData[j][i] != null) break;
                    ++j;
                }
                this.dataSet[i] = j < this.sourceData.length ? new DataSet(this.sourceData[0][i].getName()) : null;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dataSet.length) {
                if (this.dataSet[i] != null) {
                    this.dataSet[i].reset();
                }
                ++i;
            }
        }
        if (this.smartComputing) {
            this.computeDataSmart();
        } else {
            this.computeDataExact();
        }
        this.computeMaxValue();
    }

    public void addPanel(DataSet[] ds, GenericPanel jp) {
        int i;
        if (this.sourceData == null) {
            this.sourceData = new DataSet[5][ds.length];
            int i2 = 0;
            while (i2 < ds.length) {
                this.sourceData[0][i2] = ds[i2];
                ++i2;
            }
            this.sourcePanel = new GenericPanel[5];
            this.sourcePanel[0] = jp;
            this.selected = new boolean[5];
            this.selected[0] = true;
            this.numData = 1;
            return;
        }
        if (ds.length != this.sourceData[0].length) {
            System.out.println("SumXYPanel: unexpected number of DataSet values");
            return;
        }
        if (this.numData == this.sourceData.length) {
            DataSet[][] oldSourceData = this.sourceData;
            GenericPanel[] oldSourcePanel = this.sourcePanel;
            boolean[] oldSelected = this.selected;
            this.sourceData = new DataSet[oldSourceData.length + 5][oldSourceData[0].length];
            this.sourcePanel = new GenericPanel[oldSourceData.length + 5];
            this.selected = new boolean[oldSourceData.length + 5];
            i = 0;
            while (i < oldSourceData.length) {
                int j = 0;
                while (j < oldSourceData[0].length) {
                    this.sourceData[i][j] = oldSourceData[i][j];
                    ++j;
                }
                this.sourcePanel[i] = oldSourcePanel[i];
                this.selected[i] = oldSelected[i];
                ++i;
            }
        }
        i = 0;
        while (i < ds.length) {
            this.sourceData[this.numData][i] = ds[i];
            ++i;
        }
        this.sourcePanel[this.numData] = jp;
        this.selected[this.numData] = true;
        ++this.numData;
    }

    private float linear(int x, int x1, int x2, float y1, float y2) {
        float f = 1.0f * (y2 - y1) / (float)(x2 - x1) * (float)x + (1.0f * (float)x2 * y1 - 1.0f * (float)x1 * y2) / (float)(x2 - x1);
        return f;
    }

    private float getvalidData(DataSet ds, int slot) {
        if (ds == null) {
            return -1.0f;
        }
        int lslot = ds.getNearestValidSlotLeft(slot);
        int rslot = ds.getNearestValidSlotRight(slot);
        if (lslot < 0 || rslot < 0 || lslot >= DataSet.SLOTS || rslot >= DataSet.SLOTS) {
            return -1.0f;
        }
        if (slot == lslot) {
            return ds.getValue(slot);
        }
        return this.linear(slot, lslot, rslot, ds.getValue(lslot), ds.getValue(rslot));
    }

    private float getValidData(DataSet ds, int slot, byte type) {
        float rvalue;
        float lvalue;
        if (ds == null) {
            return -1.0f;
        }
        int lslot = ds.getNearestValidSlotLeft(slot);
        int rslot = ds.getNearestValidSlotRight(slot);
        if (lslot < 0 || rslot < 0 || lslot >= DataSet.SLOTS || rslot >= DataSet.SLOTS) {
            return -1.0f;
        }
        if (slot == lslot) {
            switch (type) {
                case 1: {
                    return ds.getAbsMin(slot);
                }
                case 2: {
                    return ds.getAbsMax(slot);
                }
                case 0: {
                    return ds.getValue(slot);
                }
            }
            return -1.0f;
        }
        switch (type) {
            case 1: {
                lvalue = ds.getAbsMin(lslot);
                rvalue = ds.getAbsMin(rslot);
                break;
            }
            case 2: {
                lvalue = ds.getAbsMax(lslot);
                rvalue = ds.getAbsMax(rslot);
                break;
            }
            case 0: {
                lvalue = ds.getValue(lslot);
                rvalue = ds.getValue(lslot);
                break;
            }
            default: {
                return -1.0f;
            }
        }
        return this.linear(slot, lslot, rslot, lvalue, rvalue);
    }

    public void setSmartComputing(boolean smartComputing) {
        this.smartComputing = smartComputing;
    }
}

