/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import pGraph.DataSet;
import pGraph.GenericPanel;
import pGraph.GlobalConfig;
import pGraph.PerfData;

public class StackPanel
extends GenericPanel {
    private static final long serialVersionUID = -8927812739647083606L;
    private Color[] theColors = null;
    private boolean fixedMax = false;
    private DataSet maxData = null;
    private int selectedSet = -1;
    private int[] lastPolyX = new int[4 * DataSet.SLOTS];
    private float[] lastPolyY = new float[4 * DataSet.SLOTS];
    private int[] currPolyX = new int[4 * DataSet.SLOTS];
    private float[] currPolyY = new float[4 * DataSet.SLOTS];
    private int numCurrPoly;
    private int numLastUpper;
    private int numCurrUpper;
    private int[] polyX = new int[4 * (DataSet.SLOTS + 1)];
    private int[] polyY = new int[4 * (DataSet.SLOTS + 1)];

    public StackPanel(GlobalConfig config) {
        super(config);
    }

    public void setData(PerfData perfData, DataSet[] dataSet, String[] names) {
        this.perfData = perfData;
        this.completeDataSet = dataSet;
        this.completeNames = names;
        this.required_top = dataSet.length;
        this.dataSet = new DataSet[this.required_top];
        this.overrideNames = new String[this.required_top];
        this.extractTopByAvg();
        this.computeMaxValue();
        this.createColors();
    }

    public void setMaxData(DataSet ds) {
        this.maxData = ds;
        this.computeMaxValue();
    }

    public void setMaxData(float f) {
        if (f > 0.0f) {
            this.maxValue = f;
            this.fixedMax = true;
        }
    }

    protected void computeMaxValue() {
        if (this.fixedMax) {
            return;
        }
        if (this.maxData != null) {
            this.maxValue = this.maxData.getMax();
            return;
        }
        this.maxValue = 0.0f;
        int i = 0;
        while (i < DataSet.SLOTS) {
            float m = 0.0f;
            int j = 0;
            while (j < this.dataSet.length) {
                if (this.dataSet[j].getValue(i) > 0.0f) {
                    m += this.dataSet[j].getValue(i);
                } else {
                    int lslot = this.dataSet[j].getNearestValidSlotLeft(i);
                    int rslot = this.dataSet[j].getNearestValidSlotRight(i);
                    if (lslot >= 0 && rslot >= 0 && lslot < DataSet.SLOTS && rslot < DataSet.SLOTS) {
                        m += this.linear(i, lslot, rslot, this.dataSet[j].getValue(lslot), this.dataSet[j].getValue(rslot));
                    }
                }
                ++j;
            }
            if (m > this.maxValue) {
                this.maxValue = m;
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        int i;
        super.paintComponent(g);
        int ysize = this.getHeight() - this.TEXT_SPACE;
        if (this.maxData != null) {
            g.setColor(this.configuration.getGraphBackColor());
            g.fillRect(0, 0, DataSet.SLOTS - 1, ysize - 1);
            this.numCurrPoly = 0;
            this.polyX[this.numCurrPoly] = 0;
            this.polyY[this.numCurrPoly] = ysize - 1;
            ++this.numCurrPoly;
            i = 0;
            while (i < DataSet.SLOTS) {
                if (!(this.maxData.getValue(i) < 0.0f)) {
                    this.polyX[this.numCurrPoly] = i;
                    this.polyY[this.numCurrPoly] = ysize - 1 - (int)(this.maxData.getValue(i) / this.maxValue * (float)(ysize - 1));
                    ++this.numCurrPoly;
                }
                ++i;
            }
            this.polyX[this.numCurrPoly] = DataSet.SLOTS - 1;
            this.polyY[this.numCurrPoly] = ysize - 1;
            ++this.numCurrPoly;
            g.setColor(Color.green);
            g.drawPolygon(this.polyX, this.polyY, this.numCurrPoly);
            g.fillPolygon(this.polyX, this.polyY, this.numCurrPoly);
        } else {
            g.setColor(Color.green);
            g.fillRect(0, 0, DataSet.SLOTS - 1, ysize - 1);
        }
        this.getPointedSet(this.pointedX, this.pointedY);
        this.lastPolyX[0] = 0;
        this.lastPolyY[0] = ysize - 1;
        this.lastPolyX[1] = DataSet.SLOTS - 1;
        this.lastPolyY[1] = ysize - 1;
        this.numLastUpper = 2;
        i = 0;
        while (i < this.dataSet.length) {
            this.numCurrPoly = 0;
            this.numCurrUpper = 0;
            int lastPolyUsed = 0;
            int min = this.dataSet[i].getNearestValidSlotRight(0);
            if (min >= 0 && min != DataSet.SLOTS) {
                int max;
                int rslot;
                int lslot;
                int j;
                if (min > 0) {
                    j = 0;
                    while (this.lastPolyX[j] <= min) {
                        this.currPolyX[this.numCurrPoly] = this.lastPolyX[j];
                        this.currPolyY[this.numCurrPoly] = this.lastPolyY[j];
                        ++this.numCurrPoly;
                        lastPolyUsed = j++;
                    }
                    if (this.lastPolyX[lastPolyUsed] != min) {
                        lslot = this.lastPolyX[lastPolyUsed];
                        rslot = this.lastPolyX[lastPolyUsed + 1];
                        this.currPolyX[this.numCurrPoly] = min;
                        this.currPolyY[this.numCurrPoly] = this.linear(min, lslot, rslot, this.lastPolyY[lastPolyUsed], this.lastPolyY[lastPolyUsed + 1]);
                        ++this.numCurrPoly;
                    }
                }
                if ((max = this.dataSet[i].getNearestValidSlotLeft(DataSet.SLOTS - 1)) >= 0 && max != DataSet.SLOTS) {
                    j = min;
                    while (j <= max) {
                        int k;
                        float v = this.dataSet[i].getValue(j);
                        if (v < 0.0f) {
                            k = lastPolyUsed;
                            while (this.lastPolyX[k] < j) {
                                ++k;
                            }
                            if (this.lastPolyX[k] == j) {
                                lastPolyUsed = k;
                                lslot = this.dataSet[i].getNearestValidSlotLeft(j);
                                rslot = this.dataSet[i].getNearestValidSlotRight(j);
                                this.currPolyX[this.numCurrPoly] = j;
                                this.currPolyY[this.numCurrPoly] = this.lastPolyY[k] - 1.0f * this.linear(j, lslot, rslot, this.dataSet[i].getValue(lslot), this.dataSet[i].getValue(rslot)) / this.maxValue * (float)(ysize - 1);
                                ++this.numCurrPoly;
                            }
                        } else {
                            k = lastPolyUsed;
                            while (k + 1 < this.numLastUpper && this.lastPolyX[k + 1] <= j) {
                                ++k;
                            }
                            lastPolyUsed = k;
                            this.currPolyX[this.numCurrPoly] = j;
                            if (this.lastPolyX[k] == j) {
                                this.currPolyY[this.numCurrPoly] = this.lastPolyY[k] - 1.0f * v / this.maxValue * (float)(ysize - 1);
                            } else {
                                lslot = this.lastPolyX[k];
                                rslot = this.lastPolyX[k + 1];
                                this.currPolyY[this.numCurrPoly] = this.linear(j, lslot, rslot, this.lastPolyY[k], this.lastPolyY[k + 1]) - 1.0f * v / this.maxValue * (float)(ysize - 1);
                            }
                            ++this.numCurrPoly;
                        }
                        ++j;
                    }
                    if (max < DataSet.SLOTS - 1) {
                        if (this.lastPolyX[lastPolyUsed] == max) {
                            this.currPolyX[this.numCurrPoly] = max;
                            this.currPolyY[this.numCurrPoly] = this.lastPolyY[lastPolyUsed];
                            ++this.numCurrPoly;
                        } else {
                            this.currPolyX[this.numCurrPoly] = max;
                            lslot = this.lastPolyX[lastPolyUsed];
                            rslot = this.lastPolyX[lastPolyUsed + 1];
                            this.currPolyY[this.numCurrPoly] = this.linear(max, lslot, rslot, this.lastPolyY[lastPolyUsed], this.lastPolyY[lastPolyUsed + 1]);
                            ++this.numCurrPoly;
                        }
                        j = lastPolyUsed + 1;
                        while (j < this.numLastUpper) {
                            this.currPolyX[this.numCurrPoly] = this.lastPolyX[j];
                            this.currPolyY[this.numCurrPoly] = this.lastPolyY[j];
                            ++this.numCurrPoly;
                            ++j;
                        }
                    }
                    this.numCurrUpper = this.numCurrPoly;
                    j = this.numLastUpper - 1;
                    while (j >= 0) {
                        this.currPolyX[this.numCurrPoly] = this.lastPolyX[j];
                        this.currPolyY[this.numCurrPoly] = this.lastPolyY[j];
                        ++this.numCurrPoly;
                        --j;
                    }
                    j = 0;
                    while (j < this.numCurrPoly) {
                        this.polyX[j] = this.currPolyX[j];
                        this.polyY[j] = (int)this.currPolyY[j];
                        ++j;
                    }
                    this.polyX[this.numCurrPoly] = 0;
                    this.polyY[this.numCurrPoly] = ysize - 1;
                    if (i == this.selectedSet) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(this.getColor(i));
                    }
                    g.drawPolygon(this.polyX, this.polyY, this.numCurrPoly);
                    g.fillPolygon(this.polyX, this.polyY, this.numCurrPoly);
                    int[] ia = this.currPolyX;
                    this.currPolyX = this.lastPolyX;
                    this.lastPolyX = ia;
                    float[] fa = this.currPolyY;
                    this.currPolyY = this.lastPolyY;
                    this.lastPolyY = fa;
                    this.numLastUpper = this.numCurrUpper;
                }
            }
            ++i;
        }
        this.drawZoomBars(g);
        this.drawGrid(g);
        this.drawLimits(g);
    }

    protected void drawLimits(Graphics g) {
        g.setColor(Color.lightGray);
        g.fillRect(DataSet.SLOTS, 0, this.getWidth(), this.getHeight() - this.TEXT_SPACE);
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.configuration.getPanelDataFont());
        int limitsFontSize = this.configuration.getPanelDataFont().getSize();
        g2.setColor(Color.BLACK);
        g2.drawString("From:", DataSet.SLOTS + 3, limitsFontSize + 5);
        g2.drawString(this.gcToString(this.perfData.getStart(), true), DataSet.SLOTS + 50, limitsFontSize + 5);
        g2.drawString("To:", DataSet.SLOTS + 3, (limitsFontSize + 5) * 2);
        g2.drawString(this.gcToString(this.perfData.getEnd(), true), DataSet.SLOTS + 50, (limitsFontSize + 5) * 2);
        g2.setColor(Color.WHITE);
        g2.drawString("Limits: [ Min - Avg - Max ]", DataSet.SLOTS + 3, (limitsFontSize + 5) * 3);
        if (this.selectedSet >= 0) {
            g2.setColor(Color.red);
            g2.drawString("Selected: " + this.limitString(this.selectedSet), DataSet.SLOTS + 3, (limitsFontSize + 5) * 4);
        }
        int lineY = (limitsFontSize + 5) * 5;
        int i = 0;
        while (i < this.dataSet.length && lineY < this.getHeight() - this.TEXT_SPACE - (limitsFontSize + 5)) {
            g2.setColor(this.getColor(i));
            g2.drawString(this.limitString(i), DataSet.SLOTS + 3, lineY);
            lineY += limitsFontSize + 5;
            ++i;
        }
        if (lineY >= this.getHeight() - this.TEXT_SPACE - (limitsFontSize + 5) && i < this.dataSet.length) {
            g2.setColor(Color.WHITE);
            g2.drawString("... others not shown ...", DataSet.SLOTS + 3, lineY);
        }
    }

    private void getPointedSet(int x, int y) {
        if (x < 0 || x >= DataSet.SLOTS || y < 0 || y > this.getHeight() - this.TEXT_SPACE) {
            this.selectedSet = -1;
            return;
        }
        float value = this.maxValue - (float)y * this.maxValue / (float)(this.getHeight() - this.TEXT_SPACE);
        float f = 0.0f;
        int j = 0;
        while (j < this.dataSet.length) {
            block8: {
                block7: {
                    block6: {
                        if (!(this.dataSet[j].getValue(x) > 0.0f)) break block6;
                        f += this.dataSet[j].getValue(x);
                        break block7;
                    }
                    int lslot = this.dataSet[j].getNearestValidSlotLeft(x);
                    int rslot = this.dataSet[j].getNearestValidSlotRight(x);
                    if (lslot < 0 || rslot < 0 || lslot >= DataSet.SLOTS || rslot >= DataSet.SLOTS) break block8;
                    f += this.linear(x, lslot, rslot, this.dataSet[j].getValue(lslot), this.dataSet[j].getValue(rslot));
                }
                if (value < f) {
                    this.selectedSet = j;
                    return;
                }
            }
            ++j;
        }
        this.selectedSet = -1;
    }

    protected String getPointedData(int time) {
        if (time < 0 || time >= DataSet.SLOTS) {
            return " ";
        }
        String s = "[" + this.gcToString(this.slotToGc(time), true) + "]";
        s = this.selectedSet >= 0 ? String.valueOf(s) + " " + this.overrideNames[this.selectedSet] + "=" + this.dataSet[this.selectedSet].getValue(time) : String.valueOf(s) + " no selection";
        return s;
    }

    private Color getColor(int n) {
        return this.theColors[n];
    }

    private float linear(int x, int x1, int x2, float y1, float y2) {
        float f = 1.0f * (y2 - y1) / (float)(x2 - x1) * (float)x + (1.0f * (float)x2 * y1 - 1.0f * (float)x1 * y2) / (float)(x2 - x1);
        return f;
    }

    protected String limitString(int n) {
        String result = String.valueOf(this.overrideNames[n]) + ": [ ";
        float v = this.dataSet[n].getMin();
        result = v < 0.0f ? String.valueOf(result) + "N/A" : String.valueOf(result) + Float.toString(v);
        result = String.valueOf(result) + " - ";
        v = this.dataSet[n].getAvg();
        result = v < 0.0f ? String.valueOf(result) + "N/A" : String.valueOf(result) + Float.toString(v);
        result = String.valueOf(result) + " - ";
        v = this.dataSet[n].getMax();
        result = v < 0.0f ? String.valueOf(result) + "N/A" : String.valueOf(result) + Float.toString(v);
        result = String.valueOf(result) + " ]";
        return result;
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.getPointedSet(this.pointedX, this.pointedY);
        this.firePropertyChange("focus", null, this.getPointedData(this.validPointedSlot));
    }

    private void createColors() {
        this.theColors = new Color[this.dataSet.length];
        int i = 0;
        while (i < this.dataSet.length) {
            this.theColors[i] = new Color(0.0f, 0.0f, 1.0f * (float)(i + 1) / (float)this.dataSet.length);
            ++i;
        }
    }
}

