/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.util.GregorianCalendar;
import java.util.Vector;
import pGraph.DataSet;
import pGraph.Parser;
import pGraph.ParserManager;
import pGraph.PerfData;

public class Parser_Topas
extends Parser {
    private long delta = 0L;
    private byte type = UNKNOWN;
    private static byte UNKNOWN = 0;
    public static byte XMTREND = 1;
    public static byte TOPASCEC = (byte)2;
    private Parser[] parser = null;
    private int lpar_id = -1;
    private GregorianCalendar lpar_gc = null;
    private float lpar_lp = -1.0f;
    private float lpar_smt = -1.0f;
    private float lpar_shared = -1.0f;
    private GregorianCalendar cec_gc = null;
    private float cec_poolsize = -1.0f;
    private float cec_dedicated = -1.0f;

    public Parser_Topas(ParserManager v) {
        this.manager = v;
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.start != null && this.end != null && this.type != UNKNOWN) {
            this.valid = true;
        }
    }

    private void parseTimeLimits() throws Exception {
        String line;
        GregorianCalendar curr = null;
        String time = null;
        this.valid = false;
        BufferedReader br = this.getReader();
        while ((line = br.readLine()) != null) {
            ++this.total_lines;
            if (!line.startsWith("Time")) {
                if (line.indexOf("xmtrend recording") >= 0) {
                    this.type = XMTREND;
                    continue;
                }
                if (line.indexOf("topas_cec recording") < 0) continue;
                this.type = TOPASCEC;
                continue;
            }
            if (line.length() < 26) continue;
            String s = line.substring(6, 25);
            if (time == null || !time.equals(s)) {
                try {
                    curr = new GregorianCalendar(Integer.parseInt(line.substring(6, 10)), Integer.parseInt(line.substring(11, 13)) - 1, Integer.parseInt(line.substring(14, 16)), Integer.parseInt(line.substring(17, 19)), Integer.parseInt(line.substring(20, 22)), Integer.parseInt(line.substring(23, 25)));
                }
                catch (Exception e) {
                    continue;
                }
                time = s;
            }
            if (this.start == null) {
                this.start = curr;
            }
            if (this.end != null && !this.end.before(curr)) continue;
            this.end = curr;
        }
        if (this.type == UNKNOWN) {
            this.start = null;
            this.end = null;
        }
        br.close();
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block2: {
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of topasout data at line " + this.current_file_line_read);
                if (!lastParse) break block2;
                this.endOfData();
            }
        }
    }

    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        int i;
        String line = null;
        String time = null;
        GregorianCalendar gc = null;
        if (this.type == TOPASCEC && !firstParse && !firstParse) {
            System.out.println(String.valueOf(this.fileName) + " Error, topascec data in multiple file load.");
            return;
        }
        this.resetTopascecData();
        if (firstParse) {
            this.lines_read = 0;
            this.perfData.setLimits(this.start, this.end);
            if (this.parser != null) {
                i = 0;
                while (i < this.parser.length) {
                    this.parser[i].getPerfData().setLimits(this.start, this.end);
                    ++i;
                }
            }
        }
        this.current_file_line_read = 0;
        BufferedReader br = this.getReader();
        try {
            while ((line = this.readLineAndShowProgress(br)) != null) {
                Vector v;
                if (!line.startsWith("Time") || line.length() < 26) continue;
                String s = line.substring(6, 25);
                if (time == null || !time.equals(s)) {
                    try {
                        gc = new GregorianCalendar(Integer.parseInt(line.substring(6, 10)), Integer.parseInt(line.substring(11, 13)) - 1, Integer.parseInt(line.substring(14, 16)), Integer.parseInt(line.substring(17, 19)), Integer.parseInt(line.substring(20, 22)), Integer.parseInt(line.substring(23, 25)));
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (time != null) {
                        GregorianCalendar pre = new GregorianCalendar(Integer.parseInt(time.substring(0, 4)), Integer.parseInt(time.substring(5, 7)) - 1, Integer.parseInt(time.substring(8, 10)), Integer.parseInt(time.substring(11, 13)), Integer.parseInt(time.substring(14, 16)), Integer.parseInt(time.substring(17)));
                        this.delta = (gc.getTimeInMillis() - pre.getTimeInMillis()) / 1000L;
                    }
                    time = s;
                }
                if ((v = this.splitLine(line.substring(28))) == null || v.size() < 2) continue;
                if (((String)v.elementAt(0)).equals("CPU")) {
                    this.handle_CPU(gc, v);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("LPAR")) {
                    this.handle_LPAR(gc, v);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("Mem")) {
                    this.handle_Mem(gc, v);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("Disk")) {
                    this.handle_Disk(gc, v);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("IP") && ((String)v.elementAt(1)).equals("NetIF")) {
                    this.handle_NetIF(gc, v);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("Proc")) {
                    this.handle_Proc(gc, v);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("Syscall")) {
                    this.handle_Syscall(gc, v);
                    continue;
                }
                if (!this.multipleLPAR && (((String)v.elementAt(0)).equals("CEC") || ((String)v.elementAt(1)).equals("CEC"))) {
                    this.handle_CEC(gc, v);
                    continue;
                }
                if (((String)v.elementAt(1)).equals("LPAR")) {
                    this.handle_host_LPAR(gc, v);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("WLM")) {
                    this.handle_WLM(gc, v);
                    continue;
                }
                if (this.multipleLPAR || v.size() != 5 || !((String)v.elementAt(0)).equals("FS")) continue;
                this.handle_FS(gc, v);
            }
        }
        catch (Exception e) {
            System.out.println("Error reading line: " + line);
            throw e;
        }
        if (this.type == TOPASCEC) {
            this.store_lpar_data();
            this.store_cec_data();
        }
        br.close();
        i = 0;
        while (this.parser != null && i < this.parser.length) {
            this.parser[i].endOfData();
            ++i;
        }
        if (lastParse) {
            this.perfData.endOfData();
        }
        DataSet pool = this.perfData.getData((byte)0, 0, (byte)3);
        DataSet tot_cpu = this.perfData.getData((byte)0, 0, (byte)35);
        DataSet freepool = this.perfData.getData((byte)0, 0, (byte)4);
        if (pool.getMin() == 0.0f && pool.getMax() == 0.0f && tot_cpu.getMin() == 0.0f && tot_cpu.getMax() == 0.0f) {
            this.perfData.removeData((byte)0, 0, (byte)3);
            this.perfData.removeData((byte)0, 0, (byte)35);
        }
        if (freepool.getMin() == 0.0f && freepool.getMax() == 0.0f) {
            this.perfData.removeData((byte)0, 0, (byte)4);
        }
    }

    private void handle_CEC(GregorianCalendar gc, Vector v) {
        float value;
        String type;
        String group;
        if (((String)v.elementAt(0)).equals("CEC")) {
            if (v.size() != 4) {
                return;
            }
            group = (String)v.elementAt(1);
            type = (String)v.elementAt(2);
            value = ((Float)v.elementAt(3)).floatValue();
        } else {
            if (v.size() != 5) {
                return;
            }
            group = (String)v.elementAt(2);
            type = (String)v.elementAt(3);
            value = ((Float)v.elementAt(4)).floatValue();
        }
        if (this.cec_gc != null && gc.getTimeInMillis() != this.cec_gc.getTimeInMillis()) {
            this.store_cec_data();
            this.cec_gc = null;
        }
        this.cec_gc = gc;
        int slot = this.getSlot(gc);
        if (group.equals("Lpars")) {
            if (type.equals("shared")) {
                this.perfData.add(slot, (byte)38, value);
                return;
            }
            if (type.equals("dedicated")) {
                this.perfData.add(slot, (byte)37, value);
                return;
            }
        }
        if (group.equals("CPU")) {
            if (type.equals("app")) {
                this.perfData.add(slot, (byte)4, value);
                return;
            }
            if (type.equals("poolsize")) {
                this.cec_poolsize = value;
                return;
            }
            if (type.equals("dedicated")) {
                this.cec_dedicated = value;
                return;
            }
            if (type.equals("shr_physb")) {
                this.perfData.add(slot, (byte)0, value);
                return;
            }
        }
    }

    private void handle_host_LPAR(GregorianCalendar gc, Vector v) {
        if (v.size() < 5) {
            return;
        }
        if (!((String)v.elementAt(2)).equals("CPU") && !((String)v.elementAt(2)).equals("Sys")) {
            return;
        }
        int index = this.getLPARIndex((String)v.elementAt(0));
        if (index != this.lpar_id) {
            this.store_lpar_data();
            this.lpar_id = index;
            this.lpar_gc = gc;
        }
        boolean unknownLPAR = false;
        if (((String)v.elementAt(0)).equals("")) {
            unknownLPAR = true;
        }
        int slot = this.getSlot(gc);
        PerfData pd = this.parser[index].getPerfData();
        if (((String)v.elementAt(3)).equals("lcpu")) {
            this.lpar_lp = ((Float)v.elementAt(4)).floatValue();
            pd.add(slot, (byte)2, this.lpar_lp);
            return;
        }
        if (!unknownLPAR && ((String)v.elementAt(3)).equals("user")) {
            pd.add(slot, (byte)1, (byte)0, AVG_CPU, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (!unknownLPAR && ((String)v.elementAt(3)).equals("kern")) {
            pd.add(slot, (byte)1, (byte)1, AVG_CPU, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (!unknownLPAR && ((String)v.elementAt(3)).equals("wait")) {
            pd.add(slot, (byte)1, (byte)2, AVG_CPU, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (!unknownLPAR && ((String)v.elementAt(3)).equals("idle")) {
            pd.add(slot, (byte)1, (byte)3, AVG_CPU, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (((String)v.elementAt(3)).equals("physc")) {
            pd.add(slot, (byte)0, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (((String)v.elementAt(3)).equals("entc")) {
            pd.add(slot, (byte)5, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (((String)v.elementAt(3)).equals("ent")) {
            pd.add(slot, (byte)6, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (((String)v.elementAt(3)).equals("shared")) {
            this.lpar_shared = ((Float)v.elementAt(4)).floatValue();
            return;
        }
        if (((String)v.elementAt(3)).equals("smt")) {
            this.lpar_smt = ((Float)v.elementAt(4)).floatValue();
            return;
        }
    }

    private void handle_WLM(GregorianCalendar gc, Vector v) {
        int slot = this.getSlot(gc);
        if (v.size() != 5) {
            return;
        }
        if (((String)v.elementAt(2)).equals("CPU")) {
            this.perfData.add(slot, (byte)6, (byte)0, (String)v.elementAt(1), ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (((String)v.elementAt(2)).equals("MEM")) {
            this.perfData.add(slot, (byte)6, (byte)1, (String)v.elementAt(1), ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (((String)v.elementAt(2)).equals("DISK")) {
            this.perfData.add(slot, (byte)6, (byte)2, (String)v.elementAt(1), ((Float)v.elementAt(4)).floatValue());
            return;
        }
    }

    private void handle_CPU(GregorianCalendar gc, Vector v) {
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(1)).equals("gluser")) {
            this.perfData.add(slot, (byte)1, (byte)0, AVG_CPU, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (((String)v.elementAt(1)).equals("glkern")) {
            this.perfData.add(slot, (byte)1, (byte)1, AVG_CPU, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (((String)v.elementAt(1)).equals("glwait")) {
            this.perfData.add(slot, (byte)1, (byte)2, AVG_CPU, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (((String)v.elementAt(1)).equals("glidle")) {
            this.perfData.add(slot, (byte)1, (byte)3, AVG_CPU, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (((String)v.elementAt(1)).startsWith("cpu")) {
            int num = Integer.parseInt(((String)v.elementAt(1)).substring(3)) + 1;
            if (((String)v.elementAt(2)).equals("user")) {
                this.perfData.add(slot, (byte)1, (byte)0, "CPU" + num, ((Float)v.elementAt(3)).floatValue());
                return;
            }
            if (((String)v.elementAt(2)).equals("kern")) {
                this.perfData.add(slot, (byte)1, (byte)1, "CPU" + num, ((Float)v.elementAt(3)).floatValue());
                return;
            }
            if (((String)v.elementAt(2)).equals("wait")) {
                this.perfData.add(slot, (byte)1, (byte)2, "CPU" + num, ((Float)v.elementAt(3)).floatValue());
                return;
            }
            if (((String)v.elementAt(2)).equals("idle")) {
                this.perfData.add(slot, (byte)1, (byte)3, "CPU" + num, ((Float)v.elementAt(3)).floatValue());
                return;
            }
            return;
        }
    }

    private void handle_LPAR(GregorianCalendar gc, Vector v) {
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(1)).equals("pcpuinpool")) {
            this.perfData.add(slot, (byte)3, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (((String)v.elementAt(1)).equals("vcpu")) {
            if (this.lpar_shared < 0.0f) {
                return;
            }
            if (this.lpar_shared > 0.0f) {
                this.perfData.add(slot, (byte)1, ((Float)v.elementAt(2)).floatValue());
            } else {
                this.perfData.add(slot, (byte)35, ((Float)v.elementAt(2)).floatValue());
            }
            return;
        }
        if (((String)v.elementAt(1)).equals("lcpu")) {
            this.perfData.add(slot, (byte)2, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (((String)v.elementAt(1)).equals("app")) {
            this.perfData.add(slot, (byte)4, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (this.lpar_shared > 0.0f && ((String)v.elementAt(1)).equals("ent")) {
            this.perfData.add(slot, (byte)5, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (this.lpar_shared > 0.0f && ((String)v.elementAt(1)).equals("physc")) {
            this.perfData.add(slot, (byte)0, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (this.lpar_shared > 0.0f && ((String)v.elementAt(1)).equals("entc")) {
            this.perfData.add(slot, (byte)6, ((Float)v.elementAt(2)).floatValue());
            return;
        }
        if (((String)v.elementAt(1)).equals("shared")) {
            this.lpar_shared = ((Float)v.elementAt(2)).floatValue();
            return;
        }
    }

    private void handle_Disk(GregorianCalendar gc, Vector v) {
        String name = (String)v.elementAt(1);
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(2)).equals("busy")) {
            if (name.startsWith("hdiskpower")) {
                return;
            }
            if (name.startsWith("dac")) {
                return;
            }
            this.perfData.add(slot, (byte)2, (byte)0, name, ((Float)v.elementAt(3)).floatValue());
            return;
        }
        if (((String)v.elementAt(2)).equals("xfer")) {
            if (name.startsWith("hdiskpower")) {
                this.perfData.add(slot, (byte)3, (byte)2, name, ((Float)v.elementAt(3)).floatValue());
            } else if (name.startsWith("dac")) {
                this.perfData.add(slot, (byte)11, (byte)3, name, ((Float)v.elementAt(3)).floatValue());
            } else {
                this.perfData.add(slot, (byte)2, (byte)3, name, ((Float)v.elementAt(3)).floatValue());
            }
            return;
        }
        if (((String)v.elementAt(2)).equals("rblk") && this.delta != 0L) {
            if (name.startsWith("hdiskpower")) {
                this.perfData.add(slot, (byte)3, (byte)0, name, ((Float)v.elementAt(3)).floatValue() / (float)this.delta);
            } else if (name.startsWith("dac")) {
                this.perfData.add(slot, (byte)11, (byte)1, name, ((Float)v.elementAt(3)).floatValue() / (float)this.delta);
            } else {
                this.perfData.add(slot, (byte)2, (byte)1, name, ((Float)v.elementAt(3)).floatValue() / (float)this.delta);
            }
            return;
        }
        if (((String)v.elementAt(2)).equals("wblk") && this.delta != 0L) {
            if (name.startsWith("hdiskpower")) {
                this.perfData.add(slot, (byte)3, (byte)1, name, ((Float)v.elementAt(3)).floatValue() / (float)this.delta);
            } else if (name.startsWith("dac")) {
                this.perfData.add(slot, (byte)11, (byte)2, name, ((Float)v.elementAt(3)).floatValue() / (float)this.delta);
            } else {
                this.perfData.add(slot, (byte)2, (byte)2, name, ((Float)v.elementAt(3)).floatValue() / (float)this.delta);
            }
            return;
        }
        if (((String)v.elementAt(2)).equals("avgserv")) {
            if (name.startsWith("hdiskpower")) {
                this.perfData.add(slot, (byte)3, (byte)4, name, ((Float)v.elementAt(3)).floatValue());
            } else if (name.startsWith("dac")) {
                this.perfData.add(slot, (byte)11, (byte)23, name, ((Float)v.elementAt(3)).floatValue());
            } else {
                this.perfData.add(slot, (byte)2, (byte)23, name, ((Float)v.elementAt(3)).floatValue());
            }
            return;
        }
        if (((String)v.elementAt(2)).equals("avgwait")) {
            if (name.startsWith("hdiskpower")) {
                this.perfData.add(slot, (byte)3, (byte)5, name, ((Float)v.elementAt(3)).floatValue());
            } else if (name.startsWith("dac")) {
                this.perfData.add(slot, (byte)11, (byte)24, name, ((Float)v.elementAt(3)).floatValue());
            } else {
                this.perfData.add(slot, (byte)2, (byte)24, name, ((Float)v.elementAt(3)).floatValue());
            }
            return;
        }
    }

    private void handle_FS(GregorianCalendar gc, Vector v) {
        String name = String.valueOf((String)v.elementAt(1)) + ":" + (String)v.elementAt(2);
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(3)).equals("%totused")) {
            this.perfData.add(slot, (byte)9, (byte)0, name, ((Float)v.elementAt(4)).floatValue());
            return;
        }
        if (((String)v.elementAt(3)).equals("%nodesused")) {
            this.perfData.add(slot, (byte)9, (byte)1, name, ((Float)v.elementAt(4)).floatValue());
            return;
        }
    }

    private void handle_NetIF(GregorianCalendar gc, Vector v) {
        String name = (String)v.elementAt(2);
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(3)).equals("ioctet_kb") && this.delta != 0L) {
            this.perfData.add(slot, (byte)5, (byte)0, name, ((Float)v.elementAt(4)).floatValue() / (float)this.delta);
            return;
        }
        if (((String)v.elementAt(3)).equals("ooctet_kb") && this.delta != 0L) {
            this.perfData.add(slot, (byte)5, (byte)1, name, ((Float)v.elementAt(4)).floatValue() / (float)this.delta);
            return;
        }
    }

    private int getLPARIndex(String name) {
        if (name.equals("")) {
            name = "<Unknown>";
        }
        if (this.parser == null) {
            this.parser = new Parser[1];
            this.parser[0] = new Parser_Topas(this.manager);
            this.parser[0].setFileName(name);
            this.parser[0].setApplet(this.applet);
            this.parser[0].setStart(this.start);
            this.parser[0].setEnd(this.end);
            this.parser[0].getPerfData().setLimits(this.start, this.end);
            return 0;
        }
        int i = 0;
        while (i < this.parser.length) {
            if (this.parser[i].getFileName().equals(name)) {
                return i;
            }
            ++i;
        }
        Parser[] old = this.parser;
        this.parser = new Parser_Topas[old.length + 1];
        int i2 = 0;
        while (i2 < old.length) {
            this.parser[i2] = old[i2];
            ++i2;
        }
        this.parser[old.length] = new Parser_Topas(this.manager);
        this.parser[old.length].setFileName(name);
        this.parser[old.length].setApplet(this.applet);
        this.parser[old.length].setStart(this.start);
        this.parser[old.length].setEnd(this.end);
        this.parser[old.length].getPerfData().setLimits(this.start, this.end);
        return old.length;
    }

    private void handle_Mem(GregorianCalendar gc, Vector v) {
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(1)).equals("Real")) {
            if (((String)v.elementAt(2)).equals("numfrb")) {
                this.perfData.add(slot, (byte)8, ((Float)v.elementAt(3)).floatValue() * 4.0f / 1024.0f);
                this.perfData.add(slot, (byte)22, ((Float)v.elementAt(3)).floatValue());
                return;
            }
            if (((String)v.elementAt(2)).equals("size")) {
                this.perfData.add(slot, (byte)16, ((Float)v.elementAt(3)).floatValue() * 4.0f / 1024.0f);
                return;
            }
            if (((String)v.elementAt(2)).equals("%noncomp")) {
                this.perfData.add(slot, (byte)17, ((Float)v.elementAt(3)).floatValue());
                return;
            }
        }
        if (((String)v.elementAt(1)).equals("Virt")) {
            if (((String)v.elementAt(2)).equals("pgspgin")) {
                this.perfData.add(slot, (byte)9, ((Float)v.elementAt(3)).floatValue());
                return;
            }
            if (((String)v.elementAt(2)).equals("pgspgout")) {
                this.perfData.add(slot, (byte)10, ((Float)v.elementAt(3)).floatValue());
                return;
            }
            if (((String)v.elementAt(2)).equals("steal")) {
                this.perfData.add(slot, (byte)13, ((Float)v.elementAt(3)).floatValue());
                return;
            }
        }
    }

    private void handle_Proc(GregorianCalendar gc, Vector v) {
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(1)).equals("runque")) {
            this.perfData.add(slot, (byte)26, ((Float)v.elementAt(2)).floatValue());
        }
        if (((String)v.elementAt(1)).equals("swpque")) {
            this.perfData.add(slot, (byte)27, ((Float)v.elementAt(2)).floatValue());
        }
        if (((String)v.elementAt(1)).equals("pswitch")) {
            this.perfData.add(slot, (byte)29, ((Float)v.elementAt(2)).floatValue());
        }
    }

    private void handle_Syscall(GregorianCalendar gc, Vector v) {
        int slot = this.getSlot(gc);
        if (((String)v.elementAt(1)).equals("total")) {
            this.perfData.add(slot, (byte)30, ((Float)v.elementAt(2)).floatValue());
        }
        if (((String)v.elementAt(1)).equals("fork")) {
            this.perfData.add(slot, (byte)31, ((Float)v.elementAt(2)).floatValue());
        }
        if (((String)v.elementAt(1)).equals("exec")) {
            this.perfData.add(slot, (byte)32, ((Float)v.elementAt(2)).floatValue());
        }
        if (((String)v.elementAt(1)).equals("read")) {
            this.perfData.add(slot, (byte)33, ((Float)v.elementAt(2)).floatValue());
        }
        if (((String)v.elementAt(1)).equals("write")) {
            this.perfData.add(slot, (byte)34, ((Float)v.elementAt(2)).floatValue());
        }
    }

    private Vector splitLine(String s) {
        int end;
        Vector<Object> result = new Vector<Object>();
        int begin = 0;
        while ((end = s.indexOf(47, begin)) >= 0) {
            result.add(s.substring(begin, end));
            begin = end + 1;
        }
        end = s.indexOf(61, begin);
        if (end < 0 || end == begin) {
            return null;
        }
        result.add(s.substring(begin, end));
        result.add(new Float(s.substring(end + 1)));
        return result;
    }

    public byte getType() {
        return this.type;
    }

    public Parser getParser(int num) {
        return this.parser[num];
    }

    public String[] getParserNames() {
        if (this.parser == null) {
            return null;
        }
        String[] result = new String[this.parser.length];
        int i = 0;
        while (i < this.parser.length) {
            result[i] = this.parser[i].getFileName();
            ++i;
        }
        return result;
    }

    private void store_lpar_data() {
        if (this.lpar_id < 0) {
            return;
        }
        int slot = this.getSlot(this.lpar_gc);
        PerfData pd = this.parser[this.lpar_id].getPerfData();
        if (this.lpar_shared != 0.0f) {
            if (this.lpar_smt != 0.0f) {
                pd.add(slot, (byte)1, this.lpar_lp / 2.0f);
            } else {
                pd.add(slot, (byte)1, this.lpar_lp);
            }
        } else if (this.lpar_smt != 0.0f) {
            pd.add(slot, (byte)0, this.lpar_lp / 2.0f);
        } else {
            pd.add(slot, (byte)0, this.lpar_lp);
        }
    }

    private void store_cec_data() {
        if (this.cec_gc == null) {
            return;
        }
        int slot = this.getSlot(this.cec_gc);
        this.perfData.add(slot, (byte)3, this.cec_poolsize);
        this.perfData.add(slot, (byte)35, this.cec_dedicated + this.cec_poolsize);
    }

    private void resetTopascecData() {
        this.lpar_id = -1;
        this.lpar_gc = null;
        this.lpar_lp = -1.0f;
        this.lpar_smt = -1.0f;
        this.lpar_shared = -1.0f;
        this.cec_gc = null;
        this.cec_poolsize = -1.0f;
        this.cec_dedicated = -1.0f;
    }
}

