/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.util.GregorianCalendar;
import pGraph.Parser;
import pGraph.ParserManager;
import pGraph.Parser_Topas;
import pGraph.PerfData;

public class Parser_Snmp
extends Parser {
    private Parser[] parser = null;
    private float[] cores = null;

    public Parser_Snmp(ParserManager v) {
        this.manager = v;
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block2: {
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of snmp data at line " + this.current_file_line_read);
                if (!lastParse) break block2;
                this.endOfData();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        int i;
        String line = null;
        String time = null;
        String date = null;
        GregorianCalendar gc = null;
        if (firstParse) {
            this.lines_read = 0;
            this.perfData.setLimits(this.start, this.end);
            if (this.parser != null) {
                i = 0;
                while (i < this.parser.length) {
                    this.parser[i].getPerfData().setLimits(this.start, this.end);
                    ++i;
                }
            }
        }
        this.current_file_line_read = 0;
        BufferedReader br = this.getReader();
        try {
            while ((line = this.readLineAndShowProgress(br)) != null) {
                int index;
                if (!line.contains("CpuIdle") && !line.contains("cores")) continue;
                String[] tokens = line.trim().split("\\s+");
                if (tokens.length == 4 && tokens[1].equals("cores")) {
                    index = this.getLPARIndex(tokens[0]);
                    try {
                        this.cores[index] = Float.parseFloat(tokens[3]);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (tokens.length != 6) continue;
                if (date == null || !time.equals(tokens[1]) || time == null || !time.equals(tokens[2])) {
                    try {
                        gc = new GregorianCalendar(Integer.parseInt(tokens[1].substring(0, 4)), Integer.parseInt(tokens[1].substring(5, 7)) - 1, Integer.parseInt(tokens[1].substring(8)), Integer.parseInt(tokens[2].substring(0, 2)), Integer.parseInt(tokens[2].substring(3)), 0);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    date = tokens[1];
                    time = tokens[2];
                }
                index = this.getLPARIndex(tokens[0]);
                int slot = this.getSlot(gc);
                PerfData pd = this.parser[index].getPerfData();
                float id = Float.parseFloat(tokens[5]);
                float us = 100.0f - id;
                float wa = 0.0f;
                float sy = 0.0f;
                pd.add(slot, (byte)1, (byte)3, AVG_CPU, id);
                pd.add(slot, (byte)1, (byte)0, AVG_CPU, us);
                pd.add(slot, (byte)1, (byte)2, AVG_CPU, wa);
                pd.add(slot, (byte)1, (byte)1, AVG_CPU, sy);
                if (!(this.cores[index] > 0.0f)) continue;
                pd.add(slot, (byte)35, this.cores[index]);
            }
        }
        catch (Exception e) {
            System.out.println("Error reading line: " + line);
            throw e;
        }
        br.close();
        i = 0;
        while (this.parser != null && i < this.parser.length) {
            this.parser[i].endOfData();
            ++i;
        }
        if (lastParse) {
            this.perfData.endOfData();
        }
    }

    private int getLPARIndex(String name) {
        if (name.equals("")) {
            name = "<Unknown>";
        }
        if (this.parser == null) {
            this.parser = new Parser[1];
            this.parser[0] = new Parser_Topas(this.manager);
            this.parser[0].setFileName(name);
            this.parser[0].setApplet(this.applet);
            this.parser[0].setStart(this.start);
            this.parser[0].setEnd(this.end);
            this.parser[0].getPerfData().setLimits(this.start, this.end);
            this.cores = new float[1];
            this.cores[0] = -1.0f;
            return 0;
        }
        int i = 0;
        while (i < this.parser.length) {
            if (this.parser[i].getFileName().equals(name)) {
                return i;
            }
            ++i;
        }
        Parser[] old = this.parser;
        this.parser = new Parser_Topas[old.length + 1];
        float[] oldCores = this.cores;
        this.cores = new float[old.length + 1];
        int i2 = 0;
        while (i2 < old.length) {
            this.parser[i2] = old[i2];
            this.cores[i2] = oldCores[i2];
            ++i2;
        }
        this.parser[old.length] = new Parser_Topas(this.manager);
        this.parser[old.length].setFileName(name);
        this.parser[old.length].setApplet(this.applet);
        this.parser[old.length].setStart(this.start);
        this.parser[old.length].setEnd(this.end);
        this.parser[old.length].getPerfData().setLimits(this.start, this.end);
        this.cores[old.length] = -1.0f;
        return old.length;
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
    }

    private void parseTimeLimits() throws Exception {
        String line;
        GregorianCalendar curr = null;
        String date = null;
        String time = null;
        this.valid = false;
        BufferedReader br = this.getReader();
        while ((line = br.readLine()) != null) {
            ++this.total_lines;
            String[] tokens = line.trim().split("\\s+");
            if (tokens.length != 6) continue;
            if (date == null || !time.equals(tokens[1]) || time == null || !time.equals(tokens[2])) {
                try {
                    curr = new GregorianCalendar(Integer.parseInt(tokens[1].substring(0, 4)), Integer.parseInt(tokens[1].substring(5, 7)) - 1, Integer.parseInt(tokens[1].substring(8)), Integer.parseInt(tokens[2].substring(0, 2)), Integer.parseInt(tokens[2].substring(3)), 0);
                }
                catch (Exception e) {
                    continue;
                }
                date = tokens[1];
                time = tokens[2];
            }
            if (this.start == null) {
                this.start = curr;
            }
            if (this.end != null && !this.end.before(curr)) continue;
            this.end = curr;
        }
        br.close();
    }

    public Parser getParser(int num) {
        return this.parser[num];
    }

    public String[] getParserNames() {
        if (this.parser == null) {
            return null;
        }
        String[] result = new String[this.parser.length];
        int i = 0;
        while (i < this.parser.length) {
            result[i] = this.parser[i].getFileName();
            ++i;
        }
        return result;
    }
}

