/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.GregorianCalendar;
import pGraph.DataSet;
import pGraph.Parser;
import pGraph.ParserManager;
import pGraph.PerfData;

public class Parser_Lslparutil
extends Parser {
    private static final int MAXLPAR = 1024;
    private static final int MAXPROCPOOLS = 256;
    private String[] lparName = new String[1024];
    private int[] dataId = new int[1024];
    private int numLpar = 0;
    private PerfData[] lparPerfData = new PerfData[1024];
    private BigDecimal[][] lparData = new BigDecimal[1024][10];
    private static final byte CAPPED_CYCLES = 0;
    private static final byte UNCAPPED_CYCLES = 1;
    private static final byte ENTITLED_CYCLES = 2;
    private static final byte PROC_UNITS = 3;
    private static final byte PROCS = 4;
    private static final byte SHARED_CYCLES = 5;
    private static final byte LPAR_TIME_CYCLES = 6;
    private static final byte LOGICAL_MEM = 7;
    private static final byte PHYS_MEM = 8;
    private static final byte LOAN_MEM = 9;
    private static final byte NUM_LPARDATA = 10;
    private GregorianCalendar[] lparTime = new GregorianCalendar[1024];
    private BigDecimal[] poolData = new BigDecimal[6];
    private BigDecimal[][] procPoolData = new BigDecimal[256][6];
    private static final byte UTILIZED_POOL_CYCLES = 0;
    private static final byte TOTAL_POOL_CYCLES = 1;
    private static final byte POOL_PROC_UNITS = 2;
    private static final byte BORROWED_POOL_PROC_UNITS = 3;
    private static final byte AVAILABLE_POOL_PROC_UNITS = 4;
    private static final byte POOL_TIME_CYCLES = 5;
    private static final byte NUM_POOLDATA = 6;
    private String[] procPoolName = new String[256];
    private BigDecimal[] memPoolData = new BigDecimal[6];
    private static final byte PAGE_FAULTS = 0;
    private static final byte PAGE_IN_DELAY = 1;
    private static final byte POOL_MEM = 3;
    private static final byte LPAR_RUM_MEM = 4;
    private static final byte SYS_FIRMWARE_POOL_MEM = 5;
    private static final byte NUM_MEMPOOLDATA = 6;
    private float numCPUinSystem;
    private BigDecimal cyclesPerSecond = null;
    private GregorianCalendar poolTime = null;
    private GregorianCalendar[] procPoolTime = new GregorianCalendar[256];
    private GregorianCalendar memPoolTime = null;
    private Parser[] parser = null;
    private String line;
    private int resource_type;
    private static final byte POOL = 0;
    private static final byte LPAR = 1;
    private static final byte CEC = 2;
    private static final byte PROCPOOL = 3;
    private static final byte MEMPOOL = 4;
    private static final byte INVALID = 5;
    private String currLpar;
    private byte currProcPool;
    private String currProcPoolName;
    private BigDecimal[] currData = new BigDecimal[this.max((byte)10, (byte)6, (byte)6)];
    private GregorianCalendar currTime = null;
    private byte currLparType;
    private byte[] lparType = new byte[1024];
    private static final byte SHARED = 0;
    private static final byte DEDICATED = 1;
    private static final byte SHARED_DED = 2;
    private static final byte UNKNOWN = 3;
    private String currLparProcPoolName;
    private static final BigDecimal zero = new BigDecimal(0);

    public Parser_Lslparutil(String name, PerfData data, GregorianCalendar start, GregorianCalendar end) {
        this.fileName = name;
        this.perfData = data;
        this.start = start;
        this.end = end;
        this.valid = true;
    }

    public Parser_Lslparutil(ParserManager v) {
        this.manager = v;
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block3: {
            if (this.start == null || this.end == null) {
                return;
            }
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of lslparutil data (line " + this.current_file_line_read + ")");
                if (!lastParse) break block3;
                this.endOfData();
            }
        }
    }

    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        int j;
        int i;
        if (firstParse) {
            this.lines_read = 0;
            this.perfData.setLimits(this.start, this.end);
            i = 0;
            while (i < 1024) {
                if (this.lparPerfData[i] != null) {
                    this.lparPerfData[i].setLimits(this.start, this.end);
                }
                ++i;
            }
        }
        this.current_file_line_read = 0;
        BufferedReader br = this.getReader();
        i = 0;
        while (i < 1024) {
            this.lparTime[i] = null;
            this.lparType[i] = 3;
            j = 0;
            while (j < 10) {
                this.lparData[i][j] = null;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            this.poolData[i] = null;
            j = 0;
            while (j < 256) {
                this.procPoolData[j][i] = null;
                ++j;
            }
            ++i;
        }
        this.poolTime = null;
        i = 0;
        while (i < 256) {
            this.procPoolTime[i] = null;
            ++i;
        }
        block20: while (true) {
            BigDecimal bi3;
            BigDecimal bi2;
            BigDecimal bi4;
            BigDecimal bi1;
            int slot;
            this.line = this.readLineAndShowProgress(br);
            if (this.line == null) break;
            this.parseLine();
            if (this.resource_type == 5) continue;
            if (this.resource_type == 2) {
                slot = this.getSlot(this.currTime);
                this.perfData.add(slot, (byte)35, this.numCPUinSystem);
                continue;
            }
            if (this.resource_type == 0) {
                if (this.poolData[0] != null && this.cyclesPerSecond != null) {
                    slot = this.getSlot(this.poolTime);
                    bi1 = this.poolData[1].subtract(this.currData[1]);
                    bi4 = this.poolData[5].subtract(this.currData[5]);
                    bi2 = bi1.divide(bi4, new MathContext(5));
                    this.perfData.add(slot, (byte)3, bi2.floatValue());
                    bi3 = this.poolData[0].subtract(this.currData[0]);
                    bi4 = this.poolData[1].subtract(this.currData[1]);
                    try {
                        bi4 = bi2.subtract(bi3.divide(bi4, new MathContext(5)).multiply(bi2));
                        this.perfData.add(slot, (byte)4, bi4.floatValue());
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                }
                this.poolTime = this.currTime;
                i = 0;
                while (true) {
                    if (i >= 6) continue block20;
                    this.poolData[i] = this.currData[i];
                    ++i;
                }
            }
            if (this.resource_type == 4) {
                if (this.memPoolData[0] != null) {
                    slot = this.getSlot(this.memPoolTime);
                    bi1 = this.memPoolData[0].subtract(this.currData[0]);
                    this.perfData.add(slot, (byte)48, bi1.floatValue());
                    bi1 = this.memPoolData[1].subtract(this.currData[1]).divide(new BigDecimal(1000), new MathContext(2));
                    this.perfData.add(slot, (byte)49, bi1.floatValue());
                    bi1 = this.memPoolData[3];
                    this.perfData.add(slot, (byte)45, bi1.floatValue());
                    bi1 = this.memPoolData[4].add(this.memPoolData[5]);
                    this.perfData.add(slot, (byte)46, bi1.floatValue());
                }
                this.memPoolTime = this.currTime;
                i = 0;
                while (true) {
                    if (i >= 6) continue block20;
                    this.memPoolData[i] = this.currData[i];
                    ++i;
                }
            }
            if (this.resource_type == 3) {
                if (this.procPoolData[this.currProcPool][0] != null && this.cyclesPerSecond != null) {
                    slot = this.getSlot(this.procPoolTime[this.currProcPool]);
                    bi1 = this.procPoolData[this.currProcPool][1].subtract(this.currData[1]);
                    bi4 = this.procPoolData[this.currProcPool][5].subtract(this.currData[5]);
                    bi2 = bi1.divide(bi4, new MathContext(5));
                    this.perfData.add(slot, (byte)12, (byte)0, this.procPoolName[this.currProcPool], bi2.floatValue());
                    bi3 = this.procPoolData[this.currProcPool][0].subtract(this.currData[0]);
                    bi4 = bi3.compareTo(new BigDecimal(0)) == 0 ? bi3 : bi3.divide(bi1, new MathContext(5)).multiply(bi2, new MathContext(5));
                    this.perfData.add(slot, (byte)12, (byte)1, this.procPoolName[this.currProcPool], bi4.floatValue());
                }
                this.procPoolTime[this.currProcPool] = this.currTime;
                this.procPoolName[this.currProcPool] = this.currProcPoolName;
                i = 0;
                while (true) {
                    if (i >= 6) continue block20;
                    this.procPoolData[this.currProcPool][i] = this.currData[i];
                    ++i;
                }
            }
            if (this.resource_type == 1) {
                int lparId = this.getLparData(this.currLpar);
                slot = this.getSlot(this.currTime);
                this.lparPerfData[lparId].add(slot, (byte)1, this.currData[4].floatValue());
                switch (this.currLparType) {
                    case 1: {
                        this.lparPerfData[lparId].add(slot, (byte)37, 1.0f);
                        break;
                    }
                    case 0: {
                        this.lparPerfData[lparId].add(slot, (byte)5, this.currData[3].floatValue());
                        break;
                    }
                    case 2: {
                        this.lparPerfData[lparId].add(slot, (byte)39, 1.0f);
                        break;
                    }
                    default: {
                        System.out.println("Internal error in Parser_lslparutil: line " + this.current_file_line_read);
                    }
                }
                if (this.lparType[lparId] != 3 && this.lparType[lparId] == this.currLparType && this.lparData[lparId][2].compareTo(this.currData[2]) >= 0) {
                    slot = this.getSlot(this.lparTime[lparId]);
                    bi1 = this.lparData[lparId][0].subtract(this.currData[0]);
                    bi2 = this.lparData[lparId][1].subtract(this.currData[1]);
                    bi3 = this.lparData[lparId][2].subtract(this.currData[2]);
                    bi4 = this.lparData[lparId][5] != null && this.currData[5] != null ? this.lparData[lparId][5].subtract(this.currData[5]) : null;
                    try {
                        bi1 = this.currData[2].compareTo(zero) == 0 ? zero : (bi4 == null ? bi1.add(bi2).divide(bi3, new MathContext(5)) : bi1.add(bi2).add(bi4).divide(bi3, new MathContext(5)));
                        this.lparPerfData[lparId].add(slot, (byte)6, bi1.floatValue() * 100.0f);
                        switch (this.currLparType) {
                            case 1: {
                                this.lparPerfData[lparId].add(slot, (byte)0, bi1.multiply(this.lparData[lparId][4]).floatValue());
                                break;
                            }
                            case 0: {
                                this.lparPerfData[lparId].add(slot, (byte)0, bi1.multiply(this.lparData[lparId][3]).floatValue());
                                break;
                            }
                            case 2: {
                                this.lparPerfData[lparId].add(slot, (byte)0, bi1.multiply(this.lparData[lparId][4]).floatValue());
                                break;
                            }
                            default: {
                                System.out.println("Internal error in Parser_lslparutil: line " + this.current_file_line_read);
                                slot /= 0;
                            }
                        }
                        if (this.currLparProcPoolName != null) {
                            this.lparPerfData[lparId].add(slot, (byte)12, (byte)2, this.currLparProcPoolName, 1.0f);
                        }
                    }
                    catch (ArithmeticException arithmeticException) {
                        // empty catch block
                    }
                }
                if (this.lparData[lparId][7] != null && this.lparData[lparId][8] != null && this.lparData[lparId][9] != null) {
                    this.lparPerfData[lparId].add(slot, (byte)45, this.lparData[lparId][7].divide(new BigDecimal(1024), new MathContext(5)).floatValue());
                    this.lparPerfData[lparId].add(slot, (byte)46, this.lparData[lparId][8].divide(new BigDecimal(1024), new MathContext(5)).floatValue());
                    this.lparPerfData[lparId].add(slot, (byte)47, this.lparData[lparId][9].divide(new BigDecimal(1024), new MathContext(5)).floatValue());
                }
                this.lparTime[lparId] = this.currTime;
                this.lparType[lparId] = this.currLparType;
                i = 0;
                while (true) {
                    if (i >= 10) continue block20;
                    this.lparData[lparId][i] = this.currData[i];
                    ++i;
                }
            }
            System.out.println("Skipped line: " + this.line);
        }
        if (!lastParse) {
            return;
        }
        i = 0;
        while (i < this.numLpar) {
            this.lparPerfData[i].endOfData();
            ++i;
        }
        this.parser = new Parser_Lslparutil[this.numLpar];
        j = 0;
        while (j < this.numLpar) {
            this.parser[j] = new Parser_Lslparutil(this.lparName[j], this.lparPerfData[this.dataId[j]], this.start, this.end);
            ++j;
        }
        DataSet ds = null;
        DataSet ds1 = null;
        i = 0;
        while (i < DataSet.SLOTS) {
            int shared = -1;
            int dedicated = -1;
            int shared_ded = -1;
            float pc = -1.0f;
            float ent = -1.0f;
            float vp = -1.0f;
            float ent_used = -1.0f;
            float min_pc = -1.0f;
            float min_ent = -1.0f;
            float min_vp = -1.0f;
            float max_pc = -1.0f;
            float max_ent = -1.0f;
            float max_vp = -1.0f;
            float max_ent_used = -1.0f;
            float min_ent_used = -1.0f;
            j = 0;
            while (j < this.numLpar) {
                float f;
                ds = this.parser[j].getPerfData().getData((byte)0, 0, (byte)37);
                if (ds != null && (f = ds.getValue(i)) > 0.0f) {
                    dedicated = dedicated >= 0 ? ++dedicated : 1;
                }
                if ((ds = this.parser[j].getPerfData().getData((byte)0, 0, (byte)39)) != null && (f = ds.getValue(i)) > 0.0f) {
                    shared_ded = shared_ded >= 0 ? ++shared_ded : 1;
                }
                if ((ds = this.parser[j].getPerfData().getData((byte)0, 0, (byte)5)) != null) {
                    f = ds.getValue(i);
                    if (f > 0.0f) {
                        ent = ent >= 0.0f ? (ent += f) : f;
                        shared = shared >= 0 ? ++shared : 1;
                    }
                    if ((f = ds.getAbsMin(i)) > 0.0f) {
                        min_ent = min_ent >= 0.0f ? (min_ent += f) : f;
                    }
                    if ((f = ds.getAbsMax(i)) > 0.0f) {
                        max_ent = max_ent >= 0.0f ? (max_ent += f) : f;
                    }
                }
                if ((ds = this.parser[j].getPerfData().getData((byte)0, 0, (byte)1)) != null) {
                    f = ds.getValue(i);
                    if (f > 0.0f) {
                        vp = vp >= 0.0f ? (vp += f) : f;
                    }
                    if ((f = ds.getAbsMin(i)) > 0.0f) {
                        min_vp = min_vp >= 0.0f ? (min_vp += f) : f;
                    }
                    if ((f = ds.getAbsMax(i)) > 0.0f) {
                        max_vp = max_vp >= 0.0f ? (max_vp += f) : f;
                    }
                }
                if ((ds = this.parser[j].getPerfData().getData((byte)0, 0, (byte)0)) != null) {
                    float f1;
                    f = ds.getValue(i);
                    if (f > 0.0f) {
                        pc = pc >= 0.0f ? (pc += f) : f;
                    }
                    if ((f = ds.getAbsMin(i)) > 0.0f) {
                        min_pc = min_pc >= 0.0f ? (min_pc += f) : f;
                    }
                    if ((f = ds.getAbsMax(i)) > 0.0f) {
                        max_pc = max_pc >= 0.0f ? (max_pc += f) : f;
                    }
                    if ((ds1 = this.parser[j].getPerfData().getData((byte)0, 0, (byte)5)) != null && (f1 = ds1.getValue(i)) > 0.0f) {
                        f = ds.getValue(i);
                        if (f > f1) {
                            f = f1;
                        }
                        ent_used = ent_used >= 0.0f ? (ent_used += f) : f;
                        f = ds.getAbsMin(i);
                        if (f > f1) {
                            f = f1;
                        }
                        min_ent_used = min_ent_used >= 0.0f ? (min_ent_used += f) : f;
                        f = ds.getAbsMax(i);
                        if (f > f1) {
                            f = f1;
                        }
                        max_ent_used = max_ent_used >= 0.0f ? (max_ent_used += f) : f;
                    }
                }
                ++j;
            }
            this.perfData.addBySlot(i, (byte)1, vp, min_vp, max_vp);
            this.perfData.addBySlot(i, (byte)5, ent, min_ent, max_ent);
            this.perfData.addBySlot(i, (byte)0, pc, min_pc, max_pc);
            this.perfData.addBySlot(i, (byte)58, ent_used, min_ent_used, max_ent_used);
            if (shared >= 0 || dedicated >= 0 || shared_ded >= 0) {
                if (shared >= 0) {
                    this.perfData.add(i, (byte)38, shared);
                } else {
                    this.perfData.add(i, (byte)38, 0.0f);
                }
                if (dedicated >= 0) {
                    this.perfData.add(i, (byte)37, dedicated);
                } else {
                    this.perfData.add(i, (byte)37, 0.0f);
                }
                if (shared_ded >= 0) {
                    this.perfData.add(i, (byte)39, shared_ded);
                } else {
                    this.perfData.add(i, (byte)39, 0.0f);
                }
            }
            ++i;
        }
        int num = 0;
        i = 0;
        while (i < 256) {
            if (this.procPoolName[i] != null) {
                ++num;
            }
            ++i;
        }
        String[] names = new String[num];
        String[] alias = new String[num];
        i = 0;
        while (i < 256) {
            if (this.procPoolName[i] != null) {
                names[i] = String.valueOf(i);
                alias[i] = this.procPoolName[i];
            }
            ++i;
        }
        this.perfData.endOfData();
    }

    private void parseLine() {
        if (!this.line.startsWith("time=")) {
            this.resource_type = 5;
            return;
        }
        if (!this.line.contains("event_type=sample")) {
            this.resource_type = 5;
            return;
        }
        if (this.line.length() < 24) {
            this.resource_type = 5;
            return;
        }
        this.currTime = new GregorianCalendar(Integer.parseInt(this.line.substring(11, 15)), 0 + Integer.parseInt(this.line.substring(5, 7)) - 1, Integer.parseInt(this.line.substring(8, 10)), Integer.parseInt(this.line.substring(16, 18)), Integer.parseInt(this.line.substring(19, 21)), Integer.parseInt(this.line.substring(22, 24)));
        int i = 0;
        while (i < this.currData.length) {
            this.currData[i] = null;
            ++i;
        }
        if (this.line.contains("configurable_sys_proc_units")) {
            int a = this.line.indexOf("configurable_sys_proc_units=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            int b = this.line.indexOf(44, a);
            this.numCPUinSystem = b > 0 ? Float.parseFloat(this.line.substring(a + 28, b)) : Float.parseFloat(this.line.substring(a + 28));
            a = this.line.indexOf("proc_cycles_per_second=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.cyclesPerSecond = b > 0 ? new BigDecimal(this.line.substring(a + 23, b)) : new BigDecimal(this.line.substring(a + 23));
            this.resource_type = 2;
            return;
        }
        if (this.line.contains("resource_type=pool")) {
            int a = this.line.indexOf("total_pool_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            int b = this.line.indexOf(44, a);
            this.currData[1] = b > 0 ? new BigDecimal(this.line.substring(a + 18, b)) : new BigDecimal(this.line.substring(a + 18));
            a = this.line.indexOf("utilized_pool_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[0] = b > 0 ? new BigDecimal(this.line.substring(a + 21, b)) : new BigDecimal(this.line.substring(a + 21));
            a = this.line.indexOf("configurable_pool_proc_units=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[2] = b > 0 ? new BigDecimal(this.line.substring(a + 29, b)) : new BigDecimal(this.line.substring(a + 29));
            a = this.line.indexOf("borrowed_pool_proc_units=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[3] = b > 0 ? new BigDecimal(this.line.substring(a + 25, b)) : new BigDecimal(this.line.substring(a + 25));
            a = this.line.indexOf("curr_avail_pool_proc_units=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[4] = b > 0 ? new BigDecimal(this.line.substring(a + 27, b)) : new BigDecimal(this.line.substring(a + 27));
            a = this.line.indexOf("time_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[5] = b > 0 ? new BigDecimal(this.line.substring(a + 12, b)) : new BigDecimal(this.line.substring(a + 12));
            this.resource_type = 0;
            return;
        }
        if (this.line.contains("resource_type=lpar")) {
            String s;
            this.currLparType = 1;
            int a = this.line.indexOf("capped_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            int b = this.line.indexOf(44, a);
            this.currData[0] = b > 0 ? new BigDecimal(this.line.substring(a + 14, b)) : new BigDecimal(this.line.substring(a + 14));
            a = this.line.indexOf("uncapped_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[1] = b > 0 ? new BigDecimal(this.line.substring(a + 16, b)) : new BigDecimal(this.line.substring(a + 16));
            a = this.line.indexOf("entitled_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[2] = b > 0 ? new BigDecimal(this.line.substring(a + 16, b)) : new BigDecimal(this.line.substring(a + 16));
            a = this.line.indexOf("curr_proc_units=");
            if (a > 0) {
                b = this.line.indexOf(44, a);
                this.currData[3] = b > 0 ? new BigDecimal(this.line.substring(a + 16, b)) : new BigDecimal(this.line.substring(a + 16));
                this.currLparType = 0;
            } else {
                this.currData[3] = null;
            }
            a = this.line.indexOf("curr_procs=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[4] = b > 0 ? new BigDecimal(this.line.substring(a + 11, b)) : new BigDecimal(this.line.substring(a + 11));
            a = this.line.indexOf("lpar_name=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currLpar = b > 0 ? this.line.substring(a + 10, b) : this.line.substring(a + 10);
            a = this.line.indexOf("shared_cycles_while_active=");
            this.currData[5] = a < 0 ? null : ((b = this.line.indexOf(44, a)) > 0 ? new BigDecimal(this.line.substring(a + 27, b)) : new BigDecimal(this.line.substring(a + 27)));
            a = this.line.indexOf("curr_sharing_mode=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            String mode = b > 0 ? this.line.substring(a + 18, b) : this.line.substring(a + 18);
            if (mode.equals("share_idle_procs_always")) {
                this.currLparType = (byte)2;
            }
            if ((a = this.line.indexOf("time_cycles=")) < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[6] = b > 0 ? new BigDecimal(this.line.substring(a + 12, b)) : new BigDecimal(this.line.substring(a + 12));
            a = this.line.indexOf("curr_shared_proc_pool_name=");
            this.currLparProcPoolName = a < 0 ? null : ((b = this.line.indexOf(44, a)) > 0 ? this.line.substring(a + 27, b) : this.line.substring(a + 27));
            a = this.line.indexOf("mem_mode=");
            if (a >= 0 && (s = (b = this.line.indexOf(44, a)) > 0 ? this.line.substring(a + 9, b) : this.line.substring(a + 9)).equals("shared")) {
                a = this.line.indexOf("phys_run_mem=");
                if (a < 0) {
                    this.resource_type = 5;
                    return;
                }
                b = this.line.indexOf(44, a);
                this.currData[8] = b > 0 ? new BigDecimal(this.line.substring(a + 13, b)) : new BigDecimal(this.line.substring(a + 13));
                a = this.line.indexOf("mem_overage_cooperation=");
                if (a < 0) {
                    this.resource_type = 5;
                    return;
                }
                b = this.line.indexOf(44, a);
                s = b > 0 ? this.line.substring(a + 24, b) : this.line.substring(a + 24);
                this.currData[9] = s.startsWith("-") ? new BigDecimal(s.substring(1)) : new BigDecimal(s);
                a = this.line.indexOf("curr_mem=");
                if (a < 0) {
                    this.resource_type = 5;
                    return;
                }
                b = this.line.indexOf(44, a);
                this.currData[7] = b > 0 ? new BigDecimal(this.line.substring(a + 9, b)) : new BigDecimal(this.line.substring(a + 9));
            }
            this.resource_type = 1;
            return;
        }
        if (this.line.contains("resource_type=procpool")) {
            int a = this.line.indexOf("shared_proc_pool_id=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            int b = this.line.indexOf(44, a);
            this.currProcPool = b > 0 ? Byte.parseByte(this.line.substring(a + 20, b)) : Byte.parseByte(this.line.substring(a + 20));
            a = this.line.indexOf("shared_proc_pool_name=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currProcPoolName = b > 0 ? this.line.substring(a + 22, b) : this.line.substring(a + 22);
            a = this.line.indexOf("total_pool_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[1] = b > 0 ? new BigDecimal(this.line.substring(a + 18, b)) : new BigDecimal(this.line.substring(a + 18));
            a = this.line.indexOf("utilized_pool_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[0] = b > 0 ? new BigDecimal(this.line.substring(a + 21, b)) : new BigDecimal(this.line.substring(a + 21));
            a = this.line.indexOf("time_cycles=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[5] = b > 0 ? new BigDecimal(this.line.substring(a + 12, b)) : new BigDecimal(this.line.substring(a + 12));
            this.resource_type = 3;
            return;
        }
        if (this.line.contains("resource_type=mempool")) {
            int a = this.line.indexOf("page_faults=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            int b = this.line.indexOf(44, a);
            this.currData[0] = b > 0 ? new BigDecimal(this.line.substring(a + 12, b)) : new BigDecimal(this.line.substring(a + 12));
            a = this.line.indexOf("page_in_delay=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[1] = b > 0 ? new BigDecimal(this.line.substring(a + 14, b)) : new BigDecimal(this.line.substring(a + 14));
            a = this.line.indexOf("curr_pool_mem=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[3] = b > 0 ? new BigDecimal(this.line.substring(a + 14, b)) : new BigDecimal(this.line.substring(a + 14));
            a = this.line.indexOf("lpar_run_mem=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[4] = b > 0 ? new BigDecimal(this.line.substring(a + 13, b)) : new BigDecimal(this.line.substring(a + 13));
            a = this.line.indexOf("sys_firmware_pool_mem=");
            if (a < 0) {
                this.resource_type = 5;
                return;
            }
            b = this.line.indexOf(44, a);
            this.currData[5] = b > 0 ? new BigDecimal(this.line.substring(a + 22, b)) : new BigDecimal(this.line.substring(a + 22));
            this.resource_type = 4;
            return;
        }
        this.resource_type = 5;
    }

    private int getLparData(String name) {
        if (this.numLpar == 0) {
            this.addName(name, 0);
            return this.dataId[0];
        }
        return this.getLparData(name, 0, this.numLpar);
    }

    private int getLparData(String name, int from, int to) {
        if (from + 1 == to) {
            int comp = name.compareTo(this.lparName[from]);
            if (comp == 0) {
                return this.dataId[from];
            }
            if (comp < 0) {
                this.addName(name, from);
                return this.dataId[from];
            }
            this.addName(name, to);
            return this.dataId[to];
        }
        int pos = (from + to) / 2;
        int comp = name.compareTo(this.lparName[pos]);
        if (comp == 0) {
            return this.dataId[pos];
        }
        if (comp < 0) {
            return this.getLparData(name, from, pos);
        }
        if (pos + 1 == to) {
            this.addName(name, to);
            return this.dataId[to];
        }
        return this.getLparData(name, pos + 1, to);
    }

    private void addName(String name, int pos) {
        int i = this.numLpar;
        while (i > pos) {
            this.lparName[i] = this.lparName[i - 1];
            this.dataId[i] = this.dataId[i - 1];
            --i;
        }
        this.lparName[pos] = name;
        this.dataId[pos] = this.numLpar;
        this.lparPerfData[this.numLpar] = new PerfData();
        this.lparPerfData[this.numLpar].setLimits(this.start, this.end);
        ++this.numLpar;
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
    }

    private void parseTimeLimits() throws Exception {
        GregorianCalendar gc = null;
        BufferedReader br = this.getReader();
        while (true) {
            String line;
            if ((line = br.readLine()) == null) {
                if (this.start == null || this.end == null) break;
                this.valid = true;
                break;
            }
            ++this.total_lines;
            if (!line.startsWith("time=") || line.length() < 35 || !line.startsWith("time=") || !line.contains(",event_type=")) continue;
            gc = new GregorianCalendar(Integer.parseInt(line.substring(11, 15)), 0 + Integer.parseInt(line.substring(5, 7)) - 1, Integer.parseInt(line.substring(8, 10)), Integer.parseInt(line.substring(16, 18)), Integer.parseInt(line.substring(19, 21)), Integer.parseInt(line.substring(22, 24)));
            if (this.start == null || gc.before(this.start)) {
                this.start = gc;
            }
            if (this.end != null && !gc.after(this.end)) continue;
            this.end = gc;
        }
    }

    public Parser getParser(int num) {
        return this.parser[num];
    }

    public String[] getParserNames() {
        String[] result = new String[this.numLpar];
        int i = 0;
        while (i < this.numLpar) {
            result[i] = this.lparName[i];
            ++i;
        }
        return result;
    }

    private byte max(byte a, byte b, byte c) {
        if (a > b) {
            if (a > c) {
                return a;
            }
            return c;
        }
        if (b > c) {
            return b;
        }
        return c;
    }
}

