/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.util.GregorianCalendar;
import pGraph.Parser;
import pGraph.ParserManager;

public class Parser_Iostat
extends Parser {
    private int parsed_day;
    private int last_parsed_hour;
    private String last_time = null;
    private GregorianCalendar last_gc = null;
    private boolean isIostat = false;

    public Parser_Iostat(ParserManager v) {
        this.manager = v;
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block2: {
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of iostat data.");
                if (!lastParse) break block2;
                this.endOfData();
            }
        }
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.start != null && this.end != null && this.isIostat) {
            this.valid = true;
        }
    }

    private void checkIostat(String line) {
        if (this.isIostat) {
            return;
        }
        if (!line.contains("xfers")) {
            return;
        }
        if (line.contains("read") && line.contains("write") && line.contains("queue") && line.contains("time")) {
            this.isIostat = true;
        }
    }

    private void parseTimeLimits() throws Exception {
        String line;
        GregorianCalendar curr = null;
        String time = null;
        int day = 1;
        this.valid = false;
        BufferedReader br = this.getReader();
        while ((line = br.readLine()) != null) {
            ++this.total_lines;
            this.checkIostat(line);
            if (!this.isDataLine(line)) continue;
            String s = line.substring(line.length() - "xx:xx:xx".length());
            if (time != null && time.equals(s)) continue;
            time = s;
            try {
                curr = new GregorianCalendar(1970, 0, day, Integer.parseInt(time.substring(0, 2)), Integer.parseInt(time.substring(3, 5)), Integer.parseInt(time.substring(6)));
            }
            catch (Exception e) {
                continue;
            }
            if (curr == null) {
                // empty if block
            }
            if (this.end != null && curr.before(this.end)) {
                curr.add(5, 1);
                ++day;
            }
            if (this.start == null) {
                this.start = curr;
            }
            if (this.end != null && !this.end.before(curr)) continue;
            this.end = curr;
        }
        br.close();
    }

    float convertTimeValue(String s) {
        float factor = 1.0f;
        if (s.endsWith("S")) {
            factor = 1000.0f;
        }
        if (s.endsWith("H")) {
            factor = 3600000.0f;
        }
        if (factor != 1.0f) {
            s = s.substring(0, s.length() - 1);
        }
        return factor * Float.parseFloat(s);
    }

    float convertKByteValue(String s) {
        float factor = 1.0f;
        if (s.endsWith("K")) {
            factor = 1000.0f;
        }
        if (s.endsWith("M")) {
            factor = 1000000.0f;
        }
        if (s.endsWith("G")) {
            factor = 1.0E9f;
        }
        if (s.endsWith("T")) {
            factor = 1.0E12f;
        }
        if (factor != 1.0f) {
            s = s.substring(0, s.length() - 1);
        }
        return factor * Float.parseFloat(s) / 1024.0f;
    }

    private GregorianCalendar timeToGC(String time) {
        if (time.equals(this.last_time)) {
            return this.last_gc;
        }
        GregorianCalendar result = null;
        try {
            result = new GregorianCalendar(1970, 0, this.parsed_day, Integer.parseInt(time.substring(0, 2)), Integer.parseInt(time.substring(3, 5)), Integer.parseInt(time.substring(6)));
        }
        catch (Exception e) {
            return null;
        }
        int hour = Integer.parseInt(time.substring(0, 2));
        if (hour < this.last_parsed_hour) {
            ++this.parsed_day;
            result.add(5, 1);
        }
        this.last_parsed_hour = hour;
        this.last_time = time;
        this.last_gc = result;
        return result;
    }

    private boolean isDataLine(String line) {
        if (line == null) {
            return false;
        }
        if (line.length() <= "xx:xx:xx".length()) {
            return false;
        }
        return line.charAt(line.length() - 6) == ':' && line.charAt(line.length() - 3) == ':';
    }

    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        int num = 0;
        if (firstParse) {
            this.perfData.setLimits(this.start, this.end);
            this.lines_read = 0;
        }
        this.current_file_line_read = 0;
        this.parsed_day = 1;
        this.last_parsed_hour = 0;
        this.last_time = null;
        this.last_gc = null;
        BufferedReader br = this.getReader();
        String line = this.readLineAndShowProgress(br);
        if (line == null) {
            return;
        }
        ++num;
        DataParser dp = new DataParser();
        while (true) {
            int slot;
            GregorianCalendar gc;
            if (line.startsWith("Vadapter:")) {
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.startsWith("-------")) {
                    System.out.println("Virtual adapter stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.endsWith("avg  serv")) {
                    System.out.println("Virtual adapter stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.endsWith("sqsz qfull")) {
                    System.out.println("Virtual adapter stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!dp.parse(line)) {
                    System.out.println("Virtual adapter stanza interrupted in line " + num);
                    continue;
                }
                gc = this.timeToGC(dp.getTime());
                slot = this.getSlot(gc);
                if (dp.getNumData() == 21) {
                    this.perfData.add(slot, (byte)4, (byte)2, dp.getLabel(), dp.getValue(2));
                    this.perfData.add(slot, (byte)4, (byte)0, dp.getLabel(), dp.getValue(3) / 1024.0f);
                    this.perfData.add(slot, (byte)4, (byte)1, dp.getLabel(), dp.getValue(4) / 1024.0f);
                    this.perfData.add(slot, (byte)4, (byte)3, dp.getLabel(), dp.getValue(6));
                    this.perfData.add(slot, (byte)4, (byte)4, dp.getLabel(), dp.getValue(7));
                    this.perfData.add(slot, (byte)4, (byte)5, dp.getLabel(), dp.getValue(8));
                    this.perfData.add(slot, (byte)4, (byte)6, dp.getLabel(), dp.getValue(9));
                    this.perfData.add(slot, (byte)4, (byte)7, dp.getLabel(), dp.getValue(10));
                    this.perfData.add(slot, (byte)4, (byte)8, dp.getLabel(), dp.getValue(11));
                    this.perfData.add(slot, (byte)4, (byte)9, dp.getLabel(), dp.getValue(12));
                    this.perfData.add(slot, (byte)4, (byte)10, dp.getLabel(), dp.getValue(13));
                    this.perfData.add(slot, (byte)4, (byte)11, dp.getLabel(), dp.getValue(14));
                    this.perfData.add(slot, (byte)4, (byte)12, dp.getLabel(), dp.getValue(15));
                    this.perfData.add(slot, (byte)4, (byte)13, dp.getLabel(), dp.getValue(16));
                    this.perfData.add(slot, (byte)4, (byte)14, dp.getLabel(), dp.getValue(17));
                    this.perfData.add(slot, (byte)4, (byte)15, dp.getLabel(), dp.getValue(18));
                    this.perfData.add(slot, (byte)4, (byte)16, dp.getLabel(), dp.getValue(19));
                } else if (dp.getNumData() == 20) {
                    this.perfData.add(slot, (byte)4, (byte)2, dp.getLabel(), dp.getValue(2));
                    this.perfData.add(slot, (byte)4, (byte)0, dp.getLabel(), dp.getValue(3) / 1024.0f);
                    this.perfData.add(slot, (byte)4, (byte)1, dp.getLabel(), dp.getValue(4) / 1024.0f);
                    this.perfData.add(slot, (byte)4, (byte)3, dp.getLabel(), dp.getValue(5));
                    this.perfData.add(slot, (byte)4, (byte)4, dp.getLabel(), dp.getValue(6));
                    this.perfData.add(slot, (byte)4, (byte)5, dp.getLabel(), dp.getValue(7));
                    this.perfData.add(slot, (byte)4, (byte)6, dp.getLabel(), dp.getValue(8));
                    this.perfData.add(slot, (byte)4, (byte)7, dp.getLabel(), dp.getValue(9));
                    this.perfData.add(slot, (byte)4, (byte)8, dp.getLabel(), dp.getValue(10));
                    this.perfData.add(slot, (byte)4, (byte)9, dp.getLabel(), dp.getValue(11));
                    this.perfData.add(slot, (byte)4, (byte)10, dp.getLabel(), dp.getValue(12));
                    this.perfData.add(slot, (byte)4, (byte)11, dp.getLabel(), dp.getValue(13));
                    this.perfData.add(slot, (byte)4, (byte)12, dp.getLabel(), dp.getValue(14));
                    this.perfData.add(slot, (byte)4, (byte)13, dp.getLabel(), dp.getValue(15));
                    this.perfData.add(slot, (byte)4, (byte)14, dp.getLabel(), dp.getValue(16));
                    this.perfData.add(slot, (byte)4, (byte)15, dp.getLabel(), dp.getValue(17));
                    this.perfData.add(slot, (byte)4, (byte)16, dp.getLabel(), dp.getValue(18));
                } else {
                    System.out.println("Virtual adapter stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                continue;
            }
            if (line.startsWith("Paths/Disk:") || line.startsWith("Disks:")) {
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.startsWith("-------")) {
                    System.out.println("Disk stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.endsWith("avg  serv")) {
                    System.out.println("Disk stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.endsWith("sqsz qfull")) {
                    System.out.println("Disk stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                while (dp.parse(line)) {
                    if (dp.getNumData() == 25) {
                        gc = this.timeToGC(dp.getTime());
                        slot = this.getSlot(gc);
                        this.perfData.add(slot, (byte)2, (byte)0, dp.getLabel(), dp.getValue(1));
                        this.perfData.add(slot, (byte)2, (byte)3, dp.getLabel(), dp.getValue(3));
                        this.perfData.add(slot, (byte)2, (byte)1, dp.getLabel(), dp.getValue(4) / 1024.0f);
                        this.perfData.add(slot, (byte)2, (byte)2, dp.getLabel(), dp.getValue(5) / 1024.0f);
                        this.perfData.add(slot, (byte)2, (byte)5, dp.getLabel(), dp.getValue(6));
                        this.perfData.add(slot, (byte)2, (byte)6, dp.getLabel(), dp.getValue(7));
                        this.perfData.add(slot, (byte)2, (byte)7, dp.getLabel(), dp.getValue(8));
                        this.perfData.add(slot, (byte)2, (byte)8, dp.getLabel(), dp.getValue(9));
                        this.perfData.add(slot, (byte)2, (byte)9, dp.getLabel(), dp.getValue(10));
                        this.perfData.add(slot, (byte)2, (byte)10, dp.getLabel(), dp.getValue(11));
                        this.perfData.add(slot, (byte)2, (byte)11, dp.getLabel(), dp.getValue(12));
                        this.perfData.add(slot, (byte)2, (byte)12, dp.getLabel(), dp.getValue(13));
                        this.perfData.add(slot, (byte)2, (byte)13, dp.getLabel(), dp.getValue(14));
                        this.perfData.add(slot, (byte)2, (byte)14, dp.getLabel(), dp.getValue(15));
                        this.perfData.add(slot, (byte)2, (byte)15, dp.getLabel(), dp.getValue(16));
                        this.perfData.add(slot, (byte)2, (byte)16, dp.getLabel(), dp.getValue(17));
                        this.perfData.add(slot, (byte)2, (byte)17, dp.getLabel(), dp.getValue(18));
                        this.perfData.add(slot, (byte)2, (byte)18, dp.getLabel(), dp.getValue(19));
                        this.perfData.add(slot, (byte)2, (byte)19, dp.getLabel(), dp.getValue(20));
                        this.perfData.add(slot, (byte)2, (byte)20, dp.getLabel(), dp.getValue(21));
                        this.perfData.add(slot, (byte)2, (byte)21, dp.getLabel(), dp.getValue(22));
                        this.perfData.add(slot, (byte)2, (byte)22, dp.getLabel(), dp.getValue(23));
                    } else if (dp.getLabel().startsWith("hdiskpower") && dp.getNumData() == 7) {
                        gc = this.timeToGC(dp.getTime());
                        slot = this.getSlot(gc);
                        this.perfData.add(slot, (byte)3, (byte)3, dp.getLabel(), dp.getValue(1));
                        this.perfData.add(slot, (byte)3, (byte)2, dp.getLabel(), dp.getValue(3));
                        this.perfData.add(slot, (byte)3, (byte)0, dp.getLabel(), dp.getValue(4) / 1024.0f);
                        this.perfData.add(slot, (byte)3, (byte)1, dp.getLabel(), dp.getValue(5) / 1024.0f);
                    } else if (!dp.getLabel().startsWith("cd") || dp.getNumData() != 7) {
                        System.out.println("Disk stanza interrupted in line " + num);
                        break;
                    }
                    line = this.readLineAndShowProgress(br);
                    if (line == null) break;
                    ++num;
                }
                if (line != null) continue;
                break;
            }
            if (line.startsWith("Adapter:")) {
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.startsWith("-------")) {
                    System.out.println("Physical adapter stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.endsWith("bread  bwrtn")) {
                    System.out.println("Physical adapter stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!dp.parse(line) || dp.getNumData() != 6) {
                    System.out.println("Physical adapter stanza interrupted in line " + num);
                    continue;
                }
                gc = this.timeToGC(dp.getTime());
                slot = this.getSlot(gc);
                this.perfData.add(slot, (byte)4, (byte)2, dp.getLabel(), dp.getValue(2));
                this.perfData.add(slot, (byte)4, (byte)0, dp.getLabel(), dp.getValue(3) / 1024.0f);
                this.perfData.add(slot, (byte)4, (byte)1, dp.getLabel(), dp.getValue(4) / 1024.0f);
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                continue;
            }
            if (line.startsWith("Vtargets/Disks:")) {
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.startsWith("-------")) {
                    System.out.println("Disk stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.endsWith("avg  serv")) {
                    System.out.println("Disk stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                if (!line.endsWith("sqsz qfull")) {
                    System.out.println("Disk stanza interrupted in line " + num);
                    continue;
                }
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                while (dp.parse(line)) {
                    if (dp.getNumData() != 19) {
                        System.out.println("Disk stanza interrupted in line " + num);
                        break;
                    }
                    gc = this.timeToGC(dp.getTime());
                    slot = this.getSlot(gc);
                    this.perfData.add(slot, (byte)2, (byte)3, dp.getLabel(), dp.getValue(1));
                    this.perfData.add(slot, (byte)2, (byte)1, dp.getLabel(), dp.getValue(2) / 1024.0f);
                    this.perfData.add(slot, (byte)2, (byte)2, dp.getLabel(), dp.getValue(3) / 1024.0f);
                    this.perfData.add(slot, (byte)2, (byte)5, dp.getLabel(), dp.getValue(4));
                    this.perfData.add(slot, (byte)2, (byte)6, dp.getLabel(), dp.getValue(5));
                    this.perfData.add(slot, (byte)2, (byte)7, dp.getLabel(), dp.getValue(6));
                    this.perfData.add(slot, (byte)2, (byte)8, dp.getLabel(), dp.getValue(7));
                    this.perfData.add(slot, (byte)2, (byte)11, dp.getLabel(), dp.getValue(8));
                    this.perfData.add(slot, (byte)2, (byte)12, dp.getLabel(), dp.getValue(9));
                    this.perfData.add(slot, (byte)2, (byte)13, dp.getLabel(), dp.getValue(10));
                    this.perfData.add(slot, (byte)2, (byte)14, dp.getLabel(), dp.getValue(11));
                    this.perfData.add(slot, (byte)2, (byte)17, dp.getLabel(), dp.getValue(12));
                    this.perfData.add(slot, (byte)2, (byte)18, dp.getLabel(), dp.getValue(13));
                    this.perfData.add(slot, (byte)2, (byte)19, dp.getLabel(), dp.getValue(14));
                    this.perfData.add(slot, (byte)2, (byte)20, dp.getLabel(), dp.getValue(15));
                    this.perfData.add(slot, (byte)2, (byte)21, dp.getLabel(), dp.getValue(16));
                    this.perfData.add(slot, (byte)2, (byte)22, dp.getLabel(), dp.getValue(17));
                    line = this.readLineAndShowProgress(br);
                    if (line == null) break;
                    ++num;
                }
                if (line != null) continue;
                break;
            }
            if (line.startsWith("System configuration") || line.startsWith("Disk history") || line.startsWith("System configuration changed") || line.length() == 0) {
                line = this.readLineAndShowProgress(br);
                if (line == null) break;
                ++num;
                continue;
            }
            System.out.println("Unrecognized data. Skipping line " + num);
            line = this.readLineAndShowProgress(br);
            if (line == null) break;
            ++num;
        }
        br.close();
        if (lastParse) {
            this.perfData.endOfData();
        }
    }

    class DataParser {
        private String line = null;
        private final int MAX_DATA = 50;
        private int[] begin = new int[50];
        private int[] end = new int[50];
        private int numData;

        DataParser() {
        }

        public boolean parse(String s) {
            this.line = s;
            if (!this.line.matches("([#_\\-\\w\\d\\.]+\\s+)+\\d\\d:\\d\\d:\\d\\d")) {
                return false;
            }
            this.numData = 0;
            boolean found = false;
            int i = 0;
            while (i < this.line.length() && this.numData < 50) {
                if (this.line.charAt(i) != ' ') {
                    if (!found) {
                        found = true;
                        this.begin[this.numData] = i;
                    }
                } else if (found) {
                    found = false;
                    this.end[this.numData++] = i - 1;
                }
                ++i;
            }
            if (this.numData == 50) {
                System.out.println("DataParser: line with too many labels");
                return false;
            }
            this.end[this.numData++] = this.line.length() - 1;
            return true;
        }

        public String getLabel() {
            return this.line.substring(0, this.end[0] + 1);
        }

        public String getTime() {
            return this.line.substring(this.begin[this.numData - 1]);
        }

        public int getNumData() {
            return this.numData;
        }

        public float getValue(int pos) {
            if (pos >= this.numData) {
                return -1.0f;
            }
            float result = 0.0f;
            boolean comma = false;
            float decimal = 0.1f;
            int i = this.begin[pos];
            while (i <= this.end[pos]) {
                char c = this.line.charAt(i);
                if (c >= '0' && c <= '9') {
                    if (!comma) {
                        result = result * 10.0f + (float)(c - 48);
                    } else {
                        result += decimal * (float)(c - 48);
                        decimal /= 10.0f;
                    }
                } else if (c == '.') {
                    comma = true;
                } else {
                    if (i != this.end[pos]) {
                        return -1.0f;
                    }
                    switch (c) {
                        case 'K': {
                            result *= 1000.0f;
                            break;
                        }
                        case 'M': {
                            result *= 1000000.0f;
                            break;
                        }
                        case 'G': {
                            result *= 1.0E9f;
                            break;
                        }
                        case 'T': {
                            result *= 1.0E12f;
                            break;
                        }
                        case 'S': {
                            result *= 1000.0f;
                            break;
                        }
                        case 'H': {
                            result *= 3600000.0f;
                            break;
                        }
                        default: {
                            System.out.println("DataParser: unknown suffix");
                            return -1.0f;
                        }
                    }
                }
                ++i;
            }
            return result;
        }
    }
}

