/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.File;
import java.util.GregorianCalendar;
import pGraph.Parser;
import pGraph.Parser_CEC;
import pGraph.Parser_Collectl;
import pGraph.Parser_Insight;
import pGraph.Parser_Iostat;
import pGraph.Parser_Lslparutil;
import pGraph.Parser_Nmon;
import pGraph.Parser_Sar;
import pGraph.Parser_Snmp;
import pGraph.Parser_Topas;
import pGraph.Parser_Vmstat;
import pGraph.Viewer;
import pGraph.ViewerApplet;

public class ParserManager
implements Runnable {
    private Viewer caller = null;
    private File source = null;
    private Parser parser = null;
    private boolean singleHost = true;
    private String[] singleHostFiles = null;
    private ViewerApplet applet = null;
    private String configurationFile = null;
    public static final byte UNKNOWN = 0;
    public static final byte NMON = 1;
    public static final byte VMSTAT = 2;
    public static final byte CECDIR = 3;
    public static final byte XMTREND = 6;
    public static final byte TOPASCEC = 7;
    public static final byte IOSTAT = 8;
    public static final byte LSLPARUTIL = 9;
    public static final byte CONFIGFILE = 10;
    public static final byte SAR = 11;
    public static final byte INSIGHT = 12;
    public static final byte COLLECTL = 13;
    public static final byte SNMP = 14;
    private byte filetype = 0;
    private byte numThreads = 0;
    GregorianCalendar start = null;
    GregorianCalendar end = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean running() {
        ParserManager parserManager = this;
        synchronized (parserManager) {
            return this.numThreads != 0;
        }
    }

    public ParserManager(Viewer caller) {
        this.caller = caller;
    }

    public void showReadProgress(int p) {
        this.caller.setProgressValue(p);
    }

    public void setSource(File f) {
        this.source = f;
        this.parser = null;
        this.configurationFile = null;
        this.singleHostFiles = null;
    }

    public void setLimits(GregorianCalendar start, GregorianCalendar end) {
        if (this.parser != null) {
            this.parser.setStart(start);
            this.parser.setEnd(end);
        } else {
            this.start = start;
            this.end = end;
        }
    }

    private Parser loadConfigurationFile() {
        this.caller.setProgressMessage("Prescan configuration file: " + this.configurationFile);
        this.caller.setProgressIndeterminate(true);
        Parser_CEC parser = new Parser_CEC(this);
        parser.setConfigurationFile(this.configurationFile);
        parser.setApplet(null);
        this.start = parser.getStart();
        this.end = parser.getEnd();
        parser.scanTimeLimits();
        if (!parser.isValid()) {
            System.out.println("No valid data found.");
            this.filetype = 0;
            return null;
        }
        this.filetype = (byte)10;
        return parser;
    }

    private Parser loadCECDirectory(File dir) {
        if (this.applet == null) {
            this.caller.setProgressMessage("Prescan: " + dir.getPath());
        } else {
            this.caller.setProgressMessage("Prescan: multiple files, multiple hosts, from server");
        }
        this.caller.setProgressIndeterminate(true);
        Parser_CEC parser = new Parser_CEC(this);
        if (this.applet == null) {
            ((Parser)parser).setFileName(dir.getPath());
        } else {
            ((Parser)parser).setFileName(null);
        }
        parser.setApplet(this.applet);
        ((Parser)parser).scanTimeLimits();
        if (!parser.isValid()) {
            System.out.println("No valid data found.");
            this.filetype = 0;
            return null;
        }
        this.filetype = (byte)3;
        return parser;
    }

    public void setProgressMessage(String s) {
        if (this.caller == null) {
            return;
        }
        this.caller.setProgressMessage(s);
    }

    private Parser loadSingleFile(String fileName) {
        this.singleHostFiles = new String[1];
        this.singleHostFiles[0] = fileName;
        this.caller.setProgressIndeterminate(true);
        Parser parser = new Parser_Nmon(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if nmon: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = 1;
            return parser;
        }
        parser = new Parser_Vmstat(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if vmstat: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = (byte)2;
            return parser;
        }
        parser = new Parser_Topas(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if topasout: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = ((Parser_Topas)parser).getType() == Parser_Topas.TOPASCEC ? (byte)7 : (byte)6;
            return parser;
        }
        parser = new Parser_Iostat(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if iostat: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = (byte)8;
            return parser;
        }
        parser = new Parser_Lslparutil(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if lslparutil: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = (byte)9;
            return parser;
        }
        parser = new Parser_Sar(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if sar: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = (byte)11;
            return parser;
        }
        parser = new Parser_Insight(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if Insight: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = (byte)12;
            return parser;
        }
        parser = new Parser_Snmp(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if Snmp: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = (byte)14;
            return parser;
        }
        parser = new Parser_Collectl(this);
        parser.setFileName(fileName);
        parser.setApplet(this.applet);
        this.caller.setProgressMessage("Check if Snmp: " + fileName);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = (byte)13;
            return parser;
        }
        this.filetype = 0;
        return null;
    }

    private Parser loadMultipleSourcesSingleHost(String[] fileNames) {
        int num = 0;
        int total_lines = 0;
        num = 0;
        GregorianCalendar start = null;
        GregorianCalendar end = null;
        byte myFileType = 0;
        int i = 0;
        while (i < fileNames.length) {
            Parser p = this.loadSingleFile(fileNames[i]);
            if (this.filetype != 1 && this.filetype != 9 && this.filetype != 6 && this.filetype != 11 && this.filetype != 12 && this.filetype != 13) {
                p = null;
            }
            if (p == null) {
                fileNames[i] = null;
            } else if (myFileType == 0) {
                myFileType = this.filetype;
                start = p.getStart();
                end = p.getEnd();
                ++num;
                total_lines += p.getTotal_lines();
            } else if (myFileType != this.filetype) {
                fileNames[i] = null;
            } else {
                GregorianCalendar gc = p.getStart();
                if (gc.before(start)) {
                    start = gc;
                }
                if ((gc = p.getEnd()).after(end)) {
                    end = gc;
                }
                ++num;
                total_lines += p.getTotal_lines();
            }
            ++i;
        }
        if (num == 0) {
            this.filetype = 0;
            return null;
        }
        this.filetype = myFileType;
        switch (this.filetype) {
            case 1: {
                this.parser = new Parser_Nmon(this);
                break;
            }
            case 6: {
                this.parser = new Parser_Topas(this);
                break;
            }
            case 9: {
                this.parser = new Parser_Lslparutil(this);
                break;
            }
            case 11: {
                this.parser = new Parser_Sar(this);
                break;
            }
            case 12: {
                this.parser = new Parser_Insight(this);
                break;
            }
            case 13: {
                this.parser = new Parser_Collectl(this);
                break;
            }
            default: {
                return null;
            }
        }
        this.parser.setFileName(fileNames[0]);
        this.parser.setApplet(this.applet);
        this.parser.setStart(start);
        this.parser.setEnd(end);
        this.parser.setTotal_lines(total_lines);
        this.singleHostFiles = new String[num];
        i = 0;
        int j = 0;
        while (i < fileNames.length) {
            if (fileNames[i] != null) {
                this.singleHostFiles[j++] = fileNames[i];
            }
            ++i;
        }
        return this.parser;
    }

    private Parser loadDirectorySingleHost(File dir) {
        int num = 0;
        String[] fileNames = null;
        File[] child = dir.listFiles();
        int i = 0;
        while (i < child.length) {
            if (child[i].isDirectory()) {
                child[i] = null;
            } else {
                ++num;
            }
            ++i;
        }
        fileNames = new String[num];
        i = 0;
        int j = 0;
        while (i < child.length) {
            if (child[i] != null) {
                fileNames[j++] = child[i].getPath();
            }
            ++i;
        }
        return this.loadMultipleSourcesSingleHost(fileNames);
    }

    private void parseData() {
        this.end = null;
        this.start = null;
        if (this.parser == null) {
            this.caller.setProgressMessage("No valid file selected");
            return;
        }
        this.caller.setProgressIndeterminate(false);
        if (this.source != null && this.source.isFile() || this.singleHost && this.singleHostFiles.length == 1) {
            if (this.applet == null) {
                this.caller.setProgressMessage("Parsing: " + this.source.getPath());
            } else {
                this.caller.setProgressMessage("Parsing: " + this.singleHostFiles[0]);
            }
            this.parser.parseData(true, true);
        } else if (this.singleHost) {
            this.caller.setProgressMessage("Parsing: " + this.singleHostFiles[0]);
            this.parser.setFileName(this.singleHostFiles[0]);
            this.parser.parseData(true, false);
            int i = 1;
            while (i < this.singleHostFiles.length - 1) {
                this.caller.setProgressMessage("Parsing: " + this.singleHostFiles[i]);
                this.parser.setFileName(this.singleHostFiles[i]);
                this.parser.parseData(false, false);
                ++i;
            }
            this.caller.setProgressMessage("Parsing: " + this.singleHostFiles[this.singleHostFiles.length - 1]);
            this.parser.setFileName(this.singleHostFiles[this.singleHostFiles.length - 1]);
            this.parser.parseData(false, true);
        } else if (this.configurationFile == null) {
            if (this.applet == null) {
                this.caller.setProgressMessage("Parsing: " + this.source.getPath());
            } else {
                this.caller.setProgressMessage("Parsing: multiple hosts");
            }
            this.parser.parseData(true, true);
        } else {
            this.caller.setProgressMessage("Parsing from configuration file");
            this.parser.parseData(true, true);
        }
        this.showReadProgress(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ParserManager parserManager = this;
        synchronized (parserManager) {
            if (this.numThreads != 0) {
                System.out.println("WARNING: avoided attempt to run two threads into ParserManager");
                return;
            }
            this.numThreads = (byte)(this.numThreads + 1);
        }
        this.caller.repaint();
        if (this.parser == null) {
            String[] files;
            this.parser = this.applet != null ? ((files = this.applet.getFiles()).length == 1 ? this.loadSingleFile(files[0]) : (this.singleHost ? this.loadMultipleSourcesSingleHost(files) : this.loadCECDirectory(null))) : (this.configurationFile == null ? (this.source.isFile() ? this.loadSingleFile(this.source.getPath()) : (this.source.isDirectory() && this.singleHost ? this.loadDirectorySingleHost(this.source) : this.loadCECDirectory(this.source))) : this.loadConfigurationFile());
        }
        if (this.start != null && this.end != null) {
            this.setLimits(this.start, this.end);
        }
        this.parseData();
        if (this.configurationFile != null) {
            this.caller.parsingComplete(this.configurationFile, this.parser);
        } else if (this.applet == null) {
            this.caller.parsingComplete(this.source.getPath(), this.parser);
        } else if (this.singleHost) {
            this.caller.parsingComplete(this.singleHostFiles[0], this.parser);
        } else {
            this.caller.parsingComplete("Multiple files provided by server", this.parser);
        }
        parserManager = this;
        synchronized (parserManager) {
            this.numThreads = (byte)(this.numThreads - 1);
        }
    }

    public void setSingleHost(boolean singleHost) {
        this.singleHost = singleHost;
    }

    public byte getFiletype() {
        return this.filetype;
    }

    public void setApplet(ViewerApplet applet) {
        this.applet = applet;
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
        this.parser = null;
    }
}

