/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.GregorianCalendar;
import java.util.zip.GZIPInputStream;
import pGraph.DataSet;
import pGraph.FileTokenizer;
import pGraph.ParserManager;
import pGraph.PerfData;
import pGraph.ViewerApplet;

public abstract class Parser {
    protected static final int MAX_TOPPROC = 4000;
    protected boolean avoidTop = false;
    protected boolean valid = false;
    protected GregorianCalendar start = null;
    protected GregorianCalendar end = null;
    protected int total_lines = 0;
    protected int lines_read;
    protected int current_file_line_read;
    protected ParserManager manager = null;
    protected String fileName = null;
    protected String cecName = null;
    protected ViewerApplet applet = null;
    protected PerfData perfData = new PerfData();
    protected boolean multipleLPAR = false;
    public static String AVG_CPU = "Avg-CPU";

    public abstract void scanTimeLimits();

    public abstract void parseData(boolean var1, boolean var2);

    protected void endOfData() {
        this.perfData.endOfData();
    }

    public void setEnd(GregorianCalendar calendar) {
        this.end = calendar;
    }

    public void setStart(GregorianCalendar calendar) {
        this.start = calendar;
    }

    public GregorianCalendar getEnd() {
        return this.end;
    }

    public GregorianCalendar getStart() {
        return this.start;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getCecName() {
        return this.cecName;
    }

    protected int getSlot(GregorianCalendar gc) {
        if (gc.before(this.start) || gc.after(this.end)) {
            return -1;
        }
        long a = this.start.getTime().getTime();
        long b = this.end.getTime().getTime();
        long x = gc.getTime().getTime();
        return (int)(1.0f * (float)(x - a) / (float)(b - a) * (float)(DataSet.SLOTS - 1));
    }

    public String[] getParserNames() {
        return null;
    }

    public Parser getParser(int num) {
        return null;
    }

    public PerfData getPerfData() {
        return this.perfData;
    }

    protected BufferedReader getReader() throws IOException {
        BufferedReader br = this.applet == null ? (this.fileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.fileName))), 0x100000) : new BufferedReader(new FileReader(this.fileName), 0x100000)) : (this.fileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(this.applet.getInputStream(this.fileName))), 0x100000) : new BufferedReader(new InputStreamReader(this.applet.getInputStream(this.fileName)), 0x100000));
        return br;
    }

    public void setTotal_lines(int total_lines) {
        this.total_lines = total_lines;
    }

    public int getTotal_lines() {
        return this.total_lines;
    }

    protected String readLineAndShowProgress(BufferedReader br) throws IOException {
        int step = this.total_lines < 100 ? 10 : this.total_lines / 100;
        String line = br.readLine();
        if (line == null) {
            return null;
        }
        ++this.lines_read;
        ++this.current_file_line_read;
        if (this.manager != null && this.lines_read % step == 0) {
            this.manager.showReadProgress((int)(100.0f * (float)this.lines_read / (float)this.total_lines));
        }
        return line;
    }

    protected int readLineAndShowProgress(FileTokenizer ft) {
        int step = this.total_lines < 100 ? 10 : this.total_lines / 100;
        int num = ft.readLine();
        if (num < 0) {
            return num;
        }
        ++this.lines_read;
        ++this.current_file_line_read;
        if (this.manager != null && this.lines_read % step == 0) {
            this.manager.showReadProgress((int)(100.0f * (float)this.lines_read / (float)this.total_lines));
        }
        return num;
    }

    public void setApplet(ViewerApplet applet) {
        this.applet = applet;
    }

    public void setMultipleLPAR(boolean multipleLPAR) {
        this.multipleLPAR = multipleLPAR;
    }

    public void setCpuWeight(float cpuWeight) {
        this.perfData.setCpuWeight(cpuWeight);
    }
}

