/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

public class DataSet
implements Cloneable {
    public static int SLOTS = 500;
    protected boolean endOfInputData = false;
    private float[] data = null;
    private float min;
    private float avg;
    private float max;
    private int[] counter = null;
    private String name = null;
    private boolean absLimitActive = true;
    private float[] absMin = null;
    private float[] absMax = null;
    private float m;
    private float s;
    private float devstd;
    private float numSamples;
    private float weight = 1.0f;

    public DataSet(String name) {
        this.name = name;
        this.endOfInputData = false;
        this.min = Float.POSITIVE_INFINITY;
        this.avg = 0.0f;
        this.max = Float.NEGATIVE_INFINITY;
        this.devstd = -1.0f;
        this.s = -1.0f;
        this.m = -1.0f;
        this.numSamples = 0.0f;
    }

    public void reset() {
        this.endOfInputData = false;
        this.data = null;
        this.min = Float.MAX_VALUE;
        this.avg = 0.0f;
        this.max = Float.MIN_VALUE;
        this.counter = null;
        this.devstd = -1.0f;
        this.s = -1.0f;
        this.m = -1.0f;
        this.numSamples = 0.0f;
        this.absMax = null;
        this.absMin = null;
    }

    public DataSet clone(String newName) {
        DataSet result;
        try {
            result = (DataSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        result.name = newName;
        return result;
    }

    public boolean isValid() {
        return this.data != null && this.endOfInputData;
    }

    public void add(int slot, float value) {
        if (slot < 0 || slot >= SLOTS || this.endOfInputData) {
            return;
        }
        if (value < 0.0f) {
            return;
        }
        if (this.data == null) {
            this.data = new float[SLOTS];
            this.counter = new int[SLOTS];
            if (this.absLimitActive) {
                this.absMax = new float[SLOTS];
                this.absMin = new float[SLOTS];
                int i = 0;
                while (i < SLOTS) {
                    this.absMin[i] = Float.MAX_VALUE;
                    this.absMax[i] = Float.MIN_VALUE;
                    ++i;
                }
            }
        }
        int n = slot;
        this.data[n] = this.data[n] + value;
        int n2 = slot;
        this.counter[n2] = this.counter[n2] + 1;
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.avg += value;
        if (this.numSamples == 0.0f) {
            this.m = value;
            this.s = 0.0f;
            this.numSamples = 1.0f;
        } else {
            float prev_m = this.m;
            float prev_s = this.s;
            this.numSamples += 1.0f;
            this.m = prev_m + (value - prev_m) / this.numSamples;
            this.s = prev_s + (value - prev_m) * (value - this.m);
        }
        if (this.absLimitActive) {
            if (value < this.absMin[slot]) {
                this.absMin[slot] = value;
            }
            if (value > this.absMax[slot]) {
                this.absMax[slot] = value;
            }
        }
    }

    public void addBySlot(int slot, float value) {
        if (slot < 0 || slot >= SLOTS || this.endOfInputData) {
            return;
        }
        if (value < 0.0f) {
            return;
        }
        if (this.data == null) {
            this.data = new float[SLOTS];
            this.counter = new int[SLOTS];
            if (this.absLimitActive) {
                this.absMax = new float[SLOTS];
                this.absMin = new float[SLOTS];
                int i = 0;
                while (i < SLOTS) {
                    this.absMin[i] = Float.MAX_VALUE;
                    this.absMax[i] = Float.MIN_VALUE;
                    ++i;
                }
            }
        }
        this.data[slot] = value;
        this.counter[slot] = 1;
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.avg += value;
        if (this.numSamples == 0.0f) {
            this.m = value;
            this.s = 0.0f;
            this.numSamples = 1.0f;
        } else {
            float prev_m = this.m;
            float prev_s = this.s;
            this.numSamples += 1.0f;
            this.m = prev_m + (value - prev_m) / this.numSamples;
            this.s = prev_s + (value - prev_m) * (value - this.m);
        }
    }

    public void addBySlot(int slot, float value, float vmin, float vmax) {
        if (slot < 0 || slot >= SLOTS || this.endOfInputData) {
            return;
        }
        if (value < 0.0f) {
            return;
        }
        this.addBySlot(slot, value);
        this.absMin[slot] = vmin;
        this.absMax[slot] = vmax;
        if (vmin < this.min) {
            this.min = vmin;
        }
        if (vmax > this.max) {
            this.max = vmax;
        }
    }

    public void endOfData() {
        if (this.data == null) {
            return;
        }
        int num = 0;
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = this.counter[i] == 0 ? -1.0f : this.data[i] * this.weight / (float)this.counter[i];
            num += this.counter[i];
            ++i;
        }
        this.avg = this.avg * this.weight / (float)num;
        this.min *= this.weight;
        this.max *= this.weight;
        this.devstd = (float)Math.sqrt(this.s / (this.numSamples - 1.0f));
        if (this.absLimitActive) {
            i = 0;
            while (i < this.data.length) {
                if (this.data[i] < 0.0f) {
                    this.absMin[i] = -1.0f;
                    this.absMax[i] = -1.0f;
                } else {
                    this.absMin[i] = this.absMin[i] * this.weight;
                    this.absMax[i] = this.absMax[i] * this.weight;
                }
                ++i;
            }
        }
        this.endOfInputData = true;
    }

    public void endOfDataSpecial() {
        if (this.data == null) {
            return;
        }
        int num = 0;
        this.min = Float.MAX_VALUE;
        this.max = Float.MIN_VALUE;
        int i = 0;
        while (i < this.data.length) {
            if (this.counter[i] == 0) {
                this.data[i] = -1.0f;
            } else {
                this.counter[i] = 1;
                ++num;
                if (this.data[i] < this.min) {
                    this.min = this.data[i];
                }
                if (this.data[i] > this.max) {
                    this.max = this.data[i];
                }
                if (num == 1) {
                    this.m = this.data[i];
                    this.s = 0.0f;
                    this.numSamples = 1.0f;
                } else {
                    float prev_m = this.m;
                    float prev_s = this.s;
                    this.numSamples += 1.0f;
                    this.m = prev_m + (this.data[i] - prev_m) / this.numSamples;
                    this.s = prev_s + (this.data[i] - prev_m) * (this.data[i] - this.m);
                }
            }
            ++i;
        }
        this.avg /= (float)num;
        this.devstd = (float)Math.sqrt(this.s / (this.numSamples - 1.0f));
        this.absLimitActive = false;
        this.endOfInputData = true;
    }

    protected float twoDigits(float f) {
        if (f < 0.0f) {
            return -1.0f;
        }
        return 1.0f * (float)((int)(f * 100.0f)) / 100.0f;
    }

    public float getValue(int slot) {
        if (this.data == null) {
            return -1.0f;
        }
        if (slot < 0 || slot >= SLOTS) {
            return -1.0f;
        }
        if (this.counter[slot] == 0) {
            return -1.0f;
        }
        return this.twoDigits(this.data[slot]);
    }

    public float getAbsMin(int slot) {
        if (this.absMin == null) {
            return -1.0f;
        }
        if (slot < 0 || slot >= SLOTS) {
            return -1.0f;
        }
        if (this.counter[slot] == 0) {
            return -1.0f;
        }
        return this.twoDigits(this.absMin[slot]);
    }

    public float getAbsMax(int slot) {
        if (this.absMax == null) {
            return -1.0f;
        }
        if (slot < 0 || slot >= SLOTS) {
            return -1.0f;
        }
        if (this.counter[slot] == 0) {
            return -1.0f;
        }
        return this.twoDigits(this.absMax[slot]);
    }

    public float getMin() {
        return this.twoDigits(this.min);
    }

    public float getAvg() {
        return this.twoDigits(this.avg);
    }

    public float getMax() {
        return this.twoDigits(this.max);
    }

    public float getDevStd() {
        return this.twoDigits(this.devstd);
    }

    public int getNearestValidSlot(int slot) {
        if (this.data == null) {
            return -1;
        }
        int pre = this.getNearestValidSlotLeft(slot);
        int post = this.getNearestValidSlotRight(slot);
        if (post == SLOTS) {
            return pre;
        }
        if (pre < 0) {
            return post;
        }
        if (slot - pre < post - slot) {
            return pre;
        }
        return post;
    }

    public int getNearestValidSlotLeft(int slot) {
        if (this.data == null) {
            return -1;
        }
        if (slot < 0) {
            return -1;
        }
        if (slot >= SLOTS) {
            slot = SLOTS - 1;
        }
        int pre = slot;
        while (pre >= 0 && this.counter[pre] == 0) {
            --pre;
        }
        return pre;
    }

    public int getNearestValidSlotRight(int slot) {
        if (this.data == null) {
            return -1;
        }
        if (slot < 0) {
            slot = 0;
        }
        if (slot >= SLOTS) {
            return SLOTS;
        }
        int post = slot;
        while (post < SLOTS && this.counter[post] == 0) {
            ++post;
        }
        return post;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public boolean isAbsLimitActive() {
        return this.absLimitActive;
    }

    public void setAbsLimitActive(boolean absLimitActive) {
        this.absLimitActive = absLimitActive;
    }
}

