/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Console
extends JFrame
implements Runnable {
    private static final long serialVersionUID = -3902418647512280344L;
    private JTextArea textArea = null;
    private PipedInputStream pis_out = new PipedInputStream();
    private PipedInputStream pis_err = new PipedInputStream();
    private Thread outThread;
    private Thread errThread;
    private static final int MAXBUFFER = 1024;
    private byte[] out_buffer = new byte[1024];
    private byte[] err_buffer = new byte[1024];

    public Console() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width, screenSize.height / 5);
        this.setLocation(0, screenSize.height / 5 * 4);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
        this.setVisible(false);
        this.setDefaultCloseOperation(1);
        this.setName("pGraph Console");
        this.setTitle("pGraph Console");
        try {
            PipedOutputStream pos_out = new PipedOutputStream(this.pis_out);
            System.setOut(new PrintStream(pos_out, true));
        }
        catch (Exception e) {
            this.textArea.append("Couldn't redirect STDOUT to this console\n" + e.getMessage());
        }
        try {
            PipedOutputStream pos_err = new PipedOutputStream(this.pis_err);
            System.setErr(new PrintStream(pos_err, true));
        }
        catch (Exception e) {
            this.textArea.append("Couldn't redirect STDERR to this console\n" + e.getMessage());
        }
        this.outThread = new Thread(this);
        this.outThread.setDaemon(true);
        this.outThread.start();
        this.errThread = new Thread(this);
        this.errThread.setDaemon(true);
        this.errThread.start();
    }

    private synchronized void writeData(PipedInputStream pis) throws IOException {
        boolean out_of_memory = false;
        byte[] buffer = pis == this.pis_out ? this.out_buffer : this.err_buffer;
        int num = pis.available();
        if (num == 0) {
            return;
        }
        this.setVisible(true);
        GregorianCalendar gc = new GregorianCalendar();
        String hour = " ";
        int read = gc.get(11);
        hour = read < 10 ? String.valueOf(hour) + "0" + read + ":" : String.valueOf(hour) + read + ":";
        read = gc.get(12);
        hour = read < 10 ? String.valueOf(hour) + "0" + read + ":" : String.valueOf(hour) + read + ":";
        read = gc.get(13);
        hour = read < 10 ? String.valueOf(hour) + "0" + read : String.valueOf(hour) + read;
        this.textArea.append("\n\n==========================================================================\n");
        this.textArea.append(hour);
        this.textArea.append("\n==========================================================================\n");
        while (num > 0) {
            read = pis.read(buffer, 0, 1024);
            String s = new String(buffer, 0, read);
            this.textArea.append(s);
            num -= read;
            if (s.indexOf("OutOfMemoryError") < 0) continue;
            out_of_memory = true;
        }
        if (out_of_memory) {
            this.textArea.append("\n\nIncrease maximum Java memory using the -X switch.");
            this.textArea.append("\nExample (200MB): java -Xmx200m -cp pGraph.jar pGraph.Viewer");
        }
    }

    public synchronized void run() {
        try {
            while (Thread.currentThread() == this.outThread) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.writeData(this.pis_out);
            }
            while (Thread.currentThread() == this.errThread) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.writeData(this.pis_err);
            }
        }
        catch (Exception e) {
            this.textArea.append("\nConsole reports an Internal error.");
            this.textArea.append("The error is: " + e);
        }
    }
}

