/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Graphics;
import pGraph.DataSet;
import pGraph.GenericPanel;
import pGraph.GlobalConfig;

public class CPUPerfPanel
extends GenericPanel {
    private static final long serialVersionUID = -1735174618520322946L;

    public CPUPerfPanel(GlobalConfig config) {
        super(config);
    }

    public void paint(Graphics g) {
        super.paintComponent(g);
        int ysize = this.getHeight() - this.TEXT_SPACE;
        int x = -1;
        int usx = 0;
        int syx = 0;
        int wax = 0;
        int[] px = new int[4];
        int[] py = new int[4];
        float[] v = new float[3];
        g.setColor(this.configuration.getIdColor());
        g.fillRect(0, 0, DataSet.SLOTS, ysize);
        int i = 0;
        while (i < DataSet.SLOTS) {
            int j = 0;
            while (j < 3) {
                v[j] = this.dataSet[j].getValue(i);
                ++j;
            }
            if (v[0] < 0.0f || v[1] < 0.0f || v[2] < 0.0f) {
                g.setColor(this.configuration.getGraphBackColor());
                g.drawLine(i, 0, i, ysize - 1);
            } else {
                int us = (int)(1.0f * v[0] * (float)(ysize - 1) / 100.0f);
                int sy = (int)(1.0f * v[1] * (float)(ysize - 1) / 100.0f);
                int wa = (int)(1.0f * v[2] * (float)(ysize - 1) / 100.0f);
                if (i > 0 && x >= 0 && x < i - 1) {
                    g.setColor(this.configuration.getUsColor());
                    px[0] = x + 1;
                    py[0] = ysize;
                    px[1] = x + 1;
                    py[1] = usx;
                    px[2] = i - 1;
                    py[2] = ysize - us;
                    px[3] = i - 1;
                    py[3] = ysize;
                    g.drawPolygon(px, py, 4);
                    g.fillPolygon(px, py, 4);
                    g.setColor(this.configuration.getSyColor());
                    px[0] = x + 1;
                    py[0] = usx;
                    px[1] = x + 1;
                    py[1] = syx;
                    px[2] = i - 1;
                    py[2] = ysize - us - sy;
                    px[3] = i - 1;
                    py[3] = ysize - us - 1;
                    g.drawPolygon(px, py, 4);
                    g.fillPolygon(px, py, 4);
                    g.setColor(this.configuration.getWaColor());
                    px[0] = x + 1;
                    py[0] = -1;
                    px[1] = x + 1;
                    py[1] = wax - 1;
                    px[2] = i - 1;
                    py[2] = wa - 1;
                    px[3] = i - 1;
                    py[3] = -1;
                    g.drawPolygon(px, py, 4);
                    g.fillPolygon(px, py, 4);
                }
                g.setColor(this.configuration.getUsColor());
                if (us > 0) {
                    g.drawLine(i, ysize - 1, i, ysize - us);
                }
                g.setColor(this.configuration.getSyColor());
                if (sy > 0) {
                    g.drawLine(i, ysize - us - 1, i, ysize - us - sy);
                }
                g.setColor(this.configuration.getWaColor());
                if (wa > 0) {
                    g.drawLine(i, 0, i, wa);
                }
                x = i;
                usx = ysize - us;
                syx = ysize - us - sy;
                wax = wa;
            }
            ++i;
        }
        this.drawZoomBars(g);
        this.drawGrid(g);
        this.drawLimits(g);
    }
}

