/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import pGraph.DataSet;
import pGraph.GenericPanel;
import pGraph.GlobalConfig;
import pGraph.PerfData;
import pGraph.XYPanel;

public class AvgSumXYPanel
extends XYPanel {
    private static final long serialVersionUID = 3819142265041879154L;
    private final byte BLOCK = (byte)5;
    private DataSet[][] sourceData = null;
    private DataSet[] weightData = null;
    private GenericPanel[] sourcePanel = null;
    private boolean[] selected = null;
    private int numData = 0;

    public AvgSumXYPanel(PerfData perfData, GlobalConfig config) {
        super(config);
        this.perfData = perfData;
    }

    public void selectAll() {
        int i = 0;
        while (i < this.numData) {
            this.selected[i] = true;
            ++i;
        }
        this.computeData();
    }

    public void deselectAll() {
        int i = 0;
        while (i < this.numData) {
            this.selected[i] = false;
            ++i;
        }
        this.computeData();
    }

    public void panelIsSelected(GenericPanel jp, boolean isSelected) {
        int i = 0;
        while (i < this.numData) {
            if (jp == this.sourcePanel[i]) {
                if (isSelected != this.selected[i]) {
                    this.selected[i] = isSelected;
                    this.computeData();
                }
                return;
            }
            ++i;
        }
    }

    public void zoom() {
        this.computeData();
        super.zoom();
    }

    private void computeDataExact() {
        int i = 0;
        while (i < this.dataSet.length) {
            if (this.dataSet[i] != null) {
                int slot = 0;
                while (slot < DataSet.SLOTS) {
                    float sum = -1.0f;
                    float weightedSum = -1.0f;
                    int j = 0;
                    while (j < this.numData) {
                        if (this.selected[j] && this.sourceData[j][i] != null && this.weightData[j] != null) {
                            float v = this.sourceData[j][i].getValue(slot);
                            float w = this.weightData[j].getValue(slot);
                            if (v >= 0.0f && w >= 0.0f) {
                                weightedSum = weightedSum >= 0.0f ? (weightedSum += v * w) : v * w;
                                sum = sum >= 0.0f ? (sum += w) : w;
                            }
                        }
                        ++j;
                    }
                    if (sum > 0.0f) {
                        this.dataSet[i].add(slot, weightedSum / sum);
                    }
                    ++slot;
                }
                this.dataSet[i].endOfData();
            }
            ++i;
        }
    }

    public void computeData() {
        if (this.dataSet == null) {
            this.dataSet = new DataSet[this.sourceData[0].length];
            int i = 0;
            while (i < this.dataSet.length) {
                int j = 0;
                while (j < this.sourceData.length) {
                    if (this.sourceData[j][i] != null) break;
                    ++j;
                }
                this.dataSet[i] = j < this.sourceData.length ? new DataSet(this.sourceData[0][i].getName()) : null;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dataSet.length) {
                if (this.dataSet[i] != null) {
                    this.dataSet[i].reset();
                }
                ++i;
            }
        }
        this.computeDataExact();
        this.computeMaxValue();
    }

    public void addPanel(DataSet[] ds, DataSet we, GenericPanel jp) {
        int i;
        if (this.sourceData == null) {
            this.sourceData = new DataSet[5][ds.length];
            this.weightData = new DataSet[5];
            int i2 = 0;
            while (i2 < ds.length) {
                this.sourceData[0][i2] = ds[i2];
                ++i2;
            }
            this.weightData[0] = we;
            this.sourcePanel = new GenericPanel[5];
            this.sourcePanel[0] = jp;
            this.selected = new boolean[5];
            this.selected[0] = true;
            this.numData = 1;
            return;
        }
        if (ds.length != this.sourceData[0].length) {
            System.out.println("SumXYPanel: unexpected number of DataSet values");
            return;
        }
        if (this.numData == this.sourceData.length) {
            DataSet[][] oldSourceData = this.sourceData;
            DataSet[] oldWeightData = this.weightData;
            GenericPanel[] oldSourcePanel = this.sourcePanel;
            boolean[] oldSelected = this.selected;
            this.sourceData = new DataSet[oldSourceData.length + 5][oldSourceData[0].length];
            this.weightData = new DataSet[oldSourceData.length + 5];
            this.sourcePanel = new GenericPanel[oldSourceData.length + 5];
            this.selected = new boolean[oldSourceData.length + 5];
            i = 0;
            while (i < oldSourceData.length) {
                int j = 0;
                while (j < oldSourceData[0].length) {
                    this.sourceData[i][j] = oldSourceData[i][j];
                    ++j;
                }
                this.weightData[i] = oldWeightData[i];
                this.sourcePanel[i] = oldSourcePanel[i];
                this.selected[i] = oldSelected[i];
                ++i;
            }
        }
        i = 0;
        while (i < ds.length) {
            this.sourceData[this.numData][i] = ds[i];
            ++i;
        }
        this.weightData[this.numData] = we;
        this.sourcePanel[this.numData] = jp;
        this.selected[this.numData] = true;
        ++this.numData;
    }
}

