#!/bin/sh

# *************************************************************************
# This script is used to initialize common maximo environment variables.
#
# Here is the list of variables.
#
# MAXIMO_HOME
#
# MAXIMO_CLASSPATH
#
# *************************************************************************


# MAXIMO_HOME
if [ "$1" != "" ] ; then
   export MAXIMO_HOME=$1/../..
else
   export MAXIMO_HOME=../..
fi

# MAXIMO_ROOT
export MAXIMO_ROOT=$MAXIMO_HOME/applications/maximo

# MAXIMO_LIB_PATH
export MAXIMO_LIB_PATH=$MAXIMO_ROOT/lib

# MAXIMO_COMMON_LIBS
export MAXIMO_8-20120326.jar:$MAXIMO_ROOT/properties:$MAXIMO_ROOT/resources:$MAXIMO_ROOT/businessobjects/classes:$MAXIMO_ROOT/maximouiweb/webmodule/WEB-INF/classes:$MAXIMO_LIB_PATH/j2ee.jar:$MAXIMO_LIB_PATH/log4j-1.2.16.jar:$MAXIMO_LIB_PATH/poi-3.8-20120326.jar:$MAXIMO_LIB_PATH/poi-excelant-3.8-20120326.jar:$MAXIMO_LIB_PATH/bcel-5.2.jar:$MAXIMO_LIB_PATH/tools.jar:$MAXIMO_LIB_PATH/icu4j.jar


# MAXIMO_DB_LIBS
export MAXIMO_DB_LIBS=$MAXIMO_LIB_PATH/oraclethin.jar:$MAXIMO_LIB_PATH/Opta.jar:$MAXIMO_LIB_PATH/sqljdbc.jar:$MAXIMO_LIB_PATH/db2jcc.jar:$MAXIMO_LIB_PATH/db2jcc_license_cu.jar:$MAXIMO_LIB_PATH/jaxen-1.1-beta-8.jar

# MAXIMO_XML_LIBS
export MAXIMO_XML_LIBS=$MAXIMO_LIB_PATH/jdom.jar:$MAXIMO_LIB_PATH/xercersImpl.jar

# MAXIMO_MEA_LIBS
export MAXIMO_MEA_LIBS=$MAXIMO_LIB_PATH/jaxrpc.jar:$MAXIMO_LIB_PATH/saaj.jar:$MAXIMO_LIB_PATH/uddi4j.jar:$MAXIMO_LIB_PATH/wsdl4j.jar:$MAXIMO_LIB_PATH/jaxen-full.jar:$MAXIMO_LIB_PATH/saxpath.jar::$MAXIMO_LIB_PATH/commons-discovery.jar:$MAXIMO_LIB_PATH/commons-logging.jar:$MAXIMO_LIB_PATH/axis.jar:$MAXIMO_LIB_PATH/axis-ant.jar:$MAXIMO_XML_LIBS

# MAXIMO_REPORT
MAXIMO_REPORT=$MAXIMO_HOME/reports/birt/tools/classes


# MAXIMO_CLASSPATH
# export MAXIMO_CLASSPATH=.:$MAXIMO_COMMON_LIBS:$MAXIMO_DB_LIBS
export MAXIMO_CLASSPATH=.:$MAXIMO_COMMON_LIBS:$MAXIMO_DB_LIBS:$MAXIMO_XML_LIBS:$MAXIMO_REPORT

export MEMORY_ARGS=-Xmx1024m

# optional parameter, for example -Djava.net.preferIPv4Stack=true
export IPV_ARGS=