//RMMEX2  JOB ...
//******************************************************************
//* DFSORT/ICETOOL STORAGE ADMINISTRATOR EXAMPLES
//* DFSMSRMM EXAMPLE 2: CREATE AV COMMANDS
//* CREATES DFSMSRMM ADDVOLUME COMMANDS FOR IDENTIFIED LOST TAPES TO
//* RECOVER.  REQUIRES AN OLD EXTRACT DATA SET WHICH CONTAINS ALL THE
//* INFORMATION ABOUT THE LOST TAPES.
//*   INPUT:
//*     IN1 DD:  LOST TAPE DATA SET - A VARIABLE-LENGTH DATA SET
//*              CONTAINING THE RACK NUMBERS (IN POSITIONS 6-11)
//*              OF THE TAPES TO BE RECOVERED.
//*     IN2 DD:  OLD DFSMSRMM EXTRACT DATA SET - AN OLD DFSMSRMM
//*              EXTRACT DATA SET CONTAINING INFORMATION ABOUT THE
//*              TAPES BEFORE LOSS (CREATED WITH JULIAN DATES).
//*   OUTPUT:
//*     COMMANDS DD:  CLIST OF CREATED DFSMSRMM ADDVOLUME COMMANDS
//*                   FOR THE LOST TAPES
//*********************************************************************
//STEP1   EXEC  PGM=ICETOOL
//TOOLMSG DD  SYSOUT=*
//IN1     DD DSN=Y897797.R10.CLIST.OLD(LOSTTAPE),DISP=SHR
//IN2     DD DSN=Y897797.MASTER.EXTRACT,DISP=SHR
//OUT1    DD DSN=&O1,DISP=(,PASS),UNIT=SYSDA,
// SPACE=(CYL,(2,1))
//OUT2    DD DSN=&O2,DISP=(,PASS),UNIT=SYSDA,
// SPACE=(CYL,(2,1))
//* PUT OLD EXTRACT DATA SET FIRST TO GET RECORDS WITH
//* NEEDED INFORMATION
//CONCAT  DD DSN=*.OUT2,VOL=REF=*.OUT2,DISP=(OLD,PASS)
//        DD DSN=*.OUT1,VOL=REF=*.OUT1,DISP=(OLD,PASS)
//OUT3    DD DSN=&O3,DISP=(,PASS),UNIT=SYSDA,
// SPACE=(CYL,(2,1))
//FINAL   DD DSN=&TEMP,DISP=(,PASS),UNIT=SYSDA,SPACE=(CYL,(2,1))
//COMMANDS DD DSN=Y897797.RMM.RECOVERD.CLIST,DISP=(,CATLG),
//    LRECL=370,RECFM=VB,DSORG=PS,AVGREC=K,SPACE=(370,(1,1),RLSE)
//DFSMSG    DD  SYSOUT=*
//TOOLIN DD *
** CREATE NEW DATA SETS WITH FIELD IN SAME COLUMNS
*    MOVE RACK NUMBER (6,6,CH) FIELD FROM LOST TAPE DATA SET
*    TO POSITION 5
  COPY FROM(IN1) TO(OUT1) USING(CPY1)
*    MOVE RACK NUMBER (365,6,CH) FIELD FROM OLD EXTRACT DATA SET
*    TO POSITION 5
*    MOVE OTHER INFORMATION (9,500,CH) FIELDS FROM
*    OLD EXTRACT DATA SET TO POSITION 11
  COPY FROM(IN2) TO(OUT2) USING(CPY2)
* SELECT ONLY THE RECORDS WITH DUPLICATE RACK NUMBERS
  SELECT FROM(CONCAT) TO(OUT3) ON(5,6,CH) ALLDUPS
* KEEP ONLY THE FIRST OF THE RECORDS WITH DUPLICATE RACK NUMBERS
  SELECT FROM(OUT3) TO(FINAL) ON(5,6,CH) FIRST
* BUILD ADDVOLUME COMMANDS USING OUTFIL'S OUTREC/LOOKUP/CHANGE
  COPY FROM(FINAL) USING(CMDT)
//CPY1CNTL DD *
  OUTREC FIELDS=(1,4,6,6)
//CPY2CNTL DD *
  INCLUDE COND=(5,1,CH,EQ,C'V')
  OUTREC FIELDS=(1,4,365,6,9,500)
//CMDTCNTL DD *
* BUILD ADDVOLUME COMMANDS USING OUTFIL - TO ACCOUNT FOR
* CPY2CNTL REFORMATTING, ADD 7 TO THE OFFSETS IN THE DFSMSRMM BOOK
 OUTFIL FNAMES=COMMANDS,
  OUTREC=(1,4,C' AV ',11,6,
   C' STATUS(',324,8,C')',
   C' RACK(',367,8,C')',
   C' UNIT(',359,8,C')',
   C' LABEL(',339,3,C')',
* LOOKUP TABLE IS USED TO CHANGE '****' TO '*' IN DENSITY FIELD
   C' DENSITY(',
     131,4,CHANGE=(4,C'****',C'*'),NOMATCH=(131,4),
    C')',
* LOOKUP TABLE IS USED TO CHANGE FLAGS TO WORDS IN USE FIELD
   C' USE(',
     357,2,CHANGE=(6,C'YY',C'MVS VM',C'YN',C'MVS',C'NY',C'VM'),
           NOMATCH=(C' '),
    C')',
   C' DESCRIPTION(''',447,30,C''')',
   C' ACCOUNT(''',407,40,C''')',
* ASSUMES DATE CREATED IN JULIAN FORMAT
   C' EXPDT(',121,8,C')',
* LOOKUP TABLE IS USED TO CHANGE FLAG TO WORD IN OWNERACCESS FIELD:
   C' OWNERACCESS(',
     355,1,CHANGE=(6,C'R',C'READ',C'U',C'UPDATE',C'A',C'ALTER'),
     NOMATCH=(C' '),
    C')',
* LOOKUP TABLE IS USED TO CHANGE BLANK TO 'NONE' IN SECLEVEL FIELD
   C' SECLEVEL(',
     282,1,CHANGE=(8,C' ',C'NONE'),NOMATCH=(282,8),
    C')',
   C' OWNER(',258,8,C')',
* ASSUMES DATE CREATED IN JULIAN FORMAT
   C' ASDATE(',242,8,C')',
   C' ASTIME(',252,6,C')',
* LOOKUP TABLE IS USED TO CHANGE 'OWNER' TO 'RETURN'
   C' RELEASEACTION(',
     343,8,CHANGE=(8,C'OWNER',C'RETURN'),NOMATCH=(343,8),
* LOOKUP TABLE IS USED TO CHANGE FLAGS TO WORDS IN RELEASEACTION FIELD
     351,1,CHANGE=(7,C'Y',C'REPLACE'),NOMATCH=(C' '),X,
     352,1,CHANGE=(4,C'Y',C'INIT'),NOMATCH=(C' '),X,
     353,1,CHANGE=(5,C'Y',C'ERASE'),NOMATCH=(C' '),X,
     354,1,CHANGE=(6,C'Y',C'NOTIFY'),NOMATCH=(C' '),
    C')',
   370:X)  PAD OUT RECORDS TO 370 BYTES
/*
