//DCOLEX3  JOB ...
//******************************************************************
//* DFSORT/ICETOOL STORAGE ADMINISTRATOR EXAMPLES
//* DCOLLECT EXAMPLE 3: CAPACITY PLANNING
//*   CAPACITY PLANNING ANALYSIS AND REPORTS.
//******************************************************************
//S1      EXEC  PGM=ICETOOL,REGION=1024K
//DFSMSG    DD  SYSOUT=*
//TOOLMSG   DD  SYSOUT=*
//INDD      DD  DSN=USERGRP.DCOLLECT,DISP=SHR
//OUTDD1    DD  DSN=&&TEMP1,DISP=(NEW,PASS),LIKE=USERGRP.DCOLLECT
//SGVOLS    DD  SYSOUT=*
//OUTDD2    DD  DSN=&&TEMP2,DISP=(NEW,PASS),LIKE=USERGRP.DCOLLECT
//SCRPT     DD  SYSOUT=*
//OUTDD3    DD  DSN=&&TEMP3,DISP=(NEW,PASS),LIKE=USERGRP.DCOLLECT
//VOLRPT    DD  SYSOUT=*
//TOOLIN    DD  *
* Part 1
*  Show the number of system-managed data sets that may be reblocked
*  Include only D-type records with DCDSMSM and DCDREBLK flags on
   COUNT FROM(INDD) USING(SMSM)
* Part 2
*  Create a temporary data set with only 'V' type records
   COPY FROM(INDD) TO(OUTDD1) USING(CPY1)
*  Show volume free space statistics
   STATS FROM(OUTDD1) ON(40,1,BI)
*  Show the number of volumes with free space > 30%
   RANGE FROM(OUTDD1) ON(40,1,BI) HIGHER(30)
* Part 3
*  Print a report showing the number of volumes in each storage group
   OCCUR FROM(OUTDD1) LIST(SGVOLS) BLANK -
    DATE TITLE('Volumes in Each Storage Group') -
    HEADER('Storage Group') HEADER('Volume Count') -
    ON(87,30,CH)                   ON(VALCNT)
* Part 4
*  Create a temporary data set containing data set records that
*  are sorted by storage class, with the allocated space totalled
*  (SUMmed)
   SORT FROM(INDD) TO(OUTDD2) USING(SRT1)
*  Print a report showing total allocated space by storage class
*  including the maximum, minimum and average allocated space
   DISPLAY FROM(OUTDD2) LIST(SCRPT) BLANK -
    TITLE('Total Allocated Space (KB) by Storage Class') DATE TIME -
    HEADER('Storage Class')  HEADER('Total Space (KB)') -
    ON(171,10,CH)                  ON(93,4,BI) -
    MAXIMUM('Most Space:') MINIMUM('Least Space:') -
    AVERAGE('Average Space:')
* Part 5
*   Create a temporary data set that contains:
*    - Type 'C' capacity planning records,
*    - Occupancy after processing > target occupancy, and
*    - Volume level is L0
   COPY FROM(INDD) TO(OUTDD3) USING(CPY2)
*   Print a report showing volume serial number, target occupancy,
*   occupancy after processing and date
    DISPLAY FROM(OUTDD3) LIST(VOLRPT) BLANK -
      DATE(DMY.) TITLE('Volumes Not Meeting Target Threshold') -
      HEADER('Volume') ON(29,6,CH) -
      HEADER('Target Occupancy') ON(45,1,FI) -
      HEADER('Occupancy After Processing') ON(48,1,FI) -
      HEADER('Date') ON(35,4,PD)
//SMSMCNTL DD *
* Include only D-type records with DCDSMSM and DCDREBLK flags on
  OPTION VLSHRT
  INCLUDE COND=(9,1,CH,EQ,C'D',AND,74,1,BI,EQ,B'.1...1..')
/*
//CPY1CNTL DD *
* Include only V-type records
 INCLUDE COND=(9,1,CH,EQ,C'V')
/*
//SRT1CNTL DD *
* Include only D-type records, sort by storage class and
* sum (total) allocated space
 INCLUDE COND=(9,1,CH,EQ,C'D')
 SORT FIELDS=(171,10,CH,A)
 SUM FIELDS=(93,4,BI)
/*
//CPY2CNTL DD *
* Include only C-type records with volume level of L0 and
* occupancy after processing > target occupancy
 OPTION VLSHRT
 INCLUDE COND=((9,1,CH,EQ,C'C'),&,
               (39,1,BI,EQ,X'00'),&,
               (48,1,FI,GT,45,1,FI))
/*
//*
