//DCOLEX2  JOB ...
//******************************************************************
//* DFSORT/ICETOOL STORAGE ADMINISTRATOR EXAMPLES
//* DCOLLECT EXAMPLE 2: CONVERSION REPORTS
//*   ASSIGN ENGLISH DESCRIPTIONS TO BIT FLAGS TO SHOW MIGRATION
//*   STATUS OF VOLUMES (IN CONVERSION, MANAGED BY SMS AND
//*   NON-SMS MANAGED).
//******************************************************************
//STEP1  EXEC  PGM=ICETOOL
//TOOLMSG  DD SYSOUT=*   ICETOOL MESSAGES
//DFSMSG   DD SYSOUT=*   DFSORT  MESSAGES
//TOOLIN   DD *          CONTROL STATEMENTS
* PART 1 - ADD IDENTIFYING STATUS (FLAG) DESCRIPTION FOR 'MANAGED',
*          'IN CONVERSION' AND 'NON-MANAGED' VOLUME RECORDS
   COPY FROM(DCOLALL) USING(FLAG)
* PART 2 - PRINT REPORT SHOWING COUNT OF EACH STATUS TYPE
   OCCUR FROM(STATUS) LIST(REPORTS) -
    TITLE('STATUS COUNT REPORT') DATE -
    BLANK -
    HEADER('STATUS') ON(7,20,CH) -
    HEADER('NUMBER OF VOLUMES') ON(VALCNT)
* PART 3 - PRINT REPORT SORTED BY VOLUMES AND STATUS
  SORT FROM(STATUS) TO(SRTVOUT) USING(SRTV)
  DISPLAY FROM(SRTVOUT) LIST(REPORTV) -
    TITLE('VOLUME/STATUS REPORT') DATE PAGE -
    BLANK -
    HEADER('VOLUME') ON(1,6,CH) -
    HEADER('STATUS') ON(7,20,CH)
* PART 4 - PRINT REPORT SORTED BY STATUS AND VOLUMES
  SORT FROM(STATUS) TO(SRTIOUT) USING(SRTI)
  DISPLAY FROM(SRTIOUT) LIST(REPORTI) -
    TITLE('STATUS/VOLUME REPORT') DATE PAGE -
    BLANK -
    HEADER('STATUS') ON(7,20,CH) -
    HEADER('VOLUME') ON(1,6,CH)
//DCOLALL DD DSN=Y176398.R12.DCOLLECT,DISP=SHR
//STATUS   DD DSN=&&TEMP1,DISP=(,PASS),UNIT=SYSDA,
//  LRECL=50,RECFM=FB,DSORG=PS
//SRTVOUT  DD DSN=&&TEMP2,DISP=(,PASS),UNIT=SYSDA
//SRTIOUT  DD DSN=&&TEMP3,DISP=(,PASS),UNIT=SYSDA
//FLAGCNTL DD *
* FIND V-TYPE RECORDS WITH STATUS FLAGS OF INTEREST
  INCLUDE COND=(9,2,CH,EQ,C'V ',AND,
                35,1,BI,NE,B'......10')
* CREATE RECFM=FB OUTPUT RECORDS WITH VOLSER AND STATUS DESCRIPTION.
* LOOKUP/CHANGE TABLE -
*   FLAG          DESCRIPTION
*   ----------    ---------------------
*   DCVMANGD      MANAGED BY SMS
*   DCVINITL      IN CONVERSION TO SMS
*   DCVNMNGD      NON-SMS MANAGED

  OUTFIL FNAMES=STATUS,CONVERT,
    OUTREC=(29,6,
      35,1,CHANGE=(20,
            B'......11',C'MANAGED BY SMS',
            B'......01',C'IN CONVERSION TO SMS',
            B'......00',C'NON-SMS MANAGED'),
      50:X)
//REPORTS DD SYSOUT=*
//SRTVCNTL DD *
* SORT BY VOLUME AND INDENTIFYING STATUS STRING
  SORT FIELDS=(1,6,CH,A,7,20,CH,A)
//SRTICNTL DD *
* SORT BY INDENTIFYING STATUS STRING AND VOLUME
  SORT FIELDS=(7,20,CH,A,1,6,CH,A)
//REPORTV DD SYSOUT=*
//REPORTI DD SYSOUT=*
//*
