//DCOLEX1  JOB ...
//******************************************************************
//* DFSORT/ICETOOL STORAGE ADMINISTRATOR EXAMPLES
//* DCOLLECT EXAMPLE 1: VSAM REPORT
//*   IDENTIFIES NON-SMS-MANAGED VSAM MULTIVOLUME DATA SETS
//*   AND KEY-RANGE VSAM DATA SETS.
//*   NOTES: (1) IF DUPLICATE VSAM DATA SETS ARE PRESENT THEY
//*              WILL BE LISTED ALONG WITH THE MULTIVOLUME DATA SETS
//*          (2) KEY-RANGE VSAM DATA SETS WILL NOT BE LISTED ALONG
//*              WITH THE MULTIVOLUME DATA SETS, BUT WILL BE LISTED
//*              SEPARATELY.
//******************************************************************
//STEP1    EXEC PGM=ICETOOL
//DFSMSG   DD   SYSOUT=*
//TOOLMSG  DD   SYSOUT=*
//INDD     DD   DSN=Y176398.R12.DCOLFESS,DISP=SHR
//OUTDD1   DD   DSN=&&TEMP1,DISP=(NEW,PASS),LIKE=Y176398.R12.DCOLFESS
//OUTDD2   DD   DSN=&&TEMP2,DISP=(NEW,PASS),LIKE=Y176398.R12.DCOLFESS
//REPORT1  DD   SYSOUT=*
//REPORT2  DD   SYSOUT=*
//TOOLIN   DD *
*  Create a data set containing only D-type records for VSAM data sets
*  that are non-SMS-managed
   COPY FROM(INDD) TO(OUTDD1) USING(CPY1)
*  Print a report showing all of the non-SMS-managed multi-volume
*  VSAM data sets including a count of the number of volumes
*  each resides on
   OCCUR FROM(OUTDD1) LIST(REPORT1) -
    ALLDUPS -
    BLANK -
    TITLE('Non-SMS-Managed Multi-Volume VSAM Data Set Report') -
    DATE TIME PAGE -
    HEADER('VSAM Data Set Name')   ON(29,44,CH) -
    HEADER('Number of Volumes')    ON(VALCNT)
*  Create a data set containing only A-type records for key-range VSAM
*  data sets
   SORT FROM(INDD) TO(OUTDD2) USING(SRT1)
*  Print a report showing all of the key-range VSAM data sets
   DISPLAY FROM(OUTDD2) LIST(REPORT2) -
    BLANK -
    TITLE('Key-range VSAM Data Set Report') -
    DATE TIME PAGE -
    HEADER('VSAM Data Set Name') ON(29,44,CH)
/*
//CPY1CNTL DD *
*  Include D-type records for non-SMS-managed (DCDSMSM)
*  VSAM data sets (DCDDSGVS).
   INCLUDE COND=(9,1,CH,EQ,C'D',AND,
                 74,1,BI,EQ,B'.0......',AND,
                 80,1,BI,EQ,B'....1...')
   OPTION VLSHRT
/*
//SRT1CNTL DD *
*  Include A-type records for key-range VSAM data sets (DCAKRDS).
   INCLUDE COND=(9,1,CH,EQ,C'A',AND,
                 117,1,BI,EQ,B'....1...')
*  Sort on dataset name.
   SORT FIELDS=(29,44,CH,A)
   OPTION VLSHRT
/*
//*
