/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

public class StatManager {
    private static final byte BLOCKSIZE = 10;
    private double step = 1.0;
    private int[][] virtualCounter = null;
    private double maxValue = 0.0;
    private int numValues = 0;
    private double sumValues = 0.0;

    private int getSubBlockId(double n) {
        int id = (int)Math.ceil(n / this.step) / 10;
        if (this.virtualCounter == null) {
            this.virtualCounter = new int[id + 1][];
            this.virtualCounter[id] = new int[10];
            return id;
        }
        if (id >= this.virtualCounter.length) {
            int[][] newV = new int[id + 1][];
            int i = 0;
            while (i < this.virtualCounter.length) {
                newV[i] = this.virtualCounter[i];
                ++i;
            }
            newV[id] = new int[10];
            this.virtualCounter = newV;
            return id;
        }
        if (this.virtualCounter[id] == null) {
            this.virtualCounter[id] = new int[10];
            return id;
        }
        return id;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public void addNumber(double n) {
        if (n > this.maxValue) {
            this.maxValue = n;
        }
        ++this.numValues;
        this.sumValues += n;
        int blockId = this.getSubBlockId(n);
        int index = (int)Math.ceil(n / this.step) - blockId * 10;
        int[] nArray = this.virtualCounter[blockId];
        int n2 = index;
        nArray[n2] = nArray[n2] + 1;
    }

    public double getMax() {
        return this.maxValue;
    }

    public double getAvg() {
        return this.numValues == 0 ? -1.0 : this.sumValues / (double)this.numValues;
    }

    public double getLevel(double level) {
        if (this.numValues == 0) {
            return 0.0;
        }
        int target = (int)Math.ceil((double)this.numValues * level);
        int counter = 0;
        int j = 0;
        int i = 0;
        i = 0;
        while (i < this.virtualCounter.length) {
            j = 0;
            while (this.virtualCounter[i] != null && j < 10) {
                if ((counter += this.virtualCounter[i][j]) >= target) {
                    double result = this.step * (double)(i * 10 + j + 1);
                    if (result > this.maxValue) {
                        return this.maxValue;
                    }
                    return result;
                }
                ++j;
            }
            ++i;
        }
        double result = this.step * (double)(i * 10 + j + 1);
        if (result > this.maxValue) {
            return this.maxValue;
        }
        return result;
    }
}

