/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import hmcScanner.StatManager;
import java.util.GregorianCalendar;

public class Old_DataManager {
    private static int DAYS = 365;
    private static int HOURLY_DAYS = 60;
    private int NUM_COUNTERS = 100;
    private static float MAX_ERROR = 0.1f;
    private GregorianCalendar last;
    private float[] min;
    private float[] avg;
    private float[] max;
    private int[] num;
    private static byte HOURLY = 0;
    private static byte DAILY = 1;
    private static byte FINISHED = (byte)2;
    private byte status = HOURLY;
    private static byte MIN_HOURLY_SAMPLES = 0;
    private float[] monthMin;
    private float[] monthAvg;
    private float[] monthMax;
    private float[] monthNum;
    private GregorianCalendar[] monthName;
    private static byte NUM_MONTHS = (byte)13;
    private float[] hourAvg;
    private float[] hourNum;
    private StatManager dailyStat = new StatManager();
    private StatManager hourlyStat = new StatManager();

    public Old_DataManager() {
        this.last = null;
        this.max = null;
        this.avg = null;
        this.min = null;
        this.num = null;
    }

    public Old_DataManager(GregorianCalendar last) {
        this.last = last;
        this.max = null;
        this.avg = null;
        this.min = null;
        this.num = null;
    }

    private void allocate() {
        this.min = new float[DAYS];
        this.max = new float[DAYS];
        this.avg = new float[DAYS];
        this.num = new int[DAYS];
        int i = 0;
        while (i < DAYS) {
            this.min[i] = Float.POSITIVE_INFINITY;
            this.max[i] = Float.NEGATIVE_INFINITY;
            this.avg[i] = 0.0f;
            this.num[i] = 0;
            ++i;
        }
        this.hourAvg = new float[HOURLY_DAYS * 24];
        this.hourNum = new float[HOURLY_DAYS * 24];
        i = 0;
        while (i < HOURLY_DAYS * 24) {
            this.hourAvg[i] = 0.0f;
            this.hourNum[i] = 0.0f;
            ++i;
        }
        this.dailyStat.setStep(0.01);
        this.hourlyStat.setStep(0.01);
    }

    private int getSlot(GregorianCalendar gc) {
        float diff = this.last.getTimeInMillis() - gc.getTimeInMillis();
        int day = DAYS - 1 - (int)(diff / 8.64E7f);
        return day;
    }

    private int getHourSlot(GregorianCalendar gc) {
        float diff = this.last.getTimeInMillis() - gc.getTimeInMillis();
        int slot = HOURLY_DAYS * 24 - 1 - (int)(diff / 3600000.0f);
        return slot;
    }

    public void add(GregorianCalendar gc, float value) {
        if (this.num == null) {
            this.allocate();
        }
        if (this.last == null) {
            this.last = gc;
        }
        if (value < 0.0f) {
            return;
        }
        int slot = this.getSlot(gc);
        if (slot < 0 || slot >= DAYS) {
            return;
        }
        if (this.status == DAILY) {
            this.dailyStat.addNumber(value);
        }
        if (this.status == FINISHED || this.status == DAILY && this.num[slot] != 0) {
            return;
        }
        if (value < this.min[slot]) {
            this.min[slot] = value;
        }
        if (value > this.max[slot]) {
            this.max[slot] = value;
        }
        int n = slot;
        this.avg[n] = this.avg[n] + value;
        int n2 = slot;
        this.num[n2] = this.num[n2] + 1;
        if (this.status != HOURLY) {
            return;
        }
        slot = this.getHourSlot(gc);
        if (slot < 0 || slot >= HOURLY_DAYS * 24) {
            return;
        }
        int n3 = slot;
        this.hourAvg[n3] = this.hourAvg[n3] + value;
        int n4 = slot;
        this.hourNum[n4] = this.hourNum[n4] + 1.0f;
        this.hourlyStat.addNumber(value);
    }

    public void endOfHourlyData() {
        if (this.num == null) {
            return;
        }
        int i = 0;
        while (i < DAYS) {
            if (this.num[i] < MIN_HOURLY_SAMPLES) {
                this.min[i] = Float.POSITIVE_INFINITY;
                this.max[i] = Float.NEGATIVE_INFINITY;
                this.avg[i] = 0.0f;
                this.num[i] = 0;
            } else if (this.num[i] != 0) {
                this.avg[i] = this.avg[i] / (float)this.num[i];
            }
            ++i;
        }
        i = 0;
        while (i < HOURLY_DAYS * 24) {
            if (this.hourNum[i] != 0.0f) {
                this.hourAvg[i] = this.hourAvg[i] / this.hourNum[i];
            }
            ++i;
        }
        this.status = DAILY;
    }

    public void endOfDailyData() {
        GregorianCalendar gc;
        if (this.num == null) {
            return;
        }
        this.monthAvg = new float[NUM_MONTHS];
        this.monthMin = new float[NUM_MONTHS];
        this.monthMax = new float[NUM_MONTHS];
        this.monthNum = new float[NUM_MONTHS];
        this.monthName = new GregorianCalendar[NUM_MONTHS];
        int i = 0;
        while (i < NUM_MONTHS) {
            this.monthAvg[i] = 0.0f;
            this.monthMin[i] = Float.POSITIVE_INFINITY;
            this.monthMax[i] = Float.NEGATIVE_INFINITY;
            this.monthNum[i] = 0.0f;
            this.monthName[i] = null;
            ++i;
        }
        byte m = 0;
        int d = 0;
        while (d < DAYS) {
            gc = (GregorianCalendar)this.last.clone();
            gc.add(5, -(DAYS - 1 - d));
            if (this.monthName[m] == null) {
                this.monthName[m] = gc;
                this.monthNum[m] = 0.0f;
            } else if (gc.get(2) != this.monthName[m].get(2)) {
                this.monthName[++m] = gc;
                this.monthNum[m] = 0.0f;
            }
            if (this.num[d] > 0) {
                byte by = m;
                this.monthAvg[by] = this.monthAvg[by] + this.avg[d];
                if (this.min[d] < this.monthMin[m]) {
                    this.monthMin[m] = this.min[d];
                }
                if (this.max[d] > this.monthMax[m]) {
                    this.monthMax[m] = this.max[d];
                }
                byte by2 = m;
                this.monthNum[by2] = this.monthNum[by2] + 1.0f;
            }
            ++d;
        }
        boolean missing_month = false;
        byte good_month = -1;
        m = 0;
        while (m < NUM_MONTHS) {
            if (this.monthNum[m] != 0.0f) {
                this.monthAvg[m] = this.monthAvg[m] / this.monthNum[m];
                good_month = m;
            } else {
                missing_month = true;
            }
            ++m;
        }
        if (missing_month && good_month >= 0) {
            m = 0;
            while (m < NUM_MONTHS) {
                if (this.monthName[m] == null) {
                    gc = (GregorianCalendar)this.monthName[good_month].clone();
                    gc.add(2, m - good_month);
                    this.monthName[m] = gc;
                }
                ++m;
            }
        }
        this.status = FINISHED;
    }

    public GregorianCalendar getHourDate(int hour) {
        if (this.status != FINISHED || hour < 0 || hour >= HOURLY_DAYS * 24) {
            return null;
        }
        GregorianCalendar gc = (GregorianCalendar)this.last.clone();
        gc.add(10, -(HOURLY_DAYS * 24 - 1 - hour));
        return gc;
    }

    public float getHourAvg(int hour) {
        if (this.status != FINISHED || hour < 0 || hour >= HOURLY_DAYS * 24 || this.hourNum[hour] == 0.0f) {
            return -1.0f;
        }
        return this.hourAvg[hour];
    }

    public GregorianCalendar getDayDate(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS) {
            return null;
        }
        GregorianCalendar gc = (GregorianCalendar)this.last.clone();
        gc.add(5, -(DAYS - 1 - day));
        return gc;
    }

    public float getDayAvg(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS || this.num[day] == 0) {
            return -1.0f;
        }
        return this.avg[day];
    }

    public float getDayMin(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS || this.num[day] == 0) {
            return -1.0f;
        }
        return this.min[day];
    }

    public float getDayMax(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS || this.num[day] == 0) {
            return -1.0f;
        }
        return this.max[day];
    }

    public GregorianCalendar[] getMonthNames() {
        if (this.status != FINISHED) {
            return null;
        }
        return this.monthName;
    }

    public float getMonthMin(int month) {
        if (this.status != FINISHED || this.monthNum[month] == 0.0f) {
            return -1.0f;
        }
        return this.monthMin[month];
    }

    public float getMonthMax(int month) {
        if (this.status != FINISHED || this.monthNum[month] == 0.0f) {
            return -1.0f;
        }
        return this.monthMax[month];
    }

    public float getMonthAvg(int month) {
        if (this.status != FINISHED || this.monthNum[month] == 0.0f) {
            return -1.0f;
        }
        return this.monthAvg[month];
    }

    public float getMonthNum(int month) {
        if (this.status != FINISHED) {
            return -1.0f;
        }
        return this.monthNum[month];
    }

    public double getDaily90p() {
        return this.dailyStat.getLevel(0.9);
    }

    public double getDaily95p() {
        return this.dailyStat.getLevel(0.95);
    }

    public double getHourly90p() {
        return this.hourlyStat.getLevel(0.9);
    }

    public double getHourly95p() {
        return this.hourlyStat.getLevel(0.95);
    }

    public double getDailyMax() {
        return this.dailyStat.getMax();
    }

    public double getDailyAvg() {
        return this.dailyStat.getAvg();
    }

    public double getHourlyMax() {
        return this.hourlyStat.getMax();
    }

    public double getHourlyAvg() {
        return this.hourlyStat.getAvg();
    }
}

