/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import hmcScanner.StringChanger;
import java.util.GregorianCalendar;
import java.util.Vector;

public class LparStatus {
    private static int DAYS = 365;
    private static int HOURLY_DAYS = 60;
    private GregorianCalendar last;
    private String[] msDaily;
    private String[] poolDaily;
    private boolean[] capDaily;
    private static byte HOURLY = 0;
    private static byte DAILY = 1;
    private static byte FINISHED = (byte)2;
    private byte status = HOURLY;
    private String[] msMonthly;
    private String[] poolMonthly;
    private boolean[] capMonthly;
    private GregorianCalendar[] monthName;
    private static byte NUM_MONTHS = (byte)13;
    private String[] msHourly;
    private String[] poolHourly;
    private boolean[] capHourly;
    private Vector<String> names = new Vector();
    private Vector<String> msNames = new Vector();
    private Vector<String> poolNames = new Vector();

    public LparStatus(GregorianCalendar last) {
        this.last = last;
    }

    private void allocate() {
        this.msDaily = new String[DAYS];
        this.poolDaily = new String[DAYS];
        this.capDaily = new boolean[DAYS];
        int i = 0;
        while (i < DAYS) {
            this.msDaily[i] = null;
            this.poolDaily[i] = null;
            this.capDaily[i] = true;
            ++i;
        }
        this.msHourly = new String[HOURLY_DAYS * 24];
        this.poolHourly = new String[HOURLY_DAYS * 24];
        this.capHourly = new boolean[HOURLY_DAYS * 24];
        i = 0;
        while (i < HOURLY_DAYS * 24) {
            this.msHourly[i] = null;
            this.poolHourly[i] = null;
            this.capHourly[i] = true;
            ++i;
        }
    }

    private int getSlot(GregorianCalendar gc) {
        float diff = this.last.getTimeInMillis() - gc.getTimeInMillis();
        int day = DAYS - 1 - (int)(diff / 8.64E7f);
        return day;
    }

    private int getHourSlot(GregorianCalendar gc) {
        float diff = this.last.getTimeInMillis() - gc.getTimeInMillis();
        int slot = HOURLY_DAYS * 24 - 1 - (int)(diff / 3600000.0f);
        return slot;
    }

    private String getString(String s) {
        int i = 0;
        while (i < this.names.size()) {
            if (s.equals(this.names.elementAt(i))) break;
            ++i;
        }
        if (i < this.names.size()) {
            return this.names.elementAt(i);
        }
        this.names.add(s);
        return s;
    }

    private String getMSString(String s) {
        int i = 0;
        while (i < this.msNames.size()) {
            if (s.equals(this.msNames.elementAt(i))) break;
            ++i;
        }
        if (i < this.msNames.size()) {
            return this.msNames.elementAt(i);
        }
        this.msNames.add(s);
        return s;
    }

    private String getPoolString(String s) {
        int i = 0;
        while (i < this.poolNames.size()) {
            if (s.equals(this.poolNames.elementAt(i))) break;
            ++i;
        }
        if (i < this.poolNames.size()) {
            return this.poolNames.elementAt(i);
        }
        this.poolNames.add(s);
        return s;
    }

    public void add(GregorianCalendar gc, String ms, String pool, boolean cap) {
        if (ms == null || pool == null) {
            return;
        }
        if (pool.equals("")) {
            pool = "DefaultPool";
        }
        if (this.msDaily == null) {
            this.allocate();
        }
        if (this.last == null) {
            this.last = gc;
        }
        if (this.status == FINISHED) {
            return;
        }
        int slot = this.getSlot(gc);
        if (slot >= 0 && slot < DAYS && this.msDaily[slot] == null) {
            this.msDaily[slot] = this.getMSString(ms);
            this.poolDaily[slot] = this.getPoolString(pool);
            this.capDaily[slot] = cap;
        }
        if (this.status == HOURLY && (slot = this.getHourSlot(gc)) >= 0 && slot < HOURLY_DAYS * 24 && this.msHourly[slot] == null) {
            this.msHourly[slot] = this.getMSString(ms);
            this.poolHourly[slot] = this.getPoolString(pool);
            this.capHourly[slot] = cap;
        }
    }

    public void endOfHourlyData() {
        this.status = DAILY;
    }

    public void endOfDailyData() {
        if (this.msDaily == null) {
            return;
        }
        this.msMonthly = new String[NUM_MONTHS];
        this.poolMonthly = new String[NUM_MONTHS];
        this.capMonthly = new boolean[NUM_MONTHS];
        this.monthName = new GregorianCalendar[NUM_MONTHS];
        int i = 0;
        while (i < NUM_MONTHS) {
            this.msMonthly[i] = null;
            this.poolMonthly[i] = null;
            this.capMonthly[i] = true;
            this.monthName[i] = null;
            ++i;
        }
        int m = 0;
        int d = 0;
        while (d < DAYS) {
            GregorianCalendar gc = (GregorianCalendar)this.last.clone();
            gc.add(5, -(DAYS - 1 - d));
            if (this.monthName[m] == null) {
                this.monthName[m] = gc;
            } else if (gc.get(2) != this.monthName[m].get(2)) {
                this.monthName[++m] = gc;
            }
            if (this.msDaily[d] != null) {
                this.msMonthly[m] = this.msDaily[d];
                this.poolMonthly[m] = this.poolDaily[d];
                this.capMonthly[m] = this.capDaily[d];
            }
            ++d;
        }
        this.status = FINISHED;
    }

    public GregorianCalendar getHourDate(int hour) {
        if (this.status != FINISHED || hour < 0 || hour >= HOURLY_DAYS * 24) {
            return null;
        }
        GregorianCalendar gc = (GregorianCalendar)this.last.clone();
        gc.add(10, -(HOURLY_DAYS * 24 - 1 - hour));
        return gc;
    }

    public String getHourMS(int hour) {
        if (this.status != FINISHED || hour < 0 || hour >= HOURLY_DAYS * 24 || this.msHourly[hour] == null) {
            return null;
        }
        return this.msHourly[hour];
    }

    public String getHourPool(int hour) {
        if (this.status != FINISHED || hour < 0 || hour >= HOURLY_DAYS * 24 || this.msHourly[hour] == null) {
            return null;
        }
        return this.poolHourly[hour];
    }

    public boolean getHourCap(int hour) {
        if (this.status != FINISHED || hour < 0 || hour >= HOURLY_DAYS * 24 || this.msHourly[hour] == null) {
            return true;
        }
        return this.capHourly[hour];
    }

    public GregorianCalendar getDayDate(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS) {
            return null;
        }
        GregorianCalendar gc = (GregorianCalendar)this.last.clone();
        gc.add(5, -(DAYS - 1 - day));
        return gc;
    }

    public String getDayMS(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS || this.msDaily[day] == null) {
            return null;
        }
        return this.msDaily[day];
    }

    public String getDayPool(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS || this.msDaily[day] == null) {
            return null;
        }
        return this.poolDaily[day];
    }

    public boolean getDayCap(int day) {
        if (this.status != FINISHED || day < 0 || day >= DAYS || this.msDaily[day] == null) {
            return true;
        }
        return this.capDaily[day];
    }

    public GregorianCalendar[] getMonthNames() {
        if (this.status != FINISHED) {
            return null;
        }
        return this.monthName;
    }

    public String getMonthMS(int month) {
        if (this.status != FINISHED || this.msMonthly[month] == null) {
            return null;
        }
        return this.msMonthly[month];
    }

    public String getMonthPool(int month) {
        if (this.status != FINISHED || this.msMonthly[month] == null) {
            return null;
        }
        return this.poolMonthly[month];
    }

    public boolean getMonthCap(int month) {
        if (this.status != FINISHED || this.msMonthly[month] == null) {
            return true;
        }
        return this.capMonthly[month];
    }

    public void sanitize(StringChanger msChange, StringChanger poolChange) {
        int i = 0;
        while (this.msNames != null && i < this.msNames.size()) {
            this.msNames.setElementAt(msChange.translate(this.msNames.elementAt(i)), i);
            ++i;
        }
        i = 0;
        while (this.poolNames != null && i < this.poolNames.size()) {
            if (!this.poolNames.elementAt(i).equals("DefaultPool")) {
                this.poolNames.setElementAt(poolChange.translate(this.poolNames.elementAt(i)), i);
            }
            ++i;
        }
        i = 0;
        while (this.msDaily != null && i < this.msDaily.length) {
            if (this.msDaily[i] != null) {
                this.msDaily[i] = msChange.translate(this.msDaily[i]);
            }
            ++i;
        }
        i = 0;
        while (this.msHourly != null && i < this.msHourly.length) {
            if (this.msHourly[i] != null) {
                this.msHourly[i] = msChange.translate(this.msHourly[i]);
            }
            ++i;
        }
        i = 0;
        while (this.msMonthly != null && i < this.msMonthly.length) {
            if (this.msMonthly[i] != null) {
                this.msMonthly[i] = msChange.translate(this.msMonthly[i]);
            }
            ++i;
        }
        i = 0;
        while (this.poolDaily != null && i < this.poolDaily.length) {
            if (this.poolDaily[i] != null && !this.poolDaily[i].equals("DefaultPool")) {
                this.poolDaily[i] = poolChange.translate(this.poolDaily[i]);
            }
            ++i;
        }
        i = 0;
        while (this.poolHourly != null && i < this.poolHourly.length) {
            if (this.poolHourly[i] != null && !this.poolHourly[i].equals("DefaultPool")) {
                this.poolHourly[i] = poolChange.translate(this.poolHourly[i]);
            }
            ++i;
        }
        i = 0;
        while (this.poolMonthly != null && i < this.poolMonthly.length) {
            if (this.poolMonthly[i] != null && !this.poolMonthly[i].equals("DefaultPool")) {
                this.poolMonthly[i] = poolChange.translate(this.poolMonthly[i]);
            }
            ++i;
        }
    }
}

