/*
 * Decompiled with CFR 0.152.
 */
package hmcScanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.VerticalAlignment;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WriteException;

public class DataSheet {
    private static final byte MIN_ROW_LENGTH = 10;
    private static final byte MIN_ROWS = 10;
    private static int NONE = 0;
    private static int BOLD = 1;
    private static int CENTRE = 2;
    private static int RIGHT = 4;
    private static int LEFT = 8;
    private static int VCENTRE = 16;
    private static int B_TOP_MED = 32;
    private static int B_BOTTOM_MED = 64;
    private static int B_LEFT_MED = 128;
    private static int B_RIGHT_MED = 256;
    private static int B_ALL_MED = 512;
    private static int B_TOP_LOW = 1024;
    private static int B_BOTTOM_LOW = 2048;
    private static int B_LEFT_LOW = 4096;
    private static int B_RIGHT_LOW = 8192;
    private static int B_ALL_LOW = 16384;
    private static int GRAY_25 = 32768;
    private static int GREEN = 65536;
    private static int WRAP = 131072;
    private static int DIAG45 = 262144;
    private static int BLACK = 524288;
    private static int YELLOW = 0x100000;
    private static int RED = 0x200000;
    private int nrows = 0;
    private int[] ncolumns = null;
    private int[] colSize = null;
    private Cell[][] sheet = null;
    private char separator = (char)44;
    private static final byte LABEL = 0;
    private static final byte FLOAT = 1;
    private static final byte INTEGER = 2;
    private static final byte IMAGE = 3;
    private static final byte FORMULA = 4;
    private static final byte VOID = 5;

    public static void main(String[] args) {
        DataSheet sd = new DataSheet();
    }

    public void createExcelSheet(WritableSheet excelSheet) {
        int col;
        int row = 0;
        while (row < this.nrows) {
            col = 0;
            while (col < this.ncolumns[row]) {
                if (this.sheet[row][col] != null) {
                    try {
                        if (this.sheet[row][col].getMerge_to_col() >= 0 && this.sheet[row][col].getMerge_to_row() >= 0) {
                            excelSheet.mergeCells(col, row, this.sheet[row][col].getMerge_to_col(), this.sheet[row][col].getMerge_to_row());
                        }
                        switch (this.sheet[row][col].getType()) {
                            case 0: {
                                excelSheet.addCell((WritableCell)new Label(col, row, this.sheet[row][col].getString(), (CellFormat)this.getExcelFormat(row, col)));
                                break;
                            }
                            case 1: 
                            case 2: {
                                excelSheet.addCell((WritableCell)new Number(col, row, this.sheet[row][col].getNumber(), (CellFormat)this.getExcelFormat(row, col)));
                                break;
                            }
                            case 3: {
                                File f = new File(this.sheet[row][col].getString());
                                WritableImage imgobj = new WritableImage((double)col, (double)row, (double)this.sheet[row][col].getWidth(), (double)this.sheet[row][col].getHeight(), f);
                                excelSheet.addImage(imgobj);
                                break;
                            }
                            case 5: {
                                break;
                            }
                            case 4: {
                                excelSheet.addCell((WritableCell)new Formula(col, row, this.sheet[row][col].getString(), (CellFormat)this.getExcelFormat(row, col)));
                                break;
                            }
                        }
                    }
                    catch (WriteException writeException) {
                        // empty catch block
                    }
                }
                ++col;
            }
            ++row;
        }
        col = 0;
        while (this.colSize != null && col < this.colSize.length) {
            if (this.colSize[col] > 0) {
                excelSheet.setColumnView(col, this.colSize[col]);
            }
            ++col;
        }
    }

    public void createCSVSheet(String fileName) {
        PrintWriter csv = null;
        try {
            csv = new PrintWriter(new FileOutputStream(new File(fileName)));
        }
        catch (IOException e) {
            return;
        }
        int row = 0;
        while (row < this.nrows) {
            int col = 0;
            while (col < this.ncolumns[row]) {
                if (this.sheet[row][col] != null) {
                    switch (this.sheet[row][col].getType()) {
                        case 0: {
                            String s = this.sheet[row][col].getString();
                            if (s == null) break;
                            csv.print(s);
                            break;
                        }
                        case 2: {
                            int i = (int)this.sheet[row][col].getNumber();
                            csv.print(i);
                            break;
                        }
                        case 1: {
                            double d = this.sheet[row][col].getNumber();
                            d = 1.0 * (double)((int)(d * 100.0)) / 100.0;
                            csv.print(d);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                if (col < this.ncolumns[row] - 1) {
                    csv.print(this.separator);
                }
                ++col;
            }
            csv.println();
            ++row;
        }
        csv.close();
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void createHTMLSheet(String fileName) {
        PrintWriter html = null;
        try {
            html = new PrintWriter(new FileOutputStream(new File(fileName)));
        }
        catch (IOException e) {
            return;
        }
        html.println("<HTML>\n<HEAD>\n<style>\n\ttable{border-collapse:collapse}\n\tth,td{border:1px solid black;border-collapse:collapse;padding:7px;font-family:calibri;font-size:12px;}\n</style>\n</HEAD>\n<BODY style=\"background-color:#e6e6e6;\">\n<TABLE>\n");
        int row = 0;
        while (row < this.nrows) {
            if (this.ncolumns[row] == 0) {
                html.println("<TR style=\"border:0px\">");
                html.println("\t<TD style=\"border:0px\"></TD>");
                html.println("</TR>");
            } else {
                html.println("<TR>");
                int col = 0;
                while (col < this.ncolumns[row]) {
                    if (this.sheet[row][col] == null) {
                        html.print("\t<TD style=\"border:0px\">");
                        html.print("</TD>");
                    } else if (this.sheet[row][col].getType() != 5) {
                        int merge;
                        int map = this.sheet[row][col].getMap();
                        String s = "";
                        if ((map & GREEN) != 0) {
                            s = String.valueOf(s) + "background-color:LightGreen;";
                        }
                        if ((map & BLACK) != 0) {
                            s = String.valueOf(s) + "background-color:Black;";
                        }
                        if ((map & YELLOW) != 0) {
                            s = String.valueOf(s) + "background-color:Yellow;";
                        }
                        if ((map & RED) != 0) {
                            s = String.valueOf(s) + "background-color:Red;";
                        }
                        if ((map & BOLD) != 0) {
                            s = String.valueOf(s) + "font-weight:bold;";
                        }
                        if ((map & CENTRE) != 0) {
                            s = String.valueOf(s) + "text-align:center;";
                        }
                        if ((map & LEFT) != 0) {
                            s = String.valueOf(s) + "text-align:left;";
                        }
                        if ((map & RIGHT) != 0) {
                            s = String.valueOf(s) + "text-align:right;";
                        }
                        if (s.length() > 0) {
                            s = " style=\"" + s + "\"";
                        }
                        if ((merge = this.sheet[row][col].getMerge_to_col()) > 0 && merge > col) {
                            s = String.valueOf(s) + " colspan=\"" + (merge - col + 1) + "\"";
                        }
                        if ((merge = this.sheet[row][col].getMerge_to_row()) > 0 && merge > row) {
                            s = String.valueOf(s) + " rowspan=\"" + (merge - row + 1) + "\"";
                        }
                        html.print("\t<TD" + s + ">");
                        switch (this.sheet[row][col].getType()) {
                            case 0: {
                                s = this.sheet[row][col].getString();
                                if (s == null) break;
                                html.print(s);
                                break;
                            }
                            case 2: {
                                html.print((int)this.sheet[row][col].getNumber());
                                break;
                            }
                            case 1: {
                                double d = this.sheet[row][col].getNumber();
                                d = 1.0 * (double)((int)(d * 100.0)) / 100.0;
                                html.print(d);
                                break;
                            }
                            case 3: {
                                FileInputStream input = null;
                                FileOutputStream output = null;
                                try {
                                    int bytesRead;
                                    input = new FileInputStream(this.sheet[row][col].getString());
                                    String dest = String.valueOf(new File(fileName).getParent()) + File.separatorChar + new File(this.sheet[row][col].getString()).getName();
                                    output = new FileOutputStream(dest);
                                    byte[] buf = new byte[1024];
                                    while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                                        ((OutputStream)output).write(buf, 0, bytesRead);
                                    }
                                    ((InputStream)input).close();
                                    ((OutputStream)output).close();
                                    html.print("<IMG SRC=\"" + new File(this.sheet[row][col].getString()).getName() + "\">");
                                }
                                catch (IOException iOException) {}
                                break;
                            }
                            case 4: {
                                break;
                            }
                        }
                        html.print("</TD>");
                    }
                    ++col;
                }
                html.println("\n</TR>");
            }
            ++row;
        }
        html.println("</TABLE>\n</BODY>\n</HTML>");
        html.close();
    }

    private WritableCellFormat getExcelFormat(int row, int col) {
        WritableCellFormat wcf;
        Cell c = this.sheet[row][col];
        int map = c.getMap();
        byte type = c.getType();
        WritableFont wf = (map & BOLD) != 0 ? new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, true) : new WritableFont(WritableFont.ARIAL, 10);
        switch (type) {
            case 0: {
                wcf = new WritableCellFormat(wf);
                break;
            }
            case 1: 
            case 4: {
                wcf = new WritableCellFormat(wf, NumberFormats.FORMAT3);
                break;
            }
            case 2: {
                wcf = new WritableCellFormat(wf, NumberFormats.INTEGER);
                break;
            }
            default: {
                wcf = null;
            }
        }
        try {
            if ((map & CENTRE) != 0) {
                wcf.setAlignment(Alignment.CENTRE);
            }
            if ((map & RIGHT) != 0) {
                wcf.setAlignment(Alignment.RIGHT);
            }
            if ((map & LEFT) != 0) {
                wcf.setAlignment(Alignment.LEFT);
            }
            if ((map & VCENTRE) != 0) {
                wcf.setVerticalAlignment(VerticalAlignment.CENTRE);
            }
            if ((map & B_TOP_MED) != 0) {
                wcf.setBorder(Border.TOP, BorderLineStyle.MEDIUM);
            }
            if ((map & B_BOTTOM_MED) != 0) {
                wcf.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
            }
            if ((map & B_LEFT_MED) != 0) {
                wcf.setBorder(Border.LEFT, BorderLineStyle.MEDIUM);
            }
            if ((map & B_RIGHT_MED) != 0) {
                wcf.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
            }
            if ((map & B_ALL_MED) != 0) {
                wcf.setBorder(Border.RIGHT, BorderLineStyle.MEDIUM);
                wcf.setBorder(Border.LEFT, BorderLineStyle.MEDIUM);
                wcf.setBorder(Border.TOP, BorderLineStyle.MEDIUM);
                wcf.setBorder(Border.BOTTOM, BorderLineStyle.MEDIUM);
            }
            if ((map & B_TOP_LOW) != 0) {
                wcf.setBorder(Border.TOP, BorderLineStyle.THIN);
            }
            if ((map & B_BOTTOM_LOW) != 0) {
                wcf.setBorder(Border.BOTTOM, BorderLineStyle.THIN);
            }
            if ((map & B_LEFT_LOW) != 0) {
                wcf.setBorder(Border.LEFT, BorderLineStyle.THIN);
            }
            if ((map & B_RIGHT_LOW) != 0) {
                wcf.setBorder(Border.RIGHT, BorderLineStyle.THIN);
            }
            if ((map & B_ALL_LOW) != 0) {
                wcf.setBorder(Border.RIGHT, BorderLineStyle.THIN);
                wcf.setBorder(Border.LEFT, BorderLineStyle.THIN);
                wcf.setBorder(Border.TOP, BorderLineStyle.THIN);
                wcf.setBorder(Border.BOTTOM, BorderLineStyle.THIN);
            }
            if ((map & GRAY_25) != 0) {
                wcf.setBackground(Colour.GRAY_25);
            }
            if ((map & GREEN) != 0) {
                wcf.setBackground(Colour.LIGHT_GREEN);
            }
            if ((map & BLACK) != 0) {
                wcf.setBackground(Colour.BLACK);
            }
            if ((map & YELLOW) != 0) {
                wcf.setBackground(Colour.YELLOW);
            }
            if ((map & RED) != 0) {
                wcf.setBackground(Colour.RED);
            }
            if ((map & WRAP) != 0) {
                wcf.setWrap(true);
            }
            if ((map & DIAG45) != 0) {
                wcf.setOrientation(Orientation.PLUS_45);
            }
        }
        catch (WriteException we) {
            System.out.println("DataSheet.getExcelFormat: WriteException. Keep going...");
        }
        return wcf;
    }

    public void setColSize(int col, int size) {
        if (this.colSize == null) {
            this.colSize = new int[this.sheet[0].length];
        }
        if (col >= this.colSize.length) {
            return;
        }
        this.colSize[col] = size;
    }

    public void addFormula(int col, int row, String formula, int map) {
        Cell c = this.getCell(row, col);
        c.setString(formula);
        c.setMap(map);
        c.setType((byte)4);
    }

    public int addLabel(int col, int row, String s, int map) {
        Cell c = this.getCell(row, col);
        c.setString(s);
        c.setMap(map);
        c.setType((byte)0);
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public int addLabel(int col, int row, String[] s, int index, int map) {
        Cell c = this.getCell(row, col);
        c.setMap(map);
        c.setType((byte)0);
        if (s == null || index >= s.length) {
            c.setString(null);
            return 0;
        }
        c.setString(s[index]);
        if (s[index] == null) {
            return 0;
        }
        return s[index].length();
    }

    public void addMultipleLabelsWrap(int col, int row, String[] s, int map) {
        Cell c = this.getCell(row, col);
        c.setMap(map | WRAP);
        c.setType((byte)0);
        if (s == null || s.length == 0) {
            c.setString(null);
            return;
        }
        if (s.length == 1) {
            c.setString(s[0]);
            return;
        }
        String result = s[0];
        int i = 1;
        while (i < s.length) {
            result = String.valueOf(result) + "\n" + s[i];
            ++i;
        }
        c.setString(result);
    }

    public void addFloat(int col, int row, String[] s, int index, int map) {
        this.addNumber(col, row, s, index, map, (byte)1);
    }

    public void addInteger(int col, int row, String[] s, int index, int map) {
        this.addNumber(col, row, s, index, map, (byte)2);
    }

    public void addFloat(int col, int row, double d, int map) {
        this.addNumber(col, row, d, map, (byte)1);
    }

    public void addInteger(int col, int row, double d, int map) {
        this.addNumber(col, row, d, map, (byte)2);
    }

    public void addFloatDiv1024(int col, int row, String[] s, int index, int map) {
        this.addNumberDiv1024(col, row, s, index, map, (byte)1);
    }

    public void addIntegerDiv1024(int col, int row, String[] s, int index, int map) {
        this.addNumberDiv1024(col, row, s, index, map, (byte)2);
    }

    public void addPicture(int col, int row, int width, int height, String file) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Cell c = this.getCell(row, col);
        c.setString(file);
        c.setType((byte)3);
        c.setWidth(width);
        c.setHeight(height);
    }

    private void addNumber(int col, int row, String[] s, int index, int map, byte type) {
        double d;
        if (s == null || index >= s.length || s[index] == null) {
            return;
        }
        try {
            d = Double.parseDouble(s[index]);
            d = 1.0 * (double)((int)(d * 100.0)) / 100.0;
        }
        catch (NumberFormatException nfe) {
            Cell c = this.getCell(row, col);
            c.setMap(map);
            c.setType((byte)0);
            c.setString("NaN");
            return;
        }
        Cell c = this.getCell(row, col);
        c.setMap(map);
        c.setNumber(d);
        c.setType(type);
    }

    private void addNumber(int col, int row, double d, int map, byte type) {
        Cell c = this.getCell(row, col);
        c.setMap(map);
        c.setNumber(d);
        c.setType(type);
    }

    private void addNumberDiv1024(int col, int row, String[] s, int index, int map, byte type) {
        double d;
        if (s == null || index >= s.length || s[index] == null) {
            return;
        }
        try {
            d = Double.parseDouble(s[index]);
            d /= 1024.0;
            d = 1.0 * (double)((int)(d * 100.0)) / 100.0;
        }
        catch (NumberFormatException nfe) {
            Cell c = this.getCell(row, col);
            c.setMap(map);
            c.setType((byte)0);
            c.setString("NaN");
            return;
        }
        Cell c = this.getCell(row, col);
        c.setMap(map);
        c.setNumber(d);
        c.setType(type);
    }

    private Cell getCell(int row, int col) {
        Cell c;
        Cell[][] new_sheet = null;
        if (row < this.nrows && col < this.ncolumns[row]) {
            Cell c2;
            if (this.sheet[row][col] != null) {
                return this.sheet[row][col];
            }
            this.sheet[row][col] = c2 = new Cell();
            return c2;
        }
        if (row < this.nrows) {
            Cell c3;
            if (col < this.sheet[row].length) {
                Cell c4;
                this.ncolumns[row] = col + 1;
                this.sheet[row][col] = c4 = new Cell();
                return c4;
            }
            int sheet_width = this.sheet[0].length > (1 + col / 10) * 10 ? this.sheet[0].length : (1 + col / 10) * 10;
            new_sheet = new Cell[this.sheet.length][sheet_width];
            int i = 0;
            while (i < this.nrows) {
                int j = 0;
                while (j < this.ncolumns[i]) {
                    new_sheet[i][j] = this.sheet[i][j];
                    ++j;
                }
                ++i;
            }
            this.sheet = new_sheet;
            this.ncolumns[row] = col + 1;
            this.sheet[row][col] = c3 = new Cell();
            return c3;
        }
        if (this.nrows == 0) {
            Cell c5;
            this.ncolumns = new int[(1 + row / 10) * 10];
            this.nrows = row + 1;
            this.ncolumns[row] = col + 1;
            this.sheet = new Cell[(1 + row / 10) * 10][(1 + col / 10) * 10];
            this.sheet[row][col] = c5 = new Cell();
            return c5;
        }
        if (row < this.ncolumns.length) {
            Cell c6;
            if (col < this.sheet[row].length) {
                Cell c7;
                this.nrows = row + 1;
                this.ncolumns[row] = col + 1;
                this.sheet[row][col] = c7 = new Cell();
                return c7;
            }
            int sheet_width = this.sheet[0].length > (1 + col / 10) * 10 ? this.sheet[0].length : (1 + col / 10) * 10;
            new_sheet = new Cell[this.sheet.length][sheet_width];
            int i = 0;
            while (i < this.nrows) {
                int j = 0;
                while (j < this.ncolumns[i]) {
                    new_sheet[i][j] = this.sheet[i][j];
                    ++j;
                }
                ++i;
            }
            this.sheet = new_sheet;
            this.nrows = row + 1;
            this.ncolumns[row] = col + 1;
            this.sheet[row][col] = c6 = new Cell();
            return c6;
        }
        int sheet_width = this.sheet[0].length > (1 + col / 10) * 10 ? this.sheet[0].length : (1 + col / 10) * 10;
        new_sheet = new Cell[(1 + row / 10) * 10][sheet_width];
        int i = 0;
        while (i < this.nrows) {
            int j = 0;
            while (j < this.ncolumns[i]) {
                new_sheet[i][j] = this.sheet[i][j];
                ++j;
            }
            ++i;
        }
        this.sheet = new_sheet;
        int[] new_ncolumns = new int[(1 + row / 10) * 10];
        i = 0;
        while (i < this.nrows) {
            new_ncolumns[i] = this.ncolumns[i];
            ++i;
        }
        this.ncolumns = new_ncolumns;
        this.nrows = row + 1;
        this.ncolumns[row] = col + 1;
        this.sheet[row][col] = c = new Cell();
        return c;
    }

    public void mergeCells(int colf, int rowf, int colt, int rowt) {
        Cell c = this.getCell(rowf, colf);
        c.setMerge_to_col(colt);
        c.setMerge_to_row(rowt);
        int i = rowf;
        while (i <= rowt) {
            int j = colf;
            while (j <= colt) {
                c = this.getCell(i, j);
                c.setType((byte)5);
                ++j;
            }
            ++i;
        }
    }

    public class Cell {
        private byte type = 0;
        private String string = null;
        private double number = 0.0;
        private int map = 0;
        private int width = 0;
        private int height = 0;
        private int merge_to_row = -1;
        private int merge_to_col = -1;

        public void setType(byte v) {
            this.type = v;
        }

        public byte getType() {
            return this.type;
        }

        public void setString(String s) {
            this.string = s;
        }

        public String getString() {
            return this.string;
        }

        public void setNumber(double d) {
            this.number = d;
        }

        public double getNumber() {
            return this.number;
        }

        public void setMap(int m) {
            this.map = m;
        }

        public int getMap() {
            return this.map;
        }

        public void setWidth(int w) {
            this.width = w;
        }

        public int getWidth() {
            return this.width;
        }

        public void setHeight(int w) {
            this.height = w;
        }

        public int getHeight() {
            return this.height;
        }

        public int getMerge_to_row() {
            return this.merge_to_row;
        }

        public void setMerge_to_row(int merge_to_row) {
            this.merge_to_row = merge_to_row;
        }

        public int getMerge_to_col() {
            return this.merge_to_col;
        }

        public void setMerge_to_col(int merge_to_col) {
            this.merge_to_col = merge_to_col;
        }
    }
}

