//>>built
define("ibm/swg/DojoTree/Source", ["dojo/dom-style", "dojo/_base/array", "dojo/_base/connect", "dojo/dnd/Manager","dijit/tree/dndSource"], function(domStyle, array, connect, DNDManager, Source) {

return dojo.declare("ibm.swg.DojoTree.Source", Source, {

	onMouseMove: function(e){
		// summary:
		//		Called for any onmousemove/ontouchmove events over the Tree
		// e: Event
		//		onmousemouse/ontouchmove event
		// tags:
		//		private
		if(this.isDragging && this.targetState == "Disabled"){ return; }
		this._doDeselect = false; 
		var m = DNDManager.manager();
		if(this.isDragging){
			this._onDragMouse(e);
		}else{
			if(this.mouseDown && this.isSource &&
				 (Math.abs(e.pageX-this._lastX)>=this.dragThreshold || Math.abs(e.pageY-this._lastY)>=this.dragThreshold)){
				var nodes = this.getSelectedTreeNodes();
				if(nodes.length){
					if(nodes.length > 1){
						//filter out all selected items which has one of their ancestor selected as well
						var seen = this.selection, i = 0, r = [], n, p;
						nextitem: while((n = nodes[i++])){
							for(p = n.getParent(); p && p !== this.tree; p = p.getParent()){
								if(seen[p.id]){ //parent is already selected, skip this node
									continue nextitem;
								}
							}
							//this node does not have any ancestors selected, add it
							r.push(n);
						}
						nodes = r;
					}
					nodes = array.map(nodes, function(n){return n.domNode});
					m.startDrag(this, nodes, this.copyState(connect.isCopyKey(e)));
					
					var parentNode = nodes[0];
					var zInd = domStyle.getComputedStyle(parentNode)["zIndex"];
					while ( parentNode && parentNode.style && (zInd == undefined || zInd == "auto")) {
						parentNode = parentNode.parentNode;
						zInd = domStyle.getComputedStyle(parentNode)["zIndex"];//(parentNode,"z-index");
					}
					
					zInd = parseInt(zInd) + 1;
					domStyle.set(m.avatar.node,"zIndex",zInd);
					console.log(m.avatar);
				}
			}
		}
	}
});
});


