/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util.security;

import com.filenet.wcm.toolkit.server.util.xml.WcmXMLUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.security.WcmSecurityAccess;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WcmSecurityAccessUtil {
    public static final WcmString NAME_OWNERCTRL = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_owner_control", "Owner Control");
    public static final WcmString NAME_MODIFYCONTENT = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_modify_content", "Modify Content");
    public static final WcmString NAME_MODIFYPROPS = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_modify_propeties", "Modify Properties");
    public static final WcmString NAME_VIEWCONTENT = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_view_content", "View Content");
    public static final WcmString NAME_VIEWPROPS = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_view_properties", "View Properties");
    public static final WcmString NAME_ADDTOFOLDER = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_add_to_folder", "Add To Folder");
    public static final WcmString NAME_PROMOTEVERSION = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_promote_version", "Promote Version");
    public static final WcmString NAME_PUBLISH = new WcmString("toolkit.WcmSecurityAccessUtil.access_level_publish", "Publish");
    public static final int REVOKE = 0;
    public static final int GRANT = 1;
    public static final int DENY = 2;
    public static final int SECURITY_POLICY_GRANT = 3;
    public static final int SECURITY_POLICY_DENY = 4;
    public static final int INHERITED_GRANT = 5;
    public static final int INHERITED_DENY = 6;
    public static final int ADVANCE_GRANT = 7;
    public static final int ADVANCE_DENY = 8;
    public static final int ADVANCE_SETTINGS = 9;
    public static final int INHERITED_ADVANCE_SETTINGS = 10;
    protected static final int VIEW_PROPERTIES = 131073;
    protected static final int VIEW_CONTENT = 131201;
    protected static final int ADD_TO_FOLDER = 131121;
    protected static final int FOLDER_MODIFY_PROPERTIES = 135159;
    protected static final int CUSTOMOBJECT_MODIFY_PROPERTIES = 131347;
    protected static final int DEFAULT_MODIFY_PROPERTIES = 131331;
    protected static final int DOCUMENT_MODIFY_PROPERTIES = 132499;
    protected static final int SEARCH_MODIFY_PROPERTIES = 132499;
    protected static final int DOCUMENT_MODIFY_CONTENT = 132563;
    protected static final int SEARCH_MODIFY_CONTENT = 132563;
    protected static final int FOLDER_OWNER_CONTROL = 987127;
    protected static final int CUSTOMOBJECT_OWNER_CONTROL = 983315;
    protected static final int DEFAULT_OWNER_CONTROL = 983299;
    protected static final int DOCUMENT_OWNER_CONTROL = 986583;
    protected static final int SEARCH_OWNER_CONTROL = 984535;
    protected static final int PROMOTE_VERSION = 132567;
    protected static final int PUBLISH = 134547;
    protected static final int DEFAULT_DOCUMENT_ALLOW_ACCESS = 131201;
    protected static final int DEFAULT_FOLDER_ALLOW_ACCESS = 131073;
    protected static final int DEFAULT_SEARCH_ALLOW_ACCESS = 131201;
    protected static final int DEFAULT_CUSTOMOBJECT_ALLOW_ACCESS = 131073;
    protected static final int DEFAULT_LINK_ALLOW_ACCESS = 131073;
    protected static final int DEFAULT_WORKFLOW_SUBSCRIPTION_ALLOW_ACCESS = 131073;
    protected static final int DEFAULT_WORKFLOW_SECURITY_POLICY_ALLOW_ACCESS = 131073;
    protected int[] accessLevels;
    protected int allow;
    protected int deny;
    protected int securityPolicyAllow;
    protected int securityPolicyDeny;
    protected int inheritedAllow;
    protected int inheritedDeny;
    protected int objType = -1;

    public static boolean canAddMarking(int userAccess) {
        return WcmSecurityAccessUtil.getSecurityRight(userAccess, 0x2000000);
    }

    public static boolean canAddAMarking(NodeList markingsList) {
        boolean canAdd = false;
        for (int i = 0; i < markingsList.getLength() && !(canAdd = WcmSecurityAccessUtil.getSecurityRight(Integer.parseInt(WcmXMLUtil.getElementText((Element)markingsList.item(i))), 0x2000000)); ++i) {
        }
        return canAdd;
    }

    public static boolean canRemoveMarking(int userAccess) {
        return WcmSecurityAccessUtil.getSecurityRight(userAccess, 0x4000000);
    }

    public static boolean getSecurityRight(int userAccess, int accessMask) {
        if (userAccess != 0) {
            return (accessMask & userAccess) == accessMask;
        }
        return false;
    }

    public int getDefaultAllowMask() throws Exception {
        return this.getDefaultAllowMask(Locale.getDefault());
    }

    public int getDefaultAllowMask(Locale locale) throws Exception {
        switch (this.objType) {
            case 1: 
            case 1175: {
                return 131201;
            }
            case -101: 
            case -100: {
                return 131201;
            }
            case 2: {
                return 131073;
            }
            case 15: 
            case 1156: 
            case 1165: 
            case 1166: {
                return 131073;
            }
            case 1170: {
                return 131073;
            }
        }
        throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.objectTypeNotSet", "Object type not set!");
    }

    public int getDefaultDenyMask(Locale locale) throws Exception {
        if (this.objType == -1) {
            throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.objectTypeNotSet", "Object type not set!");
        }
        return 0;
    }

    public int getDefaultDenyMask() throws Exception {
        if (this.objType == -1) {
            throw new WcmException("toolkit.WcmSecurityAccessUtil.objectTypeNotSet", "Object type not set!");
        }
        return 0;
    }

    public static String mapAccessLevelToName(Locale locale, int accessLevel) throws Exception {
        if (accessLevel == 986583 || accessLevel == 987127 || accessLevel == 984535 || accessLevel == 983315 || accessLevel == 983299) {
            return NAME_OWNERCTRL.toString(locale);
        }
        if (accessLevel == 132567) {
            return NAME_PROMOTEVERSION.toString(locale);
        }
        if (accessLevel == 132563) {
            return NAME_MODIFYCONTENT.toString(locale);
        }
        if (accessLevel == 132499 || accessLevel == 135159 || accessLevel == 131347 || accessLevel == 131331) {
            return NAME_MODIFYPROPS.toString(locale);
        }
        if (accessLevel == 131201) {
            return NAME_VIEWCONTENT.toString(locale);
        }
        if (accessLevel == 131121) {
            return NAME_ADDTOFOLDER.toString(locale);
        }
        if (accessLevel == 131073) {
            return NAME_VIEWPROPS.toString(locale);
        }
        if (accessLevel == 134547) {
            return NAME_PUBLISH.toString(locale);
        }
        throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
    }

    public static String mapAccessLevelToName(int accessLevel) throws Exception {
        if (accessLevel == 986583 || accessLevel == 987127 || accessLevel == 984535 || accessLevel == 983315 || accessLevel == 983299) {
            return NAME_OWNERCTRL.toString();
        }
        if (accessLevel == 132567) {
            return NAME_PROMOTEVERSION.toString();
        }
        if (accessLevel == 132563) {
            return NAME_MODIFYCONTENT.toString();
        }
        if (accessLevel == 132499 || accessLevel == 135159 || accessLevel == 131347 || accessLevel == 131331) {
            return NAME_MODIFYPROPS.toString();
        }
        if (accessLevel == 131201) {
            return NAME_VIEWCONTENT.toString();
        }
        if (accessLevel == 131121) {
            return NAME_ADDTOFOLDER.toString();
        }
        if (accessLevel == 131073) {
            return NAME_VIEWPROPS.toString();
        }
        if (accessLevel == 134547) {
            return NAME_PUBLISH.toString();
        }
        throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
    }

    public static WcmSecurityAccess computeAccessRight(Locale locale, int allowBits, int denyBits, int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int objectType) throws Exception {
        String systemNote = "";
        int explicitRight = WcmSecurityAccessUtil.computeExplicitAccessRight(locale, allowBits, denyBits, accessLevel, objectType);
        int systemRight = WcmSecurityAccessUtil.computeInheritedAccessRight(locale, securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, accessLevel, objectType);
        if (explicitRight == 9) {
            systemNote = WcmSecurityAccessUtil.getSystemNotes(locale, explicitRight);
        } else if (explicitRight == 0 || systemRight != 0) {
            systemNote = WcmSecurityAccessUtil.getSystemNotes(locale, systemRight);
        }
        WcmSecurityAccess securityAccess = new WcmSecurityAccess();
        securityAccess.accessLevel = accessLevel;
        securityAccess.accessName = WcmSecurityAccessUtil.mapAccessLevelToName(locale, accessLevel);
        securityAccess.explicitRight = explicitRight;
        securityAccess.systemRight = systemRight;
        securityAccess.systemNote = systemNote;
        return securityAccess;
    }

    public static WcmSecurityAccess computeAccessRight(int allowBits, int denyBits, int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int objectType) throws Exception {
        String systemNote = "";
        int explicitRight = WcmSecurityAccessUtil.computeExplicitAccessRight(allowBits, denyBits, accessLevel, objectType);
        int systemRight = WcmSecurityAccessUtil.computeInheritedAccessRight(securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, accessLevel, objectType);
        if (explicitRight == 9) {
            systemNote = WcmSecurityAccessUtil.getSystemNotes(explicitRight);
        } else if (explicitRight == 0 || systemRight != 0) {
            systemNote = WcmSecurityAccessUtil.getSystemNotes(systemRight);
        }
        WcmSecurityAccess securityAccess = new WcmSecurityAccess();
        securityAccess.accessLevel = accessLevel;
        securityAccess.accessName = WcmSecurityAccessUtil.mapAccessLevelToName(accessLevel);
        securityAccess.explicitRight = explicitRight;
        securityAccess.systemRight = systemRight;
        securityAccess.systemNote = systemNote;
        return securityAccess;
    }

    public int computeExplicitAccessRight(Locale locale, int accessLevel, int objectType) throws Exception {
        int delta = this.getDeltaMask(locale, accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 1;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = this.computeExplicitAccessRight(locale, inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeExplicitRight(this.allow, this.deny, rights, delta);
    }

    public int computeExplicitAccessRight(int accessLevel, int objectType) throws Exception {
        int delta = this.getDeltaMask(accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 1;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = this.computeExplicitAccessRight(inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeExplicitRight(this.allow, this.deny, rights, delta);
    }

    public static int computeExplicitAccessRight(Locale locale, int allowBits, int denyBits, int accessLevel, int objectType) throws Exception {
        int delta = WcmSecurityAccessUtil.getDeltaAccessMask(locale, accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 1;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = WcmSecurityAccessUtil.computeExplicitAccessRight(locale, allowBits, denyBits, inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeExplicitRight(allowBits, denyBits, rights, delta);
    }

    public static int computeExplicitAccessRight(int allowBits, int denyBits, int accessLevel, int objectType) throws Exception {
        int delta = WcmSecurityAccessUtil.getDeltaAccessMask(accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 1;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = WcmSecurityAccessUtil.computeExplicitAccessRight(allowBits, denyBits, inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeExplicitRight(allowBits, denyBits, rights, delta);
    }

    private static int computeExplicitRight(int allowBits, int denyBits, int rights, int delta) {
        if ((denyBits & delta) == delta) {
            return 2;
        }
        if ((denyBits & delta) > 0) {
            return 9;
        }
        if ((allowBits & delta) == delta) {
            if (rights == 2) {
                return 9;
            }
            return rights;
        }
        if ((allowBits & delta) > 0) {
            return 9;
        }
        if (rights == 9) {
            return rights;
        }
        return 0;
    }

    public int computeInheritedAccessRight(Locale locale, int accessLevel, int objectType) throws Exception {
        int delta = this.getDeltaMask(locale, accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 3;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = this.computeInheritedAccessRight(locale, inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeInheritedRight(locale, this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, rights, delta, objectType);
    }

    public int computeInheritedAccessRight(int accessLevel, int objectType) throws Exception {
        int delta = this.getDeltaMask(accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 3;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = this.computeInheritedAccessRight(inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeInheritedRight(this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, rights, delta, objectType);
    }

    public static int computeInheritedAccessRight(Locale locale, int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int objectType) throws Exception {
        int delta = WcmSecurityAccessUtil.getDeltaAccessMask(locale, accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 3;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = WcmSecurityAccessUtil.computeInheritedAccessRight(locale, securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeInheritedRight(locale, securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, accessLevel, rights, delta, objectType);
    }

    public static int computeInheritedAccessRight(int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int objectType) throws Exception {
        int delta = WcmSecurityAccessUtil.getDeltaAccessMask(accessLevel, objectType);
        int inverse = accessLevel - delta;
        int rights = 3;
        if (accessLevel != 986583 && accessLevel != 987127 && accessLevel != 984535 && accessLevel != 983315 && accessLevel != 983299 && inverse > 0) {
            rights = WcmSecurityAccessUtil.computeInheritedAccessRight(securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, inverse, objectType);
        }
        return WcmSecurityAccessUtil.computeInheritedRight(securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, accessLevel, rights, delta, objectType);
    }

    private static int computeInheritedRight(Locale locale, int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int rights, int delta, int objectType) throws Exception {
        if ((securityPolicyDenyBits & delta) == delta) {
            return 4;
        }
        if ((securityPolicyDenyBits & delta) > 0) {
            if (((securityPolicyDenyBits | securityPolicyAllowBits ^ inheritedDenyBits) & delta) == delta) {
                return 8;
            }
            return 10;
        }
        if ((securityPolicyAllowBits & delta) == delta) {
            switch (rights) {
                case 3: 
                case 5: 
                case 7: {
                    return 3;
                }
            }
            return 10;
        }
        if ((securityPolicyAllowBits & delta) > 0) {
            if (WcmSecurityAccessUtil.isGranted(locale, 0, 0, securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, accessLevel, objectType)) {
                return 7;
            }
            return 10;
        }
        if ((inheritedDenyBits & delta) == delta) {
            return 6;
        }
        if ((inheritedAllowBits & delta) == delta) {
            switch (rights) {
                case 3: 
                case 5: 
                case 7: {
                    return 5;
                }
            }
            return 10;
        }
        if ((inheritedAllowBits & delta) > 0 || (inheritedDenyBits & delta) > 0) {
            return 10;
        }
        return 0;
    }

    private static int computeInheritedRight(int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int rights, int delta, int objectType) throws Exception {
        if ((securityPolicyDenyBits & delta) == delta) {
            return 4;
        }
        if ((securityPolicyDenyBits & delta) > 0) {
            if (((securityPolicyDenyBits | securityPolicyAllowBits ^ inheritedDenyBits) & delta) == delta) {
                return 8;
            }
            return 10;
        }
        if ((securityPolicyAllowBits & delta) == delta) {
            switch (rights) {
                case 3: 
                case 5: 
                case 7: {
                    return 3;
                }
            }
            return 10;
        }
        if ((securityPolicyAllowBits & delta) > 0) {
            if (WcmSecurityAccessUtil.isGranted(0, 0, securityPolicyAllowBits, securityPolicyDenyBits, inheritedAllowBits, inheritedDenyBits, accessLevel, objectType)) {
                return 7;
            }
            return 10;
        }
        if ((inheritedDenyBits & delta) == delta) {
            return 6;
        }
        if ((inheritedAllowBits & delta) == delta) {
            switch (rights) {
                case 3: 
                case 5: 
                case 7: {
                    return 5;
                }
            }
            return 10;
        }
        if ((inheritedAllowBits & delta) > 0 || (inheritedDenyBits & delta) > 0) {
            return 10;
        }
        return 0;
    }

    public boolean isGranted(Locale locale, int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.isGranted(locale, this.allow, this.deny, this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, this.objType);
    }

    public boolean isGranted(int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.isGranted(this.allow, this.deny, this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, this.objType);
    }

    public static boolean isGranted(Locale locale, int allowBits, int denyBits, int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int objectType) throws Exception {
        int accessMask;
        int explicitAllowRights = allowBits ^ denyBits & allowBits;
        int securityPolicyAllowRights = securityPolicyAllowBits ^ (denyBits | securityPolicyDenyBits) & securityPolicyAllowBits;
        int inheritedAllowRights = inheritedAllowBits ^ (denyBits | securityPolicyDenyBits | inheritedDenyBits) & inheritedAllowBits;
        int allowRights = explicitAllowRights | securityPolicyAllowRights | inheritedAllowRights;
        switch (accessLevel) {
            case 983299: 
            case 983315: 
            case 984535: 
            case 986583: 
            case 987127: {
                accessMask = WcmSecurityAccessUtil.getDeltaAccessMask(locale, accessLevel, objectType);
                break;
            }
            default: {
                accessMask = accessLevel;
            }
        }
        return (accessMask & allowRights) == accessMask;
    }

    public static boolean isGranted(int allowBits, int denyBits, int securityPolicyAllowBits, int securityPolicyDenyBits, int inheritedAllowBits, int inheritedDenyBits, int accessLevel, int objectType) throws Exception {
        int accessMask;
        int explicitAllowRights = allowBits ^ denyBits & allowBits;
        int securityPolicyAllowRights = securityPolicyAllowBits ^ (denyBits | securityPolicyDenyBits) & securityPolicyAllowBits;
        int inheritedAllowRights = inheritedAllowBits ^ (denyBits | securityPolicyDenyBits | inheritedDenyBits) & inheritedAllowBits;
        int allowRights = explicitAllowRights | securityPolicyAllowRights | inheritedAllowRights;
        switch (accessLevel) {
            case 983299: 
            case 983315: 
            case 984535: 
            case 986583: 
            case 987127: {
                accessMask = WcmSecurityAccessUtil.getDeltaAccessMask(accessLevel, objectType);
                break;
            }
            default: {
                accessMask = accessLevel;
            }
        }
        return (accessMask & allowRights) == accessMask;
    }

    public static String getSystemNotes(Locale locale, int accessRights) {
        switch (accessRights) {
            case 0: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.ImplicitDeny", "Implicit Deny").toString();
            }
            case 3: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.SecurityPolicyAllow", "Allow due to security policy").toString();
            }
            case 4: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.SecurityPolicyDeny", "Deny due to security policy").toString();
            }
            case 5: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.InheritedAllow", "Allow due to inherited security").toString();
            }
            case 6: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.InheritedDeny", "Deny  due to inherited security").toString();
            }
            case 8: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.AdvancedDeny", "Deny due to Advanced System Defined Settings").toString();
            }
            case 7: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.AdvancedAllow", "Allow due to Advanced System Defined Settings").toString();
            }
            case 9: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.AdvancedSettings", "Advanced System Defined Settings").toString();
            }
            case 10: {
                return new WcmString(locale, "toolkit.WcmSecurityAccessUtil.InheritedAdvancedSettings", "Advanced System Defined Settings").toString();
            }
        }
        return "";
    }

    public static String getSystemNotes(int accessRights) {
        switch (accessRights) {
            case 0: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.ImplicitDeny", "Implicit Deny").toString();
            }
            case 3: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.SecurityPolicyAllow", "Allow due to security policy").toString();
            }
            case 4: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.SecurityPolicyDeny", "Deny due to security policy").toString();
            }
            case 5: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.InheritedAllow", "Allow due to inherited security").toString();
            }
            case 6: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.InheritedDeny", "Deny  due to inherited security").toString();
            }
            case 8: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.AdvancedDeny", "Deny due to Advanced System Defined Settings").toString();
            }
            case 7: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.AdvancedAllow", "Allow due to Advanced System Defined Settings").toString();
            }
            case 9: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.AdvancedSettings", "Advanced System Defined Settings").toString();
            }
            case 10: {
                return new WcmString("toolkit.WcmSecurityAccessUtil.InheritedAdvancedSettings", "Advanced System Defined Settings").toString();
            }
        }
        return "";
    }

    public final void grantAccess(int accessLevel) throws Exception {
        this.allow |= accessLevel;
        if ((this.deny & accessLevel) > 0) {
            this.deny ^= this.deny & accessLevel;
        }
    }

    public final void denyAccess(Locale locale, int accessLevel) throws Exception {
        int mask = this.getDenyMask(locale, accessLevel);
        this.allow ^= mask & this.allow;
        this.deny |= mask;
    }

    public final void denyAccess(int accessLevel) throws Exception {
        int mask = this.getDenyMask(accessLevel);
        this.allow ^= mask & this.allow;
        this.deny |= mask;
    }

    public void revokeAccess(Locale locale, int accessLevel, int accessType) throws Exception {
        int mask = this.getDenyMask(locale, accessLevel);
        switch (accessType) {
            case 2: {
                this.deny ^= mask & this.deny;
                break;
            }
            case 1: {
                this.allow ^= mask & this.allow;
                break;
            }
            default: {
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccessType", "Invalid access type!");
            }
        }
    }

    public void revokeAccess(int accessLevel, int accessType) throws Exception {
        int mask = this.getDenyMask(accessLevel);
        switch (accessType) {
            case 2: {
                this.deny ^= mask & this.deny;
                break;
            }
            case 1: {
                this.allow ^= mask & this.allow;
                break;
            }
            default: {
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccessType", "Invalid access type!");
            }
        }
    }

    protected void setAccessLevels(Locale locale, int objType) throws Exception {
        this.objType = objType;
        switch (objType) {
            case 1: 
            case 1175: {
                this.setDocumentAccessLevels();
                break;
            }
            case 2: {
                this.setFolderAccessLevels();
                break;
            }
            case -100: {
                this.setSearchAccessLevels();
                break;
            }
            case -101: {
                this.setPublishAccessLevels();
                break;
            }
            case 15: {
                this.setCustomObjectAccessLevels();
                break;
            }
            case 1156: {
                this.setLinkAccessLevels();
                break;
            }
            case 1165: 
            case 1166: {
                this.setWorkflowSubscriptionAccessLevels();
                break;
            }
            case 1170: {
                this.setSecurityPolicyAccessLevels();
                break;
            }
            default: {
                this.objType = -1;
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidObjectType", "Invalid object type!");
            }
        }
    }

    protected void setAccessLevels(int objType) throws Exception {
        this.objType = objType;
        switch (objType) {
            case 1: 
            case 1175: {
                this.setDocumentAccessLevels();
                break;
            }
            case 2: {
                this.setFolderAccessLevels();
                break;
            }
            case -100: {
                this.setSearchAccessLevels();
                break;
            }
            case -101: {
                this.setPublishAccessLevels();
                break;
            }
            case 15: {
                this.setCustomObjectAccessLevels();
                break;
            }
            case 1156: {
                this.setLinkAccessLevels();
                break;
            }
            case 1165: 
            case 1166: {
                this.setWorkflowSubscriptionAccessLevels();
                break;
            }
            case 1170: {
                this.setSecurityPolicyAccessLevels();
                break;
            }
            default: {
                this.objType = -1;
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidObjectType", "Invalid object type!");
            }
        }
    }

    protected WcmSecurityAccess computeAccessRight(Locale locale, int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.computeAccessRight(locale, this.allow, this.deny, this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, this.objType);
    }

    protected WcmSecurityAccess computeAccessRight(int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.computeAccessRight(this.allow, this.deny, this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, this.objType);
    }

    protected int computeExplicitAccessRight(Locale locale, int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.computeExplicitAccessRight(locale, this.allow, this.deny, accessLevel, this.objType);
    }

    protected int computeExplicitAccessRight(int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.computeExplicitAccessRight(this.allow, this.deny, accessLevel, this.objType);
    }

    protected int computeInheritedAccessRight(Locale locale, int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.computeInheritedAccessRight(locale, this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, this.objType);
    }

    protected int computeInheritedAccessRight(int accessLevel) throws Exception {
        return WcmSecurityAccessUtil.computeInheritedAccessRight(this.securityPolicyAllow, this.securityPolicyDeny, this.inheritedAllow, this.inheritedDeny, accessLevel, this.objType);
    }

    protected int getDeltaMask(Locale locale, int accessLevel, int objectType) throws Exception {
        return WcmSecurityAccessUtil.getDeltaAccessMask(locale, accessLevel, objectType);
    }

    protected int getDeltaMask(int accessLevel, int objectType) throws Exception {
        return WcmSecurityAccessUtil.getDeltaAccessMask(accessLevel, objectType);
    }

    private static int getDeltaAccessMask(Locale locale, int accessLevel, int objectType) throws Exception {
        switch (objectType) {
            case 1: 
            case 1175: {
                switch (accessLevel) {
                    case 986583: {
                        return 851968;
                    }
                    case 132567: {
                        return 4;
                    }
                    case 132563: {
                        return 64;
                    }
                    case 132499: {
                        return 1298;
                    }
                    case 131201: {
                        return 128;
                    }
                    case 131073: {
                        return 131073;
                    }
                    case 134547: {
                        return 2048;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 2: {
                switch (accessLevel) {
                    case 987127: {
                        return 851968;
                    }
                    case 135159: {
                        return 4038;
                    }
                    case 131121: {
                        return 48;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case -101: 
            case -100: {
                switch (accessLevel) {
                    case 984535: {
                        return 851968;
                    }
                    case 132567: {
                        return 4;
                    }
                    case 132563: {
                        return 64;
                    }
                    case 132499: {
                        return 1298;
                    }
                    case 131201: {
                        return 128;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 15: 
            case 1165: 
            case 1166: {
                switch (accessLevel) {
                    case 983315: {
                        return 851968;
                    }
                    case 131347: {
                        return 274;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 1156: {
                switch (accessLevel) {
                    case 983299: {
                        return 851968;
                    }
                    case 131331: {
                        return 258;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
        }
        switch (accessLevel) {
            case 983299: {
                return 851968;
            }
            case 131331: {
                return 258;
            }
            case 131073: {
                return 131073;
            }
        }
        throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
    }

    private static int getDeltaAccessMask(int accessLevel, int objectType) throws Exception {
        switch (objectType) {
            case 1: 
            case 1175: {
                switch (accessLevel) {
                    case 986583: {
                        return 851968;
                    }
                    case 132567: {
                        return 4;
                    }
                    case 132563: {
                        return 64;
                    }
                    case 132499: {
                        return 1298;
                    }
                    case 131201: {
                        return 128;
                    }
                    case 131073: {
                        return 131073;
                    }
                    case 134547: {
                        return 2048;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 2: {
                switch (accessLevel) {
                    case 987127: {
                        return 851968;
                    }
                    case 135159: {
                        return 4038;
                    }
                    case 131121: {
                        return 48;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case -101: 
            case -100: {
                switch (accessLevel) {
                    case 984535: {
                        return 851968;
                    }
                    case 132567: {
                        return 4;
                    }
                    case 132563: {
                        return 64;
                    }
                    case 132499: {
                        return 1298;
                    }
                    case 131201: {
                        return 128;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 15: 
            case 1165: 
            case 1166: {
                switch (accessLevel) {
                    case 983315: {
                        return 851968;
                    }
                    case 131347: {
                        return 274;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 1156: {
                switch (accessLevel) {
                    case 983299: {
                        return 851968;
                    }
                    case 131331: {
                        return 258;
                    }
                    case 131073: {
                        return 131073;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
        }
        switch (accessLevel) {
            case 983299: {
                return 851968;
            }
            case 131331: {
                return 258;
            }
            case 131073: {
                return 131073;
            }
        }
        throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
    }

    protected int getDenyMask(Locale locale, int accessLevel) throws Exception {
        switch (this.objType) {
            case 1: 
            case 1175: {
                switch (accessLevel) {
                    case 986583: {
                        return 851968;
                    }
                    case 132567: {
                        return 851972;
                    }
                    case 132563: {
                        return 852036;
                    }
                    case 132499: {
                        return 855382;
                    }
                    case 131201: {
                        return 855510;
                    }
                    case 131073: {
                        return 986583;
                    }
                    case 134547: {
                        return 854016;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 2: {
                switch (accessLevel) {
                    case 987127: {
                        return 851968;
                    }
                    case 135159: {
                        return 856006;
                    }
                    case 131121: {
                        return 856054;
                    }
                    case 131073: {
                        return 987127;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case -101: 
            case -100: {
                switch (accessLevel) {
                    case 984535: {
                        return 851968;
                    }
                    case 132567: {
                        return 851972;
                    }
                    case 132563: {
                        return 852036;
                    }
                    case 132499: {
                        return 853334;
                    }
                    case 131201: {
                        return 853462;
                    }
                    case 131073: {
                        return 984535;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 15: 
            case 1165: 
            case 1166: {
                switch (accessLevel) {
                    case 983315: {
                        return 851968;
                    }
                    case 131347: {
                        return 852242;
                    }
                    case 131073: {
                        return 983315;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 1156: {
                switch (accessLevel) {
                    case 983299: {
                        return 851968;
                    }
                    case 131331: {
                        return 852226;
                    }
                    case 131073: {
                        return 983299;
                    }
                }
                throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
        }
        switch (accessLevel) {
            case 983299: {
                return 851968;
            }
            case 131331: {
                return 852226;
            }
            case 131073: {
                return 983299;
            }
        }
        throw new WcmException(locale, "toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
    }

    protected int getDenyMask(int accessLevel) throws Exception {
        switch (this.objType) {
            case 1: 
            case 1175: {
                switch (accessLevel) {
                    case 986583: {
                        return 851968;
                    }
                    case 132567: {
                        return 851972;
                    }
                    case 132563: {
                        return 852036;
                    }
                    case 132499: {
                        return 855382;
                    }
                    case 131201: {
                        return 855510;
                    }
                    case 131073: {
                        return 986583;
                    }
                    case 134547: {
                        return 854016;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 2: {
                switch (accessLevel) {
                    case 987127: {
                        return 851968;
                    }
                    case 135159: {
                        return 856006;
                    }
                    case 131121: {
                        return 856054;
                    }
                    case 131073: {
                        return 987127;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case -101: 
            case -100: {
                switch (accessLevel) {
                    case 984535: {
                        return 851968;
                    }
                    case 132567: {
                        return 851972;
                    }
                    case 132563: {
                        return 852036;
                    }
                    case 132499: {
                        return 853334;
                    }
                    case 131201: {
                        return 853462;
                    }
                    case 131073: {
                        return 984535;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 15: 
            case 1165: 
            case 1166: {
                switch (accessLevel) {
                    case 983315: {
                        return 851968;
                    }
                    case 131347: {
                        return 852242;
                    }
                    case 131073: {
                        return 983315;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
            case 1156: {
                switch (accessLevel) {
                    case 983299: {
                        return 851968;
                    }
                    case 131331: {
                        return 852226;
                    }
                    case 131073: {
                        return 983299;
                    }
                }
                throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
            }
        }
        switch (accessLevel) {
            case 983299: {
                return 851968;
            }
            case 131331: {
                return 852226;
            }
            case 131073: {
                return 983299;
            }
        }
        throw new WcmException("toolkit.WcmSecurityAccessUtil.invalidAccess", "Invalid Security Access Definition.");
    }

    private void setDocumentAccessLevels() {
        this.accessLevels = new int[7];
        this.accessLevels[0] = 986583;
        this.accessLevels[1] = 132567;
        this.accessLevels[2] = 132563;
        this.accessLevels[3] = 132499;
        this.accessLevels[4] = 131201;
        this.accessLevels[5] = 131073;
        this.accessLevels[6] = 134547;
    }

    private void setFolderAccessLevels() {
        this.accessLevels = new int[4];
        this.accessLevels[0] = 987127;
        this.accessLevels[1] = 135159;
        this.accessLevels[2] = 131121;
        this.accessLevels[3] = 131073;
    }

    private void setSearchAccessLevels() {
        this.accessLevels = new int[6];
        this.accessLevels[0] = 984535;
        this.accessLevels[1] = 132567;
        this.accessLevels[2] = 132563;
        this.accessLevels[3] = 132499;
        this.accessLevels[4] = 131201;
        this.accessLevels[5] = 131073;
    }

    private void setPublishAccessLevels() {
        this.accessLevels = new int[6];
        this.accessLevels[0] = 984535;
        this.accessLevels[1] = 132567;
        this.accessLevels[2] = 132563;
        this.accessLevels[3] = 132499;
        this.accessLevels[4] = 131201;
        this.accessLevels[5] = 131073;
    }

    private void setCustomObjectAccessLevels() {
        this.accessLevels = new int[3];
        this.accessLevels[0] = 983315;
        this.accessLevels[1] = 131347;
        this.accessLevels[2] = 131073;
    }

    private void setWorkflowSubscriptionAccessLevels() {
        this.accessLevels = new int[3];
        this.accessLevels[0] = 983315;
        this.accessLevels[1] = 131347;
        this.accessLevels[2] = 131073;
    }

    private void setSecurityPolicyAccessLevels() {
        this.accessLevels = new int[3];
        this.accessLevels[0] = 983299;
        this.accessLevels[1] = 131331;
        this.accessLevels[2] = 131073;
    }

    private void setLinkAccessLevels() {
        this.accessLevels = new int[3];
        this.accessLevels[0] = 983299;
        this.accessLevels[1] = 131331;
        this.accessLevels[2] = 131073;
    }
}

