/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.wcm.toolkit.util.WcmString;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.StringTokenizer;

public class WcmXMLEncode {
    public static final int ENCODING_NONE = 0;
    public static final int ENCODING_BASE64 = 1;
    public static final int DECODEERROR_INVALIDCHAR = 1;
    public static final int DECODEERROR_INVALIDLENGTH = 2;
    public static final int DECODEERROR_INVALIDENCODING = 3;
    private static final int MAX_CHARS_IN_LINE = 76;
    private static EntityMapEntry[] entityMap = new EntityMapEntry[]{new EntityMapEntry('&', "&amp;"), new EntityMapEntry('<', "&lt;"), new EntityMapEntry('>', "&gt;"), new EntityMapEntry('\"', "&quot;"), new EntityMapEntry('\'', "&apos;"), new EntityMapEntry('\t', "&#9;"), new EntityMapEntry('\n', "&#10;"), new EntityMapEntry('\r', "&#13;")};
    private static String mappedChars;
    private static int longestEntity;
    private static String alphabet;

    public static XmlEncodeResult encodeForXml(String inString, XmlEncodeResult result) {
        if (result == null) {
            result = new XmlEncodeResult();
        }
        if (WcmXMLEncode.isAllValidXmlChars(inString)) {
            result.encoding = 0;
            result.outString = WcmXMLEncode.encodeEntities(inString);
        } else {
            result.encoding = 1;
            result.outString = WcmXMLEncode.encodeBase64(inString);
        }
        return result;
    }

    public static String decodeFromXml(Locale locale, int howEncoded, String inString) throws XmlDecodeException {
        String outStr = null;
        switch (howEncoded) {
            case 1: {
                outStr = WcmXMLEncode.decodeBase64(locale, inString);
                break;
            }
            default: {
                throw new XmlDecodeException(WcmXMLEncode.getDecodeErrorMessage(locale, 3), 3, inString, 0);
            }
        }
        return outStr;
    }

    public static String decodeFromXml(int howEncoded, String inString) throws XmlDecodeException {
        String outStr = null;
        switch (howEncoded) {
            case 1: {
                outStr = WcmXMLEncode.decodeBase64(inString);
                break;
            }
            default: {
                throw new XmlDecodeException(WcmXMLEncode.getDecodeErrorMessage(3), 3, inString, 0);
            }
        }
        return outStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String encodeEntities(String inString) {
        int inLen;
        if (longestEntity == -1) {
            EntityMapEntry[] entityMapEntryArray = entityMap;
            // MONITORENTER : entityMap
            if (longestEntity == -1) {
                StringBuffer mappedCharsBuff = new StringBuffer();
                int longestEntityAccum = 0;
                for (int ii = 0; ii < entityMap.length; ++ii) {
                    mappedCharsBuff.append(WcmXMLEncode.entityMap[ii].mappedChar);
                    WcmXMLEncode.entityMap[ii].entityLen = WcmXMLEncode.entityMap[ii].entity.length();
                    if (WcmXMLEncode.entityMap[ii].entityLen <= longestEntityAccum) continue;
                    longestEntityAccum = WcmXMLEncode.entityMap[ii].entityLen;
                }
                mappedChars = mappedCharsBuff.toString();
                longestEntity = longestEntityAccum;
            }
            // MONITOREXIT : entityMapEntryArray
        }
        if ((inLen = inString.length()) <= 0) {
            return inString;
        }
        StringTokenizer izer = new StringTokenizer(inString, mappedChars, true);
        if (izer.countTokens() <= 1) {
            if (izer.countTokens() != 1) return inString;
            if (inLen != 1) return inString;
        }
        StringBuffer outStrBuff = new StringBuffer();
        outStrBuff.ensureCapacity(longestEntity * inLen);
        while (izer.hasMoreTokens()) {
            String tok = izer.nextToken();
            int mappedCharPos = -1;
            if (tok.length() == 1) {
                mappedCharPos = mappedChars.indexOf(tok.charAt(0));
            }
            if (mappedCharPos >= 0) {
                outStrBuff.append(WcmXMLEncode.entityMap[mappedCharPos].entity);
                continue;
            }
            outStrBuff.append(tok);
        }
        return outStrBuff.toString();
    }

    public static boolean isAllValidXmlChars(String inString) {
        boolean retVal = true;
        int strLen = inString.length();
        for (int i = 0; i < strLen; ++i) {
            char c = inString.charAt(i);
            if (c <= '\ud7ff') {
                if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                retVal = false;
                break;
            }
            if (c >= '\ue000' && c <= '\ufffd') continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    public static String encodeBase64(String inStr) {
        int outCh;
        int inOffset;
        byte[] inBytes = null;
        try {
            inBytes = inStr.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("encodeBase64: Unexpected couldn't get bytes in UnicodeLittleUnmarked format!");
        }
        if (inBytes == null) {
            try {
                inBytes = inStr.getBytes("UTF-16LE");
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("encodeBase64: Last chance, couldn't get bytes in UTF-16LE format!");
                inBytes = new byte[]{};
            }
        }
        int inLenBytes = inBytes.length;
        StringBuffer outBuff = new StringBuffer();
        int chInLine = 0;
        for (inOffset = 0; inOffset < inLenBytes - 2; inOffset += 3) {
            if (chInLine > 76) {
                outBuff.append("\r\n");
                chInLine = 0;
            }
            outCh = inBytes[inOffset] >>> 2 & 0x3F;
            outBuff.append(alphabet.charAt(outCh));
            outCh = (inBytes[inOffset] & 3) << 4 | inBytes[inOffset + 1] >>> 4 & 0xF;
            outBuff.append(alphabet.charAt(outCh));
            outCh = (inBytes[inOffset + 1] & 0xF) << 2 | inBytes[inOffset + 2] >>> 6 & 3;
            outBuff.append(alphabet.charAt(outCh));
            outCh = inBytes[inOffset + 2] & 0x3F;
            outBuff.append(alphabet.charAt(outCh));
            chInLine += 4;
        }
        if (inOffset > inLenBytes) {
            inOffset -= 3;
        }
        if (inLenBytes - inOffset > 0) {
            if (chInLine > 76) {
                outBuff.append("\r\n");
            }
            switch (inLenBytes - inOffset) {
                case 1: {
                    outCh = inBytes[inOffset] >>> 2 & 0x3F;
                    outBuff.append(alphabet.charAt(outCh));
                    outCh = (inBytes[inOffset] & 3) << 4;
                    outBuff.append(alphabet.charAt(outCh));
                    outBuff.append("==");
                    break;
                }
                case 2: {
                    outCh = inBytes[inOffset] >>> 2 & 0x3F;
                    outBuff.append(alphabet.charAt(outCh));
                    outCh = (inBytes[inOffset] & 3) << 4 | inBytes[inOffset + 1] >>> 4 & 0xF;
                    outBuff.append(alphabet.charAt(outCh));
                    outCh = (inBytes[inOffset + 1] & 0xF) << 2;
                    outBuff.append(alphabet.charAt(outCh));
                    outBuff.append('=');
                    break;
                }
                default: {
                    System.out.println("encodeBase64: Unexpected (inLenBytes - inOffset) not 1 or 2!");
                    break;
                }
            }
        } else if (inLenBytes % 3 != 0) {
            System.out.println("encodeBase64: Unexpected inLenBytes not modulo 3!");
        }
        return outBuff.toString();
    }

    public static String decodeBase64(Locale locale, String inStr) throws XmlDecodeException {
        int inLen;
        String retVal = null;
        int errNum = 0;
        for (inLen = inStr.length(); inLen > 0 && Character.isWhitespace(inStr.charAt(inLen - 1)); --inLen) {
        }
        int outBytes = inLen / 4 * 3 + 2;
        byte[] outBuff = new byte[outBytes];
        int inOffset = 0;
        int outOffset = 0;
        byte outVal = 0;
        int chReadInCycle = 0;
        block15: while (inOffset < inLen && errNum == 0) {
            char inCh;
            byte val;
            if ((val = (byte)alphabet.indexOf(inCh = inStr.charAt(inOffset++))) >= 0) {
                switch (chReadInCycle) {
                    case 0: {
                        outVal = (byte)(val << 2 & 0xFF);
                        chReadInCycle = 1;
                        continue block15;
                    }
                    case 1: {
                        outVal = (byte)(outVal | val >>> 4 & 0xF);
                        outBuff[outOffset++] = outVal;
                        outVal = (byte)(val << 4 & 0xFF);
                        chReadInCycle = 2;
                        continue block15;
                    }
                    case 2: {
                        outVal = (byte)(outVal | val >>> 2 & 0x3F);
                        outBuff[outOffset++] = outVal;
                        outVal = (byte)(val << 6 & 0xFF);
                        chReadInCycle = 3;
                        continue block15;
                    }
                    case 3: {
                        outVal = (byte)(outVal | val);
                        outBuff[outOffset++] = outVal;
                        chReadInCycle = 0;
                        continue block15;
                    }
                }
                System.out.println("WcmXMLEncode.decodeBase64: Unexpected chReadInCycle value " + chReadInCycle + "!");
                continue;
            }
            if (inCh == '\r' || inCh == '\n') continue;
            if (inCh == '=') {
                switch (chReadInCycle) {
                    case 2: {
                        if (inOffset == inLen - 1) {
                            chReadInCycle = 3;
                            continue block15;
                        }
                        errNum = 1;
                        continue block15;
                    }
                    case 3: {
                        if (inOffset == inLen) {
                            chReadInCycle = 0;
                            continue block15;
                        }
                        errNum = 1;
                        continue block15;
                    }
                }
                errNum = 1;
                continue;
            }
            errNum = 1;
        }
        if (chReadInCycle != 0) {
            errNum = 2;
        }
        if (errNum == 0) {
            outBuff[outOffset] = 0;
            outBuff[outOffset + 1] = 0;
            try {
                retVal = new String(outBuff, 0, outOffset, "UnicodeLittle");
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("WcmXMLEncode.decodeBase64: Can't decode UnicodeLittle");
                retVal = null;
            }
            if (retVal == null) {
                try {
                    retVal = new String(outBuff, 0, outOffset, "UTF-16LE");
                }
                catch (UnsupportedEncodingException ex) {
                    System.out.println("WcmXMLEncode.decodeBase64: Last chance, can't decode UTF-16LE");
                    errNum = 3;
                    retVal = null;
                }
            }
        }
        if (errNum != 0) {
            retVal = null;
            throw new XmlDecodeException(WcmXMLEncode.getDecodeErrorMessage(locale, errNum), errNum, inStr, inOffset - 1);
        }
        return retVal;
    }

    public static String decodeBase64(String inStr) throws XmlDecodeException {
        int inLen;
        String retVal = null;
        int errNum = 0;
        for (inLen = inStr.length(); inLen > 0 && Character.isWhitespace(inStr.charAt(inLen - 1)); --inLen) {
        }
        int outBytes = inLen / 4 * 3 + 2;
        byte[] outBuff = new byte[outBytes];
        int inOffset = 0;
        int outOffset = 0;
        byte outVal = 0;
        int chReadInCycle = 0;
        block15: while (inOffset < inLen && errNum == 0) {
            char inCh;
            byte val;
            if ((val = (byte)alphabet.indexOf(inCh = inStr.charAt(inOffset++))) >= 0) {
                switch (chReadInCycle) {
                    case 0: {
                        outVal = (byte)(val << 2 & 0xFF);
                        chReadInCycle = 1;
                        continue block15;
                    }
                    case 1: {
                        outVal = (byte)(outVal | val >>> 4 & 0xF);
                        outBuff[outOffset++] = outVal;
                        outVal = (byte)(val << 4 & 0xFF);
                        chReadInCycle = 2;
                        continue block15;
                    }
                    case 2: {
                        outVal = (byte)(outVal | val >>> 2 & 0x3F);
                        outBuff[outOffset++] = outVal;
                        outVal = (byte)(val << 6 & 0xFF);
                        chReadInCycle = 3;
                        continue block15;
                    }
                    case 3: {
                        outVal = (byte)(outVal | val);
                        outBuff[outOffset++] = outVal;
                        chReadInCycle = 0;
                        continue block15;
                    }
                }
                System.out.println("WcmXMLEncode.decodeBase64: Unexpected chReadInCycle value " + chReadInCycle + "!");
                continue;
            }
            if (inCh == '\r' || inCh == '\n') continue;
            if (inCh == '=') {
                switch (chReadInCycle) {
                    case 2: {
                        if (inOffset == inLen - 1) {
                            chReadInCycle = 3;
                            continue block15;
                        }
                        errNum = 1;
                        continue block15;
                    }
                    case 3: {
                        if (inOffset == inLen) {
                            chReadInCycle = 0;
                            continue block15;
                        }
                        errNum = 1;
                        continue block15;
                    }
                }
                errNum = 1;
                continue;
            }
            errNum = 1;
        }
        if (chReadInCycle != 0) {
            errNum = 2;
        }
        if (errNum == 0) {
            outBuff[outOffset] = 0;
            outBuff[outOffset + 1] = 0;
            try {
                retVal = new String(outBuff, 0, outOffset, "UnicodeLittle");
            }
            catch (UnsupportedEncodingException ex) {
                System.out.println("WcmXMLEncode.decodeBase64: Can't decode UnicodeLittle");
                retVal = null;
            }
            if (retVal == null) {
                try {
                    retVal = new String(outBuff, 0, outOffset, "UTF-16LE");
                }
                catch (UnsupportedEncodingException ex) {
                    System.out.println("WcmXMLEncode.decodeBase64: Last chance, can't decode UTF-16LE");
                    errNum = 3;
                    retVal = null;
                }
            }
        }
        if (errNum != 0) {
            retVal = null;
            throw new XmlDecodeException(WcmXMLEncode.getDecodeErrorMessage(errNum), errNum, inStr, inOffset - 1);
        }
        return retVal;
    }

    private static String getDecodeErrorMessage(Locale locale, int errNum) {
        String errType = null;
        switch (errNum) {
            case 1: {
                errType = WcmString.localize(locale, "client.WcmXMLEncode.invalidCharError", "Invalid character");
                break;
            }
            case 2: {
                errType = WcmString.localize(locale, "client.WcmXMLEncode.invalidLengthError", "Invalid length");
                break;
            }
            case 3: {
                errType = WcmString.localize(locale, "client.WcmXMLEncode.invalidEncodingError", "Invalid encoding");
            }
        }
        return WcmString.localize(locale, "client.WcmXMLEncode.base64DecodeError", "Base 64 decode error: {0}", (Object)errType);
    }

    private static String getDecodeErrorMessage(int errNum) {
        String errType = null;
        switch (errNum) {
            case 1: {
                errType = WcmString.localize("client.WcmXMLEncode.invalidCharError", "Invalid character");
                break;
            }
            case 2: {
                errType = WcmString.localize("client.WcmXMLEncode.invalidLengthError", "Invalid length");
                break;
            }
            case 3: {
                errType = WcmString.localize("client.WcmXMLEncode.invalidEncodingError", "Invalid encoding");
            }
        }
        return WcmString.localize("client.WcmXMLEncode.base64DecodeError", "Base 64 decode error: {0}", (Object)errType);
    }

    static {
        longestEntity = -1;
        alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789$/";
    }

    private static class EntityMapEntry {
        char mappedChar;
        String entity;
        int entityLen;

        EntityMapEntry(char mappedChar, String entity) {
            this.mappedChar = mappedChar;
            this.entity = entity;
        }
    }

    public static class XmlEncodeResult {
        public String outString;
        public int encoding;

        public XmlEncodeResult(String outString, int encoding) {
            this.outString = outString;
            this.encoding = encoding;
        }

        public XmlEncodeResult() {
        }
    }

    public static class XmlDecodeException
    extends Exception {
        private int decodeError;
        private String inputString;
        private int errorLocation;

        XmlDecodeException(String msg, int decodeError, String inputString, int errorLocation) {
            super(msg);
            this.decodeError = decodeError;
            this.inputString = inputString;
            this.errorLocation = errorLocation;
        }

        private XmlDecodeException() {
        }

        public int getDecodeError() {
            return this.decodeError;
        }

        public String getInputString() {
            return this.inputString;
        }

        public int getErrorLocation() {
            return this.errorLocation;
        }
    }
}

