/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.ae.util.search.CBRSearchTerm;
import com.filenet.ae.util.search.CBRSearchUtil;
import com.filenet.wcm.toolkit.util.CBRSearchParser;
import com.filenet.wcm.toolkit.util.CBRSearchType;
import com.filenet.wcm.toolkit.util.CBRSearchXMLUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.WcmXMLEncode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WcmVerityParser
extends CBRSearchParser {
    private static final String DATAENCODING = "dataencoding";
    private static final String NOT = "not";
    private static final String VERITY_ALL = "verityall";
    private static final String VERITY_ANY = "verityany";
    private static final String VERITY_IN = "verityin";
    private static final String VERITY_NEAR = "veritynear";
    private static final String VERITY_PARAGRAPH = "verityparagraph";
    private static final String VERITY_SENTENCE = "veritysentence";
    private static final String VERITY_UNIT = "verityunit";
    private static final String VERITY_VQL = "verityvql";
    private static final String VERITY_ZONE = "verityzone";
    private static final String VERITY_ZONE_NAME = "verityzonename";
    private static final String VERITY_ZONES = "verityzones";
    private static final String WORDVARIATION = "wordvariation";
    public static final String ZONE_NAME = "zoneName";
    private static final String BASE64 = "base64";
    private static final String WORDVARIATION_NONE = "none";
    private static final String WORDVARIATION_STEM = "stem";
    private static final String WORDVARIATION_WILDCARD = "wildcard";
    private boolean encodingEnabled = false;

    public WcmVerityParser(Document document) {
        this(document, false);
    }

    public WcmVerityParser(Document document, boolean encodingEnabled) {
        super(document);
        this.encodingEnabled = encodingEnabled;
    }

    @Override
    public CBRSearchType getType() {
        return CBRSearchType.VERITY;
    }

    @Override
    public void parse(String text, String modifier, Node parentNode, Map<String, String> attributes) throws WcmException {
        Node itemDataNode = CBRSearchXMLUtil.createNode(this.document, parentNode, "verityitemdata");
        if (WcmString.compareIgnoreCase(modifier = CBRSearchXMLUtil.convertToInternalModifier(modifier), "VQL") == 0) {
            Node vqlNode = CBRSearchXMLUtil.createNode(this.document, itemDataNode, VERITY_VQL);
            if ((text = text.trim()).length() > 0) {
                this.appendTextNode(vqlNode, text);
            }
        } else if (WcmString.compareIgnoreCase(modifier, "None") == 0) {
            this.parseText(text, itemDataNode);
        } else if (WcmString.compareIgnoreCase(modifier, "In Zone") == 0) {
            String zoneName;
            Node inNode = CBRSearchXMLUtil.createNode(this.document, itemDataNode, VERITY_IN);
            Node zonesNode = CBRSearchXMLUtil.createNode(this.document, inNode, VERITY_ZONES);
            Node zoneNode = CBRSearchXMLUtil.createNode(this.document, zonesNode, VERITY_ZONE);
            Node zoneNameNode = CBRSearchXMLUtil.createNode(this.document, zoneNode, VERITY_ZONE_NAME);
            String string = zoneName = attributes != null ? attributes.get(ZONE_NAME) : null;
            if (zoneName != null && zoneName.length() > 0) {
                this.appendTextNode(zoneNameNode, zoneName);
            }
            Node innerItemDataNode = CBRSearchXMLUtil.createNode(this.document, inNode, "verityitemdata");
            Node anyNode = CBRSearchXMLUtil.createNode(this.document, innerItemDataNode, VERITY_ANY);
            this.parseText(text, anyNode);
        } else {
            String nodeName = null;
            if (WcmString.compareIgnoreCase(modifier, "All") == 0) {
                nodeName = VERITY_ALL;
            } else if (WcmString.compareIgnoreCase(modifier, "Any") == 0) {
                nodeName = VERITY_ANY;
            } else if (WcmString.compareIgnoreCase(modifier, "Near") == 0) {
                nodeName = VERITY_NEAR;
            } else if (WcmString.compareIgnoreCase(modifier, "Paragraph") == 0) {
                nodeName = VERITY_PARAGRAPH;
            } else if (WcmString.compareIgnoreCase(modifier, "Sentence") == 0) {
                nodeName = VERITY_SENTENCE;
            }
            if (nodeName != null) {
                Node modifierNode = CBRSearchXMLUtil.createNode(this.document, itemDataNode, nodeName);
                this.parseText(text, modifierNode);
            }
        }
    }

    @Override
    public String validate(String text, String modifier, boolean required) throws WcmException {
        String errorMsg = null;
        CBRSearchParser.TextStats stats = this.analyzeText(text);
        int termCount = stats.wordCount + stats.phraseCount;
        if (WcmString.compareIgnoreCase(modifier = CBRSearchXMLUtil.convertToInternalModifier(modifier), "All") == 0 || WcmString.compareIgnoreCase(modifier, "Any") == 0 || WcmString.compareIgnoreCase(modifier, "In Zone") == 0) {
            if (required && termCount < 1) {
                errorMsg = ONE_OPERAND_MIN.toString();
            } else if (stats.prohibitedTermCount > 0) {
                errorMsg = EXCLAMATION_MARK_NOT_ALLOWED.toString();
            }
        } else if (WcmString.compareIgnoreCase(modifier, "Near") == 0 || WcmString.compareIgnoreCase(modifier, "Paragraph") == 0 || WcmString.compareIgnoreCase(modifier, "Sentence") == 0) {
            if (required && termCount < 2 || termCount == 1) {
                errorMsg = TWO_OPERANDS_MIN.toString();
            } else if (stats.prohibitedTermCount > 0) {
                errorMsg = EXCLAMATION_MARK_NOT_ALLOWED.toString();
            }
        } else if (WcmString.compareIgnoreCase(modifier, "None") == 0 && (required && termCount == 0 || termCount > 1)) {
            errorMsg = ONE_OPERAND_MAX.toString();
        }
        return errorMsg;
    }

    private void parseText(String text, Node parentNode) throws WcmException {
        if ((text = text.trim()).length() == 0) {
            CBRSearchXMLUtil.createNode(this.document, parentNode, VERITY_UNIT);
        } else {
            List strings;
            try {
                strings = CBRSearchUtil.tokenizeCbrCriteria((String)text, (boolean)true, (boolean)false);
            }
            catch (Exception e) {
                throw new WcmException("toolkit.WcmVerityParser.genericParseError", "Parser error: {0}", (Object)e.getMessage());
            }
            Iterator i = strings.iterator();
            while (i.hasNext()) {
                CBRSearchTerm term = CBRSearchTerm.fromString((String)((String)i.next()));
                Node unitNode = CBRSearchXMLUtil.createNode(this.document, parentNode, VERITY_UNIT);
                String value = term.getValue();
                if (term.isPhrase()) {
                    CBRSearchXMLUtil.setNodeAttribute(this.document, unitNode, WORDVARIATION, WORDVARIATION_NONE);
                    value = '\"' + value + '\"';
                } else if (value.indexOf(42) >= 0 || value.indexOf(63) >= 0) {
                    CBRSearchXMLUtil.setNodeAttribute(this.document, unitNode, WORDVARIATION, WORDVARIATION_WILDCARD);
                } else {
                    CBRSearchXMLUtil.setNodeAttribute(this.document, unitNode, WORDVARIATION, WORDVARIATION_STEM);
                }
                if (term.isProhibited()) {
                    CBRSearchXMLUtil.setNodeAttribute(this.document, unitNode, NOT, "true");
                }
                this.appendTextNode(unitNode, value);
            }
        }
    }

    private void appendTextNode(Node node, String data) {
        if (this.encodingEnabled) {
            WcmXMLEncode.XmlEncodeResult result = WcmXMLEncode.encodeForXml(data, null);
            if (result.encoding == 1) {
                CBRSearchXMLUtil.setNodeAttribute(this.document, node, DATAENCODING, BASE64);
            }
            node.appendChild(this.document.createTextNode(result.outString));
        } else {
            node.appendChild(this.document.createTextNode(data));
        }
    }
}

