/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.wcm.toolkit.util.ResourceBundle;
import com.filenet.wcm.toolkit.util.ResourcePathItem;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class WcmStringResources {
    public static final String STRING_CONFIG_NAME = "WcmStringResources";
    public static final String EXCEPTION_CONFIG_NAME = "WcmExceptionResources";
    public static final String SESSION_LOCALE_KEY = "HttpSession.WcmStringResources.locale";
    protected static final String STRING_PREFIX = "str";
    protected static final String EXCEPTION_PREFIX = "exc";
    protected static final String DEFAULT_LOCALE_VALUE = "en.US";
    private static ResourceMap resources = new ResourceMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetResources(boolean exceptions) {
        ResourceMap resourceMap = resources;
        synchronized (resourceMap) {
            String prefix = exceptions ? EXCEPTION_PREFIX : STRING_PREFIX;
            for (String key : resources.resourceMap.keySet()) {
                if (!key.startsWith(prefix)) continue;
                resources.resourceMap.remove(key);
            }
        }
    }

    public static ResourceBundle getJarBundle(String path, String name, Class loaderClass) {
        return new ResourcePathItem(path, name, loaderClass);
    }

    public static ResourceBundle getBundle(String path, String name) {
        return new ResourcePathItem(path, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStringBundleToPath(ResourceBundle bundle) {
        ResourceMap resourceMap = resources;
        synchronized (resourceMap) {
            resources.strResourcePath.add(bundle);
            WcmStringResources.resetResources(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExceptionBundleToPath(ResourceBundle bundle) {
        ResourceMap resourceMap = resources;
        synchronized (resourceMap) {
            resources.excResourcePath.add(bundle);
            WcmStringResources.resetResources(true);
        }
    }

    public static void addStringJarBundleToPath(String path, String name, Class loaderClass) {
        WcmStringResources.addStringBundleToPath(new ResourcePathItem(path, name, loaderClass));
    }

    public static void addExceptionJarBundleToPath(String path, String name, Class loaderClass) {
        WcmStringResources.addExceptionBundleToPath(new ResourcePathItem(path, name, loaderClass));
    }

    public static void addStringBundleToPath(String path, String name) {
        WcmStringResources.addStringBundleToPath(new ResourcePathItem(path, name));
    }

    public static void addExceptionBundleToPath(String path, String name) {
        WcmStringResources.addExceptionBundleToPath(new ResourcePathItem(path, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLegacyPRB(boolean exception, InputStream in) throws IOException {
        if (in != null) {
            ResourceMap resourceMap = resources;
            synchronized (resourceMap) {
                ArrayList legacyPRBs = exception ? resources.legacyExceptionPRBs : resources.legacyStringPRBs;
                Properties prb = new Properties();
                prb.load(in);
                in.close();
                legacyPRBs.add(prb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLegacyPRB(boolean exception, Map m) {
        ResourceMap resourceMap = resources;
        synchronized (resourceMap) {
            ArrayList legacyPRBs = exception ? resources.legacyExceptionPRBs : resources.legacyStringPRBs;
            Properties prb = new Properties();
            prb.putAll((Map<?, ?>)m);
            legacyPRBs.add(prb);
        }
    }

    private static String getResource(HashMap strings, String key, String defaultString) {
        String value = (String)strings.get(key);
        if (value == null) {
            value = defaultString;
        }
        return value;
    }

    public static String getStringResource(Locale locale, String key, String defaultString) {
        HashMap strings = null;
        try {
            strings = WcmStringResources.getStringsForLocale(locale);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            strings = new HashMap();
        }
        return WcmStringResources.getResource(strings, key, defaultString);
    }

    public static String getExceptionResource(Locale locale, String key, String defaultString) {
        HashMap strings = null;
        try {
            strings = WcmStringResources.getExceptionsForLocale(locale);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            strings = new HashMap();
        }
        return WcmStringResources.getResource(strings, key, defaultString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap getForLocale(boolean exceptions, Locale locale) throws Exception {
        ResourceMap resourceMap = resources;
        synchronized (resourceMap) {
            boolean useDefaultLocale;
            boolean bl = useDefaultLocale = locale == null;
            if (useDefaultLocale) {
                locale = Locale.getDefault();
            }
            String resourceKey = (exceptions ? EXCEPTION_PREFIX : STRING_PREFIX) + locale;
            HashMap strings = (HashMap)resources.resourceMap.get(resourceKey);
            if (strings == null) {
                strings = WcmStringResources.loadAllInPath(exceptions, locale, useDefaultLocale);
                resources.resourceMap.put(resourceKey, strings);
            }
            return strings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap loadAllInPath(boolean exceptions, Locale locale, boolean loadLegacyPRBs) throws Exception {
        ResourceMap resourceMap = resources;
        synchronized (resourceMap) {
            ArrayList thePath = exceptions ? resources.excResourcePath : resources.strResourcePath;
            ArrayList legacyPRBs = exceptions ? resources.legacyExceptionPRBs : resources.legacyStringPRBs;
            HashMap<Object, Object> strings = new HashMap<Object, Object>();
            WcmStringResources.addClassDefaultStrings(exceptions, strings, locale);
            if (loadLegacyPRBs) {
                for (Properties prb : legacyPRBs) {
                    strings.putAll(prb);
                }
            }
            for (ResourcePathItem item : thePath) {
                WcmStringResources.addToStrings(strings, locale, item);
            }
            return strings;
        }
    }

    private static HashMap getStringsForLocale(Locale locale) throws Exception {
        return WcmStringResources.getForLocale(false, locale);
    }

    private static HashMap getExceptionsForLocale(Locale locale) throws Exception {
        return WcmStringResources.getForLocale(true, locale);
    }

    private static void addClassDefaultStrings(boolean exceptions, HashMap strings, Locale locale) throws Exception {
        Class theClass = exceptions ? WcmException.class : WcmString.class;
        String configName = exceptions ? "WcmExceptionConfiguration" : "WcmStringConfiguration";
        ResourcePathItem item = new ResourcePathItem("", configName, theClass);
        WcmStringResources.addToStrings(strings, locale, item);
    }

    private static void addToStrings(HashMap strings, Locale locale, ResourcePathItem item) throws Exception {
        InputStream in = item.getConfigurationInputStream(locale);
        Properties prb = item.loadResources(in, locale);
        if (prb != null) {
            Enumeration<Object> e = prb.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                strings.put(key, prb.getProperty(key));
            }
        }
    }

    private static class ResourceMap {
        private HashMap resourceMap = new HashMap();
        private ArrayList excResourcePath = new ArrayList();
        private ArrayList strResourcePath = new ArrayList();
        private ArrayList legacyStringPRBs = new ArrayList();
        private ArrayList legacyExceptionPRBs = new ArrayList();

        private ResourceMap() {
        }
    }
}

