/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.wcm.toolkit.util.WcmStringResources;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class WcmString {
    private static final Collator collator = Collator.getInstance();
    private String key;
    private String defaultString;
    private Object[] args;
    private Locale defaultLocale;
    private Map cachedValues;
    private Map formatters;

    public WcmString(String aKey, String engString) {
        this.configureNew(null, aKey, engString, null);
    }

    public WcmString(String aKey, String engString, Object arg0) {
        this.configureNew(null, aKey, engString, new Object[]{arg0});
    }

    public WcmString(String aKey, String engString, Object arg0, Object arg1) {
        this.configureNew(null, aKey, engString, new Object[]{arg0, arg1});
    }

    public WcmString(String aKey, String engString, Object arg0, Object arg1, Object arg2) {
        this.configureNew(null, aKey, engString, new Object[]{arg0, arg1, arg2});
    }

    public WcmString(String aKey, String engString, Object[] arguments) {
        this.configureNew(null, aKey, engString, arguments);
    }

    public WcmString(Locale locale, String aKey, String engString) {
        this.configureNew(locale, aKey, engString, null);
    }

    public WcmString(Locale locale, String aKey, String engString, Object arg0) {
        this.configureNew(locale, aKey, engString, new Object[]{arg0});
    }

    public WcmString(Locale locale, String aKey, String engString, Object arg0, Object arg1) {
        this.configureNew(locale, aKey, engString, new Object[]{arg0, arg1});
    }

    public WcmString(Locale locale, String aKey, String engString, Object arg0, Object arg1, Object arg2) {
        this.configureNew(locale, aKey, engString, new Object[]{arg0, arg1, arg2});
    }

    public WcmString(Locale locale, String aKey, String engString, Object[] arguments) {
        this.configureNew(locale, aKey, engString, arguments);
    }

    private void configureNew(Locale locale, String aKey, String engString, Object[] arguments) {
        this.key = aKey;
        this.defaultString = engString;
        this.args = arguments;
        this.defaultLocale = locale;
        this.cachedValues = new HashMap();
        this.formatters = new HashMap();
    }

    public String toString() {
        return this.toString(this.args);
    }

    public String toString(Locale locale) {
        return this.toString(locale, this.args);
    }

    public static String localize(String aKey, String engString) {
        return WcmString.localize(aKey, engString, null);
    }

    public static String localize(Locale locale, String aKey, String engString) {
        return WcmString.localize(locale, aKey, engString, null);
    }

    public String toString(Object args0) {
        Object[] args = new Object[]{args0};
        return this.toString(args);
    }

    public String toString(Locale locale, Object args0) {
        Object[] args = new Object[]{args0};
        return this.toString(locale, args);
    }

    public static String localize(String aKey, String engString, Object args0) {
        Object[] args = new Object[]{args0};
        return WcmString.localize(aKey, engString, args);
    }

    public static String localize(Locale locale, String aKey, String engString, Object args0) {
        Object[] args = new Object[]{args0};
        return WcmString.localize(locale, aKey, engString, args);
    }

    public String toString(Object args0, Object args1) {
        Object[] args = new Object[]{args0, args1};
        return this.toString(args);
    }

    public String toString(Locale locale, Object args0, Object args1) {
        Object[] args = new Object[]{args0, args1};
        return this.toString(locale, args);
    }

    public static String localize(String aKey, String engString, Object args0, Object args1) {
        Object[] args = new Object[]{args0, args1};
        return WcmString.localize(aKey, engString, args);
    }

    public static String localize(Locale locale, String aKey, String engString, Object args0, Object args1) {
        Object[] args = new Object[]{args0, args1};
        return WcmString.localize(locale, aKey, engString, args);
    }

    public String toString(Object args0, Object args1, Object args2) {
        Object[] args = new Object[]{args0, args1, args2};
        return this.toString(args);
    }

    public String toString(Locale locale, Object args0, Object args1, Object args2) {
        Object[] args = new Object[]{args0, args1, args2};
        return this.toString(locale, args);
    }

    public static String localize(String aKey, String engString, Object args0, Object args1, Object args2) {
        Object[] args = new Object[]{args0, args1, args2};
        return WcmString.localize(aKey, engString, args);
    }

    public static String localize(Locale locale, String aKey, String engString, Object args0, Object args1, Object args2) {
        Object[] args = new Object[]{args0, args1, args2};
        return WcmString.localize(locale, aKey, engString, args);
    }

    public String toString(Object[] args) {
        return this.toString((Locale)null, args);
    }

    public String toString(Locale locale, Object[] args) {
        String result;
        Locale localeKey;
        locale = locale == null ? this.defaultLocale : locale;
        Locale locale2 = localeKey = locale == null ? Locale.getDefault() : locale;
        if (args != null) {
            MessageFormat formatter = (MessageFormat)this.formatters.get(localeKey);
            if (formatter == null) {
                String value = WcmStringResources.getStringResource(locale, this.key, this.defaultString);
                formatter = new MessageFormat(value);
                this.formatters.put(localeKey, formatter);
            }
            result = formatter.format(args);
        } else {
            result = (String)this.cachedValues.get(localeKey);
            if (result == null) {
                String bundleValue = WcmStringResources.getStringResource(locale, this.key, this.defaultString);
                result = MessageFormat.format(bundleValue, null);
                this.cachedValues.put(localeKey, result);
            }
        }
        return result;
    }

    public static String localize(String key, String engString, Object[] args) {
        String result = WcmStringResources.getStringResource(null, key, engString);
        return MessageFormat.format(result, args);
    }

    public static String localize(Locale locale, String key, String engString, Object[] args) {
        String result = WcmStringResources.getStringResource(locale, key, engString);
        return MessageFormat.format(result, args);
    }

    public static int compare(String string1, String string2) {
        return collator.compare(string1, string2);
    }

    public static boolean equals(String string1, String string2) {
        return collator.compare(string1, string2) == 0;
    }

    public static int compareIgnoreCase(String string1, String string2) {
        string1 = string1.toLowerCase();
        string2 = string2.toLowerCase();
        return collator.compare(string1, string2);
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof WcmString) {
            return WcmString.equals(this.toString(), anObject.toString());
        }
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public static void loadResource(InputStream in) throws IOException {
        WcmStringResources.addLegacyPRB(false, in);
    }

    public static void loadResource(Map m) {
        WcmStringResources.addLegacyPRB(false, m);
    }
}

