/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.WcmStringResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class WcmException
extends Exception
implements Serializable {
    public static final WcmString rootException = new WcmString("toolkit.WcmException.rootException", "\n\nRoot Exception:\n");
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_WARNING = 1;
    protected String key = null;
    protected Object[] args = null;
    protected Locale defaultLocale = null;
    protected int status = 0;
    protected String returnUrl = null;
    protected Throwable targetException = null;

    public WcmException(String aKey, String engString) {
        super(engString);
        this.configureException(null, aKey, null);
    }

    public WcmException(String aKey, String engString, Object arg0) {
        super(engString);
        this.configureException(null, aKey, new Object[]{arg0});
    }

    public WcmException(String aKey, String engString, Object arg0, Object arg1) {
        super(engString);
        this.configureException(null, aKey, new Object[]{arg0, arg1});
    }

    public WcmException(String aKey, String engString, Object arg0, Object arg1, Object arg2) {
        super(engString);
        this.configureException(null, aKey, new Object[]{arg0, arg1, arg2});
    }

    public WcmException(String aKey, String engString, Object[] arguments) {
        super(engString);
        this.configureException(null, aKey, arguments);
    }

    public WcmException(Locale locale, String aKey, String engString) {
        super(engString);
        this.configureException(locale, aKey, null);
    }

    public WcmException(Locale locale, String aKey, String engString, Object arg0) {
        super(engString);
        this.configureException(locale, aKey, new Object[]{arg0});
    }

    public WcmException(Locale locale, String aKey, String engString, Object arg0, Object arg1) {
        super(engString);
        this.configureException(locale, aKey, new Object[]{arg0, arg1});
    }

    public WcmException(Locale locale, String aKey, String engString, Object arg0, Object arg1, Object arg2) {
        super(engString);
        this.configureException(locale, aKey, new Object[]{arg0, arg1, arg2});
    }

    public WcmException(Locale locale, String aKey, String engString, Object[] arguments) {
        super(engString);
        this.configureException(locale, aKey, arguments);
    }

    private void configureException(Locale locale, String aKey, Object[] arguments) {
        this.defaultLocale = locale;
        this.key = aKey;
        this.args = arguments;
    }

    public static String getLocalizedMessage(Locale locale, Throwable t) {
        return t instanceof WcmException ? ((WcmException)t).toString(locale) : t.getLocalizedMessage();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Locale locale) {
        locale = locale == null ? this.defaultLocale : locale;
        String result = WcmStringResources.getExceptionResource(locale, this.key, super.getMessage());
        return MessageFormat.format(result, this.args);
    }

    public String getMessage() {
        return this.toString();
    }

    public String getLocalizedMessage() {
        return this.toString();
    }

    public String getKey() {
        return this.key;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public Throwable getTargetException() {
        return this.targetException;
    }

    public void setTargetException(Throwable value) {
        this.targetException = value;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String value) {
        this.returnUrl = value;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.targetException != null) {
            System.err.print(rootException.toString());
            this.targetException.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.targetException != null) {
            printStream.print(rootException.toString());
            this.targetException.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.targetException != null) {
            printWriter.print(rootException.toString());
            this.targetException.printStackTrace(printWriter);
        }
    }

    public static void loadResource(InputStream in) throws IOException {
        WcmStringResources.addLegacyPRB(true, in);
    }

    public static void loadResource(Map m) {
        WcmStringResources.addLegacyPRB(true, m);
    }
}

