/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.wcm.toolkit.util.ResourceBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

class ResourcePathItem
implements ResourceBundle {
    protected String path;
    protected String name;
    protected Class loaderClass = null;
    protected static final String LOCALE_KEY = "WcmStringResources.locale";
    protected static Map existsMap = Collections.synchronizedMap(new HashMap());

    protected ResourcePathItem() {
    }

    public ResourcePathItem(String path, String name) {
        this.initialize(path, name, null);
    }

    public ResourcePathItem(String path, String name, Class loaderClass) {
        this.initialize(path, name, loaderClass);
    }

    protected void initialize(String path, String name, Class loaderClass) {
        this.path = path;
        this.name = name;
        this.loaderClass = loaderClass;
    }

    private InputStream getFileInputStream(String filename) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(filename);
        }
        catch (Exception e) {
            input = null;
        }
        return input;
    }

    private InputStream getJarInputStream(String filename) {
        InputStream input = this.loaderClass.getResourceAsStream(filename);
        return input;
    }

    protected List getConfigurationNames(Locale locale, boolean includeDefaultLocale) {
        ArrayList<String> names = new ArrayList<String>();
        int max = includeDefaultLocale ? 3 : 2;
        StringBuffer qName = new StringBuffer(this.name);
        qName.append(".");
        int qBase = qName.length();
        for (int suffix = 0; suffix < max; ++suffix) {
            qName.setLength(qBase);
            switch (suffix) {
                case 0: {
                    qName.append(locale.getLanguage());
                    qName.append(".");
                    qName.append(locale.getCountry());
                    break;
                }
                case 1: {
                    qName.append(locale.getLanguage());
                    break;
                }
                case 2: {
                    qName.append("en.US");
                }
            }
            names.add(qName.toString());
        }
        return names;
    }

    protected InputStream getConfigurationInputStream(Locale locale) throws IOException {
        InputStream input = null;
        List names = this.getConfigurationNames(locale, true);
        Iterator i = names.iterator();
        while (input == null && i.hasNext()) {
            input = this.getResourceInputStream((String)i.next());
        }
        return input;
    }

    protected String getResourceKey(String name) {
        StringBuffer key = new StringBuffer();
        key.append(this.loaderClass != null ? this.loaderClass.getName() : "NoClass");
        key.append("::");
        key.append(this.path != null && this.path.length() > 0 ? this.path : "NoPath");
        key.append("::");
        key.append(name);
        return key.toString();
    }

    protected Object getResource(String name) {
        String key = this.getResourceKey(name);
        Object obj = existsMap.get(key);
        if (obj == null) {
            if (this.loaderClass != null) {
                String filename = this.path != null && this.path.length() > 0 ? this.catPathParts(this.path, name, "/") : name;
                obj = this.loaderClass.getResource(filename);
                if (obj == null) {
                    obj = new Boolean(false);
                }
            } else {
                obj = new File(this.catPathParts(this.path, name, File.separator));
                if (!((File)obj).exists()) {
                    obj = new Boolean(false);
                }
            }
            existsMap.put(key, obj);
        }
        return obj instanceof Boolean ? null : obj;
    }

    protected boolean resourceExists(String name) {
        return this.getResource(name) != null;
    }

    public Locale findLocale(Enumeration locales, Locale defaultLocale) {
        Locale locale = null;
        Enumeration e = locales;
        while (locale == null && e.hasMoreElements()) {
            Locale testLocale = (Locale)e.nextElement();
            List names = this.getConfigurationNames(testLocale, false);
            Iterator i = names.iterator();
            while (locale == null && i.hasNext()) {
                if (!this.resourceExists((String)i.next())) continue;
                locale = testLocale;
            }
        }
        return locale != null ? locale : defaultLocale;
    }

    protected String catPathParts(String part1, String part2, String separator) {
        StringBuffer buf = new StringBuffer(part1);
        if (!part1.endsWith(separator) && !part2.startsWith(separator)) {
            buf.append(separator);
        }
        buf.append(part2);
        return buf.toString();
    }

    protected InputStream getResourceInputStream(String name) {
        Object obj = this.getResource(name);
        InputStream input = null;
        try {
            if (obj instanceof URL) {
                input = ((URL)obj).openStream();
            } else if (obj instanceof File) {
                input = new FileInputStream((File)obj);
            }
        }
        catch (IOException ioe) {
            input = null;
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadResources(InputStream in, Locale locale) throws Exception {
        InputStream inStream = null;
        Properties thePrb = null;
        try {
            if (in != null) {
                LineNumberReader r = new LineNumberReader(new InputStreamReader(in));
                String line = null;
                thePrb = new Properties();
                while ((line = r.readLine()) != null) {
                    if (line.length() == 0 || line.charAt(0) == '#' || (inStream = this.getResourceInputStream(line)) == null) continue;
                    thePrb.load(inStream);
                }
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return thePrb;
    }
}

