/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.ae.util.search.CBRSearchTerm;
import com.filenet.ae.util.search.CBRSearchUtil;
import com.filenet.wcm.toolkit.util.CBRSearchParser;
import com.filenet.wcm.toolkit.util.CBRSearchType;
import com.filenet.wcm.toolkit.util.CBRSearchXMLUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeParser
extends CBRSearchParser {
    private static final WcmString PHRASE_NOT_ALLOWED = new WcmString("toolkit.CBRSearchParser.phraseNotAllowed", "Phrases cannot be used with the Near modifier. Only words can be used.");

    public CascadeParser(Document document) {
        super(document);
    }

    @Override
    public CBRSearchType getType() {
        return CBRSearchType.CASCADE;
    }

    @Override
    public void parse(String text, String modifier, Node parentNode, Map<String, String> attributes) throws WcmException {
        text = text.trim();
        modifier = CBRSearchXMLUtil.convertToInternalModifier(modifier);
        parentNode = CBRSearchXMLUtil.createNode(this.document, parentNode, "terms");
        if (WcmString.compareIgnoreCase(modifier, "Near") == 0) {
            Node termNode = CBRSearchXMLUtil.createNode(this.document, parentNode, "term");
            if (text.length() > 0) {
                termNode.appendChild(this.document.createTextNode(text));
            }
        } else if (text.length() == 0) {
            CBRSearchXMLUtil.createNode(this.document, parentNode, "term");
        } else {
            List strings;
            try {
                strings = CBRSearchUtil.tokenizeCbrCriteria((String)text, (boolean)true, (boolean)false);
            }
            catch (Exception e) {
                throw new WcmException("toolkit.CascadeParser.genericParseError", "Parser error: {0}", (Object)e.getMessage());
            }
            Iterator i = strings.iterator();
            while (i.hasNext()) {
                CBRSearchTerm term = CBRSearchTerm.fromString((String)((String)i.next()));
                Node termNode = CBRSearchXMLUtil.createNode(this.document, parentNode, "term");
                if (term.isPhrase()) {
                    CBRSearchXMLUtil.setNodeAttribute(this.document, termNode, "phrase", "true");
                }
                termNode.appendChild(this.document.createTextNode(term.getValue()));
            }
        }
    }

    @Override
    public String validate(String text, String modifier, boolean required) throws WcmException {
        String errorMsg = null;
        CBRSearchParser.TextStats stats = this.analyzeText(text);
        int termCount = stats.wordCount + stats.phraseCount;
        if (WcmString.compareIgnoreCase(modifier = CBRSearchXMLUtil.convertToInternalModifier(modifier), "None") == 0) {
            if (required && termCount == 0 || termCount > 1) {
                errorMsg = ONE_OPERAND_MAX.toString();
            }
        } else if (WcmString.compareIgnoreCase(modifier, "All") == 0 || WcmString.compareIgnoreCase(modifier, "Any") == 0) {
            if (required && termCount < 1) {
                errorMsg = ONE_OPERAND_MIN.toString();
            } else if (stats.prohibitedTermCount > 0) {
                errorMsg = EXCLAMATION_MARK_NOT_ALLOWED.toString();
            }
        } else if (WcmString.compareIgnoreCase(modifier, "Near") == 0) {
            if (required && termCount < 2 || termCount == 1) {
                errorMsg = TWO_OPERANDS_MIN.toString();
            } else if (stats.phraseCount > 0) {
                errorMsg = PHRASE_NOT_ALLOWED.toString();
            } else if (stats.prohibitedTermCount > 0) {
                errorMsg = EXCLAMATION_MARK_NOT_ALLOWED.toString();
            }
        }
        return errorMsg;
    }
}

