/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.CBRSearchParser;
import com.filenet.wcm.toolkit.util.CBRSearchType;
import com.filenet.wcm.toolkit.util.CascadeParser;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.WcmVerityParser;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CBRSearchXMLUtil {
    public static final String ELEM_CONTENT = "content";
    public static final String ELEM_AND = "and";
    public static final String ELEM_OR = "or";
    public static final String ELEM_ITEM = "item";
    public static final String ELEM_TERMS = "terms";
    public static final String ELEM_TERM = "term";
    public static final String ELEM_VERITYCONTENT = "veritycontent";
    public static final String ELEM_VERITYAND = "verityand";
    public static final String ELEM_VERITYOR = "verityor";
    public static final String ELEM_VERITYITEM = "verityitem";
    public static final String ELEM_USERTEXT = "usertext";
    public static final String ELEM_VERITYITEMDATA = "verityitemdata";
    public static final String ATTRIB_DIALECT = "dialect";
    public static final String ATTRIB_PHRASE = "phrase";
    public static final String ATTRIB_SEARCHMODIFIER = "searchmodifier";
    public static final String ATTRIB_SEARCHMODIFIERRANGE = "searchmodifierrange";
    public static final String ATTRIB_REQUIREDSTATE = "requiredstate";
    public static final String VALUE_DIALECT_LUCENE = "lucene";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_PROXIMITY = "proximity";
    public static final String VALUE_PROHIBITED = "prohibited";
    public static final String MODIFIER_NONE = "None";
    public static final String MODIFIER_ALL = "All";
    public static final String MODIFIER_ANY = "Any";
    public static final String MODIFIER_IN_ZONE = "In Zone";
    public static final String MODIFIER_NEAR = "Near";
    public static final String MODIFIER_PARAGRAPH = "Paragraph";
    public static final String MODIFIER_SENTENCE = "Sentence";
    public static final String MODIFIER_VQL = "VQL";

    private CBRSearchXMLUtil() {
    }

    public static CBRSearchParser getCBRSearchParser(CBRSearchType cbrSearchType, Document document) {
        return cbrSearchType == CBRSearchType.VERITY ? new WcmVerityParser(document) : new CascadeParser(document);
    }

    public static String convertToInternalModifier(String localizedModifier) {
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_verityNoneStr) == 0) {
            return MODIFIER_NONE;
        }
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_allStr) == 0) {
            return MODIFIER_ALL;
        }
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_anyStr) == 0) {
            return MODIFIER_ANY;
        }
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_inZoneStr) == 0) {
            return MODIFIER_IN_ZONE;
        }
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_nearStr) == 0) {
            return MODIFIER_NEAR;
        }
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_paragraphStr) == 0) {
            return MODIFIER_PARAGRAPH;
        }
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_sentenceStr) == 0) {
            return MODIFIER_SENTENCE;
        }
        if (WcmString.compareIgnoreCase(localizedModifier, WcmResource.s_vqlStr) == 0) {
            return MODIFIER_VQL;
        }
        return localizedModifier;
    }

    public static boolean isModifierCompatible(CBRSearchType cbrSearchType, String modifier) {
        boolean compatible = true;
        if (modifier != null && modifier.length() > 0) {
            modifier = CBRSearchXMLUtil.convertToInternalModifier(modifier);
            if (!(cbrSearchType != CBRSearchType.CASCADE || modifier.equalsIgnoreCase(MODIFIER_NONE) || modifier.equalsIgnoreCase(MODIFIER_ALL) || modifier.equalsIgnoreCase(MODIFIER_ANY) || modifier.equalsIgnoreCase(MODIFIER_NEAR))) {
                compatible = false;
            }
        }
        return compatible;
    }

    public static Node createNode(Document document, Node parentNode, String name) {
        Element node = document.createElement(name);
        parentNode.appendChild(node);
        parentNode.appendChild(document.createTextNode("\n"));
        return node;
    }

    public static void setNodeAttribute(Document document, Node node, String name, String value) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            Attr attribNode = document.createAttribute(name);
            attribNode.setNodeValue(value);
            attributes.setNamedItem(attribNode);
        }
    }

    public static void setNodeAttributes(Document document, Node node, Map<String, String> attributes) {
        for (String name : attributes.keySet()) {
            CBRSearchXMLUtil.setNodeAttribute(document, node, name, attributes.get(name));
        }
    }
}

