/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.util;

import com.filenet.ae.util.search.CBRSearchTerm;
import com.filenet.ae.util.search.CBRSearchUtil;
import com.filenet.wcm.toolkit.util.CBRSearchType;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CBRSearchParser {
    protected static final WcmString ONE_OPERAND_MAX = new WcmString("toolkit.CBRSearchParser.oneOperandMax", "This modifier requires one operand.");
    protected static final WcmString ONE_OPERAND_MIN = new WcmString("toolkit.CBRSearchParser.oneOperandMin", "This modifier requires one or more operands.");
    protected static final WcmString TWO_OPERANDS_MIN = new WcmString("toolkit.CBRSearchParser.two_operands_min", "This modifier requires two or more operands.");
    protected static final WcmString EXCLAMATION_MARK_NOT_ALLOWED = new WcmString("toolkit.CBRSearchParser.exclamationMarkNotAllowed", "An exclamation mark cannot be used as the first character of a word or phrase.");
    protected Document document;

    public CBRSearchParser(Document document) {
        this.document = document;
    }

    public abstract CBRSearchType getType();

    public abstract void parse(String var1, String var2, Node var3, Map<String, String> var4) throws WcmException;

    public abstract String validate(String var1, String var2, boolean var3) throws WcmException;

    protected TextStats analyzeText(String text) throws WcmException {
        List strings;
        try {
            strings = CBRSearchUtil.tokenizeCbrCriteria((String)text, (this.getType() == CBRSearchType.CASCADE ? 1 : 0) != 0, (boolean)false);
        }
        catch (IOException e) {
            throw new WcmException("toolkit.CBRSearchParser.parserError", "Parser error: {0}", (Object)e.getMessage());
        }
        TextStats stats = new TextStats();
        Iterator i = strings.iterator();
        while (i.hasNext()) {
            CBRSearchTerm term = CBRSearchTerm.fromString((String)((String)i.next()));
            if (term.isPhrase()) {
                ++stats.phraseCount;
            } else {
                ++stats.wordCount;
            }
            if (!term.isProhibited()) continue;
            ++stats.prohibitedTermCount;
        }
        return stats;
    }

    protected static final class TextStats {
        protected int wordCount = 0;
        protected int phraseCount = 0;
        protected int prohibitedTermCount = 0;

        protected TextStats() {
        }
    }
}

