/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.server.util.xml;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WcmXMLUtil {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    private WcmXMLUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = WcmXMLUtil.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            return WcmXMLUtil.documentBuilderFactory.newDocumentBuilder();
        }
    }

    public static void writePrettyXML(Writer w, Node node) {
        WcmXMLUtil.writeXML(new PrettyFilter(w), node);
    }

    public static void writeXML(Writer w, Node node) {
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        XMLWriter.serializeAsXML(node, w);
    }

    public static void writeXML(OutputStream out, Node node) {
        OutputStreamWriter w = new OutputStreamWriter(out);
        WcmXMLUtil.writeXML(w, node);
    }

    public static Document getDocumentFromString(String xml) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder db = WcmXMLUtil.getDocumentBuilder();
        return db.parse(new InputSource(new StringReader(xml)));
    }

    public static Document getDocumentFromReader(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder dp = WcmXMLUtil.getDocumentBuilder();
        return dp.parse(new InputSource(reader));
    }

    public static Document getDocumentFromInputStream(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder dp = WcmXMLUtil.getDocumentBuilder();
        return dp.parse(inputStream);
    }

    public static Document getDocumentFromInputSource(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder dp = WcmXMLUtil.getDocumentBuilder();
        return dp.parse(inputSource);
    }

    public static Element getChildElement(Element parent, String childElementName) {
        return (Element)WcmXMLUtil.getChildNode(parent, childElementName);
    }

    public static String getChildElementText(Element parent, String childElementName) {
        Element child = (Element)WcmXMLUtil.getChildNode(parent, childElementName);
        if (child != null) {
            return WcmXMLUtil.getElementText(child);
        }
        return null;
    }

    public static List getChildElements(Element parentElement) {
        NodeList oChildren = parentElement.getChildNodes();
        int len = oChildren.getLength();
        ArrayList<Node> oList = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node oNode = oChildren.item(i);
            if (oNode.getNodeType() != 1) continue;
            oList.add(oNode);
        }
        return oList;
    }

    public static List getChildElements(Element parentElement, String childElementName) {
        NodeList children = parentElement.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> list = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(childElementName)) continue;
            list.add(node);
        }
        return list;
    }

    public static Node getChildNode(Node node, String childToFind) {
        NodeList oChildren = node.getChildNodes();
        Node oReturnValue = WcmXMLUtil.getNamedNode(oChildren, childToFind);
        return oReturnValue;
    }

    public static Node getNamedNode(NodeList nodes, String nameToFind) {
        int nCount = nodes.getLength();
        for (int i = 0; i < nCount; ++i) {
            Node node = nodes.item(i);
            String sNodeName = node.getNodeName();
            if (sNodeName == null || !sNodeName.equals(nameToFind)) continue;
            return node;
        }
        return null;
    }

    public static void setElementText(Element element, String value) {
        if (element != null) {
            Node childNode = element.getFirstChild();
            if (childNode != null) {
                childNode.setNodeValue(value);
            } else {
                childNode = element.getOwnerDocument().createTextNode(value);
                element.appendChild(childNode);
            }
        }
    }

    public static String getElementText(Element element) {
        Node oChildNode;
        if (element != null && (oChildNode = element.getFirstChild()) != null && oChildNode.getNodeType() == 3) {
            return oChildNode.getNodeValue();
        }
        return null;
    }

    public static Element addChildElement(Element parent, String childElementName) {
        Element child = parent.getOwnerDocument().createElement(childElementName);
        parent.appendChild(child);
        return child;
    }

    public static Element addChildElementNS(Element parent, String childElementName) {
        String namespace = parent.getNamespaceURI();
        Element child = parent.getOwnerDocument().createElementNS(namespace, childElementName);
        parent.appendChild(child);
        return child;
    }

    public static Element addChildElement(Element parent, String childElementName, String childElementText) {
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElement(childElementName);
        child.appendChild(doc.createTextNode(childElementText));
        parent.appendChild(child);
        return child;
    }

    public static Element addChildElementNS(Element parent, String childElementName, String childElementText) {
        Document doc = parent.getOwnerDocument();
        String namespace = parent.getNamespaceURI();
        Element child = doc.createElementNS(namespace, childElementName);
        child.appendChild(doc.createTextNode(childElementText));
        parent.appendChild(child);
        return child;
    }

    public static String getElementCompleteText(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList oChildNodes = element.getChildNodes();
        int nChildCount = oChildNodes.getLength();
        for (int i = 0; i < nChildCount; ++i) {
            Node oNode = oChildNodes.item(i);
            if (oNode.getNodeType() != 3) continue;
            String sNodeValue = oNode.getNodeValue();
            sb.append(sNodeValue);
        }
        String sReturnValue = sb.toString();
        return sReturnValue;
    }

    public static void removeAllChildren(Node node) {
        while (node.getFirstChild() != null) {
            Node child = node.getFirstChild();
            node.removeChild(child);
        }
    }

    public static String[] convertNodeListToStringArray(NodeList nodes) {
        int len = nodes.getLength();
        String[] sValues = new String[len];
        for (int i = 0; i < len; ++i) {
            Node oNode = nodes.item(i);
            sValues[i] = oNode.getNodeValue();
        }
        return sValues;
    }

    public static String[] convertListOfNodesToStringArray(List nodes) {
        int len = nodes.size();
        String[] sValues = new String[len];
        for (int i = 0; i < len; ++i) {
            Node oNode = (Node)nodes.get(i);
            sValues[i] = oNode.getNodeValue();
        }
        return sValues;
    }

    public static String[] convertNodeListOfElementsToStringArray(NodeList elements) {
        int len = elements.getLength();
        String[] sValues = new String[len];
        for (int i = 0; i < len; ++i) {
            Element element = (Element)elements.item(i);
            sValues[i] = WcmXMLUtil.getElementText(element);
        }
        return sValues;
    }

    public static Document getNewDocument() throws ParserConfigurationException {
        DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
        return db.newDocument();
    }

    public static String saveToString(Node node) {
        StringWriter sw = new StringWriter(512);
        WcmXMLUtil.writeXML(sw, node);
        return sw.toString();
    }

    public static String encodeForXML(String str) {
        if (str == null) {
            return null;
        }
        int nSize = str.length();
        StringBuffer sb = new StringBuffer(nSize);
        block7: for (int i = 0; i < nSize; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String decodeFromXML(String str) {
        if (str == null) {
            return null;
        }
        int nSize = str.length();
        StringBuffer sb = new StringBuffer(nSize);
        for (int i = 0; i < nSize; ++i) {
            char c = str.charAt(i);
            if (c == '&') {
                String entity = str.substring(i + 1, str.indexOf(59, i));
                if (entity.equals("lt")) {
                    sb.append('<');
                    i = str.indexOf(59, i);
                    continue;
                }
                if (entity.equals("gt")) {
                    sb.append('>');
                    i = str.indexOf(59, i);
                    continue;
                }
                if (entity.equals("quot")) {
                    sb.append('\"');
                    i = str.indexOf(59, i);
                    continue;
                }
                if (entity.equals("apos")) {
                    sb.append('\'');
                    i = str.indexOf(59, i);
                    continue;
                }
                if (entity.equals("amp")) {
                    sb.append('&');
                    i = str.indexOf(59, i);
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Element createNamespace(Document doc, String namespaceName, String namespaceURI) throws Exception {
        Element elemContentEngineNameSpace = doc.createElement("ns");
        elemContentEngineNameSpace.setAttribute(namespaceName, namespaceURI);
        return elemContentEngineNameSpace;
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
    }

    private static class XMLWriter {
        private static final String lineSeparator = System.getProperty("line.separator", "\n");
        private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

        private XMLWriter() {
        }

        public static String nodeToString(Node node) {
            StringWriter sw = new StringWriter();
            XMLWriter.serializeAsXML(node, sw);
            return sw.toString();
        }

        public static void serializeAsXML(Node node, Writer writer) {
            XMLWriter.print(node, null, new PrintWriter(writer));
        }

        private static void print(Node node, ObjectRegistry namespaceStack, PrintWriter out) {
            if (node == null) {
                return;
            }
            boolean hasChildren = false;
            short type = node.getNodeType();
            switch (type) {
                case 9: {
                    out.println("<?xml version=\"1.0\"?>");
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int numChildren = children.getLength();
                    for (int i = 0; i < numChildren; ++i) {
                        XMLWriter.print(children.item(i), namespaceStack, out);
                    }
                    break;
                }
                case 1: {
                    NamedNodeMap attrs;
                    namespaceStack = new ObjectRegistry(namespaceStack);
                    out.print('<' + node.getNodeName());
                    String elPrefix = node.getPrefix();
                    String elNamespaceURI = node.getNamespaceURI();
                    if (elPrefix != null && elPrefix.length() > 0 && elNamespaceURI != null && elNamespaceURI.length() > 0) {
                        boolean prefixIsDeclared = false;
                        try {
                            String namespaceURI = (String)namespaceStack.lookup(elPrefix);
                            if (elNamespaceURI.equals(namespaceURI)) {
                                prefixIsDeclared = true;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        if (!prefixIsDeclared) {
                            XMLWriter.printNamespaceDecl(node, namespaceStack, out);
                        }
                    }
                    int len = (attrs = node.getAttributes()) != null ? attrs.getLength() : 0;
                    for (int i = 0; i < len; ++i) {
                        Attr attr = (Attr)attrs.item(i);
                        out.print(' ' + attr.getNodeName() + "=\"" + XMLWriter.normalize(attr.getValue()) + '\"');
                        String attrPrefix = attr.getPrefix();
                        String attrNamespaceURI = attr.getNamespaceURI();
                        if (attrPrefix == null || attrPrefix.length() <= 0 || attrNamespaceURI == null || attrNamespaceURI.length() <= 0) continue;
                        boolean prefixIsDeclared = false;
                        try {
                            String namespaceURI = (String)namespaceStack.lookup(attrPrefix);
                            if (attrNamespaceURI.equals(namespaceURI)) {
                                prefixIsDeclared = true;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        if (prefixIsDeclared) continue;
                        XMLWriter.printNamespaceDecl(attr, namespaceStack, out);
                    }
                    NodeList children = node.getChildNodes();
                    if (children != null) {
                        int numChildren = children.getLength();
                        boolean bl = hasChildren = numChildren > 0;
                        if (hasChildren) {
                            out.print('>');
                        }
                        for (int i = 0; i < numChildren; ++i) {
                            XMLWriter.print(children.item(i), namespaceStack, out);
                        }
                    } else {
                        hasChildren = false;
                    }
                    if (hasChildren) break;
                    out.print("/>");
                    break;
                }
                case 5: {
                    out.print('&');
                    out.print(node.getNodeName());
                    out.print(';');
                    break;
                }
                case 4: {
                    out.print("<![CDATA[");
                    out.print(node.getNodeValue());
                    out.print("]]>");
                    break;
                }
                case 3: {
                    out.print(XMLWriter.normalize(node.getNodeValue()));
                    break;
                }
                case 8: {
                    out.print("<!--");
                    out.print(node.getNodeValue());
                    out.print("-->");
                    break;
                }
                case 7: {
                    out.print("<?");
                    out.print(node.getNodeName());
                    String data = node.getNodeValue();
                    if (data != null && data.length() > 0) {
                        out.print(' ');
                        out.print(data);
                    }
                    out.println("?>");
                    break;
                }
            }
            if (type == 1 && hasChildren) {
                out.print("</");
                out.print(node.getNodeName());
                out.print('>');
            }
        }

        private static void printNamespaceDecl(Node node, ObjectRegistry namespaceStack, PrintWriter out) {
            switch (node.getNodeType()) {
                case 2: {
                    XMLWriter.printNamespaceDecl(((Attr)node).getOwnerElement(), node, namespaceStack, out);
                    break;
                }
                case 1: {
                    XMLWriter.printNamespaceDecl((Element)node, node, namespaceStack, out);
                }
            }
        }

        private static void printNamespaceDecl(Element owner, Node node, ObjectRegistry namespaceStack, PrintWriter out) {
            String namespaceURI = node.getNamespaceURI();
            String prefix = node.getPrefix();
            if (!namespaceURI.equals(NS_URI_XMLNS) || !prefix.equals("xmlns")) {
                if (XMLWriter.getAttributeNS(owner, NS_URI_XMLNS, prefix) == null) {
                    out.print(" xmlns:" + prefix + "=\"" + namespaceURI + '\"');
                }
            } else {
                prefix = node.getLocalName();
                namespaceURI = node.getNodeValue();
            }
            namespaceStack.register(prefix, namespaceURI);
        }

        public static String getAttributeNS(Element el, String namespaceURI, String localPart) {
            String sRet = null;
            Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
            if (attr != null) {
                sRet = attr.getValue();
            }
            return sRet;
        }

        private static String normalize(String s) {
            if (s == null) {
                return "";
            }
            int len = s.length();
            StringBuffer str = new StringBuffer(len * 2);
            block7: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '<': {
                        str.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        str.append("&gt;");
                        continue block7;
                    }
                    case '&': {
                        str.append("&amp;");
                        continue block7;
                    }
                    case '\"': {
                        str.append("&quot;");
                        continue block7;
                    }
                    case '\n': {
                        if (i > 0) {
                            char lastChar = str.charAt(str.length() - 1);
                            if (lastChar != '\r') {
                                str.append(lineSeparator);
                                continue block7;
                            }
                            str.append('\n');
                            continue block7;
                        }
                        str.append(lineSeparator);
                        continue block7;
                    }
                    default: {
                        str.append(ch);
                    }
                }
            }
            return str.toString();
        }

        public static class ObjectRegistry {
            Hashtable reg = new Hashtable();
            ObjectRegistry parent = null;

            public ObjectRegistry() {
            }

            public ObjectRegistry(ObjectRegistry parent) {
                this.parent = parent;
            }

            public void register(String name, Object obj) {
                this.reg.put(name, obj);
            }

            public void unregister(String name) {
                this.reg.remove(name);
            }

            public Object lookup(String name) throws IllegalArgumentException {
                Object obj = this.reg.get(name);
                if (obj == null && this.parent != null) {
                    obj = this.parent.lookup(name);
                }
                if (obj == null) {
                    throw new IllegalArgumentException("object '" + name + "' not in registry");
                }
                return obj;
            }
        }
    }

    private static class PrettyFilter
    extends FilterWriter {
        private boolean openCaretQueued = false;
        private boolean inElement = false;
        private boolean closeElementQueued = false;
        private boolean inWork = false;
        private int indentLevel = 0;
        private int lastIndentLevel = 0;
        private String indent = "    ";
        private int openCaret = 60;
        private int closeElement = 47;
        private int closeCaret = 62;

        public PrettyFilter(Writer w) {
            super(w);
        }

        private void reduceIndent() {
            if (--this.indentLevel < 0) {
                this.indentLevel = 0;
            }
        }

        private void writeNewLine(int useIndentLevel) throws IOException {
            super.write(10);
            for (int n = 0; n < useIndentLevel; ++n) {
                super.write(this.indent);
            }
        }

        private void writeSkipCloseElement(char c) throws IOException {
            super.write(this.closeElement);
            super.write(c);
            this.closeElementQueued = false;
        }

        private void writeCloseSingleElement() throws IOException {
            boolean doNewLine = this.lastIndentLevel != this.indentLevel;
            this.inWork = true;
            super.write(this.closeElement);
            super.write(this.closeCaret);
            if (doNewLine) {
                this.writeNewLine(this.indentLevel);
            }
            this.reduceIndent();
            this.inWork = false;
            this.openCaretQueued = false;
            this.closeElementQueued = false;
            this.inElement = false;
        }

        private void writeCloseElement() throws IOException {
            boolean doNewLine = this.lastIndentLevel != this.indentLevel;
            this.inWork = true;
            this.reduceIndent();
            if (doNewLine) {
                this.writeNewLine(this.indentLevel);
            }
            super.write(this.openCaret);
            super.write(this.closeElement);
            this.inWork = false;
            this.openCaretQueued = false;
            this.inElement = false;
        }

        private void writeOpenElement(int c) throws IOException {
            this.inWork = true;
            this.writeNewLine(this.indentLevel++);
            this.lastIndentLevel = this.indentLevel;
            super.write(this.openCaret);
            super.write(c);
            this.inWork = false;
            this.openCaretQueued = false;
            this.inElement = true;
        }

        private void writeBuffered(StringBuffer buf) throws IOException {
            if (buf.length() > 0) {
                this.inWork = true;
                super.write(buf.toString());
                this.inWork = false;
                buf.setLength(0);
            }
        }

        private void rawWrite(char c, StringBuffer buf) throws IOException {
            if (!this.openCaretQueued && c == this.openCaret) {
                if (buf != null) {
                    this.writeBuffered(buf);
                }
                this.openCaretQueued = true;
            } else if (this.openCaretQueued && c == this.closeElement) {
                this.writeCloseElement();
            } else if (!this.closeElementQueued && this.inElement && c == this.closeElement) {
                if (buf != null) {
                    this.writeBuffered(buf);
                }
                this.closeElementQueued = true;
            } else if (this.closeElementQueued && c == this.closeCaret) {
                this.writeCloseSingleElement();
            } else if (this.closeElementQueued) {
                this.writeSkipCloseElement(c);
            } else if (this.openCaretQueued) {
                this.writeOpenElement(c);
            } else if (buf != null) {
                buf.append(c);
            }
        }

        public void write(int c) throws IOException {
            if (this.inWork) {
                super.write(c);
            } else {
                this.rawWrite((char)c, null);
            }
        }

        public void write(char[] chars, int i, int i1) throws IOException {
            if (this.inWork) {
                super.write(chars, i, i1);
            } else {
                StringBuffer buf = new StringBuffer();
                for (int n = 0; n < i1; ++n) {
                    this.rawWrite(chars[i + n], buf);
                }
                this.writeBuffered(buf);
            }
        }

        public void write(String s, int i, int i1) throws IOException {
            if (this.inWork) {
                super.write(s, i, i1);
            } else {
                StringBuffer buf = new StringBuffer();
                for (int n = 0; n < i1; ++n) {
                    this.rawWrite(s.charAt(i + n), buf);
                }
                this.writeBuffered(buf);
            }
        }
    }
}

