/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.server.util.prefs;

import com.filenet.wcm.toolkit.server.util.prefs.PrefsLabel;
import com.filenet.wcm.toolkit.server.util.xml.WcmXMLUtil;
import com.filenet.wcm.toolkit.util.WcmString;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WcmPrefsObject
implements Cloneable,
Serializable {
    private static final String LOCALIZED_PREFIX = "loc_";
    private static final String DEFAULT_OBJECT_KEY = "prefsObject";
    private static final Class<WcmPrefsObject> thisClass = WcmPrefsObject.class;
    private static final Map<Object, Object> registryMap = new ConcurrentHashMap<Object, Object>();
    private Map<String, Object> data = new Hashtable<String, Object>();
    private Map<Object, Object> attributes = new Hashtable<Object, Object>();
    private String objectKey;
    private String version;

    public void clear() {
        this.data.clear();
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return "";
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public final String getElementKey() {
        if (this.objectKey == null) {
            this.objectKey = (String)registryMap.get(this.getClass());
            if (this.objectKey == null) {
                this.objectKey = DEFAULT_OBJECT_KEY;
            }
        }
        return this.objectKey;
    }

    public final void setElementKey(String name) {
        this.objectKey = name;
    }

    private void saveSetting(String key, WcmPrefsObject value) {
        if (key != null && value != null) {
            value.setElementKey(key);
            this.data.put(key, value);
        }
    }

    private void saveSetting(String key, Object value) {
        if (key != null) {
            if (value != null) {
                this.data.put(key, value);
            } else {
                this.data.remove(key);
            }
        }
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void put(String key, boolean value) {
        String sValue = value ? "true" : "false";
        this.saveSetting(key, sValue);
    }

    public void put(String key, int value) {
        this.saveSetting(key, Integer.toString(value));
    }

    public void put(String key, String value) {
        this.saveSetting(key, value);
    }

    public void put(String key, String[] value) {
        this.saveSetting(key, value);
    }

    public void put(String key, PrefsLabel value) {
        this.saveSetting(key, value);
    }

    public void put(String key, PrefsLabel[] value) {
        this.saveSetting(key, value);
    }

    public void put(String key, WcmPrefsObject value) {
        this.saveSetting(key, value);
    }

    public void put(String key, List value) {
        this.saveSetting(key, value);
    }

    public Object remove(String key) {
        return this.data.remove(key);
    }

    public WcmString removeLocalizedString(String key) {
        this.data.remove(key);
        return (WcmString)this.data.remove(LOCALIZED_PREFIX + key);
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public WcmString getLocalizedString(String key) {
        return (WcmString)this.data.get(LOCALIZED_PREFIX + key);
    }

    protected static boolean convertToBoolean(Object value) {
        return WcmPrefsObject.convertToBoolean(value, false);
    }

    protected static boolean convertToBoolean(Object value, boolean defaultValue) {
        if (value instanceof String) {
            return value.equals("true");
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        return WcmPrefsObject.convertToBoolean(value);
    }

    public PrefsLabel getLabel(String key) {
        PrefsLabel label = (PrefsLabel)this.get(key);
        return label;
    }

    public String getString(String key) {
        return (String)this.data.get(key);
    }

    protected static int convertToInt(Object value) {
        if (value instanceof String) {
            try {
                int n = Integer.parseInt((String)value);
                return n;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    protected static long convertToLong(Object value) {
        if (value instanceof String) {
            try {
                long n = Long.parseLong((String)value);
                return n;
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    protected static PrefsLabel[] convertToPrefsLabelArray(Object value) {
        if (value instanceof PrefsLabel[]) {
            return (PrefsLabel[])value;
        }
        if (value instanceof String[]) {
            String[] vals = (String[])value;
            PrefsLabel[] labels = new PrefsLabel[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                String val = vals[i];
                labels[i] = new PrefsLabel(val);
            }
            return labels;
        }
        return new PrefsLabel[0];
    }

    protected static PrefsLabel convertToPrefsLabel(Object value) {
        if (value instanceof PrefsLabel) {
            return (PrefsLabel)value;
        }
        if (value instanceof String) {
            return new PrefsLabel((String)value);
        }
        return new PrefsLabel();
    }

    public int getInt(String key) {
        Object value = this.data.get(key);
        return WcmPrefsObject.convertToInt(value);
    }

    public String[] getStringArray(String key) {
        return (String[])this.data.get(key);
    }

    public List getList(String key) {
        return (List)this.data.get(key);
    }

    public PrefsLabel[] getLabelArray(String key) {
        return (PrefsLabel[])this.data.get(key);
    }

    public final String toXML() throws IOException {
        StringWriter sw = new StringWriter(1024);
        this.writeXML(sw);
        return sw.toString();
    }

    public Set getDataKeySet() {
        return this.data.keySet();
    }

    public final byte[] toByteArrayXML() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
        this.writeXML(w);
        w.close();
        byte[] result = out.toByteArray();
        return result;
    }

    public final void writeXML(Writer w) throws IOException {
        this.writeXML(w, true);
    }

    public final void writeXML(Writer w, String encoding) throws IOException {
        if (encoding != null) {
            w.write("<?xml version=\"1.0\" encoding=\"");
            w.write(encoding);
            w.write("\"?>\n");
        }
        this.writeXML(w, true);
    }

    private void writeXML(Writer w, boolean bAddVersionNumber) throws IOException {
        this.persist();
        this.getElementKey();
        boolean keyRegistred = registryMap.get(this.objectKey) != null;
        w.write("<object key=\"");
        w.write(this.objectKey);
        w.write("\"");
        if (bAddVersionNumber) {
            w.write(" version=\"");
            w.write(this.getVersion());
            w.write(34);
        }
        if (!keyRegistred) {
            w.write(" class=\"");
            w.write(this.getClass().getName());
            w.write(34);
        }
        w.write(">\r\n");
        this.saveToXML(w);
        for (Map.Entry<String, Object> e : this.data.entrySet()) {
            Object[] values;
            String key = e.getKey();
            Object value = e.getValue();
            if (value instanceof String) {
                String s = (String)value;
                this.writeSetting(w, key, s);
                continue;
            }
            if (value instanceof WcmPrefsObject) {
                WcmPrefsObject p = (WcmPrefsObject)value;
                this.writeSetting(w, key, p);
                continue;
            }
            if (value instanceof PrefsLabel) {
                PrefsLabel label = (PrefsLabel)value;
                this.writeSetting(w, key, label);
                continue;
            }
            if (value instanceof String[]) {
                values = (String[])value;
                this.writeSetting(w, key, (String[])values);
                continue;
            }
            if (value instanceof PrefsLabel[]) {
                values = (PrefsLabel[])value;
                this.writeSetting(w, key, (PrefsLabel[])values);
                continue;
            }
            if (!(value instanceof List)) continue;
            List lst = (List)value;
            this.writeSetting(w, key, lst);
        }
        w.write("</object>\r\n");
    }

    protected final void writeStartSettingTag(Writer w, String key, String localizationKey) throws IOException {
        w.write("<setting key=\"");
        w.write(key);
        w.write("\" localizationKey=\"");
        w.write(localizationKey);
        w.write("\">");
    }

    protected final void writeStartSettingTag(Writer w, String sKey) throws IOException {
        w.write("<setting key=\"");
        w.write(sKey);
        w.write("\">");
    }

    protected final void writeEndSettingTag(Writer w) throws IOException {
        w.write("</setting>\r\n");
    }

    protected final void writeSetting(Writer w, String key, boolean value) throws IOException {
        if (key != null) {
            this.writeStartSettingTag(w, key);
            w.write(value ? "true" : "false");
            this.writeEndSettingTag(w);
        }
    }

    protected final void writeSetting(Writer w, String key, boolean[] values) throws IOException {
        if (values == null || values.length == 0) {
            w.write("<array key=\"");
            w.write(key);
            w.write("\"/>\r\n");
        } else {
            w.write("<array key=\"");
            w.write(key);
            w.write("\">\r\n");
            for (boolean value : values) {
                w.write("  <value>");
                w.write(value ? "true" : "false");
                w.write("</value>\r\n");
            }
            w.write("</array>\r\n");
        }
    }

    protected final void writeSetting(Writer w, String key, PrefsLabel value) throws IOException {
        if (value != null) {
            String keyPart = key == null || key.equals("") ? "" : " key=\"" + key + "\"";
            String localizationKeyPart = value.localizationKey == null ? "" : " localizationKey=\"" + value.localizationKey + "\"";
            String defRes = value.defaultResource == null ? "" : value.defaultResource;
            w.write("<label" + keyPart + localizationKeyPart + ">\r\n");
            w.write("  <resource>" + WcmXMLUtil.encodeForXML(defRes) + "</resource>\r\n");
            for (Map.Entry<String, String> entry : value.resourceMap.entrySet()) {
                String locale = entry.getKey();
                String resourceValue = entry.getValue();
                w.write("  <resource locale=\"" + locale + "\">" + WcmXMLUtil.encodeForXML(resourceValue) + "</resource>\r\n");
            }
            w.write("</label>\r\n");
        }
    }

    protected final void writeSetting(Writer w, String key, int value) throws IOException {
        if (key != null) {
            this.writeStartSettingTag(w, key);
            w.write(Integer.toString(value));
            this.writeEndSettingTag(w);
        }
    }

    protected final void writeSetting(Writer w, String key, long value) throws IOException {
        if (key != null) {
            this.writeStartSettingTag(w, key);
            w.write(Long.toString(value));
            this.writeEndSettingTag(w);
        }
    }

    protected final void writeSetting(Writer w, String key, String value) throws IOException {
        if (key != null && value != null) {
            this.writeStartSettingTag(w, key);
            w.write(WcmXMLUtil.encodeForXML(value));
            this.writeEndSettingTag(w);
        }
    }

    protected final void writeSetting(Writer w, String key, WcmString value) throws IOException {
        if (key != null && value != null) {
            this.writeStartSettingTag(w, key, value.getKey());
            String englishValue = value.toString();
            w.write(WcmXMLUtil.encodeForXML(englishValue));
            this.writeEndSettingTag(w);
        }
    }

    protected final void writeSetting(Writer w, String key, PrefsLabel[] values) throws IOException {
        if (values == null || values.length == 0) {
            w.write("<labelArray key=\"");
            w.write(key);
            w.write("\"/>\r\n");
        } else {
            w.write("<labelArray key=\"");
            w.write(key);
            w.write("\">\r\n");
            for (PrefsLabel value : values) {
                this.writeSetting(w, value.getKeyAttribute(), value);
            }
            w.write("</labelArray>\r\n");
        }
    }

    protected final void writeSetting(Writer w, String key, String[] values) throws IOException {
        if (values == null || values.length == 0) {
            w.write("<array key=\"");
            w.write(key);
            w.write("\"/>\r\n");
        } else {
            w.write("<array key=\"");
            w.write(key);
            w.write("\">\r\n");
            for (String value : values) {
                w.write("  <value>");
                if (value != null) {
                    w.write(WcmXMLUtil.encodeForXML(value));
                }
                w.write("</value>\r\n");
            }
            w.write("</array>\r\n");
        }
    }

    protected final void writeSetting(Writer w, String key, List values) throws IOException {
        int len = values.size();
        if (values.size() == 0) {
            w.write("<list key=\"");
            w.write(key);
            w.write("\"/>\r\n");
        } else {
            w.write("<list key=\"");
            w.write(key);
            w.write("\">\r\n");
            for (int i = 0; i < len; ++i) {
                WcmPrefsObject o = (WcmPrefsObject)values.get(i);
                o.writeXML(w, false);
            }
            w.write("</list>\r\n");
        }
    }

    protected final void writeSetting(Writer w, String key, WcmPrefsObject value) throws IOException {
        if (value != null && key != null) {
            value.setElementKey(key);
            value.writeXML(w, false);
        }
    }

    protected void saveToXML(Writer w) throws IOException {
    }

    protected void initialize() {
    }

    protected void persist() {
    }

    public void load(String xml) throws Exception {
        Document doc = WcmXMLUtil.getDocumentFromString(xml);
        this.load(doc);
    }

    public void load(InputStream in) throws Exception {
        Document doc = WcmXMLUtil.getDocumentFromInputStream(in);
        this.load(doc);
    }

    public void load(Document doc) throws Exception {
        Element e = doc.getDocumentElement();
        this.loadObject(e);
    }

    public void load(Element element) throws Exception {
        this.loadObject(element);
    }

    private void loadObject(Element objectElement) throws Exception {
        this.objectKey = objectElement.getAttribute("key");
        this.version = objectElement.getAttribute("version");
        List elements = WcmXMLUtil.getChildElements(objectElement);
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            Element e = (Element)elements.get(i);
            String key = e.getAttribute("key");
            String type = e.getNodeName();
            if (type.equals("object")) {
                String objectClass = e.getAttribute("class");
                WcmPrefsObject o = WcmPrefsObject.createPrefsObject(key, objectClass);
                o.loadObject(e);
                this.data.put(key, o);
                continue;
            }
            if (type.equals("array")) {
                String[] values = this.loadArray(e);
                this.data.put(key, values);
                continue;
            }
            if (type.equals("labelArray")) {
                PrefsLabel[] labels = this.loadLabelArray(e);
                this.data.put(key, labels);
                continue;
            }
            if (type.equals("label")) {
                PrefsLabel label = WcmPrefsObject.loadLabel(e);
                this.data.put(key, label);
                continue;
            }
            if (type.equals("list")) {
                List<WcmPrefsObject> childObjects = this.loadList(e);
                this.data.put(key, childObjects);
                continue;
            }
            if (!type.equals("setting")) continue;
            String value = WcmXMLUtil.getElementText(e);
            String localizationKey = e.getAttribute("localizationKey");
            if (localizationKey != null && localizationKey.length() != 0) {
                WcmString localizedValue = new WcmString(localizationKey, value);
                value = localizedValue.toString();
                this.data.put(LOCALIZED_PREFIX + key, localizedValue);
            }
            if (value == null) continue;
            this.data.put(key, value);
        }
        this.initialize();
    }

    private List<WcmPrefsObject> loadList(Element e) throws Exception {
        List childElements = WcmXMLUtil.getChildElements(e);
        int len = childElements.size();
        ArrayList<WcmPrefsObject> childObjects = new ArrayList<WcmPrefsObject>(len);
        for (int i = 0; i < len; ++i) {
            Element child = (Element)childElements.get(i);
            String key = child.getAttribute("key");
            String sClass = child.getAttribute("class");
            WcmPrefsObject o = WcmPrefsObject.createPrefsObject(key, sClass);
            o.loadObject(child);
            childObjects.add(o);
        }
        return childObjects;
    }

    private PrefsLabel[] loadLabelArray(Element e) {
        NodeList valueNodes = e.getElementsByTagName("label");
        int len = valueNodes.getLength();
        PrefsLabel[] arrayValues = new PrefsLabel[len];
        for (int i = 0; i < len; ++i) {
            PrefsLabel label;
            Element valueElement = (Element)valueNodes.item(i);
            arrayValues[i] = label = WcmPrefsObject.loadLabel(valueElement);
        }
        return arrayValues;
    }

    private String[] loadArray(Element e) {
        NodeList valueNodes = e.getElementsByTagName("value");
        int len = valueNodes.getLength();
        String[] arrayValues = new String[len];
        for (int i = 0; i < len; ++i) {
            Element valueElement = (Element)valueNodes.item(i);
            String value = WcmXMLUtil.getElementText(valueElement);
            String localizationKey = valueElement.getAttribute("localizationKey");
            if (localizationKey != null && localizationKey.length() != 0) {
                value = WcmString.localize(localizationKey, value);
            }
            arrayValues[i] = value;
        }
        return arrayValues;
    }

    public static void registerKey(String sObjectKey, Class<? extends WcmPrefsObject> c) {
        if (thisClass.isAssignableFrom(c)) {
            registryMap.put(sObjectKey, c);
            registryMap.put(c, sObjectKey);
        }
    }

    private static WcmPrefsObject createPrefsObject(String objectKey, String className) throws Exception {
        Class<?> c = (Class<?>)registryMap.get(objectKey);
        if (c != null) {
            try {
                return (WcmPrefsObject)c.newInstance();
            }
            catch (Exception e) {
                return new WcmPrefsObject();
            }
        }
        if (className != null && className.length() != 0) {
            try {
                c = Class.forName(className);
            }
            catch (Exception e) {
                return new WcmPrefsObject();
            }
            return (WcmPrefsObject)c.newInstance();
        }
        return new WcmPrefsObject();
    }

    public static WcmPrefsObject loadPreferences(String xml) throws Exception {
        Document doc = WcmXMLUtil.getDocumentFromString(xml);
        return WcmPrefsObject.loadPreferences(doc);
    }

    public static WcmPrefsObject loadPreferences(InputStream in) throws Exception {
        Document doc = WcmXMLUtil.getDocumentFromInputStream(new BufferedInputStream(in));
        in.close();
        return WcmPrefsObject.loadPreferences(doc);
    }

    public static WcmPrefsObject loadPreferences(Document doc) throws Exception {
        Element rootElement = doc.getDocumentElement();
        String key = rootElement.getAttribute("key");
        String type = rootElement.getNodeName();
        if (type != null && type.equals("object")) {
            String sClass = rootElement.getAttribute("class");
            WcmPrefsObject prefsObject = WcmPrefsObject.createPrefsObject(key, sClass);
            prefsObject.loadObject(rootElement);
            return prefsObject;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (!(o instanceof WcmPrefsObject)) {
            return false;
        }
        WcmPrefsObject p = (WcmPrefsObject)o;
        try {
            String xml = this.toXML();
            String other = p.toXML();
            boolean isEqual = xml.equals(other);
            return isEqual;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PrefsLabel loadLabel(Element e) {
        PrefsLabel lbl = new PrefsLabel();
        lbl.localizationKey = e.getAttribute("localizationKey");
        lbl.keyAttribute = e.getAttribute("key");
        lbl.resourceMap = new Hashtable<String, String>();
        lbl.defaultResource = WcmXMLUtil.getChildElementText(e, "resource");
        NodeList resourceNodes = e.getElementsByTagName("resource");
        int len = resourceNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Element resourceElement = (Element)resourceNodes.item(i);
            String locale = resourceElement.getAttribute("locale");
            if (locale == null || locale.length() == 0) continue;
            String value = WcmXMLUtil.getElementText(resourceElement);
            if (value == null) {
                value = "";
            }
            lbl.resourceMap.put(locale, value);
        }
        return lbl;
    }

    static {
        WcmPrefsObject.registerKey(DEFAULT_OBJECT_KEY, WcmPrefsObject.class);
    }
}

