/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.server.util.prefs;

import com.filenet.wcm.toolkit.util.WcmStringResources;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class PrefsLabel {
    String localizationKey;
    String defaultResource;
    String keyAttribute;
    Map<String, String> resourceMap = new Hashtable<String, String>();
    boolean formatBundleResources = true;

    public PrefsLabel() {
        this.defaultResource = "";
    }

    public PrefsLabel(String defaultValue) {
        this.defaultResource = defaultValue;
    }

    public PrefsLabel(Locale defaultLocale, String defaultValue) {
        this.defaultResource = defaultValue;
        this.setResource(defaultLocale, defaultValue);
    }

    public String getResource(Locale locale) {
        if (locale == null) {
            return this.defaultResource;
        }
        String key = locale.toString();
        String value = this.resourceMap.get(key);
        if (value == null && locale.getCountry().length() > 0) {
            value = this.resourceMap.get(locale.getLanguage());
        }
        if (value == null) {
            if (this.localizationKey != null && this.defaultResource != null) {
                value = WcmStringResources.getStringResource(locale, this.localizationKey, this.defaultResource);
                if (this.formatBundleResources) {
                    value = MessageFormat.format(value, new Object[]{null});
                }
            }
            if (value != null) {
                this.setResource(locale, value);
            }
        }
        if (value == null) {
            this.setResource(locale, this.defaultResource);
            value = this.defaultResource;
        }
        return value;
    }

    public void setResource(Locale locale, String value) {
        if (value != null && locale != null) {
            String key = locale.toString();
            this.resourceMap.put(key, value);
            if (this.defaultResource == null) {
                this.defaultResource = value;
            }
        }
    }

    public boolean getFormatBundleResources() {
        return this.formatBundleResources;
    }

    public void setFormatBundleResources(boolean formatBundleResources) {
        this.formatBundleResources = formatBundleResources;
    }

    public String getLocalizationKey() {
        return this.localizationKey;
    }

    public void setLocalizationKey(String localizationKey) {
        this.localizationKey = localizationKey;
    }

    public String getKeyAttribute() {
        return this.keyAttribute;
    }

    public void setKeyAttribute(String keyAttribute) {
        this.keyAttribute = keyAttribute;
    }

    public String getDefaultResource() {
        return this.defaultResource;
    }

    public void setDefaultResource(String defaultResource) {
        this.defaultResource = defaultResource;
    }

    public static String[] toStringArray(PrefsLabel[] labels, Locale locale) {
        String[] results = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            PrefsLabel label = labels[i];
            results[i] = label.getResource(locale);
        }
        return results;
    }

    public void clear() {
        this.resourceMap.clear();
    }
}

