/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.util;

import com.filenet.wcm.toolkit.util.WcmException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class WcmKeepAlive
implements Runnable {
    private long keepAliveMilli;
    private URL url;
    private HttpURLConnection urlConn;
    private volatile Thread workerThread;

    public WcmKeepAlive(String appServerUrl, long keepAliveRate) throws WcmException {
        this.keepAliveMilli = keepAliveRate * 60000L;
        try {
            this.url = new URL(appServerUrl);
        }
        catch (MalformedURLException e) {
            throw new WcmException("server.WcmKeepAlive.invalidURL", "Invalid HTTP URL.");
        }
        this.workerThread = new Thread((Runnable)this, "WcmKeepAlive");
        this.workerThread.start();
    }

    public void destroy() {
        if (this.workerThread != null) {
            Thread workerRef = this.workerThread;
            this.workerThread = null;
            workerRef.interrupt();
        }
        if (this.urlConn != null) {
            this.urlConn.disconnect();
            this.urlConn = null;
        }
    }

    public void run() {
        try {
            Thread thisThread = Thread.currentThread();
            while (thisThread == this.workerThread) {
                Thread.sleep(this.keepAliveMilli);
                if (this.url != null) {
                    this.urlConn = (HttpURLConnection)this.url.openConnection();
                    this.urlConn.setRequestMethod("GET");
                    this.urlConn.connect();
                    int respCode = this.urlConn.getResponseCode();
                    if (respCode >= 200 && respCode <= 300) {
                        this.urlConn.disconnect();
                    } else {
                        System.out.println("Error " + respCode + " in PingServer");
                    }
                    this.urlConn = null;
                    continue;
                }
                System.out.println("Null url");
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            System.out.println("IOException in run: " + e.getMessage());
        }
    }

    private void printInputStream(HttpURLConnection urlConn) throws IOException {
        String result = new String();
        InputStreamReader reader = new InputStreamReader(urlConn.getInputStream());
        char[] buf = new char[1024];
        int numRead = reader.read(buf, 0, 1023);
        while (numRead >= 0) {
            result = result + String.valueOf(buf, 0, numRead);
            numRead = reader.read(buf, 0, 1023);
        }
        System.out.println("Result is " + result);
    }
}

