/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.util;

import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WcmHelp {
    private static final int MODE_APPLET = 0;
    private static final int MODE_APPLICATION = 1;
    private static int m_mode = -1;
    private static JApplet m_applet = null;
    private static URL m_baseHelpURL = null;
    private static String m_baseHelpPrefix = null;

    public static void init(JApplet applet, String helpDir) {
        String helpPath = null;
        try {
            m_mode = 0;
            m_applet = applet;
            if (applet == null) {
                return;
            }
            helpPath = applet.getParameter("documentServerURL");
            helpPath = helpPath == null ? applet.getParameter("baseURL") : helpPath + helpDir;
            m_baseHelpURL = new URL(helpPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void init(JFrame frame) {
        String osName = null;
        m_mode = 1;
        osName = System.getProperty("os.name");
        m_baseHelpPrefix = osName.compareToIgnoreCase("Windows NT") == 0 || osName.compareToIgnoreCase("Windows 2000") == 0 ? "cmd /c " : "start ";
        m_baseHelpPrefix = m_baseHelpPrefix.concat(System.getProperty("user.dir") + System.getProperty("file.separator"));
        m_baseHelpPrefix = m_baseHelpPrefix.concat("help" + System.getProperty("file.separator"));
    }

    public static void displayPage(String page) {
        switch (m_mode) {
            case 0: {
                WcmHelp.displayHelpFromApplet(page);
                break;
            }
            case 1: {
                WcmHelp.displayHelpFromApplication(page);
            }
        }
    }

    private static void displayHelpFromApplet(String page) {
        URL helpURL = null;
        try {
            helpURL = new URL(m_baseHelpURL + page);
            m_applet.getAppletContext().showDocument(helpURL, "_blank");
        }
        catch (Exception ex) {
            JOptionPane pane = new JOptionPane();
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage());
        }
    }

    private static void displayHelpFromApplication(String page) {
        String command = null;
        try {
            command = m_baseHelpPrefix;
            command = command.concat(page);
            Runtime.getRuntime().exec(command);
        }
        catch (Exception ex) {
            JOptionPane pane = new JOptionPane();
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage());
        }
    }
}

