/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.util;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.util.WcmException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ObjectStoreFilteringUtil {
    private String m_objectStoreFilterList = null;

    public ObjectStoreFilteringUtil(String objectStoreFilterList) {
        this.m_objectStoreFilterList = objectStoreFilterList;
    }

    public void setObjectStoreFilterList(String objectStoreFilterList) {
        this.m_objectStoreFilterList = objectStoreFilterList;
    }

    public boolean isInit() {
        return this.m_objectStoreFilterList != null && this.m_objectStoreFilterList.length() > 0;
    }

    public ObjectStores filterObjectStores(ObjectStores libs) throws WcmException {
        try {
            if (this.isInit()) {
                Iterator it = null;
                ObjectStore lib2 = null;
                VerboseLibrary vLib = null;
                ObjectStores filteredLibs = null;
                filteredLibs = ObjectFactory.getObjectStores();
                for (ObjectStore lib2 : libs) {
                    try {
                        vLib = new VerboseLibrary(lib2);
                        if (this.m_objectStoreFilterList.indexOf(vLib.getId()) <= -1) continue;
                        ObjectStore accessibleLib = vLib.getLibrary();
                        filteredLibs.add((Object)accessibleLib);
                    }
                    catch (Exception e) {
                        System.out.println("Caught an error in ObjectStoreFilteringUtil.filterObjectStore(): " + e.getMessage());
                        JOptionPane.showMessageDialog(null, e.getMessage());
                    }
                }
                return filteredLibs;
            }
            this.ShowNoObjectStoresErrorMsg();
        }
        catch (Exception e) {
            throw new WcmException("toolkit.client.util.ObjectStoreFilteringUtil.errorInFilterObjectStores", "An error occurred filtering objectstores: {0}", (Object)e.getMessage());
        }
        return libs;
    }

    public WcmDlgItem[] filterObjectStores(WcmDlgItem[] itemCache) throws WcmException {
        try {
            WcmDlgItem[] itemArray = null;
            if (itemCache == null) {
                return itemCache;
            }
            Vector<WcmDlgItem> items = new Vector<WcmDlgItem>();
            if (this.isInit()) {
                for (int nIndex = 0; nIndex < itemCache.length; ++nIndex) {
                    if (this.m_objectStoreFilterList.indexOf(itemCache[nIndex].getObjectStore().getId()) > -1) {
                        // empty if block
                    }
                    items.addElement(itemCache[nIndex]);
                }
                if (!items.isEmpty()) {
                    itemArray = items.toArray(new WcmDlgItemImpl[0]);
                }
                return itemArray;
            }
            this.ShowNoObjectStoresErrorMsg();
        }
        catch (Exception e) {
            throw new WcmException("toolkit.client.util.ObjectStoreFilteringUtil.errorInFilterObjectStores", "An error occurred filtering objectstores: {0}", (Object)e.getMessage());
        }
        return itemCache;
    }

    private void ShowNoObjectStoresErrorMsg() {
        JOptionPane.showMessageDialog(null, WcmResource.s_noObjectStoresAvail);
    }
}

