/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.util;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.SessionTunnel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class AppletSessionTunnel
implements SessionTunnel {
    private static Map cookieMap = new HashMap();
    private static int reportCount = 1;
    private static boolean DEBUG_TRACE = false;
    private String opaqueParameter = null;
    private String sessionTunnelURL = null;
    private ByteArrayOutputStream baos = null;

    public AppletSessionTunnel(String sessionTunnelURL, String[] cookies) {
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.setCookie(cookies[i]);
            }
        }
        String cookieString = this.getCookieString(true);
        this.sessionTunnelURL = sessionTunnelURL;
        this.opaqueParameter = sessionTunnelURL;
        if (cookieString.length() > 0) {
            this.opaqueParameter = this.opaqueParameter + "?" + cookieString;
        }
    }

    protected AppletSessionTunnel(String opaqueParameter) {
        StringTokenizer st = new StringTokenizer(opaqueParameter, "?");
        this.opaqueParameter = opaqueParameter;
        this.sessionTunnelURL = st.nextToken();
    }

    public AppletSessionTunnel() {
    }

    private void setCookie(String cookie) {
        if (cookie != null && cookie.length() > 0) {
            int semi = cookie.indexOf(";");
            if (semi >= 0) {
                cookie = cookie.substring(0, cookie.indexOf(";"));
            }
            String cookieName = cookie.substring(0, cookie.indexOf("="));
            String cookieValue = cookie.substring(cookie.indexOf("=") + 1, cookie.length());
            cookieMap.put(cookieName.trim(), cookieValue.trim());
        }
    }

    private String getCookieString(boolean jsessionIdOnly) {
        StringBuffer cookieString = new StringBuffer();
        if (jsessionIdOnly && cookieMap.containsKey("JSESSIONID")) {
            String jsessionId = (String)cookieMap.get("JSESSIONID");
            cookieString.append("JSESSIONID=").append(jsessionId);
        } else {
            for (Map.Entry entry : cookieMap.entrySet()) {
                if (cookieString.length() > 0) {
                    cookieString.append("; ");
                }
                cookieString.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return cookieString.toString();
    }

    private synchronized void reportCookies() {
        if (DEBUG_TRACE) {
            System.out.println("********** BEGIN COOKIES DUMP #" + reportCount + "**********");
            for (Map.Entry entry : cookieMap.entrySet()) {
                System.out.println("COOKIE DUMP #" + reportCount + " Cookie: " + entry.getKey() + " -> " + entry.getValue());
            }
            System.out.println("********** END COOKIES DUMP #" + reportCount + "**********");
            ++reportCount;
        }
    }

    public SessionTunnel getInstance(String opaqueParameter) {
        return new AppletSessionTunnel(opaqueParameter);
    }

    private InputStream getWcmApiConfig(String tunnelUrl) {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("RemoteServerUrl=").append(tunnelUrl).append("\n");
        sBuf.append("RemoteServerUploadUrl=").append(tunnelUrl).append("\n");
        sBuf.append("RemoteServerDownloadUrl=").append(tunnelUrl).append("\n\n");
        sBuf.append("CredentialsProtection=Clear\n");
        sBuf.append("CryptoKeyFile=CryptoKeyFile.properties\n");
        return new ByteArrayInputStream(sBuf.toString().getBytes());
    }

    public Session createSourceSession(String appId, String token) throws MalformedURLException {
        String tunnelClassName = this.getClass().getName();
        String tunnelUrl = "tunnel:" + tunnelClassName + "/" + this.opaqueParameter;
        Session sourceSession = token != null ? ObjectFactory.getSession((String)appId, (String)"Clear", (String)token, null) : ObjectFactory.getSession((String)appId, (String)"Clear");
        sourceSession.setConfiguration(this.getWcmApiConfig(tunnelUrl));
        return sourceSession;
    }

    public OutputStream getSink() {
        try {
            return this.createRequestWriter();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public InputStream getResponse() {
        try {
            return this.createResponseReader(this.sessionTunnelURL, 0);
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.out);
            System.out.flush();
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.flush();
            throw new RuntimeException(e.getMessage());
        }
    }

    private HttpURLConnection getHttpConnection(String url) throws UnknownHostException, MalformedURLException, IOException {
        HttpURLConnection connection = this.sendRequest(new URL(url), this.getCookieString(false));
        OutputStream os = connection.getOutputStream();
        os.write(this.baos.toByteArray());
        return connection;
    }

    private OutputStream createRequestWriter() throws UnknownHostException, IOException {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream();
        }
        return this.baos;
    }

    private void captureCookies(HttpURLConnection connection) {
        String headerName;
        if (DEBUG_TRACE) {
            System.out.println("RESPONSE BEGIN Set-Cookie(s):");
        }
        int i = 1;
        while ((headerName = connection.getHeaderFieldKey(i)) != null) {
            if (headerName.equals("Set-Cookie")) {
                String cookie = connection.getHeaderField(i);
                this.setCookie(cookie);
                if (DEBUG_TRACE) {
                    System.out.println("RESPONSE Set-Cookie: " + cookie);
                }
            }
            ++i;
        }
        if (DEBUG_TRACE) {
            System.out.println("RESPONSE END Set-Cookie(s):");
            System.out.flush();
        }
    }

    private InputStream createResponseReader(String url, int count) throws IOException {
        HttpURLConnection connection = this.getHttpConnection(url);
        int responseCode = connection.getResponseCode();
        if (DEBUG_TRACE) {
            System.out.println("RESPONSE CODE: " + responseCode + " " + connection.getResponseMessage());
        }
        switch (responseCode) {
            case 301: 
            case 302: {
                if (count > 20) {
                    throw new IOException("Too many redirects");
                }
                this.captureCookies(connection);
                url = connection.getHeaderField("Location");
                if (DEBUG_TRACE) {
                    System.out.println("RESPONSE REDIRECTING TO: " + url);
                }
                return this.createResponseReader(url, ++count);
            }
            case 500: {
                InputStreamReader reader = new InputStreamReader(connection.getErrorStream());
                StringBuffer buf = new StringBuffer();
                char[] bucket = new char[4096];
                int nRead = reader.read(bucket, 0, 4095);
                while (nRead >= 0) {
                    buf.append(bucket, 0, nRead);
                    nRead = reader.read(bucket, 0, 4095);
                }
                System.out.println(buf.toString());
                System.out.flush();
                throw new IOException(connection.getResponseMessage());
            }
        }
        return connection.getInputStream();
    }

    private HttpURLConnection sendRequest(URL oUrl, String cookieString) throws MalformedURLException, IOException {
        HttpURLConnection httpURLConnection = null;
        if (oUrl != null) {
            httpURLConnection = (HttpURLConnection)oUrl.openConnection();
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
            if (cookieString != null && cookieString.length() > 0) {
                if (DEBUG_TRACE) {
                    System.out.println("TUNNEL SEND REQUEST: " + cookieString);
                    this.reportCookies();
                }
                httpURLConnection.setRequestProperty("Cookie", cookieString);
            }
        }
        return httpURLConnection;
    }
}

