/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WcmUserGroupListCellRenderer
extends JLabel
implements ListCellRenderer {
    protected ImageIcon m_userIcon = null;
    protected ImageIcon m_groupIcon = null;

    public WcmUserGroupListCellRenderer() {
        this.setOpaque(true);
        this.m_userIcon = WcmImageLoader.createImageIcon("type/Users16.gif");
        this.m_groupIcon = WcmImageLoader.createImageIcon("type/Groups16.gif");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        this.applyComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value != null && value instanceof WcmUserGroupItem) {
            switch (((WcmUserGroupItem)value).getType()) {
                case 0: {
                    this.setIcon(this.m_userIcon);
                    break;
                }
                case 1: {
                    this.setIcon(this.m_groupIcon);
                    break;
                }
                default: {
                    this.setIcon(null);
                }
            }
            String name = ((WcmUserGroupItem)value).getDisplayName();
            if (name != null && name.length() > 0 && name.charAt(0) == '\"') {
                name = name.substring(1, name.length() - 1);
            }
            this.setText(name);
            this.setToolTipText(null);
            String distinguishedName = ((WcmUserGroupItem)value).getLongName();
            if (distinguishedName != null && distinguishedName.length() > 0) {
                this.setToolTipText(distinguishedName);
            }
        } else if (value != null && value instanceof String) {
            this.setText((String)value);
            this.setToolTipText(null);
        }
        return this;
    }
}

