/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.security;

import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.toolkit.client.ui.security.SecurityMap;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityAddPanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityResource;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityUpdatePanel;
import com.filenet.wcm.toolkit.client.ui.security.WcmSummarySecModel;
import com.filenet.wcm.toolkit.client.ui.security.WcmTable;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.security.WcmSecurityAccessUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class WcmSummarySecPanel
extends JPanel
implements ListSelectionListener {
    private WcmTable table;
    private WcmSummarySecModel tblModel;
    private int prevSelRow;
    private WcmSecurityUpdatePanel updatePanel;
    private WcmSecurityAddPanel addPanel = null;
    private boolean isReadOnly;
    private Object[][] multiLineHeader;

    public WcmSummarySecPanel(Session session, Permissions objPerms, Permissions templatePerms, int objType, boolean isReadOnly, String userName) throws Exception {
        this.tblModel = new WcmSummarySecModel(session, objPerms, templatePerms, objType, userName);
        this.isReadOnly = isReadOnly;
        this.table = new WcmTable(this.tblModel);
        this.table.addKeyListener(new TabKeyListener());
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                WcmSummarySecPanel.this.prevSelRow = WcmSummarySecPanel.this.table.getSelectedRow();
                if (WcmSummarySecPanel.this.prevSelRow == -1) {
                    WcmSummarySecPanel.this.prevSelRow = 0;
                }
            }
        });
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        this.initMultiLineHeader();
        this.initColumnAttributes();
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setRowSelectionAllowed(!isReadOnly);
        if (isReadOnly) {
            this.table.setBackground(new Color(this.getBackground().getRGB()));
        }
        JScrollPane sp = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }

    public boolean isModified() {
        return this.tblModel.isModified();
    }

    public void clearModified() {
        this.tblModel.clearModified();
    }

    public Permissions getPermissions() {
        return this.tblModel.getPermissions();
    }

    public JTable getTable() {
        return this.table;
    }

    public void setCommand(WcmSecurityUpdatePanel updatePanel) {
        this.updatePanel = updatePanel;
    }

    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!e.getValueIsAdjusting()) {
            boolean canEnab = this.canEnableUpdateButtons(lsm);
            if (canEnab) {
                int minIndex = lsm.getMinSelectionIndex();
                SecurityMap secMap = this.tblModel.getRowData(minIndex);
                this.updatePanel.setMap(secMap);
                this.updatePanel.enableButtons();
            } else {
                this.updatePanel.disableButtons();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        }
        this.table.setEnabled(enabled);
        boolean canEnab = enabled;
        if (canEnab) {
            canEnab = this.canEnableUpdateButtons(this.table.getSelectionModel());
        }
        if (canEnab) {
            this.updatePanel.enableButtons();
        } else {
            this.updatePanel.disableButtons();
        }
        if (!enabled) {
            super.setEnabled(false);
        }
    }

    public void setSecurityAddPanel(WcmSecurityAddPanel secAddPanel) {
        this.addPanel = secAddPanel;
    }

    private boolean canEnableUpdateButtons(ListSelectionModel lsm) {
        boolean canEnab = true;
        int minIndex = lsm.getMinSelectionIndex();
        int maxIndex = lsm.getMaxSelectionIndex();
        if (minIndex == -1 || maxIndex == -1) {
            canEnab = false;
        } else if (!this.isReadOnly) {
            SecurityMap secMap = this.tblModel.getRowData(minIndex);
            if (secMap == null) {
                canEnab = false;
            }
        } else {
            canEnab = false;
        }
        return canEnab;
    }

    private void initMultiLineHeader() {
        if (this.table != null) {
            int count = this.tblModel.getColumnCount();
            int maxLine = 5;
            if (this.multiLineHeader == null) {
                this.multiLineHeader = new Object[count][maxLine];
            }
            String addStr = WcmSecurityAccessUtil.NAME_ADDTOFOLDER.toString().substring(0, 2);
            for (int i = 0; i < count; ++i) {
                String colName = this.tblModel.getColumnName(i);
                StringTokenizer st = new StringTokenizer(colName);
                for (int j = 0; j < maxLine && st.hasMoreTokens(); ++j) {
                    String token = st.nextToken();
                    if (token.startsWith(addStr) && st.hasMoreTokens()) {
                        token = token + " " + st.nextToken();
                    }
                    this.multiLineHeader[i][j] = token;
                }
            }
        }
    }

    private void initColumnAttributes() {
        if (this.table != null) {
            this.table.getTableHeader().setReorderingAllowed(false);
            int count = this.tblModel.getColumnCount();
            for (int i = 0; i < count; ++i) {
                TableColumn tblColumn = this.table.getColumnModel().getColumn(i);
                if (tblColumn == null) continue;
                tblColumn.setHeaderRenderer(new HeaderRenderer());
                tblColumn.setHeaderValue(this.multiLineHeader[i]);
                this.table.sizeColumnWidthToFit(tblColumn);
                if (WcmString.compare(WcmSecurityResource.NAME_GRANTEE, this.tblModel.getColumnName(i)) == 0) {
                    tblColumn.setCellRenderer(new GranteeRenderer());
                } else {
                    tblColumn.setCellRenderer(new CheckRenderer());
                }
                int width = this.tblModel.colAttributes[i].colWidth;
                tblColumn.setPreferredWidth(width);
            }
        }
    }

    private void moveToNewRow(boolean forward) {
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        if (column == -1) {
            column = 0;
        }
        if (forward) {
            if (++row == this.table.getRowCount()) {
                row = 0;
            }
        } else if (--row < 0) {
            row = this.table.getRowCount() - 1;
        }
        this.prevSelRow = row;
        JCheckBox editor = (JCheckBox)this.table.getEditorComponent();
        if (editor != null) {
            editor.setBackground(this.table.getSelectionBackground());
        }
        ListSelectionModel rowSelection = this.table.getSelectionModel();
        ListSelectionModel colSelection = this.table.getColumnModel().getSelectionModel();
        rowSelection.setSelectionInterval(row, row);
        colSelection.setSelectionInterval(column, column);
    }

    private class TabKeyListener
    extends KeyAdapter {
        private TabKeyListener() {
        }

        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 9) {
                if (evt.isShiftDown()) {
                    WcmSummarySecPanel.this.moveToNewRow(false);
                } else {
                    WcmSummarySecPanel.this.moveToNewRow(true);
                }
                evt.consume();
            }
        }
    }

    class GranteeRenderer
    extends DefaultTableCellRenderer {
        GranteeRenderer() {
        }

        public void setValue(Object value) {
            if (value instanceof SecurityMap.GranteeUI) {
                SecurityMap.GranteeUI val = (SecurityMap.GranteeUI)value;
                this.setIcon(val.getIcon());
                this.setText(val.name);
            } else {
                super.setValue(value);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!table.hasFocus()) {
                this.setToolTipText(null);
            } else {
                String szDisnName = this.getDistinguishName(table, row);
                if (row > -1 && szDisnName != null && szDisnName.length() > 0) {
                    this.setToolTipText(szDisnName);
                }
            }
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            renderer.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            return renderer;
        }

        private String getDistinguishName(JTable table, int row) {
            SecurityMap secMap;
            String retString = "";
            WcmSummarySecModel secModel = (WcmSummarySecModel)table.getModel();
            if (secModel != null && (secMap = secModel.getRowData(row)) != null) {
                retString = secMap.granteeInfo.name;
            }
            return retString;
        }
    }

    static class CheckRenderer
    extends DefaultTableCellRenderer {
        private ImageIcon check;
        private ImageIcon blank;

        public CheckRenderer() {
            this.setHorizontalAlignment(0);
            this.check = WcmImageLoader.createImageIcon("type/Check32.gif");
            this.blank = WcmImageLoader.createImageIcon("type/Blank32.gif");
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            try {
                if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    this.setIcon(b != false ? this.check : this.blank);
                    this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                } else {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this;
        }
    }

    static class HeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        protected Color foreground;
        protected Color background;
        protected Border headerBorder = UIManager.getBorder("TableHeader.cellBorder");
        protected Font font = UIManager.getFont("TableHeader.font");

        public HeaderRenderer() {
            this.setBorder(this.headerBorder);
            this.setLayout(new BoxLayout(this, 3));
            this.setOpaque(true);
            this.background = null;
        }

        public void setForeground(Color color) {
            this.foreground = color;
            super.setForeground(this.foreground);
        }

        public void setBackground(Color color) {
            this.background = color;
            super.setBackground(this.background);
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            this.removeAll();
            this.invalidate();
            if (value == null) {
                return this;
            }
            if (table != null && (header = table.getTableHeader()) != null) {
                if (this.foreground == null) {
                    super.setForeground(header.getForeground());
                }
                if (this.background == null) {
                    super.setBackground(header.getBackground());
                }
            }
            Object[] values = value instanceof Object[] ? (Object[])value : new Object[]{value};
            for (int i = 0; i < values.length; ++i) {
                Object rowObj = values[i];
                if (rowObj instanceof JComponent) {
                    this.add((JComponent)rowObj);
                    continue;
                }
                JLabel label = new JLabel();
                this.setValue(label, rowObj, i);
                this.add(label);
            }
            return this;
        }

        protected void setValue(JLabel label, Object value, int lineNumber) {
            if (value != null && value instanceof Icon) {
                label.setIcon((Icon)value);
            } else {
                label.setText(value == null ? "" : value.toString());
            }
            label.setHorizontalAlignment(0);
            label.setAlignmentX(0.5f);
            label.setOpaque(false);
            label.setForeground(this.foreground);
            label.setFont(this.font);
        }
    }
}

